#!/bin/sh

set -e

if [ $# -ne 2 ] ; then
    echo "usage: $0 <area> <zone>" >&2
    exit 1
fi

AREA=$1
ZONE=$2

if [ -z "${AREA}" -o -z "${ZONE}" ] ; then
    echo "Timezone area and zone must be specified" >&2
    echo "usage: $0 <area> <zone>" >&2
    exit 1
fi

umask 022

echo "${AREA}/${ZONE}" > /etc/timezone

cp -f /usr/share/zoneinfo/$AREA/$ZONE /etc/localtime.new && \
    mv -f /etc/localtime.new /etc/localtime
which restorecon >/dev/null 2>&1 && restorecon /etc/localtime

exit 0
