var CA_GEN = {
    init : function() {
    	CA_GEN.initUI();
    	CA_GEN.initEvents();
    },
    
    initUI : function() {

        $('#progress').hide();
        $("#cert_gen_fail").hide();
        
        $("#warn_dlg").dialog({
            autoOpen: false, resizable: false,
            modal: true, title: S_WARNING_TITLE,
            height: 70,
            buttons: [{
            	text: S_OK_BUTTON,
            	click: function () {
                     $(this).dialog("close");
                }
            }]
        });	
    },
    
    initEvents : function() {
         $('#generate_btn').button()
                           .click(CA_GEN.genCertAction);  	     
         $('#reset_btn').button()
                        .click(CA_GEN.resetAction);  
    },
    
    genCertAction : function() {
    	if($('#cname').val().length === 0 || $('#password').val().length === 0 ) {
    	    $("#warn_dlg").text(S_CNAME_AND_PASSWORD_ARE_REQUIRED).dialog('open').height("auto"); 
    	    return false;
    	}
    	
    	var days = parseInt($('#days').val(), 10);
    	
    	if(isNaN(days) || days <= 0) {
            $("#warn_dlg").text(S_LIFETIME_INVALID).dialog('open').height("auto");
            return false;
    	}
    	
    	var download = $('#download').attr('checked') ? 1 : 0 ; 
    	var new_cert_data = {
    			'name': $('#cname').val(),
    			'orgunit': $('#org').val(),
    			'password': $('#password').val(),
    			'lifetime': days,    			
    			'download': download   			
    			};
    	
    	CA_GEN.disableUI();
    	
    	$('#progress').show();
    	
    	$.ajax({
            url: 'new_cert',
            type: 'POST',
            dataType: 'json',
            data: new_cert_data,
            success : function(data) {
            	if(data.status === 0) {
                    if (!download) {
                        window.location = '/ca/manage';
                    }
                    else {
                        window.location = 'get_cert_file';
                        CA_GEN.enableUI();
                        $('#progress').hide();
                        $("#cert_gen_fail").hide();
                    }
            	}
            	else {
                    CA_GEN.enableUI();
                    $('#progress').hide();
            		$("#cert_gen_fail").show().text(S_CERT_GEN_FAILED);
            	}
            }
    	});
    },
    
    disableUI : function() {
    	$('#gen_cert :input').attr('disabled', true);
    	$('#generate_btn').button({'disabled': true}); 
    	$('#reset_btn').button({'disabled': true});
    },
    
    enableUI : function() {
    	$('#gen_cert :input').attr('disabled', false);
    	$('#generate_btn').button({'disabled': false}); 
    	$('#reset_btn').button({'disabled': false});
    },
    
    resetAction : function() {
    	var elems = ['#cname', '#org', '#password', '#days'];
    	
    	$.each(elems, function(index, value){
            $(value).val('');
    	});
    	$('#download').attr('checked', false);
    }    
};
$(document).ready(CA_GEN.init);