var CA_MANAGE = {
	
    filter_by : '',

    prev_list : '', //Maintain a list of previous sn for going to the previous page
	
    after_sn : '', //Update the after_sn everytime user clicks the 'Next' button, this is the sn that gets added to the prev_list array
	
    current_row_num : 25, //Update current_row_num, everytime user changes the number of rows, basically update the url field 
	
    init : function() {
        CA_MANAGE.initUI();
        CA_MANAGE.initEvents();
        CA_MANAGE.initPagination();
    },
    
    initUI : function() {
        CA_MANAGE.getGridData();
        
        $('#warn_dlg').dialog({
            autoOpen: false, resizable: false,
            modal: true, title: S_WARNING_TITLE,
            height: 70,
            buttons: [{
            	text: S_OK_BUTTON,
            	click: function () {
                    $(this).dialog('close');
            	}
            }]
        });        

        $('#view_cerificate_dlg').dialog ({
            dialogClass: 'transparent',
            width: 590, height: 50,
            resizable: false, autoOpen: false,
            modal: true
        });
    
        $('#pkcs12_password_dlg').dialog ({
            dialogClass: 'transparent',
            width: 300, height: 200,
            resizable: false, autoOpen: false,
            modal: true
        });	
    
        $('#confirm_dlg').dialog({
            autoOpen: false, resizable: false,
            modal: true, title: "",
            buttons:[
                    {
            	        text: S_OK_BUTTON,
                        click: function () {
            	            var serial = jQuery('#grid_table').jqGrid('getGridParam','selarrrow'); 
                            var ret = jQuery('#grid_table').jqGrid('getRowData',serial.toString());
                
                            var action = $(this).data('action_id');
    	          
                            var cert_data = {
                                'serial': serial.toString(),
                                'action': action
                            };
                
                            $.ajax({
                                url: 'update_certs',
                                method: 'POST',
                                data: cert_data,
                                dataType: 'json',
                                success: function (data) {
                                	if(data.status === 0) {
                                        CA_MANAGE.resetCertsGrid();
                                	}
                                	else {
                                		$('#warn_dlg').text(S_ACTION_ERRORS[action]).dialog('open').height('auto');
                                	}
                                }
                            });
                            $(this).dialog('close');
                            $('#view_cerificate_dlg').dialog('close');	                
                        }//end of click
                    },//button OK ends here
                    
                    {
            	        text: S_CANCEL_BUTTON,
            	        click: function () {
                            $(this).dialog('close');
                        }
                    }//button Cancel ends here
                   ]
        });
    },

    initEvents : function() {

        $(window).resize(CA_MANAGE.resizeGrid);
        
        $('.revoke_button').button()
                           .click(CA_MANAGE.certificateAction);  
        
        $('.reinstate_button').button()
                              .click(CA_MANAGE.certificateAction);       
        
        $('.destroy_button').button()
                            .click(CA_MANAGE.certificateAction);  
        
        $('#pem_button').button()
                        .click(CA_MANAGE.pemAction);  	
        
        $('#pkcs12_button').button()
                           .click(CA_MANAGE.pkcs12Action);    
        
        $('#pkcs12_password_button').button()
                                    .click(CA_MANAGE.checkPassword); 

        $('#search_box').keypress(CA_MANAGE.keyPressAction);
        
        $('#prev_button').button({ icons: { primary: "ui-icon-seek-prev"}})
                         .click(CA_MANAGE.prevAction); 
        
        $('#next_button').button({ icons: { primary: "ui-icon-seek-next"} })
                         .click(CA_MANAGE.nextAction); 
        
        $('#grid_table').delegate('a','click',CA_MANAGE.showCertificate);
        
        $("#btn_filter").button({
            icons: {
                secondary: "ui-icon-triangle-1-s"
            }
        });
        
        /* -=-=-=- Actions -=-=-=- */
        $('.li_filter,.li_action').hover(
            function () {
                selector = '#' + this.id;
                $(selector).css('background-color', '#333');
                $(selector).css('color', '#fff');
            },
            function () {
                selector = '#' + this.id;
                $(selector).css('background-color', '#fff');
                $(selector).css('color', 'black');
            }
         );
        
        /* Bind the action button to the action popup */
        $('#btn_filter').click(function () {
            domenu('#btn_filter', '#ul_filter');
        });
        
        $('#btn_filter').unbind('dblclick');
        
        $('.span_filter').hover(
            function () { },
            function () {
                closemenu('#btn_filter', '#ul_filter');
            }
        );
        
        /* Register a handler for selecting the action drop down */
        $('.li_filter').click(CA_MANAGE.popupMenuFilterAction);
        
        /* Bind the action button to the action popup */
        $('#btn_action').click(function () {
            domenu('#btn_action', '#ul_action');
        });
        
        $('#btn_action').unbind('dblclick');
        
        $('.span_action').hover(
            function () { },
            function () {
                closemenu('#btn_action', '#ul_action');
            }
        );
        
        $('.li_action').click(CA_MANAGE.popupMenuAction);
        
        $('#btn_clear').button()
                       .click(CA_MANAGE.clearAction)
                       .hide();
        
    	$('#btn_search').button({ icons: { primary: 'ui-icon-search' }, text: true })
    	                .click(CA_MANAGE.searchAction);
    },
    
    resizeGrid : function () {
        resizegrid("#grid_table",this);
        $("#grid_table").trigger('resize');
    },
    
    /*
     * 1. Initialize the prev list array
     * 2. Gray out the prev button
     *    
     */
    initPagination : function () {
    	CA_MANAGE.prev_list = []; // Initialize prev list array
    	$('#prev_button').button({'disabled': true});    	
    },
    
    /* 
     * Called when previous button is clicked
     * If prev_list is empty:
     *      a. Disable the prev button 
     *      b. Fetch the records from the beginning, by not passing any serial number
     * 
     * If prev_list is not empty:
     *      a. Retrieve the last sn from the list
     *      b. Get the cert list starting from that sn
     *      
     * In both the scenarios, update the url that is going to be passed to the server
     */
    prevAction : function() {

        var prev_sn = CA_MANAGE.prev_list.pop();
        
        if (CA_MANAGE.prev_list.length === 0) {
            CA_MANAGE.updateViewAction();
            $('#prev_button').button({'disabled': true});    	
        }
        else {
    	    CA_MANAGE.updateViewAction(prev_sn);
        }
        
        CA_MANAGE.updateURL(); //Reset the URL to not include the serial number
    },
    
    /*
     * Called when next button is clicked
     * When the user clicks the next button,
     *   a. retrieve the last row from the current view
     *   b. get the serial number and store it in the prev list
     *   c. then make the request to the server 
     * 
     *  When we make the request from the server passing the serial number, 
     *  it retrieves the records following the serial number, hence, we the user clicks the 
     *  previous button we need to make sure that the user sees the records that come after the last sn in the prev list 
     */
    nextAction : function() {
    	var dataIds = $('#grid_table').jqGrid('getDataIDs');
    	var first_sn = dataIds[0]
    	var last_sn = dataIds[dataIds.length - 1]
    	
    	CA_MANAGE.prev_list.push(CA_MANAGE.after_sn);
    	CA_MANAGE.after_sn = last_sn;
    	CA_MANAGE.updateViewAction(last_sn);
    	CA_MANAGE.updateURL(); //Reset the URL to not include the serial number
    },
    
    keyPressAction : function (event) {
        if (event.keyCode == 13) {
            $('#btn_search').click();
        }
    },
    
    checkPassword : function () {
    	var password = $('#pkcs12_password').val();
        var serial = jQuery('#grid_table').jqGrid('getGridParam','selarrrow');         
        var ret = jQuery('#grid_table').jqGrid('getRowData',serial.toString());
        
    	if (password.length === 0 ) {
    	    $('#warn_dlg').text(S_PKCS12_PASSWORD_EMPTY).dialog('open').height('auto');
    	    return false;
    	}
	    
    	$.ajax({
            url: 'view_cert?sn=' + serial + '&cert_format=PKCS12' + '&password=' + password,
            type: 'POST',
            success : function(data) {
                window.location = 'get_cert_file';    		
            },
            error : function (xhr,status,error) {
                alert(xhr.responseText);
            }
        });
    	$('#pkcs12_password_dlg').dialog('close');
    },
    
    /*
     * Show the 'Certificate Data' dialog when user clicks on a serial number 
     * Based on the status of the certificate, enable / disable the respective buttons
     * 
     */
    showCertificate : function (event) {
    	jQuery('#grid_table').jqGrid('resetSelection');
    	
    	var selected_row = jQuery('#grid_table').jqGrid('getRowData',$(this).text());
    	
    	//Based on the row get the status attribute and enabled disable buttons accordingly
    	var status = S_CERT_STATUS[selected_row['status']];
    	
    	switch (status) {
	    case 0: //If cert is valid the enable revoke, reinstate and destroy buttons
	    	$('#cert_buttons_1 button[id=revoke]').button({'disabled': false}); 
	    	$('#cert_buttons_1 button[id=reinstate]').button({'disabled': false}); 
	    	$('#cert_buttons_1 button[id=destroy]').button({'disabled': false}); 
	        break;
	    case 1: //If cert is expired the enable only destroy button
	    	$('#cert_buttons_1 button[id=revoke]').button({'disabled': true}); 
	    	$('#cert_buttons_1 button[id=reinstate]').button({'disabled': true}); 
	    	$('#cert_buttons_1 button[id=destroy]').button({'disabled': false}); 
	    	break;
	    case 2: //If cert is revoked the enable reinstate and destroy buttons
	    	$('#cert_buttons_1 button[id=revoke]').button({'disabled': true}); 
	    	$('#cert_buttons_1 button[id=reinstate]').button({'disabled': false}); 
	    	$('#cert_buttons_1 button[id=destroy]').button({'disabled': false});    	
	    	break;
	    }
    	
    	jQuery('#grid_table').jqGrid('setSelection',$(this).text());
    	
    	$.ajax({
    	    url:'view_cert?sn=' + $(this).text() + '&cert_format=TXT',
    	    method: 'POST',
    	    dataType: 'json',
    	    success: function (data) {
    	        $('#view_cerificate_dlg').dialog({ title: S_VIEW_CERTIFICATE_TITLE });
    	        
    	        var cert = data['cert'];
    	        
    	        $('#cert_text').append('<pre/>').val(cert);
    	        
    	        if(data['format'] === 0) {
    	            $('#pkcs12_button').button({'disabled': true}); 
    	        }
    	        else {
    	            $('#pkcs12_button').button({'disabled': false}); 
    	        }
                $('#view_cerificate_dlg').dialog('open').height('auto');
                
    	        $('#view_cerificate_dlg').dialog('option', 'position', 'center'); //Center the dialog
    	    },
    	    error : function (xhr,status,error) {
    	    	alert(xhr.responseText);
    	    }
    	});
    	
    	return false;
    },
    
    popupMenuAction : function (event) {
    	event.preventDefault();
    	closemenu('#btn_action', '#ul_action');
    	CA_MANAGE.certificateAction(this.id);
    },
    
    popupMenuFilterAction : function (event) {
    	event.preventDefault();
    	closemenu('#btn_filter', '#ul_filter');
        CA_MANAGE.initPagination();
        
        var filter_option = 0;
    	
        switch (this.id) {
    	    case 'all': 
    	    	CA_MANAGE.filter_by = '';
    	    	CA_MANAGE.updateViewAction();
    	    	filter_option = 0;
    	        break;
    	    case 'valid':
    	    	CA_MANAGE.filter_by = 'valid';
    	    	CA_MANAGE.updateViewAction();
    	    	filter_by = 1;
    	    	break;
    	    case 'revoked':   
    	    	CA_MANAGE.filter_by = 'revoked'; 	 
    	    	CA_MANAGE.updateViewAction();   
    	    	filter_option = 2;	
    	    	break;
    	    case 'expired':   
    	    	CA_MANAGE.filter_by = 'expired';
    	    	CA_MANAGE.updateViewAction();
    	    	filter_option = 3;
    	    	break;
    	}
        
    	var filter_text = S_FILTER_BY_TEXT[filter_option];
    	$('#filter_by').text(filter_text);
    },
    
    pkcs12Action : function() {
        $('#pkcs12_password_dlg').dialog({ title: S_PKCS12_PASSWORD_TITLE });
        $('#pkcs12_password_dlg').dialog("open").height('auto');
    },
    
    pemAction : function() {
        var serial = jQuery('#grid_table').jqGrid('getGridParam','selarrrow'); 
        
        var ret = jQuery('#grid_table').jqGrid('getRowData',serial.toString());
    	
        $.ajax({
            url: 'view_cert?sn=' + serial + '&cert_format=PEM',
            type: 'POST',
            success : function(data) {
                window.location = 'get_cert_file';    			
            }
        });
    },
    
    /*
     * This is the main method which makes the call to 'cert_list' method on the server
     * We need to update the url before the request is made.
     */
    updateViewAction : function(last_sn) {

    	var url = CA_MANAGE.updateURL(last_sn);
    	
        jQuery('#grid_table')
	        .setGridParam({'url': url})
	        .trigger('reloadGrid');       	
    },
    
    /*
     *  Update the url with the latest information ie:
     *     a. pass in any search text if entered and search type[sn ,org unit or cname]
     *     b. pass in any filters if selects [all, valid, revoked, expired]
     *     c. If 'last_sn's is present then pass in that too
     */
    updateURL : function(last_sn) {
    	
    	var url = 'cert_list?';

    	var search_type = $('#options_search').val();
    	var search_text = $('#search_box').val();
    	
    	if(search_text.length != 0 ) {
    	    url = url + 'search_type=' + search_type + '&search_text=' + search_text;
    	}
    	
    	if (CA_MANAGE.filter_by != '') {
            url = url + '&filter_by=' + CA_MANAGE.filter_by;
    	}
        
    	if(last_sn != undefined) {
            url = url +'&after_sn=' + last_sn;
    	}
    	
    	return url;
    },
    
    /*
     * Called when user clicks the Clear button
     *   a. Reset the search filter to 'Serial Number'
     *   b. Reset the search text field to ''
     *   c. Update the filter_by span text to 'All'
     *   d. Hide the clear button
     *   e. Finally reset the grid by getting the data from the beginning of the cert list
     */
    clearAction : function() {

    	var filter_text = S_FILTER_BY_TEXT[0];
    	
    	$('#options_search').val('SN');
    	$('#search_box').val('');
    	$('#filter_by').text(filter_text);
        $('#btn_clear').hide();  
        
        CA_MANAGE.filter_by = 0;
        CA_MANAGE.resetCertsGrid();
    },
    
    /*
     * Clear the prev list and disable prev button [initPagination]
     * Get the records from the beginning of the cert list
     */
    resetCertsGrid : function () {
        CA_MANAGE.initPagination();
        CA_MANAGE.updateViewAction();
    },
    
    //click on search button
    searchAction : function() {
        CA_MANAGE.resetCertsGrid();
        $('#btn_clear').show();
    },
    
    getGridData : function() {
        $.ajax({
            url: 'ca_grid_columns',
            method: 'GET',
            dataType: 'json',
            success: CA_MANAGE.onGridDataReceived
        });      	
    },
    
    onGridDataReceived : function(columns) {
        
    	jQuery('#grid_table').GridUnload('#grid_table');

        $('#grid_table').jqGrid({
            url: 'cert_list',
            datatype: 'json',
            mtype: 'GET',
            colNames: columns.col_names,
            colModel: columns.col_model,
            altRows: true,
            altclass: 'gridAltRow',
            pager: '#pager',
            pagerpos: 'right',
            loadui: 'block',
            caption: '',       
            multiselect:true,
            multiselectWidth:25,
            height: 'auto',
            width: 'auto',
            viewrecords: false,
            autowidth:true,
            recordpos: 'left',
            toppager: true,
            shrinkToFit: true,
            rowNum: 25, pgtext:'',pgbuttons:false,
            rowList: [25, 100, 250, 500, S_ALL_CERTS],
            //Before making a request check if row number has changed if yes, 
            //then get the data from the beginning of the cert list
            beforeRequest : function () {
            	var rowNum = jQuery('#grid_table').jqGrid('getGridParam','rowNum'); 
            	
            	if(CA_MANAGE.current_row_num != rowNum) {
                    CA_MANAGE.current_row_num = rowNum;
                    CA_MANAGE.resetCertsGrid();
                }
            },
            loadError: function(xhr,status,error) {
                var error_msg = xhr.responseText;        
                var msg = S_PROCESSING_ERROR;
                msg += '\n\n' + error_msg;
                alert(msg);
            },
            loadComplete: function(data) {
            	
            	//After loading is done, get the state of the next button, 
            	//this is determined at the server end
                var disable_next_button = data['disable_next_button'];

                $('#next_button').button({'disabled': disable_next_button});   
     
                if(CA_MANAGE.prev_list.length > 0) {
                    $('#prev_button').button({'disabled': false});  
                }   
                
                $(window).resize();
            }
        });
    },
    
    //Utility method to check if at least one row has been selected
    isRowSelected : function() {
    	var $grid = $('#grid_table');
    	
    	var selected_rows = $grid.getGridParam('selarrrow');
    	
    	if (selected_rows.length === 0) {
    	    $('#warn_dlg').text(S_SELECT_ONE_CERTIFICATE).dialog('open').height('auto');
    	    return false;
    	}
    	return true;    	
    },
    
    /*  Utility method to invoke 'revoke', 'reinstate' and 'destroy' actions
     *  This method is shared by the buttons under 'Actions' menu and 
     *  by the buttons under the 'View Certificate Data' dialog[ invoked when user clicks on a serial number]
     */
    certificateAction : function (id) {
        if(!CA_MANAGE.isRowSelected()) {
            return;
        }
        
        //this.id is true when buttons on the dialog are clicked
        //id is true when buttons on the 'Actions' popup menu is clicked
        var action_id = this.id || id ;  
	    
        if(action_id === undefined) {
            return;
        }
      
        //Pass the id of the button clicked, based on this we will do the necessary action
        var action_data = {'action_id':action_id};
	    
        $('#confirm_dlg').text(S_ACTION_WARNINGS[action_id])
                         .dialog('open')
                         .data(action_data)
                         .dialog('option', 'title', S_CONFIRM_TITLE)
                         .height('auto');
    }
};
$(document).ready(CA_MANAGE.init);