var CA_UPLOAD = {
    
    allVars : $.getUrlVars(),
    
    urlStatus : $.getUrlVar('status'),
    
    init : function() {
    	CA_UPLOAD.initUI();
    	CA_UPLOAD.initEvents();
    },
    
    initUI : function() {

        $("#progress").hide();
                
        $("#warn_dlg").dialog({
            autoOpen: false, resizable: false,
            modal: true, title: S_WARNING_TITLE,
            height: 70,
            buttons: [{
                text: S_OK_BUTTON,
            	click: function () {
                    $(this).dialog("close");
                }
            }]
        });
        
        if(parseInt(CA_UPLOAD.urlStatus,10) === 1) {
            $("#upload_fail").text(S_UPLOAD_ERROR);
        }
        else if (parseInt(CA_UPLOAD.urlStatus,10) === 0) {
            window.location = 'get_cert_file';
            $("#progress").hide();
        }
    },
    
    initEvents : function() {
        $('#upload_btn').button()
                        .click(CA_UPLOAD.uploadAction);  	     
        $('#reset_btn').button()
                       .click(CA_UPLOAD.resetAction);  
    },
    
    uploadAction : function() {
    	if($('#cname').val().length === 0) {
    	    $("#warn_dlg").text(S_CNAME_IS_REQUIRED).dialog('open').height("auto");
    	    return false;
    	}
    	if($('#fname').val().length === 0 ) {
    	    $("#warn_dlg").text(S_CERT_IS_REQUIRED).dialog('open').height("auto");
    	    return false;
    	}

        $("#progress").show();
        $("#upload_fail").text('');
    	$('#upload_form').submit();    	
    },
    
    resetAction : function() {        
    	$('#upload_form').each(function() {
    	    this.reset();
    	});

    	return false;
    }       
};
$(document).ready(CA_UPLOAD.init);