function formatterBandwidth(format, val) {
    return $.formatBytes(val);
}

var D_CXNLIST_POPUP = {
    grid_selector: '',
    plot_trend: null,
    seriesLength: 0,
    chart_series: null,
    byte_color: 'rgb(65,100,48)',
    hit_color: 'rgb(31,119,180)',
    init: function () {

        D_CXNLIST_POPUP.initUI();
        D_CXNLIST_POPUP.initEvents();

    },
    initUI: function () {
    },
    initEvents: function () {
        $("#log_frequency_graph").bind('jqplotDataClick', function (ev, seriesIndex, pointIndex, data) {
            var click_time = D_CXNLIST_POPUP.chart_series[pointIndex][0];
            click_time = click_time.substring(0, click_time.lastIndexOf(':'));

            /* Highlight row */
            //var group = D_CXNLIST_POPUP.data_selector + '_popupgrid';
            var grid_selector = D_CXNLIST_POPUP.grid_selector; //"#div_" + group + "_grid";
            var rows = $(grid_selector).getDataIDs();
            D_CXNLIST_POPUP.clearSelection();
            for (var i = 0; i < rows.length; i++) {
                var row = $(grid_selector).getRowData(rows[i]);
                var compare_time = row.start_time.substring(0, row.start_time.lastIndexOf(':'));
                compare_time = compare_time.substring(0, compare_time.lastIndexOf(':'));
                if (compare_time == click_time) {
                    D_CXNLIST_POPUP.selectText(rows[i]);
                    $(grid_selector).setSelection(rows[i]);
                }
            }
            $(grid_selector).resetSelection();
        });
    },
    closePopup: function () {
        if ($("#popup_connections").is(":visible")) {
            $("#popup_connections").hide();
        }
    },
    fullScreenPopup: function (series, selector, selector_data, filter_selector, filter_data) {
        $("#cxn_popup").hide();
        $("#popup_connections").show();

        var group = '_popup';
        // Unload the grid and then recreate it 
        var grid_selector = "#div_" + group + "_grid";
        D_CXNLIST_POPUP.grid_selector = grid_selector;
        var pager_selector = "#div_" + group + "_pager";
        jQuery(grid_selector).GridUnload(grid_selector);

        $("#popup_connections_resources").html("");

        var grid_html = '<div id="div_' + group + '" class="cl">'
                            + '<table id="div_' + group + '_grid" class="resizableGrid scroll" ></table>'
                            + '<div id="div_' + group + '_pager" class="scroll" style="text-align:right;"></div>'
                        + '</div>';
        $("#popup_connections_resources").html(grid_html);

        var chartMaxBytes = 0;
        var chartMaxHits = 0;
        var totalRecords = 0;
        var totalHits = 0;

        var col_names = D_CXN_POPUP_COL_NAMES;
        var col_model = [
                { 'name': 'start_time', 'index': 'start_time', 'sortable': true, 'width': 20 },
                { 'name': 'disp', 'index': 'disp', 'sortable': true, 'width': 5 },
                { 'name': 'src_ip', 'index': 'src_ip', 'sortable': true, 'width': 15 },
                { 'name': 'dst_domain', 'index': 'dst_domain', 'sortable': true, 'width': 25 },
                { 'name': 'port', 'index': 'port', 'sorttype': 'int', 'sortable': true, 'width': 6 },
                { 'name': 'bytes', 'index': 'bytes', 'formatter': $.commaify, 'sorttype': 'int', 'sortable': true, 'width': 12 },
                { 'name': 'count', 'index': 'count', 'sorttype': 'int', 'sortable': true, 'width': 5 }
        ];

        $(grid_selector).jqGrid({
            datatype: "local",
            colNames: col_names,
            colModel: col_model,
            autoencode: true,
            rowNum: -1,
            height: '100',
            loadonce: true,
            sortable: true,
            sortname: 'bytes',
            sortorder: 'desc',
            scroll: true,
            scrollrows: true,
            autowidth: true,
            forceFit: true,
            shrinkToFit: true
        }).navGrid(pager_selector, { refresh: false, search: false, edit: false, add: false, del: false }, {}, {}, {});

        if (series !== undefined && series.length > 0) {
            for (var i = 0; i < series.length; i++) {
                var bytes = parseInt(series[i].bytes, 10);
                var count = parseInt(series[i].count, 10);
                chartMaxBytes = Math.max(chartMaxBytes, bytes);
                chartMaxHits = Math.max(chartMaxHits, count);
                totalRecords += 1;
                totalHits += count;
            }
            for (var i = 0; i < series.length; i++) {
                var count = parseInt(series[i].count, 10);
                var hit_pct = parseInt((count / chartMaxHits) * 100, 10);
                var bytes = parseInt(series[i].bytes);
                var byte_pct = 0;
                if (bytes > 0) {
                    byte_pct = parseInt((bytes / chartMaxBytes) * 100, 10);
                }
                var row = { 'hit_pct': hit_pct, 'byte_pct': byte_pct, 'group': group};
                series[i].start_time = $.getDateDisplay(series[i].start_time);
                series[i].id = i;
                series[i].hit_pct = hit_pct;
                series[i].byte_pct = byte_pct;
                series[i].group = group;
            }
            $(grid_selector).jqGrid('addRowData', 'id', series);
            $(grid_selector).setGridParam({ rowNum: series.length });

            $(grid_selector).setGridParam({ sortname: 'bytes' });
            if (chartMaxBytes == 0 || isNaN(chartMaxBytes)) {
                $(grid_selector).setGridParam({ sortname: 'count' });
            }
            $(grid_selector).trigger('reloadGrid');;

            $(grid_selector).resetSelection();
        }
        else {
            $(grid_selector).jqGrid('clearGridData');
        }

        var title = selector_data + "<span style='font-weight:normal;'> [" + series.length + " &#8250; " + totalHits + " " + D_CXN_HITS + "]</span>";
        if (filter_data != '') {
            title = selector_data + " &#8250; " + filter_data + "<span style='font-weight:normal;'> [" + series.length + " &#8250; " + totalHits + " " + D_CXN_HITS + "]</span>";
        }
        $("#popup_connections_title").html(title);

    },
    clearSelection: function() {
        selection = window.getSelection();
        selection.removeAllRanges();
    },
    selectText: function (element) {
        var doc = document
            , text = doc.getElementById(element)
            , range, selection
        ;
        if (doc.body.createTextRange) { //ms
            range = doc.body.createTextRange();
            range.moveToElementText(text);
            range.select();
        } else if (window.getSelection) { //all others
            selection = window.getSelection();
            range = doc.createRange();
            range.selectNodeContents(text);
            //selection.removeAllRanges();
            selection.addRange(range);
        }
    },

    /* Chart */
    updateChartData: function (seriesLength, series1, series2) {
        var barWidth = 1;
        if (series1 == null || series1.length == 0
            || series2 == null || series2.length == 0) {
            $('#div_frequency').hide();
            return;
        }

        D_CXNLIST_POPUP.chart_series = series1

        $('#div_frequency').show();
        $('#log_frequency_graph').show();
        $('#log_frequency_loading').hide();
        $.jqplot.config.enablePlugins = true; // on the page before plot creation.    

        if (D_CXNLIST_POPUP.plot_trend) {
            $("#log_frequency_graph *").unbind();
            D_CXNLIST_POPUP.plot_trend.destroy();
        }

        for (var i = 0; i < series1.length; i++) {
            series1[i][0] = $.getDateDisplay(series1[i][0])
            series2[i][0] = $.getDateDisplay(series2[i][0])
        }

        var options = D_CXNLIST_POPUP.bar_options;
        options.axes.xaxis.min = series1[0][0]; // '2013-03-08';
        options.axes.xaxis.max = series1[0][-1]; // '2013-03-08';
        D_CXNLIST_POPUP.seriesLength = seriesLength;
        D_CXNLIST_POPUP.plot_trend = $.jqplot('log_frequency_graph', [series1, series2], options);
        D_CXNLIST_POPUP.setBarWidths(D_CXNLIST_POPUP.plot_trend, seriesLength, "#log_frequency_graph");
        D_CXNLIST_POPUP.plot_trend.replot();

    },
    bar_options: {
        title: { show: false },
        legend: {
            yoffset: 0, show: false
        },
        gridPadding: { left: 0, top: 0, right: 0, bottom: 0 },
        series: [{
            renderer: $.jqplot.BarRenderer,
            label: ' ',
            neighborThreshold: 2,
            color: '#5B94B6' // hit_color
        },
        {
            renderer: $.jqplot.BarRenderer,
            label: ' ',
            neighborThreshold: 2,
            yaxis: 'y2axis',
            color: '#258825' // byte_color
        }],
        seriesDefaults: {
            shadow: false,
            renderer: $.jqplot.BarRenderer,
            pointLabels: { show: false },
            rendererOptions: {
                barWidth: 10,
                barPadding: 0,
                barDirection: 'vertical'
            }
        },
        grid: {
            background: '#ffffff',
            shadow: false
        },
        axesDefaults: {
            useSeriesColor: false
        },
        axes: {
            xaxis: {
                pad: 0,
                renderer: $.jqplot.DateAxisRenderer,
                autoscale: false,
                numberTicks: 5,
                tickOptions: {
                    showLabel: false,
                    angle: 0,
                    formatString: '%Y-%m-%d %H:%M',
                    fontSize: 9
                }
            },
            yaxis: {
                tickOptions: {
                    fontSize: 9,
                    formatString: '%.0f',
                    show: false,
                    showLabel: false
                },
                pad: 0,
                padMax: 1.2,
                min: 0,
                autoscale: false
            },
            y2axis: {
                tickOptions: {
                    fontSize: 9,
                    formatString: '%.0f',
                    show: false,
                    formatter: formatterBandwidth,
                    showLabel: false
                },
                pad: 0,
                padMax: 1.2,
                min: 0,
                autoscale: false
            }
        },
        highlighter: {
            show: true,
            showMarker: false,
            formatString: '%s %s',
        },
        cursor: {
            zoom: false,
            tooltipLocation: 'sw',
            showVerticalLine: false,
            showCursorLegend: false,
            showTooltip: false,
            cursorLegendFormatString: '%s%s %s',
            constrainZoomTo: 'x'
        }
    },
    doResize: function (data_selector, data_filter_selector, data_filter_data, width) {
        var grid_width = width - 20;
        if ($('#popup_connections').is(':visible')) {
            var pos = $("#chart_td").offset();
            var frequency_graph_height = $("#log_frequency_graph").height();
            var popup_height = $(window).height() - pos.top - 15;
            var resources_height = popup_height - $("#popup_connections_title").height() - 20;
            if ($("#popup_connections_limit_warning").is(":visible")) {
                resources_height -= $("#popup_connections_limit_warning").outerHeight(true);
            }
            $("#popup_connections").offset({ top: pos.top, left: pos.left });
            $("#popup_connections").width(width);
            $("#popup_connections").height(popup_height);

            var group = '_popup';
            var grid_selector = "#div_" + group + "_grid";
            $(grid_selector).setGridWidth(grid_width);
            $(grid_selector).setGridHeight(resources_height - 20 - frequency_graph_height);
            $("#popup_connections_resources").height(resources_height);


            /* Resize chart */
            $("#div_frequency").width(grid_width + 1);
            if (D_CXNLIST_POPUP.plot_trend != null) {
                var length = D_CXNLIST_POPUP.seriesLength;
                if (D_CXNLIST_POPUP.plot_trend.plugins.cursor._zoom.isZoomed) {
                    length = 1;
                    for (var i in D_CXNLIST_POPUP.plot_trend.series[0].data) {
                        if (D_CXNLIST_POPUP.plot_trend.series[0].data[i]['0'] > D_CXNLIST_POPUP.plot_trend.axes.xaxis.min
                            && (D_CXNLIST_POPUP.plot_trend.series[0].data[i]['0'] < D_CXNLIST_POPUP.plot_trend.axes.xaxis.max)) {
                            length += 1;
                        }
                    }
                }
                D_CXNLIST_POPUP.setBarWidths(D_CXNLIST_POPUP.plot_trend, length, "#div_frequency", grid_width);
                D_CXNLIST_POPUP.plot_trend.replot();
            }
        }
    },
    setBarWidths: function (plot, seriesLength, selector, width) {
        if (!width) {
            width = $(selector).width();
        }
        var barWidth = 1;
        if (seriesLength > 0) {
            barWidth = Math.max(1, parseInt(width / 2 / seriesLength) - 1);
            var log = "length: " + seriesLength.toString() + " width: " + width.toString() + " bar: " + barWidth.toString();
        }
        var barWidth2 = Math.min(barWidth, 50)
        if (plot) {
            $.each(plot.series, function (index, series) {
                series.barWidth = barWidth2;
            });
        }
        return barWidth2;
    }
};
$(document).ready(D_CXNLIST_POPUP.init);

