var D_CXN_FWATCH_WLOG = {
    init: function () {
        D_CXN_FWATCH_WLOG.initUI();
        D_CXN_FWATCH_WLOG.initEvents();
    },
    initUI: function () {
    },
    initEvents: function () {
    },
    getData: function (onsuccess_cb, data_selector, data_filter_selector, data_filter_data, state, view_type, urlSn, minutes) {
        var url = 'get_fwatch_data?group=' + data_selector;
        if (data_filter_selector.length > 0) {
            url += '&filter=' + data_filter_selector;
        }
        if (data_filter_data.length > 0) {
            url += '&filterdata=' + encodeURIComponent(data_filter_data);
        }
        if (minutes && minutes > 0) {
            url += "&minutes=" + minutes;
        }
        url += '&sn=' + urlSn;
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: function (xhr, status, error) {
                checkLoginPageRedirect(xhr, status, error);
            },
            success: function (data) {
                var total = 0;
                for (var item in data.items[0]) {
                    total += parseInt(data.items[0][item].connections, 10);
                }
                $("#cxncnt, #fs_cxncnt").html(total);
                var display_nodes = { 'name': "", 'children': null };
                if (data.items[0]) {
                    $("#hitcnt, #fs_hitcnt").html(data.items[0].length);
                    display_nodes = { 'name': "", 'children': data.items[0], 'time_s': data.time_s };
                }
                onsuccess_cb(display_nodes, data_selector);
            }
        });

    },
    /*
    * Retrieve list of filtered connections from firewalld
    */
    getConnectionList: function (onsuccess_cb, disp_deny, selector, selector_data, selector_data_name, filter_selector, filter_data, filter_data_name, urlSn) {
        var url = 'get_fwatch_cxn_data';
        if (selector == '' || selector_data == '') {
            return;
        }

        url += '?selector=' + selector;
        url += '&selector_data=' + encodeURIComponent(selector_data);
        if (filter_selector != '' && filter_data != '') {
            url += '&filter_selector=' + encodeURIComponent(filter_selector);
            url += '&filter_data=' + encodeURIComponent(filter_data);
        }
        url += '&disp_deny=' + disp_deny;
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: function (xhr, status, error) {
                checkLoginPageRedirect(xhr, status, error);
            },
            success: function (data) {
                onsuccess_cb(data, selector, selector_data_name, filter_selector, filter_data_name);
            }
        });

    }
};
$(document).ready(D_CXN_FWATCH_WLOG.init);

