var D_SUMMARY = {
    dashboardType: 'executive',
    urlCluster: '',
    urlSn: '',
    urlTz: null,
    minutes: 1440,
    groups: [],
    group_names: [],
    byte_color: 'rgb(65,100,48)',
    hit_color: 'rgb(31,119,180)',
    deny_color: 'rgb(240, 16, 0)',
    data_filter_selector: '',   // Filter, e.g. 'destination'
    data_filter_data: '',       // Filter data, e.g. 'muser@wgti.net'
    drilldown: '',
    total_entities: 0,
    total_bytes: 0,
    total_cxns: 0,
    chartMaxBytes: 1,
    chartMaxHits: 1,
    tidResize: null,
    init: function () {
        var allVars = $.getUrlVars();
        D_SUMMARY.urlSn = $.getUrlVar('sn');

        D_SUMMARY.dashboardType = data.dashboard_type;
        D_SUMMARY.initUI();
        D_SUMMARY.initEvents();
    },
    initUI: function () {
        $(".frontpanelUnit").hide();

        D_SUMMARY.groups = D_SUMMARY_EXECUTIVE_GROUPS;
        D_SUMMARY.group_names = D_SUMMARY_EXECUTIVE_GROUP_NAMES;
        if (D_SUMMARY.dashboardType == 'security') {
            D_SUMMARY.groups = D_SUMMARY_SECURITY_GROUPS; 
            D_SUMMARY.group_names = D_SUMMARY_SECURITY_GROUP_NAMES;
            $(".root").html(D_SUMMARY_SECURITY); 
        }
        var group = '';
        var name = '';
        for (var i = 0; i < D_SUMMARY.groups.length; i++) {
            group = D_SUMMARY.groups[i];
            name = D_SUMMARY.group_names[i];
            D_SUMMARY.createGridDiv(group, name);
        }
    },
    initEvents: function () {
        $("#root_breadcrumb").live('click', function (eo) {
            var enable = false;
            $("#breadcrumb_lhs").html('<span class="">' + breadcrumb_title + '</span>');

            D_SUMMARY.toggleZoomOptions(false);
            D_SUMMARY.toggleFilterOptions(false, D_SUMMARY.data_filter_selector, D_SUMMARY.data_filter_data);
            D_SUMMARY.getChartData();
        });
        $("#data_filter_data").live('click', function (eo) {
            D_SUMMARY.toggleZoomOptions(false);
            D_SUMMARY.toggleFilterOptions(true, D_SUMMARY.data_filter_selector, D_SUMMARY.data_filter_data);
            D_SUMMARY.getChartData();
        });
        $(".drilldown_link").live('click', function (eo) {
            var filter_selector = this.name; //"source";
            var filter_data = this.title; // "10.0.1.3";
            if (filter_selector === 'denied_apt' || filter_selector === 'undetected_apt') {
                filter_data = filter_data.substring(D_SUMMARY_SECURITY_THREAT_ID.length);
            }
            D_SUMMARY.toggleFilterOptions(true, filter_selector, filter_data);
            D_SUMMARY.getChartData();
        });
        $('.zoom_link').live('click', function (eo) {
            var group = this.id;
            var name = $('#' + this.id).text();
            if (D_SUMMARY.drilldown != '') {
                return;
            }

            D_SUMMARY.drilldown = group;

            $('.frontpanelUnit').hide();
            D_SUMMARY.toggleZoomOptions(true, name);
            D_SUMMARY.getChartData();
        });

        $(window).bind('resizeEnd', function () {
            D_SUMMARY.doResize();
        });

        $("#custom_datepicker_trigger").bind('click', function () {
            // Listen for a click on this div, it means the date changed 
            // and a refresh is needed
            D_SUMMARY.getChartData();
        });
        $('#exec_sum_pdf').find('img').click(function (eo) {
            eo.preventDefault();
            D_SUMMARY.toggleSpinner(true);
            var startEnd = R_DATE_NAVBAR.getStartEndIsoStr();
            var startTime = startEnd[0];
            var endTime = startEnd[1];

            startTime = R_DATE_NAVBAR.convertDateStr2GMT(startTime + ':00');
            endTime = R_DATE_NAVBAR.convertDateStr2GMT(endTime + ':00');

            var repType = 'exec_summary';
            $.ajax({
                url: "/report/saveAsPdf?serial=" + D_SUMMARY.urlSn + "&client_tz=" + WGRD.client_tz + "&start_time=" + startTime + "&end_time=" + endTime + "&report_type=" + repType,
                type: 'POST',
                contentType: 'application/json',
                error: function() {
                    D_SUMMARY.toggleSpinner(false);
                },
                success: function (data) {
                    D_SUMMARY.toggleSpinner(false);
                    if (!data.status) {
                        if (data.message) {
                            alert(data.message);
                        }
                        return true;
                    }
                    window.location = "/report/get_pdf_file?serial=" + D_SUMMARY.urlSn;
                    return false;
                }
            });
        });
    },
    unZoom: function () {
        var selector = "#" + D_SUMMARY.minutes;
        $(selector).click();
    },
    toggleZoomOptions: function (enable, zoom_selector) {
        if (enable) {
            $("#breadcrumb_lhs").html('');
            $("#breadcrumb_lhs").html('<span id="root_breadcrumb" class=""><a href="#">' + breadcrumb_title + '</a></span>');
            if (D_SUMMARY.data_filter_selector != '') {
                $("#breadcrumb_lhs").append('<span id="data_filter_divider" class="divider">/</span><span><a href="#" id="data_filter_data"></a></span>');
                $("#data_filter_data").html(D_SUMMARY.data_filter_data);
            }
            $("#breadcrumb_lhs").append('<span class="divider">/</span><span>' + zoom_selector + '</span>');
        } else {
            if (D_SUMMARY.drilldown != '') {
                $("#sum_top_drilldown_" + D_SUMMARY.drilldown).remove();
            }
            D_SUMMARY.drilldown = '';
        }
    },
    toggleFilterOptions: function (enable, filter_selector, filter_data) {
        if (enable) {
            if (D_SUMMARY.drilldown != '') {
                D_SUMMARY.toggleZoomOptions(false);
            }

            $("#breadcrumb_lhs").html('');
            $("#breadcrumb_lhs").html('<span id="root_breadcrumb" class=""><a href="#">' + breadcrumb_title + '</a></span>');
            $("#breadcrumb_lhs").append('<span id="data_filter_divider" class="divider">/</span><span id="data_filter_data"></span>');

            $('#tab_' + filter_selector).hide();
            D_SUMMARY.data_filter_selector = filter_selector;
            D_SUMMARY.data_filter_data = filter_data;
            if ((filter_selector === 'denied_apt' || filter_selector === 'undetected_apt') && filter_data.indexOf(D_SUMMARY_SECURITY_THREAT_ID) !== 0) {
                D_SUMMARY.data_filter_data = D_SUMMARY_SECURITY_THREAT_ID + filter_data;
            }
            $("#data_filter_data").html(D_SUMMARY.data_filter_data);
        } else {
            $('#tab_' + D_SUMMARY.data_filter_selector).show();
            D_SUMMARY.data_filter_selector = "";
            D_SUMMARY.data_filter_data = "";

            $("#data_filter_data").html("");

        }
    },
    getChartData: function (start, end) {
        if (D_SUMMARY.urlCluster == null) {
            D_SUMMARY.urlCluster = 'NONE';
        }
        D_SUMMARY.toggleSpinner(true);

        var start_dt = $("#reports_toolbar_start").text();
        var end_dt = $("#reports_toolbar_end").text();
        if (start_dt != '') {
            start_dt = start_dt.substring(0, start_dt.length - 2).trim(); //Remove the '-' from date at the end'
            start_dt = $.getDateLocalToSecs(start_dt);
        }
        if (end_dt != '') {
            end_dt = $.getDateLocalToSecs(end_dt);
        }

        var url = 'get_summary_data?';
        if (D_SUMMARY.drilldown == '') {
            url += 'groups=';
            for (var i = 0; i < D_SUMMARY.groups.length; i++) {
                url += D_SUMMARY.groups[i];
                if (i < D_SUMMARY.groups.length - 1) {
                    url += ',';
                }
            }
        } else {
            url += 'groups=' + D_SUMMARY.drilldown + '&drilldown=1';
        }
        var filter_selector = D_SUMMARY.data_filter_selector;
        if (filter_selector.indexOf('denied_') == 0) {
            filter_selector = filter_selector.substring('denied_'.length);
        }
        if (D_SUMMARY.data_filter_selector != undefined && D_SUMMARY.data_filter_selector != '') {
            var filter_data = D_SUMMARY.data_filter_data;
            if (filter_data.indexOf(D_SUMMARY_SECURITY_THREAT_ID) === 0) { //If THREAT ID is at the beginning
                filter_data = filter_data.substring(D_SUMMARY_SECURITY_THREAT_ID.length);
            }
            url += '&filter=' + filter_selector + '&filterdata=' + encodeURIComponent(filter_data);
        }
        if (D_SUMMARY.dashboardType == 'security') {
            url += '&disp_deny=1';
        }
        url += '&sn=' + D_SUMMARY.urlSn + '&start_time=' + start_dt + '&end_time=' + end_dt;

        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: checkLoginPageRedirect,
            success: D_SUMMARY.onDataReceived
        });
    },
    toggleSpinner: function (b) {
        if (b) {
            $('.loading_spinner').remove();
            $('#pdf_link').hide();
            $('#filterbuttons').prepend('  <span class="loading_spinner"><img src="/images/loader.gif" /></span>');
        } else {
            $('.loading_spinner').remove();
            $('#pdf_link').show();
        }
    },
    onDataReceived: function (data) {
        var barWidth = 1;

        D_SUMMARY.toggleSpinner(false);
        $.jqplot.config.enablePlugins = true; // on the page before plot creation.    

        var columns = {};
        columns.col_names = data.col_names;
        columns.col_model = data.col_model;

        D_SUMMARY.chartMaxBytes = 1;
        D_SUMMARY.chartMaxHits = 1;

        var group = '';
        D_SUMMARY.total_entities = 0;
        D_SUMMARY.total_bytes = 0;
        D_SUMMARY.total_cxns = 0;
        $("#entity_info").hide();
        if (D_SUMMARY.drilldown == '') {
            for (var i = 0; i < D_SUMMARY.groups.length; i++) {
                group = D_SUMMARY.groups[i];
                if (group == D_SUMMARY.data_filter_selector) {
                    $("#sum_top_" + group).hide();
                    continue;
                }
                D_SUMMARY.createGrid("#sum_top_" + group, "#div_" + group + "_grid", "#div_" + group + "_pager", group, data.items[i], columns);
            }
            // Refresh grids so max is applied correctly
            for (var i = 0; i < D_SUMMARY.groups.length; i++) {
                var grid_selector = "#div_" + D_SUMMARY.groups[i] + "_grid";
                $(grid_selector).trigger("reloadGrid");
            }
        } else {
            group = D_SUMMARY.drilldown;
            D_SUMMARY.createGrid("#sum_top_" + group, "#div_" + group + "_grid", "#div_" + group + "_pager", group, data.items[0], columns);
            $("#entity_info").show();
            var grid_selector = "#div_" + D_SUMMARY.drilldown + "_grid";
            $(grid_selector).trigger('reloadGrid'); ;

        }
        $("#bytecnt").html($.commaify(D_SUMMARY.total_bytes));
        $("#hitcnt").html(D_SUMMARY.total_entities);
        $("#cxncnt").html(D_SUMMARY.total_cxns);
        D_SUMMARY.doResize();
        D_SUMMARY.tidResize = setTimeout(D_SUMMARY.doResize, 1000); // Delay firing another resize to help initial display if scrollbar isn't shown yet
    },
    doResize: function () {
        clearInterval(D_SUMMARY.tidResize);
        var fpwidth = $("#main_div_row").width();
        fpwidth -= $(".date_navbar_td").width();
        var marginleft = parseInt($(".frontpanelUnit").css('margin-left'));
        var marginright = parseInt($(".frontpanelUnit").css('margin-right'));
        var CHARTCOUNT = 1;
        $(".frontpanelUnitBig").height('auto');
        if (D_SUMMARY.drilldown == '' && fpwidth > 800) {
            CHARTCOUNT = 2;
            $(".frontpanelUnitBig").height(300); // Set explicit height for div containing grid
        }

        var fp_div_width = (fpwidth / CHARTCOUNT) - (marginright + marginleft) - 4;
        $(".frontpanelUnitBig").width(fp_div_width);
        $(".resizableGrid").setGridWidth(fp_div_width - 1);
    },
    linkFormatter: function (cellvalue, options, rowObject) {
        var name = escapeHtml(rowObject.name);
        var title = name;
        if (rowObject.group === 'denied_apt' || rowObject.group === 'undetected_apt') {
            title = D_SUMMARY_SECURITY_THREAT_ID + title;
            name = escapeHtml(rowObject.detail);
        }
        var href = '<a href="#" name="' + rowObject.group + '"title="' + title +'" class="drilldown_link">' + name + '</a>';
        return href;
    },
    chartFormatter: function (cellvalue, options, rowObject) {
        var data = 0;
        var div_w = 0;
        var color = 'rgb(31,119,180)';
        var color_class = 'pctbar_hits';
        var font_class = '';
        if (options.colModel.index === 'bytes') {
            var bytes = parseInt(rowObject.bytes, 10);
            data = $.formatBytes(bytes, D_SUMMARY_FORMAT_GB, D_SUMMARY_FORMAT_MB, D_SUMMARY_FORMAT_KB, ' ');

            var percent = parseInt((bytes / D_SUMMARY.chartMaxBytes) * 100, 10);
            div_w = (percent > 1 || bytes === 0) ? percent : 1;
            color = rowObject.byte_color;
            color_class = 'pctbar_byte';
            var div = '<div class="pctbar progress-inverse pctbar"><div class="' + color_class 
                + ' pctbar-bar" style="width:' + div_w + '%;"></div></div>'
                + '<div style="width:50%;">' + data + '</div>';
        } 
        else if ( options.colModel.index === 'threat_level') {
            data = rowObject.threat_level;
            font_class = "td-threat-level";
            if (data === 'high') {
                color_class = "td-high";
            }
            else if (data === 'medium') {
                color_class = "td-med";
            }
            else {
                color_class = "td-low";
            }
            var div = '<div style="width:100%;" class="' + color_class + ' '+ font_class + '">' + D_SUMMARY_THREAT_LEVEL_MAP[data]  + '</div>';
        }
        else {
            data = $.commaify(rowObject.connections);
            var percent = parseInt((rowObject.connections / D_SUMMARY.chartMaxHits) * 100, 10);
            div_w = (percent > 1) ? percent : 1;
            if (D_SUMMARY.dashboardType === 'security') {
                color = D_SUMMARY.deny_color;
                color_class = 'pctbar_deny';
            } else {
                color = rowObject.hit_color;
                color_class = 'pctbar_hits';
            }
            var div = '<div class="pctbar progress-inverse pctbar"><div class="' + color_class 
                + ' pctbar-bar" style="width:' + div_w + '%;"></div></div>'
                + '<div style="width:50%;">' + data + '</div>';
        }

        return div;
    },
    createGridDiv: function (group, group_name) {
        $("#sum_top_" + group).remove();
        var title = '';
        if (group === 'undetected_apt') {
            title = D_SUMMARY_EXECUTIVE_ZERO_DAY_APT;
        }
        var div_html = '<div id="sum_top_' + group + '" class="frontpanelUnit frontpanelUnitBig">'
                      + '<div class="frontpanelUnitHeader" title="'+ title +'">'
                        + '<div class="zoom_link pointer" id="' + group + '">' + group_name + '</div>'
                      + '</div>'
                      + '<div class="grid">'
                        + '<div id="chart_' + group + '" class="shown">'
                          + '<div class="logView">'
                            + '<div id="div_' + group + '" class="cl">'
                              + '<table id="div_' + group + '_grid" class="resizableGrid scroll" ></table>'
                              + '<div id="div_' + group + '_pager" class="scroll" style="text-align:right;"></div>'
                            + '</div>'
                          + '</div>'
                        + '</div>'
                      + '</div>'
                    + '</div>';
        $("#div_dashboard_wrapper").append(div_html);
        $("#sum_top_" + group).hide();
    },
    createGrid: function (div_selector, grid_selector, pager_selector, group, series, columns) {
        // Unload the grid and then recreate it 
        jQuery(grid_selector).GridUnload(grid_selector);

        if (series.length == 0) {
            $(div_selector).hide();
            return;
        }
        $(div_selector).show();

        var total_bytes = 0;

        $(grid_selector).jqGrid({
            datatype: "local",
            altRows: true,
            altclass: 'gridAltRow',
            autoencode: true,
            colNames: columns.col_names,
            colModel: columns.col_model,
            autoencode: true,
            rowNum: -1,
            height: 'auto',
            loadonce: true,
            sortname: 'bytes',
            sortorder: 'desc',
            scroll: false,
            autowidth: true,
            forceFit: false,
            shrinkToFit: true
        }).navGrid();

        var total_entities = 0;
        var total_cxns = 0;
        total_bytes = 0;
        if (series !== undefined) {
            for (var i = 0; i < series.length; i++) {
                if (series[i].name == 'other') {
                    continue;
                }
                D_SUMMARY.chartMaxBytes = Math.max(D_SUMMARY.chartMaxBytes, series[i].bytes);
                D_SUMMARY.chartMaxHits = Math.max(D_SUMMARY.chartMaxHits, series[i].connections);
            }
            for (var i = 0; i < series.length; i++) {
                if (series[i].name == 'other') {
                    continue;
                }
                var hits = series[i].connections;
                var bytes = parseInt(series[i].bytes);
                series[i].group = group;
                series[i].byte_color = D_SUMMARY.byte_color;
                series[i].hit_color = D_SUMMARY.hit_color;
                $(grid_selector).jqGrid('addRowData', i, series[i]);
                total_entities += 1;
                total_cxns += hits;
                total_bytes += bytes;
            }
            D_SUMMARY.total_entities += total_entities;
            D_SUMMARY.total_bytes += total_bytes;
            D_SUMMARY.total_cxns += total_cxns;
            $(grid_selector).showCol('bytes');
            $(grid_selector).setGridParam({ rowNum: series.length });
            $(grid_selector).setColProp('name', { formatter: D_SUMMARY.linkFormatter });
            $(grid_selector).setColProp('bytes', { formatter: D_SUMMARY.chartFormatter });
            if (total_bytes == 0 || isNaN(D_SUMMARY.chartMaxBytes)) {
                $(grid_selector).hideCol('bytes');
                $(grid_selector).setGridParam({ sortname: 'connections' });
            }
            $(grid_selector).setColProp('connections', { formatter: D_SUMMARY.chartFormatter });

            // In executive dashboard report, show column "threat_level" in section 
            // (Zero-day APT report), and use "level_order" to order.
            if (group === 'undetected_apt') {
                $(grid_selector).showCol('threat_level');
                $(grid_selector).setGridParam({ sortname: 'level_order' });
                $(grid_selector).setColProp('threat_level', { formatter: D_SUMMARY.chartFormatter });
                $(grid_selector).hideCol('level_order');
            } else {
                $(grid_selector).hideCol('threat_level');
                $(grid_selector).hideCol('level_order');
            }
        }
    }
}
$(document).ready(D_SUMMARY.init);
