var D_THREATMAP = {
    width: 960,
    height: 500,
    zoomScale: 1,
    translatePoints: [420, 340],
    mapPath: null,
    viewType: 'view_deny',
    dataSource: 'summary',
    mapObject: null,
    mapZoom: null,
    mapLegend: null,
    svgThreatMap: null,
    data_countries: {},
    data_columns: [],
    urlSn: 'all',
    init: function () {
        var allVars = $.getUrlVars();
        D_THREATMAP.urlSn = $.getUrlVar('sn');

        D_THREATMAP.initUI();
        D_THREATMAP.initEvents();
    },
    initUI: function () {
        $("#threatmap_combo_view").val(D_THREATMAP.viewType);
    },
    initEvents: function () {
        $(".maptype_select").click(function () {
            var name = $("#" + this.id).html();
            $("#btn_maptype_dropdown").html(name + '  <span class="caret"></span>');
            D_THREATMAP.viewType = this.id;
            D_THREATMAP.getData();
        });

        /* Respond to resizeEnd event */
        $(window).bind('resizeEnd', function () {
            D_THREATMAP.doResize();
            D_THREATMAP.initMap();
        });

        $("#custom_datepicker_trigger").bind('click', function () {
            // Listen for a click on this div, it means the date changed 
            // and a refresh is needed
            D_THREATMAP.getData();
        });

        $(document).keyup(function (eo) {
            if (eo.keyCode == 27) {
                D_THREATMAP.closePopup();
            }
        });

        $(".threat_detail_href").live('click', function (eo) {
            D_THREATMAP.togglePopupView('detail');
            D_THREATMAP.getDataDetail($(this).html());
            eo.stopPropagation();
        });

        $(".close").click(function (eo) {
            D_THREATMAP.closePopup();
        });
        $(".breadcrumb").click(function (eo) {
            D_THREATMAP.closePopup();
        });
        $(".report_table").click(function (eo) {
            D_THREATMAP.closePopup();
        });

        $("#backtolist").click(function (eo) {
            D_THREATMAP.togglePopupView('list');
        });
    },
    togglePopupView: function(view) {
        if (view == 'list') {
            $("#threatmap_detail").hide();
            $("#country_popup_resources").show();
        } else if (view == 'detail') {
            $("#threatmap_detail").show();
            $("#country_popup_resources").hide();
        }
    },
    closePopup: function() {
        if ($("#country_popup").is(":visible")) {
            $("#country_popup").hide();
        }
    },
    toggleSpinner: function (b) {
        WGRD.enableUIElements(!b, ['#btn_maptype_dropdown']);
        if (b == true) {
            $('.loading_spinner').remove();
            $('#filterbuttons').prepend('  <span class="loading_spinner" class=""><img src="/images/loader.gif" /></span>');
            $("#topn_text").hide();
        } else {
            $('.loading_spinner').remove();
            $("#topn_text").show();
        }
    },
    getData: function () {
        /* Used on page initialization to get current time range display */
        D_THREATMAP.toggleSpinner(true);

        var start_dt = $("#reports_toolbar_start").text();
        var end_dt = $("#reports_toolbar_end").text();
        if (start_dt != '') {
            start_dt = start_dt.substring(0, start_dt.length - 2).trim(); //Remove the '-' from date at the end'
            start_dt = $.getDateLocalToSecs(start_dt);
        }
        if (end_dt != '') {
            end_dt = $.getDateLocalToSecs(end_dt);
        }

        var viewType = D_THREATMAP.viewType.substring("view_".length);
        var url = 'get_threatmap_data?view_type=' + viewType;
        url += '&sn=' + D_THREATMAP.urlSn + '&start_time=' + start_dt + '&end_time=' + end_dt;

        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: function (xhr, status, error) {
                checkLoginPageRedirect(xhr, status, error);
                D_THREATMAP.toggleSpinner(false);
            },
            success: function (data) {
                D_THREATMAP.data_countries = data.countries;
                D_THREATMAP.data_columns = data.column_names;
                D_THREATMAP.byte_columns = data.countries.byte_columns;
                $("#cxncnt").html(data.countries.max_hits);
                $("#hitcnt").html(data.countries.total_entities);
                D_THREATMAP.doResize();
                D_THREATMAP.initMap();
                D_THREATMAP.toggleSpinner(false);
            }
        });
    },
    initMap: function () {
        var mapProjection = d3.geo
            .mercator()
            .scale(D_THREATMAP.width/6)
            .translate([0, -20]);

        D_THREATMAP.mapPath = d3.geo.path()
            .projection(mapProjection);

        if (D_THREATMAP.svgThreatMap != null) {
            D_THREATMAP.svgThreatMap.remove();
            $("#threatmap div").remove();
        }
        D_THREATMAP.svgThreatMap = d3.select("#threatmap").append("div").append("svg")
            .attr("width", D_THREATMAP.width)
            .attr("height", D_THREATMAP.height);

        D_THREATMAP.svgThreatMap.append("rect")
            .attr("class", "mapBackground")
            .attr("width", D_THREATMAP.width)
            .attr("height", D_THREATMAP.height)
            .on("click", D_THREATMAP.mapOnBgClick);

        D_THREATMAP.mapObject = D_THREATMAP.svgThreatMap.append("g")
            .attr("transform", "translate(" + D_THREATMAP.width / 2 + "," + D_THREATMAP.height / 2 + ")")
            .append("g")
                .attr("id", "countries");

        D_THREATMAP.mapObject.selectAll("path")
            .data(world_countries.features)
        .enter().append("path")
            .style("fill", D_THREATMAP.mapStyle)
            .style("stroke-width", 0.15 + "px")
            .attr("class", D_THREATMAP.mapClassCB)
            .on("click", D_THREATMAP.mapOnClick)
            .attr("d", D_THREATMAP.mapPath);

        if (D_THREATMAP.data_countries['Unknown']) {
            var name = D_THREATMAP.data_countries['Unknown']['country_full'];
            var unknowncnt = 0;
            var unknownhits = D_THREATMAP.data_countries['Unknown']['count'];
            for (var index in D_THREATMAP.data_countries['Unknown']['sorted_data']) {
                if (D_THREATMAP.data_countries['Unknown']['sorted_data'][index][1]['ports'] != undefined) {
                    unknowncnt += D_THREATMAP.data_countries['Unknown']['sorted_data'][index][1]['ports'].length;
                }
            }
            D_THREATMAP.svgThreatMap.append("svg:a")
                .attr("xlink:href", "#")
                .attr("z-index", 2000)
                .on("click", function () {
                    d = { 'id': 'Unknown', 'entities': unknowncnt, 'count': unknownhits, 'properties': { 'name': name } }
                    D_THREATMAP.mapPopup(d);
                    d3.event.stopPropagation();
                })
                .append("svg:text")
                    .attr("width", "100")
                    .attr("x", 0)
                    .attr("y", 15)
                    .attr("text-anchor", "left")
                    .text(name + " [" + unknowncnt.toString() + "]")
                    .style("fill", "#0088cc")
            ;
        }
    },
    mapOnZoom: function (d) {
        var x = 0,
            y = 0,
            k = 1;

        if (D_THREATMAP.zoomScale == 1) {
            var centroid = D_THREATMAP.mapPath.centroid(d);
            x = -centroid[0];
            y = -centroid[1];
            k = 2;
            D_THREATMAP.zoomScale = 2;
            D_THREATMAP.zoomTranslate = [x, y];
        } else {
            D_THREATMAP.zoomScale = 1;
            D_THREATMAP.zoomTranslate = [0, 0];
        }
        D_THREATMAP.mapObject.transition()
        .duration(1000)
            .attr("transform", "scale(" + k + ")translate(" + x + "," + y + ")")
            .style("stroke-width", 0.15 / k + "px");
    },
    mapOnBgClick: function (d) {
        if (D_THREATMAP.zoomScale > 1) {
            return D_THREATMAP.mapOnZoom(d);
        }
    },
    mapOnClick: function (d) {
        if (d.count == undefined) {
            return D_THREATMAP.mapOnZoom(d);
        }
        D_THREATMAP.mapOnMouseOver(d);

        d3.event.stopPropagation();
    },
    mapOnMouseOver: function (d) {
        var popup_title = $("#country_popup_title").html();
        if (popup_title.indexOf(d.properties.name) == 0) {
            if ($("#country_popup").is(":visible")) {
                $("#country_popup").hide();
                return;
            }
        }

        if (d.count != undefined) {
            D_THREATMAP.mapPopup(d);
        } else {
            $("#country_popup").hide();
        }
    },

    mapClassCB: function (d) {
        if (d['count'] == undefined) {
            return "ui-icon-zoomin"; //cell_nodata";
        }
        return "mouseover";
    },
    mapStyle: function (d) {
        var r_color_map = ['rgba(245, 245, 0, ',
            'rgba(245, 204, 0, ',
            'rgba(245, 163, 0, ',
            'rgba(245, 122, 0, ',
            'rgba(245, 82, 0, ',
            'rgba(245, 41, 0, ',
            'rgba(245, 0, 0, '];
        var g_color_map = ['rgba(245, 245, 0, ',
            'rgba(225, 245, 0, ',
            'rgba(204, 245, 0, ',
            'rgba(184, 245, 0, ',
            'rgba(163, 245, 0, ',
            'rgba(82, 245, 0, ',
            'rgba(41, 245, 0, '];
        var color_map = r_color_map;
        if (D_THREATMAP.viewType == 'view_app' || D_THREATMAP.viewType == 'view_all' || D_THREATMAP.viewType == 'view_http') {
            color_map = g_color_map;
        }
        if (D_THREATMAP.data_countries[d.id] == undefined) {
            d['count'] = undefined;
            return;
        }
        var count = D_THREATMAP.data_countries[d.id]['count'];
        d['entities'] = D_THREATMAP.data_countries[d.id]['entities'];
        // Note lazy creation of this data member for use later
        if (d['count'] == undefined) {
            d['count'] = count;
        } else {
            d['count'] = count;
        }
        var max_hits = D_THREATMAP.data_countries['max_hits'];
        var alpha = "1.0";
        var index = 1;
        var divisor = max_hits / 5 / 2;
        if (max_hits < 5) {
            return color_map[1] + alpha + ")";
        } else if (count != undefined) {
            if (count > divisor * 3) {
                alpha = "0.9";
                index = 6;
            } else if (count > divisor * 2) {
                alpha = "0.9";
                index = 5;
            } else if (count > divisor * 1) {
                alpha = "0.7";
                index = 3;
            } else if (count > 5) {
                alpha = "0.7";
                index = 2;
            } else if (count > 1) {
                alpha = "0.7";
                index = 1;
            }
            alpha = "1.0";
            return color_map[index] + alpha + ")";
        }
        return;
    },

    mapToolTip: function (d) {
        if (d.count == undefined) {
            $("#tooltip_popup").hide();
            return;
        }
        $("#tooltip_popup").show();
        $("#tooltip_popup_title").html(d.properties.name + " [" + d.count + "]");
        $("#tooltip_popup_resources").html("");
        D_THREATMAP.mapPositionPopup("#tooltip_popup", d);
    },
    mapPopup: function (d) {
        $("#tooltip_popup").hide();
        $("#country_popup").show();
        D_THREATMAP.togglePopupView('list');
        var width = $(window).width();
        var threatmap_offset = $("#threatmap").offset();
        var popup_height = $(window).height() - threatmap_offset.top - 25;

        $("#country_popup_title").html(d.properties.name + "<span style='font-weight:normal;'>  [" + d.entities + " &#8250; " + d.count + " " + D_THREATMAP_HITS + "]</span>");
        $("#country_popup_resources").html("");

        var resources = '';
        var resources_height = popup_height - $("#country_popup_title").height() - 20;
        resources += '<div style="height:' + resources_height.toString() + 'px;width:380px;">';
        resources += '<table style="width:90%;"><tr>';
        for (var column in D_THREATMAP.data_columns) {
            resources += '<th>' + D_THREATMAP.data_columns[column] + '</th>';
        }

        var href = "";
        for (var index in D_THREATMAP.data_countries[d.id]['sorted_data']) {
            var ip = D_THREATMAP.data_countries[d.id]['sorted_data'][index][0];
            resources += '<tr><td style="vertical-align: top;">' + ip + '</td><td>';

            if (D_THREATMAP.data_countries[d.id]['sorted_data'][index][1]['ports'] != undefined) {
                var port_cnt = D_THREATMAP.data_countries[d.id]['sorted_data'][index][1]['ports'].length;
                for (var port_index in D_THREATMAP.data_countries[d.id]['sorted_data'][index][1]['ports']) {
                    var entry_ip = D_THREATMAP.data_countries[d.id]['sorted_data'][index][1]['ports'][port_index][0];
                    var city = D_THREATMAP.data_countries[d.id]['sorted_data'][index][1]['ports'][port_index][1];
                    var count = D_THREATMAP.data_countries[d.id]['sorted_data'][index][1]['ports'][port_index][2];
                    var bytes = D_THREATMAP.data_countries[d.id]['sorted_data'][index][1]['ports'][port_index][3];
                    if (port_index != 0) {
                        resources += '<tr><td></td><td>';
                    }
                    resources += city + '</td><td>' + entry_ip + '</td><td>' + count + '</td>';
                    if (D_THREATMAP.byte_columns) {
                        resources += '<td>' + $.formatBytes(bytes, D_THREATMAP_FORMAT_GB, D_THREATMAP_FORMAT_MB, D_THREATMAP_FORMAT_KB, D_THREATMAP_FORMAT_BYTES) + '</td>';
                    }
                    resources += '</tr>';
                }
            } else {
                resources += '</td><td></td></tr>';
            }
        }

        resources += "</table>";
        resources += '</div>';
        $("#country_popup_resources").html(resources);
        D_THREATMAP.doResize();
    },
    /* Threatmap Detail page */
    getDataDetail: function (ip) {
        /* Used on page initialization to get current time range display */
        D_THREATMAP.toggleSpinner(true);
        $("#threatmap_detail_map_img").html('');
        $("#threatmap_detail_ip").html('');
        $("#threatmap_detail_map_header").html('');
        var viewType = D_THREATMAP.viewType.substring("view_".length);
        var url = 'get_threatmap_detail_data';
        url += '?ip=' + ip;
        url += '&view_type=' + viewType;
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: function (xhr, status, error) {
                // This is the end of the line, reset the button
                D_THREATMAP.toggleSpinner(false);
            },
            success: function (data) {
                //S_THREATMAP_DETAIL.response_data = data;
                D_THREATMAP.updateDetail(ip, data);
                D_THREATMAP.toggleSpinner(false);
            }
        });
    },
    getMapUrl: function (provider, lat, long, zoom, width, height) {
        var url = '/dashboard/get_threatmap_detail_map';
        url += '?lat=' + lat + '&long=' + long + '&zoom=' + zoom + '&width=' + width + '&height=' + height;
        return url;
    },
    updateDetail: function (ip, data) {
        var zoom = 8;
        var width = 600;
        var height = 250;
        var lat = data.ip_info.latitude;
        var long = data.ip_info.longitude;
        if (data.ip_info.city == null || data.ip_info.city == undefined) {
            zoom = 3;
        }
        if (lat != '' && lat != undefined && long != '' && long != undefined) {
            var url = D_THREATMAP.getMapUrl("google", lat, long, zoom, width, height);
            $("#threatmap_detail_map_img").html('<img src="' + url + '" />');

            info = data.ip_info.city;
            if (data.ip_info.city == null) {
                info = data.ip_info.country;
            } else if (data.ip_info.country == 'US') {
                info = data.ip_info.city + ", " + data.ip_info.region;
            } else {
                info = data.ip_info.city + ", " + data.ip_info.full_name;
                if (data.ip_info.city == null || data.ip_info.city == undefined) {
                    info = data.ip_info.full_name;
                }
            }
            $("#threatmap_detail_ip").html(ip);
            $("#threatmap_detail_map_header").html(info);
            $("#threatmap_detail_isp_location").show();
        }

        $("#threatmap_detail_map_report").html('');
        var row = "<tr>";
        for (var index in data.column_names) {
            row += "<th>" + data.column_names[index] + "</th>";
        }
        $("#threatmap_detail_map_report").append(row + "</tr>");

        var hit = [];
        for (var index in data.hits) {
            hit = data.hits[index];
            row = "<tr>"
            row += '<td>' + $.getDateDisplay(hit.start_time) + '</td>';
            row += '<td>' + hit.disp + '</td>';
            row += '<td>' + hit.src_ip + '</td>';
            row += '<td>' + hit.dst_domain + '</td>';
            row += '<td>' + hit.count + '</td>';
            row += '<td>' + hit.port + '</td>';
            row += "</tr>"
            $("#threatmap_detail_map_report").append(row);
        }
    },
    doResize: function () {
        var width = $(window).width();
        var contentwidth = $("#main_div_row").width();
        var threatmap_offset = $("#threatmap").offset();

        if (width < 500) {
            $("#filterbuttons").hide();
        } else {
            $("#filterbuttons").show();
        }

        D_THREATMAP.width = contentwidth - $(".date_navbar_td").width() - 10;
        var quarter = D_THREATMAP.width / 1.4;
        D_THREATMAP.height = $(window).height() - threatmap_offset.top - 25;
        if (quarter > D_THREATMAP.height) {
            D_THREATMAP.height = quarter;
        } else {
            D_THREATMAP.height = D_THREATMAP.width;
        }
        if ($('#country_popup').is(':visible')) {
            var popup_height = $(window).height() - threatmap_offset.top - 25;
            var resources_height = popup_height - $("#country_popup_title").height() - 20;
            $("#country_popup").offset({ top: threatmap_offset.top, left: threatmap_offset.left });
            $("#country_popup").width(D_THREATMAP.width);
            $("#country_popup").height(popup_height);
            $("#country_popup_resources").height(resources_height);
            $("#threatmap_detail").height(resources_height);

        }
    }
};

$(document).ready(D_THREATMAP.init);
    
