var S_LOG_DEVICES = {
    ispopup: 0,
    init: function () {
        S_LOG_DEVICES.ispopup = $("#hidden_btn_select_device").length;
        S_LOG_DEVICES.initUI();
        S_LOG_DEVICES.initEvents();

        S_LOG_DEVICES.getGridData();
        $(".logViewTable").show();
        S_LOG_DEVICES.initHelp();
    },

    initUI: function () {
        $("#btn_clear").hide();
        WGRD.enableUIElements(false, ['#device_delete_btn']);
        $('#lstabs a[href=' + selected_tab +']').tab('show');
        if (view_group_tab_perm === 0 || view_server_tab_perm === 0) {
            S_USER_MODE.selected_tab = selected_tab;
        }
    },

    initEvents: function () {
        $("#btn_search").click(function () {
            var data = $("#input_search").val();
            var searchcol = $("#select_search_column option:selected").val();
            var grid = $("#grid_entities");
            var filters;

            if (data.length === 0) {
                grid[0].p.search = false;
                filters = '';
                $("#btn_clear").hide();
            } else {
                grid[0].p.search = true;
                filters = {
                    groupOp: "OR",
                    rules: [
                        { field: searchcol, op: "cn", data: data }
                    ]
                };
                $("#btn_clear").show();
            }
            $.extend(grid[0].p.postData, { filters: JSON.stringify(filters) });
            grid.trigger("reloadGrid", [{ page: 1, current: true }]);
            $("#input_search").focus();
        });
        $("#btn_clear").click(function () {
            $("#input_search").val('');
            $("#btn_search").click();
        });

        $('#device_delete_btn').button().click(S_LOG_DEVICES.removeDeviceAction);

        $('#btn_refresh_tabs').button().click(function() {
            var attr = $('#btn_refresh_tabs').attr('disabled');
            if (attr !== 'true' && attr !== 'disabled') {
                S_LOG_DEVICES.doRefreshTabs();
            }
        });

        $(window).bind('resizeEnd', function () {
            var w = $("#main_div_row").width();
            var w1 = $("#jumpto_div").width();

            var grid_width = w - w1 - 20;
            $('#grid_entities').setGridWidth(grid_width);
        });
    },

    initHelp : function() {
        // Update help link based on tab selected
        $('#lstabs a[href="#tabDevices"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7050;
            S_USER_MODE.selected_tab = "#tabDevices";
        });
        $('#lstabs a[href="#tabGroups"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7051;
            S_USER_MODE.selected_tab = "#tabGroups";
        });
        $('#lstabs a[href="#tabServers"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7052;
            S_USER_MODE.selected_tab = "#tabServers";
        });
    },

    getGridData: function (complete_cb) {
        $.ajax({
            url: 'log_grid_columns?l_t=' + 'devices',
            method: 'GET',
            dataType: 'json',
            success: S_LOG_DEVICES.onColumnData,
            complete: function() {
                if (complete_cb) {
                    complete_cb();
                }
            }
        });
    },
    onColumnData: function(columns) {
        $.ajax({
            url: 'log_devices?_search=false&rows=10000&page=1&sidx=name&sord=asc',
            method: 'GET',
            dataType: 'json',
            success: function (response) {
                if (response.error) {
                    alert(response.message);
                } else {
                    S_LOG_DEVICES.onGridDataReceived(columns, response);
                }
            }
        });
    },
    onGridDataReceived: function (columns, data) {

        // Unload the grid and then recreate it
        jQuery("#grid_entities").GridUnload("#grid_entities");

        var padleft = parseInt($("#grid_parent").css('margin-left'));
        var grid_width = $("#grid_parent").width() - padleft * 2;

        $("#grid_entities").jqGrid({
            datatype: 'local',
            data: data.rows,
            mtype: 'GET',
            colNames: columns.col_names,
            colModel: columns.col_model,
            pager: '#pager_entities',
            pagerpos: 'right',
            toppager: true,
            viewrecords: true,
            recordpos: 'left',
            rowNum: 100,
            rowList: [25, 100, 250, 500],
            altRows: true,
            altclass: 'gridAltRow',
            sortname: 'name',
            ignoreCase: true,
            sortorder: 'asc',
            caption: '',
            height: 'auto',
            width: grid_width,
            loadComplete: function (data) {
                if (data === null) {
                    $('#error_msg').show();
                    $('#log_devices').hide();
                }
                $('.tree-leaf', $(this)).css('width', '0px');
                $(window).resize();

                S_LOG_DEVICES.toggleRemoveBtn();
            },
            loadError: function (xhr, status, error) {
                if (!checkLoginPageRedirect(xhr, status, error)) {
                    alert(status);
                }
            },
            onSelectRow: function(rowid, status, e) {
                S_LOG_DEVICES.toggleRemoveBtn();
            }
        }).navGrid("#pager_entities", { refresh: false, search: false, edit: false, add: false, del: false }, {}, { width: 350 }, {});

        var searchstring = $("#input_search").val();
        if (searchstring != '') {
            $("#btn_search").click();
        }

        if (S_LOG_DEVICES.ispopup) {
            // When in popup mode
            $("#grid_entities").jqGrid('hideCol', 'active');
            $("#grid_entities").jqGrid('hideCol', 'type_name');
        }
        $("#grid_entities").setColProp('name', {
            sorttype: function (cellvalue, options, rowdata) {
                return options.display_name.toLowerCase();
            }
        }).trigger("reloadGrid");
    },

    toggleRemoveBtn: function() {
        // enable/disable "Remove" button depending on if any rows are selected or not
        var gridSelector = "#grid_entities";
        S_LOG_DEVICES.toggleRemoveBtnCommon($(gridSelector).jqGrid('getGridParam', 'selrow'),
                                            gridSelector,
                                            "#device_delete_btn");
    },

    isRowActive: function(selRowId, gridDivSelector){
        var activityIndicator = "devices_active";
        var activityCellData = $(gridDivSelector).getCell(selRowId, 'active');
        if (activityCellData.indexOf(activityIndicator) !== -1){
            return true;
        } else{
            return false;
        }
    },

    toggleRemoveBtnCommon: function (selRowId, gridSelector, deleteBtnSelector){
        // DRY'd logic shared between js objects that toggle remove buttons for the /log/devices/ page.
        var activateBtn = false;
        if (selRowId !== null){
            activateBtn = !S_LOG_DEVICES.isRowActive(selRowId, gridSelector);
        }

        if (activateBtn){
            WGRD.enableUIElements(selRowId, [deleteBtnSelector]);
        } else{
            WGRD.enableUIElements(false, [deleteBtnSelector]);
        }

    },

    removeDeviceAction: function() {
        $('#confirmBoxDiv h3').text(S_REMOVE_DEVICE_TITLE);
        WGRD.confirmModal(S_REMOVE_DEVICE_CONFIRM_MSG, true, S_LOG_DEVICES._removeDeviceAction);
    },

    _removeDeviceAction: function() {
        WGRD.enableUIElements(false, ['#device_delete_btn']);
        var selRowId = $('#grid_entities').jqGrid('getGridParam', 'selrow');
        if (!selRowId) {
            return;
        }

        // for clusters, 'sn_diplay' is the list of SNs separated by <br>
        var rowdata = $('#grid_entities').getRowData(selRowId);
        var sn_list = rowdata['sn_disp'].split('<br>');
        var sn_data = {'sn_list': sn_list.join(',')};

        $.ajax({
            url: 'delete_client',
            type: 'POST',
            dataType: 'json',
            data: sn_data,
            success: function() {
                $('#grid_entities').jqGrid('delRowData', selRowId)
            },
            error: function() {
                alert(S_REMOVE_DEVICE_ERROR);
                S_LOG_DEVICES.toggleRemoveBtn();
            }
        });
    },

    doRefreshTabs: function() {
        // This action refreshes the tables on the Devices, Servers and Groups tabs.
        // Note: this function is making calls to js functions outside of this file and
        //       providing a callback to monitor the status of the refresh.

        S_LOG_DEVICES.refreshing_devices = true;
        S_LOG_DEVICES.refreshing_servers = true;
        S_LOG_DEVICES.refreshing_groups = true;

        $('#btn_refresh_tabs').hide();
        $('#spinner_refresh_tabs').show();

        S_LOG_DEVICES.getGridData(function() {
            S_LOG_DEVICES.refreshing_devices = false;
            S_LOG_DEVICES._checkDoneRefreshTabs();
        });

        L_SERVERS.getGridData(function() {
            S_LOG_DEVICES.refreshing_servers = false;
            S_LOG_DEVICES._checkDoneRefreshTabs();
        });

        S_LOG_GROUPS.refreshGroupsGrid(null, 'loading_groups_table', function() {
            S_LOG_DEVICES.refreshing_groups = false;
            S_LOG_DEVICES._checkDoneRefreshTabs();
        });
    },

    _checkDoneRefreshTabs: function() {
        // restore the refresh button when all tabs are done refreshing
        if (!S_LOG_DEVICES.refreshing_devices && !S_LOG_DEVICES.refreshing_servers && !S_LOG_DEVICES.refreshing_groups) {
            $('#btn_refresh_tabs').show();
            $('#spinner_refresh_tabs').hide();
        }
    }
};
$(document).ready(S_LOG_DEVICES.init);
