var S_LOG_FREQUENCY = {
    allVars: '',
    urlSn: '',
    urlCluster: '',
    urlLt: '',
    urlName: '',
    urlTz: '',
    urlChart: '',
    eatNextClick: false,
    plot_trend: null,
    seriesLength: 0,
    init: function () {
        S_LOG_FREQUENCY.allVars = $.getUrlVars();
        S_LOG_FREQUENCY.urlSn = $.getUrlVar('sn');
        S_LOG_FREQUENCY.urlCluster = $.getUrlVar('cluster_id');
        S_LOG_FREQUENCY.urlLt = $.getUrlVar('l_t');
        if (S_LOG_FREQUENCY.urlLt == undefined) {
            S_LOG_FREQUENCY.urlLt = 'tr';
        }
        S_LOG_FREQUENCY.urlName = $.getUrlVar('name');
        S_LOG_FREQUENCY.urlTz = $.getUrlVar('tz');
        S_LOG_FREQUENCY.urlChart = $.getUrlVar('c_t');

        S_LOG_FREQUENCY.initUI();
        S_LOG_FREQUENCY.initEvents();

    },
    initUI: function () {
    },
    initEvents: function () {
        // ev - event object
        // gridpos - {x,y}
        // datapos - {xaxis,yaxis,xaxis2,yaxis2,...}
        // neighbor - {seriesIndex, pointIndex, gridData}
        // plot - the plot
        $("#log_frequency_graph").bind("jqplotClick", function (ev, gridpos, datapos, neighbor, plot) {
            var click_time = datapos.xaxis;

            if ($.browser.msie) {
                // Do nothing
            } else if (S_LOG_FREQUENCY.eatNextClick) {
                S_LOG_FREQUENCY.eatNextClick = false;
                return;
            }
            S_LOG_FREQUENCY.eatNextClick = false;

            if (S_LOG_FREQUENCY.urlTz == 'utc') {
                /* The user is requesting logs in utc time, adjust to the offset */
                var d = new $.jsDate(click_time);
                var offset = d.getTimezoneOffset();
                click_time = datapos.xaxis - (offset * 60000);
            }
            $.ajax({
                url: 'frequency_click?pos=' + click_time,
                method: 'GET',
                dataType: 'json',
                error: checkLoginPageRedirect,
                success: S_LOG_FREQUENCY.onFrequencyClickDataRcvd
            });
        });
        $("#div_frequency").bind('jqplotResetZoom', function (gridpos, datapos, plot, cursor) {
            S_LOG_FREQUENCY.getChartData();
            //$(window).trigger('resize');
        });
        $("#div_frequency").bind('jqplotZoom', function (ev, gridpos, datapos, plot, cursor) {
            S_LOG_FREQUENCY.eatNextClick = true;
            start = cursor._zoom.axes.start.xaxis;
            end = cursor._zoom.datapos.xaxis;
            S_LOG_FREQUENCY.getChartData(start, end);
        });
        $('#log_frequency_bar').click(function () {
            $.ajax({
                url: 'log_update_charttype?c_t=bar',
                method: 'GET',
                dataType: 'json',
                success: function () {
                    S_LOG_FREQUENCY.getChartData();
                }
            });
            $("#chart_type").text('bar');

        });
        $('#log_frequency_line').click(function () {
            $.ajax({
                url: 'log_update_charttype?c_t=line',
                method: 'GET',
                dataType: 'json',
                success: function () {
                    S_LOG_FREQUENCY.getChartData();
                }
            });
            $("#chart_type").text('line');
        });
        $('.button-reset').click(function () { S_LOG_FREQUENCY.plot_trend.resetZoom(); });

        /* Hidden input to trigger chart reload from time range selection */
        $("#custom_timerange_trigger").bind('click', function () {
            S_LOG_FREQUENCY.getChartData();
        });
    },
    // Retrieve current chart position from dataset and determine page to jump to
    onFrequencyClickDataRcvd: function (data) {
        if (S_LOG_FREQUENCY.urlLt != null) {
            var selector = "#logs_grid";
            rownum = $(selector).getGridParam('rowNum');

            var page = parseInt(parseInt(data.recordpos) / parseInt(rownum)) + 1;
            $(selector).setGridParam({ sortname: 'update_time', sortorder: 'asc', page: page.toString() }).trigger("reloadGrid");
        }
    },
    getChartData: function (start, end) {
        if (S_LOG_FREQUENCY.urlCluster == null) {
            S_LOG_FREQUENCY.urlCluster = 'NONE';
        }
        S_LOG_FREQUENCY.showChartLoading();
        var myurl = 'log_data_frequency?sn=' + S_LOG_FREQUENCY.urlSn + '&l_t=' + S_LOG_FREQUENCY.urlLt; 
        if (start != null && end != null) {
            myurl = 'log_data_frequency?sn=' + S_LOG_FREQUENCY.urlSn + '&l_t=' + S_LOG_FREQUENCY.urlLt +'&start=' + start + '&end=' + end;
            if (start > end) {
                myurl = 'log_data_frequency?sn=' + S_LOG_FREQUENCY.urlSn + '&l_t=' + S_LOG_FREQUENCY.urlLt + '&start=' + end + '&end=' + start;
            }
            $("#log_frequency_reset").show();
        } else {
            $("#log_frequency_reset").hide();
        }
        if (S_LOG_FREQUENCY.urlTz != null) {
            myurl += '&tz=' + S_LOG_FREQUENCY.urlTz
        }
        $.ajax({
            url: myurl,
            method: 'GET',
            dataType: 'json',
            error: checkLoginPageRedirect,
            success: S_LOG_FREQUENCY.onDataReceived
        });
    },
    onDataReceived: function (series) {
        var barWidth = 1;
        if (series == null || series.length == 0) {
            $('#div_frequency').hide();
            return;
        }
        $('#div_frequency').show();
        $('#log_frequency_graph').show();
        $('#log_frequency_loading').hide();
        $.jqplot.config.enablePlugins = true; // on the page before plot creation.    

        if (S_LOG_FREQUENCY.plot_trend) {
            $("#log_frequency_graph *").unbind();
            S_LOG_FREQUENCY.plot_trend.destroy();
        }

        for (var i = 0; i < series.length; i++) {
            series[i][0] = $.getDateDisplay(series[i][0])
        }

        var options = S_LOG_FREQUENCY.line_options;
        var chartType = $("#chart_type").text();
        if (chartType == 'bar') {
            options = S_LOG_FREQUENCY.bar_options;
        }
        options.axes.xaxis.min = series[0][0]; // '2013-03-08';
        options.axes.xaxis.max = series[0][-1]; // '2013-03-08';
        S_LOG_FREQUENCY.seriesLength = series.length;
        S_LOG_FREQUENCY.plot_trend = $.jqplot('log_frequency_graph', [series], options);
        S_LOG_FREQUENCY.setBarWidths(S_LOG_FREQUENCY.plot_trend, S_LOG_FREQUENCY.seriesLength, "#log_frequency_graph");
        S_LOG_FREQUENCY.plot_trend.replot();
    },
    line_options: {
        title: { show: false },
        legend: {
            yoffset: 0, show: false
        },
        gridPadding: { left: 0, top: 0, right: 0, bottom: 0 },
        seriesDefaults: {
            pointLabels: { show: false }
        },
        axes: {
            xaxis: {
                pad: 0,
                renderer: $.jqplot.DateAxisRenderer,
                autoscale: false,
                numberTicks: 5,
                //tickRenderer: $.jqplot.CanvasAxisTickRenderer,
                tickOptions: {
                    showLabel: false,
                    angle: 0,
                    formatString: '%Y-%m-%d %H:%M',
                    fontSize: 9
                }
            },
            yaxis: {
                //autoscale: true,
                tickOptions: {
                    fontSize: 9,
                    formatString: '%.0f',
                    show: false,
                    showLabel: false
                }
            }
        },
        cursor: {
            zoom: true,
            tooltipLocation: 'sw',
            showVerticalLine: true,
            showCursorLegend: true,
            showTooltip: false,
            cursorLegendFormatString: '%s%s %s',
            constrainZoomTo: 'x'
        },
        grid: {
            background: '#ffffff'
        },
        series: [
            {
                label: ' ',
                fill: true,
                fillAlpha: 0.8,
                fillAndStroke: true,
                color: "rgb(32,92,128)",
                fillColor: "rgb(225,235,245)",
                lineWidth: 1.0,
                neighborThreshold: 10,
                showMarker: true,
                markerOptions: {
                    show: true,
                    style: 'filledCircle',
                    size: 1.0
                }

            }
        ]
    },
    bar_options: {
        title: { show: false },
        legend: {
            yoffset: 0, show: false
        },
        gridPadding: { left: 0, top: 0, right: 0, bottom: 0 },
        series: [{
            renderer: $.jqplot.BarRenderer,
            label: ' ',
            neighborThreshold: 10,
            color: '#1F77B4'
        }],
        seriesDefaults: { shadow: false,
            renderer: $.jqplot.BarRenderer,
            pointLabels: { show: false },
            rendererOptions: {
                barWidth: 10,
                barDirection: 'vertical'
            }
        },
        grid: { background: '#ffffff',
            shadow: false
        },
        axesDefaults: {
            useSeriesColor: false
        },
        axes: {
            xaxis: {
                pad: 0,
                renderer: $.jqplot.DateAxisRenderer,
                autoscale: false,
                numberTicks: 5,
                //tickRenderer: $.jqplot.CanvasAxisTickRenderer,
                tickOptions: {
                    showLabel: false,
                    angle: 0,
                    formatString: '%Y-%m-%d %H:%M',
                    fontSize: 9
                }
            },
            yaxis: {
                //autoscale: true,
                tickOptions: {
                    fontSize: 9,
                    formatString: '%.0f',
                    show: false,
                    showLabel: false
                },
                pad: 0,
                padMax: 1.2,
                min: 0,
                autoscale: false
            }
        },
        highlighter: { show: false },
        cursor: {
            zoom: true,
            tooltipLocation: 'sw',
            showVerticalLine: true,
            showCursorLegend: true,
            showTooltip: false,
            cursorLegendFormatString: '%s%s %s',
            constrainZoomTo: 'x'
        }
    },
    showChartLoading: function () {
        $('#log_frequency_loading').show();
        $('#log_frequency_graph').hide();
    },
    doResize: function () {
        var fpwidth = $("#main_div_row").width();
        fpwidth -= $(".date_navbar_td").width();
        var padleft = 0;
        var grid_width = fpwidth - padleft * 2;

        $("#div_frequency").width(grid_width);
        if (S_LOG_FREQUENCY.plot_trend != null) {
            var length = S_LOG_FREQUENCY.seriesLength;
            if (S_LOG_FREQUENCY.plot_trend.plugins.cursor._zoom.isZoomed) {
                length = 1;
                for (var i in S_LOG_FREQUENCY.plot_trend.series[0].data) {
                    if (S_LOG_FREQUENCY.plot_trend.series[0].data[i]['0'] > S_LOG_FREQUENCY.plot_trend.axes.xaxis.min
                        && (S_LOG_FREQUENCY.plot_trend.series[0].data[i]['0'] < S_LOG_FREQUENCY.plot_trend.axes.xaxis.max)) {
                        length += 1;
                    }
                }
            }
            S_LOG_FREQUENCY.setBarWidths(S_LOG_FREQUENCY.plot_trend, length, "#div_frequency");
            S_LOG_FREQUENCY.plot_trend.replot();
        }
    },
    setBarWidths: function (plot, seriesLength, selector) {
        var width = $(selector).width();
        var barWidth = 1;
        if (seriesLength > 0) {
            barWidth = Math.max(1, parseInt(width / seriesLength) - 1);
            var log = "length: " + seriesLength.toString() + " width: " + width.toString() + " bar: " + barWidth.toString();
        }
        if (plot) {
            $.each(plot.series, function (index, series) {
                series.barWidth = barWidth;
            });
        }
        return barWidth;
    }


};
$(document).ready(S_LOG_FREQUENCY.init);

