function showwaitcursor() {
    document.getElementById("loading").style.visibility = 'visible';
    document.getElementById("OK").style.visibility = 'hidden';
}
$(document).ready(function () {
    var allVars = $.getUrlVars();
    var urlSn = $.getUrlVar('sn');
    var urlCluster = $.getUrlVar('cluster_id');
    var urlLt = $.getUrlVar('l_t');
    if (urlLt == undefined) {
        urlLt = 'tr';
    }
    var urlSearch = $.getUrlVar('search');
    var urlName = $.getUrlVar('name');
    var urlTz = $.getUrlVar('tz');
    var lastQuery = null;
    var getSessionFailures = 0;
    
    $(".searchTable").hide();

    function initUI() {
        $('#tr').tooltip();
        $('#al').tooltip();
        $('#ev').tooltip();
        $('#db').tooltip();
        $('#pe').tooltip();
        $('#all').tooltip();

        $("#tr, #al, #ev, #db, #pe, #all").click(function (eo) {
            var selector = "#tr";
            if (this.id != null) {
                selector = "#" + this.id;
            }
            urlLt = this.id;
            $("#tr, #al, #ev, #db, #pe, #all").removeClass('active');
            $(selector).addClass('active');
        });

        $("#tr, #al, #ev, #db, #pe, #all").removeClass('active');
        $("#" +  urlLt).addClass('active');
    }
    initUI();

    /* -=-=-=- Grid definitions -=-=-=- */
    function getGridData() {
        $.ajax({
            url: 'log_grid_columns?l_t=search',
            method: 'GET',
            dataType: 'json',
            success: onColumnDataReceived
        });
    }
    /*$("#detailview").dialog(
        {
            width: 550,
            resizable: false,
            autoOpen: false
        }
    );*/
    function doDetailView(id, pageX, pageY) {
        var xml_log = $("#logs_search").jqGrid('getCell', id, 'xml_log');
        var output = "<table width='100%' style='padding: 3px;'>"
        
        var terms = xml_log.toString().split(",");
        for (var j=0;j<terms.length;j++) {
            output += "<tr><td>" + terms[j] + "</td></tr>";
        }

        output += "</table>";

        /* 
        * If the detail view has scrolled out of view, reposition it centered
        * and below the row that was clicked
        */
        offset = $("#detailview").offset();
        if (offset != null) {
            var scrollTop = $(document).scrollTop();
            var h_win = $(window).height();
            if (offset.top < scrollTop
                || offset.top > scrollTop + h_win) {
                w_doc = $(document).width();
                w_dlg = $("#detailview").width();
                var x = (w_doc - w_dlg) / 2;
                var y = pageY - scrollTop + 10;

                $("#detailview").dialog({ position: [x, y] });
            }
        }

        $("#detailview").html("<div>" + output + "</div>");
        $("#detailview").dialog("open").height("auto"); /* Reset the height to 'auto' for IE */
    }
    function utcDateFormatter(cellvalue, options, rowObject) {
        return $.getDateDisplay(cellvalue, true, urlTz);
    }
    function boldFormatter(cellvalue, options, rowObject) {
        if (lastQuery == null) {
            return cellvalue;
        }
        var value = cellvalue;
        var tmp = '';
        var q = lastQuery['q'];
        for (var i=0;i<q.length;i++) {
            if (q[i].all != '') {
                var terms = q[i].all.split(" ");
                for (var j=0;j<terms.length;j++) {
                    tmp = boldify(value, terms[j], 0);
                    value = tmp;
                }
            }
            if (q[i].any != '') {
                var terms = q[i].any.split(" ");
                for (var j=0;j<terms.length;j++) {
                    tmp = boldify(value, terms[j], 0);
                    value = tmp;
                }
            }
            if (q[i].exact != '') {
                tmp = boldify(value, q[i].exact, 0);
                value = tmp;
            }
        }
        return value;
    }
    function boldify(src, searchstr, offset) {
    	if (searchstr == '') {
    		return src;
    	}
    	
        var pos = src.toLowerCase().indexOf(searchstr.toLowerCase(), offset);
        if (pos == -1) {
            return src;
        }
        var searchlen = searchstr.length;
        var highlight = '<font style="font-weight:bold;">' + src.substring(pos, pos + searchlen) + '</font>';
        var result = src.substring(0, pos) + highlight + src.substring(pos + searchlen);
        
        return boldify(result, searchstr, pos + highlight.length);
    }
    function onColumnDataReceived(columns) {
        // Unload the grid and then recreate it 
        jQuery("#logs_search").GridUnload("#logs_search");

        /* Search log grid  */
        $("#logs_search").jqGrid({
            altRows: true,
            altclass: 'gridAltRow',
            autoencode: true,
            url: 'log_search_data',
            datatype: 'json',
            mtype: 'GET',
            colNames: columns.col_names,
            colModel: columns.col_model,
            pager: '#pager',
            pagerpos: 'right',
            loadui: 'block',
            rowNum: 25,
            rowList: [25, 100, 250, 500],
            sortname: 'update_time',
            sortorder: 'desc',
            caption: '',
            height: 'auto',
            width: '100%',
            viewrecords: true,
            recordpos: 'left',
            toppager: true,
            jsonReader: {
                root: "data",
                page: "currpage",
                total: "totalpages",
                records: "totalrecords",
                repeatitems: false,
                id: "sid"
            },
            loadError: checkLoginPageRedirect,
            loadComplete: function(data) {
                $("#totalrecords").html(data.totalrecords);
                doResize();
            },
            onCellSelect: function (rowid, iCol, cellcontent, e) {
                doDetailView(rowid, e.pageX, e.pageY);
            }
        }).navGrid("#pager", { refresh: false, search: false, edit: false, add: false, del: false }, {}, { width: 350 }, {});

        var l_t = $("#options_logtype option:selected").val();
        if (l_t == 'all') {
            $("#logs_search").showCol('log_type');
        } else {
            $("#logs_search").hideCol('log_type');
        }
        $("#logs_search").setColProp('update_time', { formatter: utcDateFormatter });
        $("#logs_search").setColProp('xml_log', { formatter: boldFormatter});
        $(window).resize();
    }

    function buildQuery() {
        var parts = new Array();
        $("#search_widgets .search_widget").each(function (index, element) {
            var data = {
                'any': '',
                'all': '',
                'exact': '',
                'none': ''
            };
            $(".sub_search_widget", this).each(function (index, element) {
                var type = $(".search_widget_select", this).val();
                var search_text = $(".search_widget_input", this).val();
                if (data[type].length > 0 && search_text.length > 0) {
                    data[type] += ' ' + search_text;
                } else {
                    data[type] += search_text;
                }
            });
            
            if (data.any.length > 0 ||
                data.all.length > 0 ||
                data.exact.length > 0 ||
                data.none.length > 0) {

                parts.push(data);
            }
        });

        var times = R_DATE_NAVBAR.getStartEndSeconds();
        var b_time = times[0];
        var e_time = times[1];
        
        var ret = {
            'sn': $("#select_sn").val(),
            'cluster_id': '', 
            'name': $("#select_name").html(),
            'minutes': '', 
            'b_time': b_time,
            'e_time': e_time,
            'l_t': urlLt, 
            'q': parts
            };
            
        return ret;
    }
    
    initWithQuery();
    function initWithQuery() {
        var querystring = $("#loaded_query").html();
        var sn = '';
        var cluster_id = '';
        var l_t = '';
        var minutes = '';
        
        if (querystring) {
            var data = JSON.parse(querystring);

            if ((data.sn != null && data.sn != '') || (data.cluster_id != null && data.cluster_id != '')) {

                $("#options_logtype [value='" + data.l_t + "']").attr('selected', true);
                if (data.minutes == '') {
                    $("#options_timerange [value='timerange_custom']").attr('selected', true);
                    var b = new Date(data.b_time * 1000);
                    var e = new Date(data.e_time * 1000);
                } else {
                    $("#options_timerange [value='" + data.minutes + "']").attr('selected', true);
                }
            }
            if (data.q && data.q.length > 0) {
                var q = data.q;
                for (var i=0;i<q.length;i++) {
                    AddWidget();
                    $("#search_widgets .search_widget:last").each(function (index, element) {
                        var type = 'any';
                        var val = unescape(q[i].any);
                        if (q[i].all != '') {
                            type = 'all';
                        } else if (q[i].exact != '') {
                            type = 'exact';
                        } else if (q[i].none != '') {
                            type = 'none';
                        }
                        $(".search_widget_select [value='" + type + "']").attr('selected', true);
                        $(".search_widget_input", this).val(val);

                        var type = $(".search_widget_select", this).val();
                        var search_text = $(".search_widget_input", this).val();
                        if (search_text.length > 0) {
                            data[type] = search_text;
                        }
                    });
                }
            }

            $("#loaded_query").remove();
            if (data.start_search) {
                showMenuBarProgress();
                setTimeout(doSearch, 3000);
            } else {
                showMenuBarComplete();
                getGridData();
                lastQuery = data;
            }
        } else {
            AddWidget();
        }
        
    }
    
    /* -=-=-=- Buttons -=-=-=- */
    $("#btn_addtosearch").click(AddWidget);

    $("#btn_load").click(function() {
        $("#load_query_dlg").modal();
    });

    $("#hidden_btn_select_device").click(function() {
        var sn = $("#select_sn").html();
        var name = $("#select_name").html();
        var cluster_id = $("#select_cluster").html();
        if (cluster_id.length === 0) {
            $("#crumbname").html(name);
        } else if (sn.length === 0) {
            $("#crumbname").html(cluster_id);
        } else {
            $("#crumbname").html(cluster_id + ' ' + name);
        }
        $("#device_list_dlg").modal('hide');
    });
    $(".ui-widget-overlay").live('click', function(event) {
        $("#device_list_dlg").modal('hide'); 
    });
    
    $("#btn_save").click(function() {
        var query = buildQuery();
        if (query.length === 0) {
            return;
        }
        
        $.ajax({
            url: 'log_search_save',
            type: 'POST',
            contentType: 'application/json',
            dataType: 'text',
            processData: false,
            data: JSON.stringify(query),
            error: function(xhr, status, error) {
                alert(error);
            },
            success: function(data) {
                window.location = "/log/log_search_savequery";
            }
        });
    });

    $("#btn_search").click(doSearch);

    $("#btn_export").click(function() {
        $("#search_processing").modal({ keyboard: false, backdrop: true });
        $.ajax({
            url: "/log/export_search?client_tz=" + WGRD.client_tz,
            method: 'GET',
            dataType: 'json',
            error: checkLoginPageRedirect,
            success: function(data) {
                if (data == null) {
                    $("#search_processing").modal('hide'); 
                    return;
                }
                if (!data.status) {
                    if (data.message) {
                        alert(data.message);
                    }
                    return true;
                }
                window.location = "/log/get_export_file";
                return false;
            },
            complete: function(filename) {
                $("#search_processing").modal('hide'); 
            }
        });
    });

    $("#btn_clear").click(function() {
        $.ajax({
            url: 'log_search_cancel',
            type: 'GET',
            dataType: 'json',
            error: function(xhr, status, error) {
                showMenuBarDefault();
                alert(error);
            },
            success: function(response) {
                showMenuBarDefault();
                jQuery("#logs_search").GridUnload("#logs_search");
                $("#complete_row").hide();
            }
        });
    });
    $("#btn_cancel").click(function() {
        //$("#btn_cancel").button("disable");
        $.ajax({
            url: 'log_search_cancel',
            type: 'GET',
            dataType: 'json',
            error: function(xhr, status, error) {
                showMenuBarDefault();
                alert(error);
            },
            success: function(response) {
                showMenuBarDefault();
                jQuery("#logs_search").GridUnload("#logs_search");
                $("#complete_row").hide();
            }
        });
    });

    function showMenuBarDefault() {
        $("#complete_row").hide();
        $("#progress_row").hide();
        $("#button_row button").each(function() {
            $(this).removeClass('disabled');
            //$(this).button("enable");
        });
        $("#button_row").show();
    }
    function showMenuBarComplete() {
        $("#complete_row").show();
        $("#progress_row").hide();
        $("#button_row button").each(function() {
            $(this).removeClass('disabled');
            //$(this).button("enable");
        });
        $("#button_row").show();
    }
    function showMenuBarProgress() {
        $("#btn_cancel").button("enable");
        $("#progress_row").show();
        $("#complete_row").hide();
        $("#progress .bar").css({ width: 0 }); //progressbar({ value: 0 });
        $("#button_row button").each(function() {
            $(this).addClass('disabled'); //button("disable");
        });
    }

    function getSessionInfo() {
        /* */
        $.ajax({
            url: 'log_search_session_info',
            type: 'GET',
            dataType: 'json',
            error: checkLoginPageRedirect,
            success: function(response) {
                if (response == null) {
                    if (getSessionFailures < 2) {
                        // Be patient
                        setTimeout(getSessionInfo, 1500);
                        getSessionFailures += 1;
                    } else {
                        showMenuBarDefault();
                    }
                    return;
                }
                $("#progress .bar").css('width', response.percent_complete + '%' ); //
                //$("#progress").progressbar("option", "value", response.percent_complete);
                if (response.status == '2' ||
                    response.status == '3') {
                    $("#progress .bar").css('width', '100%'); //
                    //$("#progress").progressbar("option", "value", 100);
                    if ($("#progress").is(":visible") && parseInt(response.count) > 0) {
                        $("#logs_search").setGridParam().trigger("reloadGrid");
                    }
                    setTimeout(showMenuBarComplete, 1000);
                } else {
                    setTimeout(getSessionInfo, 1500);
                }
                $("#totalrecords").html(response.count);
            }
        });
    }

    function doSearch() {
    
        getSessionFailures = 0;
        showMenuBarProgress();
        var query = buildQuery();
        if (query.length === 0) {
            return;
        }
        lastQuery = null;
        
        $.ajax({
            url: 'log_search',
            type: 'POST',
            contentType: 'application/json',
            dataType: 'text',
            processData: false,
            data: JSON.stringify(query),
            error: function(xhr, status, error) {
                showMenuBarDefault();
                alert(error);
            },
            success: function(data) {
                setTimeout(getSessionInfo, 2000);
                getGridData();
                lastQuery = query;
            }
        });
        
    };
    
    
    
    $("#btn_close").live('click', function(event) {
        var div = $(this).closest(".search_widget");
        var sub_div = $(this).closest(".sub_search_widget");
        if ($(".and", sub_div).is(':visible')) {
            sub_div.remove();
        } else {
            div.remove();
            toggleOR();
        }
    });
    
    $("#btn_addtoblock").live('click', function(event) {
        var div = $(this).closest(".search_block");
        if ($(".sub_search_widget", div).length > 3) {
            return;
        }
        var widget_html = $("#base_sub_search_widget").html();
        if (widget_html.length > 0) {
            div.append(widget_html);
        }
        $(".and", div).each(function(i) {
            if (i === 0) {
                $(this).hide();
            } else {
                $(this).show();
            }
        });
        $("#btn_addtoblock", div).each(function(i) {
            if (i === 0) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    });

    function toggleOR() {
        $("#search_widgets .search_widget .or").each(function(i) {
            if (i === 0) {
                $(this).hide();
            } else {
                $(this).show();
            }
        });
        if ($("#search_widgets .search_widget").length > 0) {
            $("#btn_search").removeClass('disabled')
                            .removeAttr('disabled');
        } else {
            $("#btn_search").addClass('disabled')
                            .attr('disabled', true);
        }
    }
    
    function AddWidget() {
        if ($(".search_widget").length > 9) {
            return;
        }
        var widget_html = $("#base_search_widget").html();
        if (widget_html.length > 0) {
            $("#search_widgets").append(widget_html);
            toggleOR();
        } 
    }

    /* -=-=-=- Page resizing -=-=-=- */
    function doResize() {
        var fpwidth = $("#main_div_row").width();
        fpwidth -= $(".date_navbar_td").width();
        var padleft = 0;
        var grid_width = fpwidth - padleft * 2;

        $('#logs_search').setGridWidth(grid_width);

        return;
    }
    $(window).bind('resizeEnd', function () {
        doResize();
    });

    $(".searchTable").show();

    if ($("#log_search_load_error").length) {
        $("#load_query_dlg").modal();
    } else if (!$("#select_sn").length) {
        // Prompt to select device when navigating from /log/search
        setTimeout(function() { $("#btn_device_list").click(); }, 100);
    }
    
}); 