var L_SERVERS = {
    init: function () {
        L_SERVERS.initUI();
        L_SERVERS.initEvents();

        L_SERVERS.getGridData();
    },
    initUI: function () {
        WGRD.enableUIElements(false, ['#server_delete_btn']);
    },
    initEvents: function () {
        $('#server_delete_btn').button().click(L_SERVERS.removeServerAction);

        $(window).bind('resizeEnd', function() {
            var w = $("#main_div_row").width();
            var w1 = $("#jumpto_div").width();

            var grid_width = w - w1 - 20;
            $('#grid_entities_servers').setGridWidth(grid_width);
        });
    },
    getGridData: function (complete_cb){
        // Note, this function is also called by S_LOG_DEVICES.doRefreshTabs() in log_devices.js
        $.ajax({
            url: 'log_grid_columns?l_t=' + 'servers',
            method: 'GET',
            dataType: 'json',
            success: L_SERVERS.onGridDataReceived,
            complete: function() {
                if (complete_cb) {
                    complete_cb();
                }
            }
        });
    },
    onGridDataReceived: function (columns) {

        // Unload the grid and then recreate it
        jQuery("#grid_entities_servers").GridUnload("#grid_entities_servers");

        var padleft = parseInt($("#grid_parent").css('margin-left'));
        var grid_width = $("#grid_parent").width() - padleft * 2;

        $("#grid_entities_servers").jqGrid({
            altRows: true,
            altclass: 'gridAltRow',
            url: 'log_servers',
            datatype: 'json',
            mtype: 'GET',
            colNames: columns.col_names,
            colModel: columns.col_model,
            pager: '#pager_entities_servers',
            pagerpos: 'right',
            toppager: true,
            viewrecords: true,
            recordpos: 'left',
            rowNum: 10,
            rowList: [10, 20, 50, 100],
            sortname: 'appliance_name',
            sortorder: 'asc',
            caption: '',
            height: 'auto',
            width: grid_width,
            loadComplete: function(data) {
                if(data === null) {
                    $('#error_msg').show();
                    $('#log_servers').hide();
                }
                $(window).resize();

                L_SERVERS.toggleRemoveBtn();
            },
            loadError: function(xhr, status, error) {
                if (!checkLoginPageRedirect(xhr, status, error)) {
                    alert(status);
                }
            },
            onSelectRow: function(rowid, status, e) {
                L_SERVERS.toggleRemoveBtn();
            }
        }).navGrid("#pager_entities_servers", { refresh: false, search: false, edit: false, add: false, del: false }, {}, { width: 350 }, {});

        $("#grid_entities_servers").setColProp('appliance_name', {
            sorttype: function (cellvalue) {
                if (cellvalue.indexOf('<span class=') >= 0
                    && cellvalue.indexOf('&nbsp;') > 0) {
                    cellvalue = cellvalue.substring(cellvalue.indexOf('&nbsp;')+6);
                }
                return cellvalue.toLowerCase();
            }
        });
    },

    toggleRemoveBtn: function() {
        // enable/disable "Remove" button depending on if any rows are selected or not
        var gridSelector = '#grid_entities_servers';
        S_LOG_DEVICES.toggleRemoveBtnCommon($(gridSelector).jqGrid('getGridParam', 'selrow'),
                                            gridSelector,
                                            '#server_delete_btn');
    },

    removeServerAction: function() {
        $('#confirmBoxDiv h3').text(S_REMOVE_SERVER_TITLE);
        WGRD.confirmModal(S_REMOVE_SERVER_CONFIRM_MSG, true, L_SERVERS._removeServerAction);
    },

    _removeServerAction: function() {
        WGRD.enableUIElements(false, ['#server_delete_btn']);
        var selRowId = $('#grid_entities_servers').jqGrid('getGridParam', 'selrow');
        if (!selRowId) {
            return;
        }

        var rowdata = $('#grid_entities_servers').getRowData(selRowId);
        var sn_data = {'sn_list': rowdata['sn']};
        $.ajax({
            url: 'delete_client',
            type: 'POST',
            dataType: 'json',
            data: sn_data,
            success: function() {
                $('#grid_entities_servers').jqGrid('delRowData', selRowId)
            },
            error: function() {
                alert(S_REMOVE_SERVER_ERROR);
                L_SERVERS.toggleRemoveBtn();
            }
        });
    }

}
$(document).ready(L_SERVERS.init);

