$(document).ready(function() {                    
	var reportName;  
    var portal_link = "http://www.watchguard.com/SecurityPortal/ThreatDetail.aspx?rule_id=";
    var allVars = $.getUrlVars();
    var urlSn = $.getUrlVar('sn');
    var repType = $.getUrlVar('reptype');    
    var date = $.getUrlVar('date');
    var id = $.getUrlVar('id');
    var period = $.getUrlVar('period');    
    var urlTz = $.getUrlVar('tz');         
    var htmlDate = $("#date").val();
    var htmlSn = $("#sn").val();    
    var startTime = '';
    var endTime = '';
    var seriesEarliestRecord = '';
    var seriesLatestRecord = '';
    var resultData = new Object();
    var showDetailView = false;
    
    // Set the report type from the url
    if(repType != null){
        $('#chart_select').val(repType);
    }
    if(period != null && period == 'custom'){
        $('#chart_select').hide();
    }   
        
	$('#pdf_link').click(function(){
		resultData.grid_data = updateTimezones(resultData.grid_data, resultData.col_model);
		resultData.user_data = updateUserTimezones(resultData.user_data, resultData.user_col_model);

		data = JSON.stringify(resultData);
		
        var reportType = $('#chart_select option:selected').val();

        var tzOffsetStart = $.getDateUTCOffsetString(seriesEarliestRecord, urlTz);
        var tzOffsetEnd = $.getDateUTCOffsetString(seriesLatestRecord, urlTz);
		
		$.ajax({
		    url: "saveAsPdf?serial=" + htmlSn + "&client_tz=" + WGRD.client_tz + "&report_type=" + reportType + "&start_time=" + seriesEarliestRecord + "&end_time=" + seriesLatestRecord
			      + "&tz_offset_start=" + tzOffsetStart +  "&tz_offset_end=" + tzOffsetEnd,
			type: 'POST',
			data: data,
			contentType: 'application/json',
			success: function(data) {
				if(!data.status){
					if(data.message){
						alert(data.message);
					}
					return true;
				}
				window.location = "get_pdf_file?serial=" + htmlSn;
				return false;
			}	
		});
	});        
        
    // Add handler for change the type of chart
    $("#chart_select").change(function () {   getData();  });

    $("#custom_datepicker_trigger").bind('click', function() {
        // Listen fora click on this div, it means the date changed 
        // and a refresh is needed
        getData();
    });       
    function getData(){
        //Once the date is set, refresh all the charts
        var jqxhr = getChartData('chart', htmlSn, true, id);
        jqxhr.success(dataReceived);
    }
     
    // Return data handler functions
    function dataReceived(series){
        resultData = series;

        seriesEarliestRecord = series.earliest_record;
        seriesLatestRecord = series.latest_record;
        startTime = $.getDateDisplay(series.earliest_record, true, urlTz);
        endTime = $.getDateDisplay(series.latest_record, true, urlTz);
        showDetailView = series.detail_view;        
        reportName = $('#chart_select option:selected').text(); 
                
        // Notify the date navbar the report range changed
        $('#report_range').trigger('reportRange', { start_time: startTime, 
                                                    end_time: endTime, 
                                                    name: reportName });        
                
        // Unload the grid and then recreate it and populate the rows
        jQuery("#app_grid_area").GridUnload("#app_grid_area");
        createAppGrid(series.col_names, series.col_model, series.grid_sort);

        for(i=0;i<=series.grid_data.length;i++) {
            $("#app_grid_area").jqGrid('addRowData',i+1,series.grid_data[i]);
        }
        $("#app_grid_area").setGridParam({rowNum:i});        
        $("#app_grid_area").jqGrid('footerData','set', series.footer, false);
        setGridHeight();
    }          
     
    // Application list DataGrid
    function createAppGrid(colNames, colModel, gridSort){
        $('#app_grid_area').jqGrid({ 
            datatype: "local", 
            colNames:colNames,
            colModel:colModel,        
            sortname: gridSort.sortname,
            sortorder: gridSort.sortorder, 
            autoencode: true,
            autowidth: true,
            shrinkToFit: true,
            subGrid: true,
            footerrow:true,
            subGridRowExpanded: function(subgrid_id, row_id){
                var subgrid_table_id, pager_id;
                subgrid_table_id = "subgrid" + row_id;
                $("#" + subgrid_id).html("<table id='" + subgrid_table_id + "'></table>");
                jQuery("#" + subgrid_table_id).jqGrid({
                    datatype: "local",
                    colNames: resultData.user_col_names,
                    colModel: resultData.user_col_model,
                    sortname: resultData.user_grid_sort.sortname,
                    sortorder: resultData.user_grid_sort.sortorder, 
                    height: '100%',
                    width: '100%',
                    onCellSelect: function(id, iCol, cellcontent, e) {
                        if(showDetailView){
                            doDetailView(id, subgrid_table_id, e.pageX, e.pageY);
                        }
                    }    
                });

                // Add click handlers to the subgrid to link to the per client reports
                $("#" + subgrid_table_id).setColProp('host', { formatter: linkFormatter });     
                $("#" + subgrid_table_id).setColProp('ip', { formatter: linkFormatter });     
                $("#" + subgrid_table_id).setColProp('user', { formatter: linkFormatter });  
                                
                //Get the subgrid data and fill it in here
                var app = $("#app_grid_area").jqGrid('getCell',row_id,'application');
                var row_data = resultData.user_data[app];

                for(var i=0;i<=row_data.length;i++) {
                    $("#" + subgrid_table_id).jqGrid('addRowData',i+1, row_data[i]);
                }
                $("#" + subgrid_table_id).setGridParam({rowNum:i});               
                setGridHeight();
                
            },           
            subGridRowColapsed: function(subgrid_id, row_id){
                /* IE doesn't resize grids with sub grids properly, so set the height manually  */
                /* subtract the height of the subgrid that's being collapsed from the grids height */
                var sub_height = $('#' + subgrid_id).height();
                var height = $('#app_grid_area').height();
                $('#app_grid_area').setGridHeight(height - sub_height);
            }          
        });
    }
    
    /* IE doesn't resize grids with sub grids properly, so set the height manually  */
    function setGridHeight(){
        var height = $('#app_grid_area').height();
        $('#app_grid_area').setGridHeight(height);    
    }

    linkFormatter = function(elem, cellval, opts){
        return formatPerClientLink(elem, cellval, opts);
    }

    function formatPerClientLink(elem, cellval, opts){
        var index = startTime.indexOf(' ');
        var start_date = startTime.substring(0,index);
        var start_time = startTime.substring(index + 1, startTime.length);
        index = endTime.indexOf(' ');
        var end_date = endTime.substring(0,index);
        var end_time = endTime.substring(index + 1, endTime.length);            

        uri = 'perclient?sn=' + urlSn + 
              '&start_date=' + start_date + 
              '&start_time=' + start_time + 
              '&end_date=' + end_date + 
              '&end_time=' + end_time;
        if(cellval.colModel.name == 'ip'){
            uri = uri + '&ip=' + elem;
            if(typeof(opts.host) != "undefined" && opts.host != '') {
            	uri += '&host=' + escape(opts.host);
            }
        }else if(cellval.colModel.name == 'user'){
            uri = uri + '&user=' + elem;
        }else if(cellval.colModel.name == 'host'){
            uri = uri + '&host=' + escape(elem);
            if(typeof(opts.ip) != "undefined" && opts.ip != '') {
            	 uri += '&ip=' + opts.ip;
            }
        }              

        return "<a href='" + uri + "'>" + escapeHtml(elem) + "</a>";
    } 

    /* -=-=-=- detail view -=-=-=- */
    $("#detailview").dialog(
        {
            width: 600,
            resizable: false,
            autoOpen: false
        }
    );
    
    function doDetailView(id, subgrid_table_id, pageX, pageY) {
        var time = $("#" + subgrid_table_id).jqGrid('getCell',id,'time');    
        var output = "<table width='100%' style='padding: 3px;'>";
        
        for (var i=0; i<resultData.user_col_model.length; i++){
            var val = $("#" + subgrid_table_id).jqGrid('getCell',id, resultData.user_col_model[i].index);
            var name = resultData.user_col_names[i];
            output += "<tr><td width='150'>" + name + "</td><td>" + val + "</td></tr>";
        }
        output += "<tr><td colspan='2'>&nbsp;</td></tr>";
        
        var sig_id = $("#" + subgrid_table_id).jqGrid('getCell',id,'sig_id');    
        if(sig_id != ""){
            output += "<tr><td colspan='2'><a href='" + portal_link + sig_id +"' target='ipsportal'>"+ portal_link + sig_id + "</a></td></tr>";
            output += "<tr><td colspan='2'>&nbsp;</td></tr>";
        }
                        
        output += "</table>";
        output += "<div>&nbsp;</div>";
        $("#detailview").html("<div>" + output + "</div>");

        /* 
        * If the detail view has scrolled out of view, reposition it centered
        * and below the row that was clicked
        */
        offset = $("#detailview").offset();
        if (offset != null) {
            var scrollTop = $(document).scrollTop();
            var h_win = $(window).height();
            if (offset.top < scrollTop
                || offset.top > scrollTop + h_win) {
                w_doc = $(document).width();
                w_dlg = $("#detailview").width();
                var x = (w_doc - w_dlg) / 2;
                var y = pageY - scrollTop + 10;
                $("#detailview").dialog({ position: [x, y] });
            }
        }

        /* Reset the height to 'auto' for IE */
        $("#detailview").dialog({ height: 'auto' });
        $("#detailview").dialog({ title: time });
        $("#detailview").dialog("open");
                 
    }
    
    $(window).bind('resizeEnd', function() {
        if(window.plot_trend){        
            var grid = "#app_grid_area";
            var parent = "#grid_data";
            var grid_width = resizegrid();
            $("#webui_content").width(grid_width);
            $(grid).setGridWidth(100, true); 
            $(grid).setGridWidth($(parent).width(), true);
            plot_trend.replot();
        }
    });      
});
