var S_APT_DETAIL = {
    init : function() {
        S_APT_DETAIL.initEvents();
    },

    initEvents : function() {
        $('#apt_ok').click(function() {
            $('#apt_detail_dlg').modal("hide");
        });
    },

    showDetailsDialog : function(event) {
        event.preventDefault();

        var threat_id = event.currentTarget.id;
        $('.apt-subtitle').text(threat_id);

        var apt_data = {'threat_id': threat_id};

        $('#threat_id_contents').empty();
        $('#details').empty();
        $('#apt_detail_header').text(S_MALICIOUS_ACTIVITY);
        $('#details_div').hide();
        $('#threat_summary_table').hide();
        $('#threat_summary_table').hide();
        $('#error_msg').hide();

        $.ajax({
            url: 'get_apt_details',
            type: 'POST',
            dataType: 'json',
            async: false,
            data: apt_data,
            success : function(data) {
                if(data.status) {
                    var md5 = data.apt_details.md5;
                    var mime_type = data.apt_details.mime_type;
                    var threat_level = data.apt_details.threat_level;
                    var threat_class = data.apt_details.threat_class;
                    var threat_name = data.apt_details.threat_name;
                    var malicious_activity = data.apt_details.malicious_activity;

                    $('#threat_summary_table').show();
                    if (md5.length > 0) {
                        S_APT_DETAIL.prepare_detail_data(S_MD5, md5);
                    }
                    if (mime_type.length > 0) {
                        S_APT_DETAIL.prepare_detail_data(S_MIME_TYPE, mime_type);
                    }
                    if (threat_level.length > 0) {
                        S_APT_DETAIL.prepare_detail_data(S_THREAT_LEVEL, threat_level);
                    }
                    if (threat_class.length > 0) {
                        S_APT_DETAIL.prepare_detail_data(S_THREAT_CLASS, threat_class);
                    }
                    if (threat_name.length > 0) {
                        S_APT_DETAIL.prepare_detail_data(S_THREAT_NAME, threat_name);
                    }
                    if (malicious_activity.length > 0) {
                        $('#details_div').show();
                        var header_text = $('#apt_detail_header').text();

                        $('#apt_detail_header').text(header_text+' ('+ malicious_activity.length + ')');

                        $.each(malicious_activity, function(index, value) {
                            $('#details').append('<tr><td>' + value + '</td></tr>');
                        });
                    }
                     //If more than one dialog is up, then first hide the current active modal dialog
                     //then show the new dialog, when the new one is closed, show the previous one
                     //This is done to prevent an Uncaught RangeError: Maximum call stack size exceeded exception that 
                     //is shown in the console if two dialogs are up at the same time.
                     var $currentModals = $('.modal.in');
                     if ($currentModals.length > 0) {
                         $currentModals.one('hidden', function () {
                             // when they've finished hiding
                             $('#apt_detail_dlg').modal('show');
                             $('#apt_detail_dlg').one('hidden', function () {
                                 // when we close the dialog
                                 $currentModals.modal('show');
                             });
                         }).modal('hide');
                     } else {
                         $("#apt_detail_dlg").show();
                     }
                } else {
                    $('#error_msg').show().find('p').text(data.message);
                }

                $("#apt_detail_dlg").modal();
            },
            error : function() {
                $('.modal-body').append('<p class="text-error">' + S_FAILED +'</p>');
            }
        });
    },

    prepare_detail_data : function (col_name, col_data) {
        var col1 = '<td><b>' + col_name + '</b></td>';
        var col2 = '<td>' + col_data + '</td>';
        var row = '<tr>' + col1 + col2 + '</tr>';

        $('#threat_id_contents').append(row);
    }
};
$(document).ready(S_APT_DETAIL.init);