var R_CH_ONLY_REP = {
    urlSn: '',
    date: '',
    id: '',
    period: '',
    urlTz: '',
    repType: '',
    htmlDate: '',
    htmlSn: '',
    startTime: '',
    endTime: '',
    seriesEarliestRecord: '',
    seriesLatestRecord: '',
    reportName: '',

    init: function () {
        var allVars = $.getUrlVars();
        R_CH_ONLY_REP.urlSn = $.getUrlVar('sn');
        R_CH_ONLY_REP.date = $.getUrlVar('date');
        R_CH_ONLY_REP.id = $.getUrlVar('id');
        R_CH_ONLY_REP.period = $.getUrlVar('period');
        R_CH_ONLY_REP.urlTz = $.getUrlVar('tz');
        R_CH_ONLY_REP.repType = $.getUrlVar('reptype');
        R_CH_ONLY_REP.htmlDate = $("#date").val();
        R_CH_ONLY_REP.htmlSn = $("#sn").val();

        R_CH_ONLY_REP.initUI();
        R_CH_ONLY_REP.initEvents();
    },

    initUI: function () {

        // Set the report type from the url
        if(R_CH_ONLY_REP.repType !== null) {
            $('#chart_select').val(R_CH_ONLY_REP.repType);
        }
    },

    initEvents: function () {
        $('#pdf_link').click(function() {
            var reportType = $('#chart_select option:selected').val();
            var tzOffsetStart = $.getDateUTCOffsetString(R_CH_ONLY_REP.seriesEarliestRecord, R_CH_ONLY_REP.urlTz);
            var tzOffsetEnd = $.getDateUTCOffsetString(R_CH_ONLY_REP.seriesLatestRecord, R_CH_ONLY_REP.urlTz);

            $.ajax({
                url: "saveAsPdf?serial=" + R_CH_ONLY_REP.htmlSn + "&client_tz=" + WGRD.client_tz + "&report_type=" + reportType + "&start_time=" + R_CH_ONLY_REP.seriesEarliestRecord + "&end_time=" + R_CH_ONLY_REP.seriesLatestRecord + "&tz_offset_start=" + tzOffsetStart +  "&tz_offset_end=" + tzOffsetEnd,
                type: 'POST',
                contentType: 'application/json',
                success: function(data) {
                    if(!data.status) {
                        if(data.message) {
                            alert(data.message);
                        }
                        return true;
                    }
                    window.location = "get_pdf_file?serial=" + R_CH_ONLY_REP.htmlSn;
                    return false;
                }
            });
        });

        $("#custom_datepicker_trigger").bind('click', function() {
            // Listen fora click on this div, it means the date changed 
            // and a refresh is needed
            R_CH_ONLY_REP.getData();
        });

        $(window).bind('resizeEnd', function() {
            if(window.plot_trend) {
                plot_trend.replot();
            }
        });
    },

    getData: function() {
        //Once the date is set, refresh all the charts
        var jqxhr = getChartData('chart', R_CH_ONLY_REP.htmlSn, true, R_CH_ONLY_REP.id);
        jqxhr.success(R_CH_ONLY_REP.dataReceived);
    },

    dataReceived: function(series) {
        R_CH_ONLY_REP.seriesEarliestRecord = series.earliest_record;
        R_CH_ONLY_REP.seriesLatestRecord = series.latest_record;
        R_CH_ONLY_REP.startTime = $.getDateDisplay(series.earliest_record, true, R_CH_ONLY_REP.urlTz);
        R_CH_ONLY_REP.endTime = $.getDateDisplay(series.latest_record, true, R_CH_ONLY_REP.urlTz);
        R_CH_ONLY_REP.reportName = $('#chart_select option:selected').text();

        // Notify the date navbar the report range changed
        $('#report_range').trigger('reportRange', { start_time: R_CH_ONLY_REP.startTime,
                                                    end_time: R_CH_ONLY_REP.endTime,
                                                    name: R_CH_ONLY_REP.reportName });
    }
};
$(document).ready(R_CH_ONLY_REP.init);