var S_COMPLIANCE_REP = {
    period: '1d',
    htmlDate: '',
    htmlSn: '',
    urlTz: '',
    startTime: '',
    endTime: '',
    rep_type:'hipaa',
    /*
     * Define a name for each widget in this page, this name is appended
     * div suffixes to show/hide/render widget pieces
     */
    compliance: 'compliance',
    undetected_apt: 'undetected_apt',
    apt: 'apt',
    gav: 'gav',
    ips: 'ips',
    audit: 'audit',
    alarms: 'alarms',
    auth: 'auth',
    seriesEarliestRecord: '',
    seriesLatestRecord: '',

    init: function() {
        S_COMPLIANCE_REP.htmlDate = $("#date").val();
        S_COMPLIANCE_REP.htmlSn = $("#sn").val();
        S_COMPLIANCE_REP.urlTz = $.getUrlVar('tz');
        S_COMPLIANCE_REP.rep_type = $.getUrlVar('reptype');
        S_COMPLIANCE_REP.initUI();
        S_COMPLIANCE_REP.initEvents();
    },

    initUI: function() {
        if (S_COMPLIANCE_REP.rep_type === 'hipaa') {
            $("#pci").remove();
            HELP_LINK_OVERRIDE = 7220;
        } else {
            $("#hipaa").remove();
            HELP_LINK_OVERRIDE = 7221;
        }
        S_COMPLIANCE_REP.getAllData();
    },

    initEvents: function() {

        // Add handler for change the type of chart
        $('#' + S_COMPLIANCE_REP.undetected_apt + '_select').change(function () {
            var jqxhr = getChartData(S_COMPLIANCE_REP.undetected_apt, S_COMPLIANCE_REP.htmlSn);
            jqxhr.success(S_COMPLIANCE_REP.retrieveData);
        });

        $('#' + S_COMPLIANCE_REP.apt + '_select').change(function () {
            var jqxhr = getChartData(S_COMPLIANCE_REP.apt, S_COMPLIANCE_REP.htmlSn);
            jqxhr.success(S_COMPLIANCE_REP.retrieveData);
        });

        $('#' + S_COMPLIANCE_REP.gav + '_select').change(function () {
            var jqxhr = getChartData(S_COMPLIANCE_REP.gav, S_COMPLIANCE_REP.htmlSn);
            jqxhr.success(S_COMPLIANCE_REP.retrieveData);
        });

        $('#' + S_COMPLIANCE_REP.ips + '_select').change(function () {
            var jqxhr = getChartData(S_COMPLIANCE_REP.ips, S_COMPLIANCE_REP.htmlSn);
            //Only IPS and GAV have multiple options of viewing data, 
            //hence update the allData if user changes the selection
            jqxhr.success(S_COMPLIANCE_REP.retrieveData);
        });

        $('#' + S_COMPLIANCE_REP.alarms + '_select').change(function () { getChartData(S_COMPLIANCE_REP.alarms, S_COMPLIANCE_REP.htmlSn); });
        $('#' + S_COMPLIANCE_REP.audit + '_select').change(function () { getChartData(S_COMPLIANCE_REP.audit, S_COMPLIANCE_REP.htmlSn); });
        $('#' + S_COMPLIANCE_REP.auth + '_select').change(function () { getChartData(S_COMPLIANCE_REP.auth, S_COMPLIANCE_REP.htmlSn); });

        // Click handlers for charts
        $('#undetected_apt').find('.pointer').click(function() {
            var report_type = $('#undetected_apt_select option:selected').val();
            document.location.href='undetected_apt?sn=' + S_COMPLIANCE_REP.htmlSn + '&reptype=' + report_type + '&period=' + S_COMPLIANCE_REP.period;
        });
        
        $('#apt').find('.pointer').click(function() {
            var report_type = $('#apt_select option:selected').val();
            document.location.href='apt?sn=' + S_COMPLIANCE_REP.htmlSn + '&reptype=' + report_type + '&period=' + S_COMPLIANCE_REP.period;
        });

        $('#gav').find('.pointer').click(function() {
            var report_type = $('#gav_select option:selected').val();
            document.location.href='gav?sn=' + S_COMPLIANCE_REP.htmlSn + '&reptype=' + report_type + '&period=' + S_COMPLIANCE_REP.period;
        });

        $('#ips').find('.pointer').click(function() {
            var report_type = $('#ips_select option:selected').val();
            document.location.href='ips?sn=' + S_COMPLIANCE_REP.htmlSn + '&reptype=' + report_type + '&period=' + S_COMPLIANCE_REP.period;
        });

        $('#audit').find('.pointer').click(function() {
            var report_type = $('#audit_select option:selected').val();
            document.location.href='audittrail?sn=' + S_COMPLIANCE_REP.htmlSn + '&reptype=' + report_type + '&period=' + S_COMPLIANCE_REP.period;
        });

        $('#alarms').find('.pointer').click(function() {
            var report_type = $('#alarms_select option:selected').val();
            document.location.href='alarms?sn=' + S_COMPLIANCE_REP.htmlSn + '&reptype=' + report_type + '&period=' + S_COMPLIANCE_REP.period;
        });

        $('#user_auth').find('.pointer').click(function() {
            var report_type = $('#auth_select option:selected').val();
            document.location.href='userauthentication?sn=' + S_COMPLIANCE_REP.htmlSn + '&reptype=' + report_type + '&period=' + S_COMPLIANCE_REP.period;
        });

        $('#pdf_link').click(function() {
            var tzOffsetStart = $.getDateUTCOffsetString(S_COMPLIANCE_REP.seriesEarliestRecord, S_COMPLIANCE_REP.urlTz);
            var tzOffsetEnd = $.getDateUTCOffsetString(S_COMPLIANCE_REP.seriesLatestRecord, S_COMPLIANCE_REP.urlTz);
            
            var undetected_apt_report_type = $('#undetected_apt_select option:selected').val();
            var apt_report_type = $('#apt_select option:selected').val();
            var gav_report_type = $('#gav_select option:selected').val();
            var ips_report_type = $('#ips_select option:selected').val();
            
            var selected_rep_types = {};  //Applicable to the drop down selection for gav, ips
            
            if (S_COMPLIANCE_REP.rep_type === 'pci') {
                selected_rep_types['undetected_apt_type'] = undetected_apt_report_type;
                selected_rep_types['apt_type'] = apt_report_type;
                selected_rep_types['gav_type'] = gav_report_type;
                selected_rep_types['ips_type'] = ips_report_type;
            }

            $('#spinner_pdf_download').show();
            $('#pdf_link').hide();
            selected_rep_types = JSON.stringify(selected_rep_types);
            
            $.ajax({
                url: "saveAsPdf?serial=" + S_COMPLIANCE_REP.htmlSn + "&client_tz=" + WGRD.client_tz + "&report_type=" + S_COMPLIANCE_REP.rep_type + "&start_time=" + S_COMPLIANCE_REP.seriesEarliestRecord + "&end_time=" + S_COMPLIANCE_REP.seriesLatestRecord + "&tz_offset_start=" + tzOffsetStart +  "&tz_offset_end=" + tzOffsetEnd,
                type: 'POST',
                data: selected_rep_types,
                contentType: 'application/json',
                success: function(data) {
                    if(!data.status) {
                        if(data.message) {
                            alert(data.message);
                        }
                        return true;
                    }
                    window.location = "get_pdf_file?serial=" + S_COMPLIANCE_REP.htmlSn;
                    return false;
                },
                complete: function() {
                    $('#spinner_pdf_download').hide();
                    $('#pdf_link').show();
                }
            });
        });

        $("#custom_datepicker_trigger").bind('click', function() {
            // Listen for a click on this div, it means the date changed 
            // and a refresh is needed
            S_COMPLIANCE_REP.getAllData();
        });
    },

    //Based on the type of report[gav,auth etc ] update the allData object    
    retrieveData: function(series) {
        if (series.earliest_record !== '') {
            S_COMPLIANCE_REP.seriesEarliestRecord = series.earliest_record;
        }
        if (series.latest_record !== '') {
            S_COMPLIANCE_REP.seriesLatestRecord = series.latest_record;
        }
    },

    getAllData: function() {
        //Once the date is set, refresh all the charts
        var jqxhr='';
        
        if (S_COMPLIANCE_REP.rep_type === 'pci') {
            jqxhr = getChartData(S_COMPLIANCE_REP.undetected_apt, S_COMPLIANCE_REP.htmlSn);
            jqxhr.success(S_COMPLIANCE_REP.retrieveData);
            
            jqxhr = getChartData(S_COMPLIANCE_REP.apt, S_COMPLIANCE_REP.htmlSn);
            jqxhr.success(S_COMPLIANCE_REP.retrieveData);

            jqxhr = getChartData(S_COMPLIANCE_REP.gav, S_COMPLIANCE_REP.htmlSn);
            jqxhr.success(S_COMPLIANCE_REP.retrieveData);

            jqxhr = getChartData(S_COMPLIANCE_REP.ips, S_COMPLIANCE_REP.htmlSn);
            jqxhr.success(S_COMPLIANCE_REP.retrieveData);
        }

        jqxhr = getChartData(S_COMPLIANCE_REP.alarms, S_COMPLIANCE_REP.htmlSn);
        jqxhr.success(S_COMPLIANCE_REP.retrieveData);

        jqxhr = getChartData(S_COMPLIANCE_REP.audit, S_COMPLIANCE_REP.htmlSn);
        jqxhr.success(S_COMPLIANCE_REP.retrieveData);

        jqxhr = getChartData(S_COMPLIANCE_REP.auth, S_COMPLIANCE_REP.htmlSn);
        jqxhr.success(S_COMPLIANCE_REP.retrieveData);
    }
};
$(document).ready(S_COMPLIANCE_REP.init);
