var R_DATE_NAVBAR = {
    urlSn: '',
    lastStartTime: '',
    lastEndTime: '',
    needData: false,
    startPickerIsOpen: false,
    endPickerIsOpen: false,
    repDates: {},
    COLLAPSE_THRESHOLD: 640,
    autoCollapse: true,
    active_div_id: '',
    init: function () {
        var allVars = $.getUrlVars();
        R_DATE_NAVBAR.urlSn = $.getUrlVar('sn');

        R_DATE_NAVBAR.initUI();
        R_DATE_NAVBAR.initEvents();
        R_DATE_NAVBAR.initTimeZone();
        R_DATE_NAVBAR.getAvailDates();
        R_DATE_NAVBAR.doResize();
    },
    initUI: function () {
        $("#datepicker").attr('disabled', true);
        $("#datepicker_end").attr('disabled', true);
        $('#available_reports').show();

        // Create date picker and handle events (need to do this before we set the date)
        $("#datepicker").datetimepicker({
            onClose: R_DATE_NAVBAR.onCloseStart,
            onSelect: R_DATE_NAVBAR.onSelectStart,
            beforeShow: R_DATE_NAVBAR.beforeShowStart,
            beforeShowDay: R_DATE_NAVBAR.beforeShowDay,
            dateFormat: 'yy-mm-dd'
        });
        $("#datepicker_end").datetimepicker({
            onClose: R_DATE_NAVBAR.onCloseEnd,
            onSelect: R_DATE_NAVBAR.onSelectEnd,
            beforeShow: R_DATE_NAVBAR.beforeShowEnd,
            beforeShowDay: R_DATE_NAVBAR.beforeShowDayEnd,
            dateFormat: 'yy-mm-dd'
        });

        $(document).on('click', '.ui-datepicker-close', R_DATE_NAVBAR.onDone);

        $("#datepicker").change(R_DATE_NAVBAR.weNeedData);
        $("#datepicker_end").change(R_DATE_NAVBAR.weNeedData);
        $("#show_hide_reps").on('click', R_DATE_NAVBAR.toggleReportsHeader);
        $("li.nav-header").live('click', R_DATE_NAVBAR.trackHeaderState);
    },
    initEvents: function () {
        $(window).bind('resizeEnd', function () {
            R_DATE_NAVBAR.doResize();
        });

        $(".mobile_datenav_btn").click(function (eo) {
            var visible_phone = false;
            if ($(window).width() < R_DATE_NAVBAR.COLLAPSE_THRESHOLD) {
                visible_phone = true;
            }
            R_DATE_NAVBAR.autoCollapse = false;
            if ($("#daily_mobile").css('display') != 'none') {
                R_DATE_NAVBAR.toggleMobile(false);
                if (!visible_phone) {
                    $(window).resize();
                }
            } else {
                R_DATE_NAVBAR.toggleMobile(true);
                $(window).resize();
            }
        });
    },
    toggleMobile: function(b) {
        if (b) {
            $("#daily_desktop").hide();
            $("#daily_mobile").show();
        } else {
            $("#daily_desktop").show();
            $("#daily_mobile").hide();
        }
    },
    doResize: function () {
        if (!R_DATE_NAVBAR.autoCollapse) {
            return;
        }
        if ($(window).width() < R_DATE_NAVBAR.COLLAPSE_THRESHOLD) {
            if ($("#daily_mobile").css('display') == 'none') {
                R_DATE_NAVBAR.toggleMobile(true);
                $(window).resize();
            }
        } else {
            if ($("#daily_mobile").css('display') != 'none') {
                R_DATE_NAVBAR.toggleMobile(false);
                $(window).resize();
            }
        }
    },
    convertDate: function(dateStr){
        var dateParts = dateStr.match(/(\d+)/g)
        var secs = "00";
        if (dateParts.length > 5) {
            secs = dateParts[5];
        }
        var newDate = new Date(dateParts[0], dateParts[1] - 1, dateParts[2], dateParts[3], dateParts[4], secs);

        return newDate;
    },
    /* Date picker support --> */
    getShortDateText: function(dateText){
        if (dateText == '' || dateText == null){
            return dateText;
        } else {
            return dateText.substring(dateText.length - 5);
        }
    },
    onSelectStart: function (dateText, inst) {
        if (dateText.length > 5) {
            var newStartTime = R_DATE_NAVBAR.getShortDateText(dateText);
            if ((R_DATE_NAVBAR.lastStartTime.length > 0 || newStartTime != '00:00') && R_DATE_NAVBAR.lastStartTime != newStartTime) {
                // Don't refresh when changing time
                R_DATE_NAVBAR.lastStartTime = newStartTime;
                R_DATE_NAVBAR.needData = true;
                return;
            } else {
                R_DATE_NAVBAR.updateTimeStart(dateText);
            }
        }
    },
    onSelectEnd: function (dateText, inst) {
        if (dateText != '') {
            var newEndTime = R_DATE_NAVBAR.getShortDateText(dateText);
            if ((R_DATE_NAVBAR.lastEndTime.length > 0 || newEndTime != '00:00') && R_DATE_NAVBAR.lastEndTime != newEndTime) {
                // Don't refresh when changing time
                R_DATE_NAVBAR.lastEndTime = newEndTime;
                R_DATE_NAVBAR.needData = true;
                return;
            } else {
                R_DATE_NAVBAR.updateTimeEnd(dateText);
            }
        }
    },
    updateTimeStart: function(newStartTime){
        if (newStartTime != null && newStartTime.length > 5) {
            // Called on datepicker close through done, clicking away, or clicking on a month.
            var start_time = $('#datepicker').datetimepicker('getDate');
            var end_time = $('#datepicker_end').datetimepicker('getDate');
            var start_time_fmt = start_time.format("yyyy-mm-dd HH:MM:ss");
            if (start_time && end_time && end_time <= start_time) {
                //$("#datepicker_end").datepicker("setDate", null);
                $("#datepicker_end").val('');
                end_time = null;
            }
            var end_time_fmt = '';
            if (end_time != null) {
                end_time_fmt = end_time.format("yyyy-mm-dd HH:MM:ss");
            }
            R_DATE_NAVBAR.lastStartTime = R_DATE_NAVBAR.getShortDateText(newStartTime);

            R_DATE_NAVBAR.setCurrentDate(start_time_fmt, end_time_fmt);
            $("#datepicker").datetimepicker("hide");
            R_DATE_NAVBAR.needData = false;
            R_DATE_NAVBAR.startPickerIsOpen = false;
        }
    },
    updateTimeEnd: function(newEndTime){
        if (newEndTime != ''){
            // Called on datepicker close through done, clicking away, or clicking on a month.
            var start_time = $('#datepicker').datetimepicker('getDate');
            var end_time = $('#datepicker_end').datetimepicker('getDate');
            if (start_time == null) {
                return;
            }
            var end_time_fmt = end_time.format('yyyy-mm-dd HH:MM:ss')
            var start_time_fmt = '';
            if (start_time && end_time) {
                var start_secs = start_time.getTime();
                var end_secs = end_time.getTime();
                if (end_secs == start_secs) {
                    // Let the user adjust the time in this case
                    return;
                }
                if (end_secs < start_secs) {
                    // Clear the end time
                    $("#datepicker_end").val('');
                    end_time = null;
                    end_time_fmt = '';
                    dateText = '';
                }
            }
            R_DATE_NAVBAR.lastEndTime = R_DATE_NAVBAR.getShortDateText(newEndTime);

            start_time_fmt = start_time.format("yyyy-mm-dd HH:MM:ss");
            R_DATE_NAVBAR.setCurrentDate(start_time_fmt, end_time_fmt);
            $("#datepicker_end").datetimepicker("hide");
            R_DATE_NAVBAR.needData = false;
            R_DATE_NAVBAR.endPickerIsOpen = false;
        }
    },
    weNeedData: function() {
        R_DATE_NAVBAR.needData = true;
    },
    onDone: function() {
        // Called when the done button is clicked.
        if (R_DATE_NAVBAR.startPickerIsOpen){
            var start_time = R_DATE_NAVBAR._getInternalTimeStr(true);
            R_DATE_NAVBAR.updateTimeStart(start_time);
        } else if (R_DATE_NAVBAR.endPickerIsOpen){
            var end_time = R_DATE_NAVBAR._getInternalTimeStr(false);
            R_DATE_NAVBAR.updateTimeEnd(end_time);
        }
    },
    beforeShowDay: function (date) {
        if (R_DATE_NAVBAR.repDates[date.format("yyyy-mm-dd")]) {
            return [true, ''];
        }
        return [false, ''];
    },
    beforeShowDayEnd: function (date) {
        var d = new Date(date);
        var start_time = $('#datepicker').datepicker('getDate');
        start_time.setHours(0, 0, 0);
        if (start_time > d) {
            return [false, ''];
        }
        if (R_DATE_NAVBAR.repDates[date.format("yyyy-mm-dd")]) {
            return [true, ''];
        }
        return [false, ''];
    },
    beforeShowStart: function (input, inst) {
        R_DATE_NAVBAR._beforeShowCommon(input, inst);
        R_DATE_NAVBAR.startPickerIsOpen = true;
    },
    beforeShowEnd: function(input, inst){
        R_DATE_NAVBAR._beforeShowCommon(input, inst);
        R_DATE_NAVBAR.endPickerIsOpen = true;
    },
    _beforeShowCommon: function(input, inst){
        var widget = $(inst).datepicker('widget');
        widget.css('font-size', '11px');
        widget.css('margin-left', ($(input).outerWidth() - widget.outerWidth()) / 2);
    },
    convertDateStr2GMT: function(dateStr){
        function f(n) {
            // Format integers to have at least two digits.
            return n < 10 ? '0' + n : n;
        }

        var newDate = R_DATE_NAVBAR.convertDate(dateStr);

        var gmtStr = newDate.getUTCFullYear() + '-' +
                     f(newDate.getUTCMonth() + 1) + '-' +
                     f(newDate.getUTCDate()) + ' ' +
                     f(newDate.getUTCHours()) + ':' +
                     f(newDate.getUTCMinutes()) + ':' +
                     f(newDate.getUTCSeconds());
       	return gmtStr;
    },
    initTimeZone: function () {
        if (date_nav_start_date != '') {
            if (parseInt(view_logs_for_specific_device_perm, 10) === 0 && parseInt(view_reports_for_specific_device_perm, 10) === 1) {
                var date_text = $("#date").val();
                var end_date_text = $("#end_date").val();
                date_text = $.getDateDisplay(date_text + " GMT", false, '');
                if (end_date_text.trim().length > 0) {
                    end_date_text = $.getDateDisplay(end_date_text + " GMT", false, '');
                    R_DATE_NAVBAR.setCurrentDate(date_text, end_date_text);
                } else {
                    R_DATE_NAVBAR.setCurrentDate(date_text);
                }
                return;
            } else {
                R_DATE_NAVBAR.getDailyReports();
                return;
            }
        }
        var d = new Date();
        d.setHours(0, 0, 0);
        var midnight_local = d.format("yyyy-mm-dd HH:MM:ss");
        $('#datepicker').datepicker("setDate", R_DATE_NAVBAR.convertDate(midnight_local));
        R_DATE_NAVBAR.setCurrentDate(midnight_local);
    },

    getAvailDates: function() {
        
        $.ajax({
            url: '/report/get_avail_dates?sn=' + R_DATE_NAVBAR.urlSn,
            method: 'GET',
            dataType: 'json',
            error: checkLoginPageRedirect,
            success: R_DATE_NAVBAR.onAvailDates
        });
    },
    onAvailDates: function (data) {
        for (var rep in data) {
            var localDate = $.getDateDisplay(rep);
            localDate = localDate.substring(0, localDate.indexOf(' '));
            R_DATE_NAVBAR.repDates[localDate] = true;
        }
        $("#datepicker").removeAttr('disabled');
        $("#datepicker_end").removeAttr('disabled');
    },

    setCurrentDate: function (starttime, endtime) {
        // Set the date on the server, must implement the getAllData function in each tab
        $("#date").val(starttime);

        var url = '/report/set_date?sn=' + R_DATE_NAVBAR.urlSn + '&date_text=' + R_DATE_NAVBAR.convertDateStr2GMT(starttime);
        if (endtime) {
            url += '&end_date_text=' + R_DATE_NAVBAR.convertDateStr2GMT(endtime);
        }
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: checkLoginPageRedirect,
            success: R_DATE_NAVBAR.dateSet
        });
    },
    dateSet: function (data) {

        // Call a click event on a hidden prop so the tabs can refresh when the date changes
        //$("#custom_datepicker_trigger").click();
        if( parseInt(view_logs_for_specific_device_perm, 10) === 0 &&  parseInt(view_reports_for_specific_device_perm, 10) === 1) {
            R_DATE_NAVBAR.createLogsSection(data);
        } else {
            R_DATE_NAVBAR.getDailyReports();
        }
    },

    createLogsSection: function(data) {
        var fragment = '';
        var html = '';
        var begin = '';
        var end = '';
        var thispage = window.location.pathname + window.location.search;

        fragment += '<ul class="nav nav-list">';
            var dashboard_urls = [
                                    { 'href': '', 'name': R_DATE_NAVBAR_LOGS },
                                    { 'href': '/log/device?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_LOGMANAGER },
                                    { 'href': '/log/search?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_LOGSEARCH }
            ];

            for (dashboard in dashboard_urls) {
                var href = dashboard_urls[dashboard].href;
                if (thispage.indexOf(href) == 0) {
                    $('#report_tabs a[href="#tabDashboard"]').tab("show");
                    classval = "active";
                }
                if (href == '') {
                    fragment += '<li class="nav-header">' + dashboard_urls[dashboard].name + '</li>'
                } else {
                    fragment += '<li class="' + classval + '"><a href="' + dashboard_urls[dashboard].href + '">' + dashboard_urls[dashboard].name + '</a></li>'
                }
                classval = '';
            }
        fragment += '</ul>';
        $("#todays_dashboard").html(fragment);

        R_DATE_NAVBAR.convertTimeAndDisplay(data);
        $("#custom_datepicker_trigger").click();
    },

    getDailyReports: function () {
        // Get the list of reports for the current date
        is_server_report = R_DATE_NAVBAR.pageIsServerReport()
        if (is_server_report == true){
            $.ajax({
                url: '/report/get_daily_reports?sn=' + R_DATE_NAVBAR.urlSn + "&server_reports=true",
                method: 'GET',
                dataType: 'json',
                error: checkLoginPageRedirect,
                success: R_DATE_NAVBAR.onDataDailyServerReports
            });
        } else {
            $.ajax({
                url: '/report/get_daily_reports?sn=' + R_DATE_NAVBAR.urlSn,
                method: 'GET',
                dataType: 'json',
                error: checkLoginPageRedirect,
                success: R_DATE_NAVBAR.onDataDailyReports
            });
        }
    },

    pageIsServerReport: function (){
        var is_server_report = false;
        var location = window.location.pathname;
        if (location === "/report/server" || location === "/log/server"){
            return true;
        }
        return is_server_report;
    },

    onDataDailyServerReports: function(data){
        // Handler for the list of today's server reports
        var report = '';
        var group = '';
        var fragment = '';
        var html = '';
        var begin = '';
        var end = '';
        $('#show_hide_reps').hide();
        var thispage = window.location.pathname + window.location.search;

        var server_urls = [
            { 'href': '', 'name': R_DATE_NAVBAR_LOGS },
            { 'href': '/log/server?sn=' + R_DATE_NAVBAR.urlSn + "&l_t=srv" + "&name=" + $.getUrlVar('name'), 'name': R_DATE_NAVBAR_LOGMANAGER },
        ];
        fragment = R_DATE_NAVBAR.getToolTabFragment(data, server_urls);
        $("#todays_dashboard").html(fragment);

        fragment = R_DATE_NAVBAR.getServerReportTabFragment(data);
        $('#todays_reports').html(fragment);

        R_DATE_NAVBAR.convertTimeAndDisplay(data);
        $("#todays_reports .group_name > a").addClass('change_color');
        $("#custom_datepicker_trigger").click();

        if (window.location.pathname === '/report/server') {
            $('#report_tabs a[href="#tabReports"]').tab("show");
            $('#show_hide_reps').hide();
        }
    },

    onDataDailyReports: function (data) {
        // Handler for the list of today's reports
        var report = '';
        var group = '';
        var fragment = '';
        var html = '';
        var begin = '';
        var end = '';

        var dashboard_urls = [
            { 'href': '', 'name': R_DATE_NAVBAR_DASHBOARDS },
            { 'href': '/dashboard/executive?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_EXECUTIVE },
            { 'href': '/dashboard/security?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_SECURITY },
            { 'href': '/dashboard/threatmap?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_THREATMAP },
            { 'href': '/dashboard/firewatch?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_FIREWATCH },
            { 'href': '/dashboard/flowmap?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_FLOWMAP },
            { 'href': '', 'name': R_DATE_NAVBAR_LOGS },
            { 'href': '/log/device?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_LOGMANAGER },
            { 'href': '/log/search?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_LOGSEARCH },
            { 'href': '', 'name': R_DATE_NAVBAR_REPORTS },
            { 'href': '/report/perclient?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_PERCLIENT_SUMMARY },
            { 'href': '/report/perclientdetail?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_PERCLIENT_DETAIL }
        ];

        fragment = R_DATE_NAVBAR.getToolTabFragment(data, dashboard_urls);
        $("#todays_dashboard").html(fragment);

        fragment = R_DATE_NAVBAR.getReportTabFragment(data);
        R_DATE_NAVBAR.convertTimeAndDisplay(data);

        $("#todays_reports").html(fragment);

        if (R_DATE_NAVBAR.active_div_id !== '') {
            $(R_DATE_NAVBAR.active_div_id).addClass("in");
        }

        $("#todays_reports .group_name > a").addClass('change_color');
        $("#custom_datepicker_trigger").click();
    },


    getToolTabFragment: function (data, dashboard_urls) {
        var thispage = window.location.pathname + window.location.search;

        fragment = '';
        fragment += '<ul class="nav nav-list">'
        if (data && data.length > 0 && data[0].reports.length > 0) {
            if (parseInt(sn_is_group, 10) === 1 || //Don't show logs sections for groups
               ((parseInt(repAndLogs_for_all_device_perm, 10) && parseInt(view_logs_for_specific_device_perm, 10)) === 1)) { //Or if user does not have permissions to view logs
                dashboard_urls.splice(6, 3);
            }

            for (dashboard in dashboard_urls) {
                var href = dashboard_urls[dashboard].href;
                if (thispage.indexOf(href) == 0) {
                    $('#report_tabs a[href="#tabDashboard"]').tab("show");
                    classval = "active";
                }
                if (href == '') {
                    fragment += '<li class="nav-header">' + dashboard_urls[dashboard].name + '</li>'
                } else {
                    fragment += '<li class="' + classval + '"><a href="' + dashboard_urls[dashboard].href + '">' + dashboard_urls[dashboard].name + '</a></li>'
                }
                classval = '';
            }
        }
        fragment += '</ul>';
        return fragment;
    },

    /* Check if the wrapper div has in class, indicating it's expanded
       If the number of divs that have the 'in' class is 0 then none of the
       report categories are expanded - Change text to read 'Expand All'
       If the number of divs that have the 'in' class is 7 then all of the
       report categories are expanded - Change text to read 'Collapse All'
    */
    trackHeaderState: function () {
        var count = $("#todays_reports ul div.in").length;
        if (count === 0) {
            $("#show_hide_reps").text(R_DATE_NAVBAR_EXPAND_TEXT);
        }
        else if (count === 7) {
            $("#show_hide_reps").text(R_DATE_NAVBAR_COLLAPSE_TEXT);
        }
    },
    toggleReportsHeader: function (event) {
        event.preventDefault();

        var toggle_text = $("#show_hide_reps").text();

        if(toggle_text === R_DATE_NAVBAR_COLLAPSE_TEXT) {
          $("#todays_reports ul div").removeClass("in").css("height", "0px");
        }
        else {
          $("#todays_reports ul div").addClass("in").css("height", "auto");
        }

        toggle_text = (toggle_text === R_DATE_NAVBAR_COLLAPSE_TEXT) ? R_DATE_NAVBAR_EXPAND_TEXT : R_DATE_NAVBAR_COLLAPSE_TEXT;
        $("#show_hide_reps").text(toggle_text);
    },

    getReportTabFragment: function(data) {
        var thispage = window.location.pathname + window.location.search;
        var classval = '';

        var fragment = '<ul class="nav nav-list">';
        if ( data[0].reports.length > 0) {
            $('#show_hide_reps').show();
        }
        else {
            $('#show_hide_reps').hide();
        }

        for (var i = 0; i < data.length; i++) {
            group = data[i];
            var d_target="#collapse"+i;
            fragment += '<li class="nav-header" style="cursor:pointer" ' +
                        'data-toggle="collapse" data-target=' + d_target +'>' +
                         group.name ;
            fragment += '</li>';

            var collapse = '<div id=' + "collapse" + i + ' class="collapse" style="display:block;">';
            fragment += collapse;
            for (var j = 0; j < group.reports.length; j++) {
                if (thispage == group.reports[j][1]) {
                    $('#report_tabs a[href="#tabReports"]').tab("show");
                    classval = "active";
                    R_DATE_NAVBAR.active_div_id = "#collapse" + i;
                }
                fragment += '<li class="' + classval + '"><a href="' + group.reports[j][1] + '">' + group.reports[j][0] + '</a></li>';
                classval = '';
            }
            fragment += '</div>';
        }
        fragment += '</ul>';
        return fragment;
    },

    getServerReportTabFragment: function(data) {
        //TODO refactor backend server_tabs method to work just like normal reports, then fold this into getReportTabFragment.
        var thispage = window.location.pathname + window.location.search;

        fragment = '<ul class="nav nav-list">';
        var display_report_link = false;
        for (var i = 0; i < data.length; i++) {
            group = data[i];
            fragment += '<li class="nav-header">' + group.name;
            fragment += '</li>';

            for (var j = 0; j < group.reports.length; j++) {
                display_report_link = true;
            }
        }
        if (display_report_link === true){
            var report_link_status = '';
            if (window.location.pathname === '/report/server'){
                report_link_status = "active";
            }
            fragment += '<li class="' + report_link_status +'"><a href="/report/server?sn=' + R_DATE_NAVBAR.urlSn + '">' + "Server Reports" + '</a></li>';
            fragment += '</ul>';
        }
        return fragment
    },

    convertTimeAndDisplay: function(data){
        // Convert start/end from UTC and display
        var begin_time = '';
        var end_time = '';
        var time_range = '';
        if (data.length > 0) {
            begin = data[0].data_begin_time;
            end = data[0].data_end_time;
            if (begin != '') {
                begin_time = $.getDateDisplay(begin, false, '');
                end_time = $.getDateDisplay(end, false, '');
                time_range = begin_time + ' &mdash; ' + end_time;
                var pickerDate = R_DATE_NAVBAR.convertDate(begin_time + ":00");
                if ($("#datepicker").val() == '') {
                    $('#datepicker').datepicker("setDate", pickerDate);
                }
            }
        }
        $("#reports_toolbar_start").html(begin_time + ' &mdash; ');
        $("#reports_toolbar_end").html(end_time);

        htmlDate = $("#end_date").val();
        if (htmlDate && htmlDate != '') {
            var pickerDate = R_DATE_NAVBAR.convertDate(end_time + ":00");
            if ($("#datepicker_end").val() == '') {
                $('#datepicker_end').datepicker("setDate", pickerDate);
            }
        }
        $("#mobile_date_navbar_daterange").html(time_range);
    },

    _getInternalTimeStr: function(getStartTime){
        // Used to get the current datetime set in the picker.
        // This is distinct from the reports_toolbar time, which is the time
        // the user has "set".
        var selector = getStartTime ? '#datepicker' : '#datepicker_end';
        var date_time = $(selector).datetimepicker('getDate');
        if (date_time != null){
            var date_time_fmt = date_time.format("yyyy-mm-dd HH:MM");
        } else{
            var date_time_fmt = '';
        }
        return date_time_fmt;
    },

    getStartEndIsoStr: function() {
        var start_dt = $("#reports_toolbar_start").text();
        var end_dt = $("#reports_toolbar_end").text();
        if (start_dt != '') {
            start_dt = start_dt.substring(0, start_dt.length - 2).trim(); //Remove the '-' from date at the end'
        }
        return [start_dt, end_dt];
    },

    getStartEndSeconds: function () {
        var startEnd = R_DATE_NAVBAR.getStartEndIsoStr();
        var start_dt = startEnd[0];
        var end_dt = startEnd[1];
        if (start_dt != '') {
            start_dt = $.getDateLocalToSecs(start_dt);
        }
        if (end_dt != '') {
            end_dt = $.getDateLocalToSecs(end_dt);
        }
        return [start_dt, end_dt];
    }

};
$(document).ready(R_DATE_NAVBAR.init);
