$(document).ready(function() {                      
    var urlSn = $.getUrlVar('sn');
    var date = $.getUrlVar('date');
    var id = $.getUrlVar('id');
    var period = $.getUrlVar('period');    
    var urlTz = $.getUrlVar('tz');     
    var repType = $.getUrlVar('reptype');    
    var htmlDate = $("#date").val();
    var htmlSn = $("#sn").val();      
    var htmlSearch = $("#search").val();
    var startTime = '';
    var endTime = '';
    var reportName = '';
    var portal_link = "http://www.watchguard.com/SecurityPortal/ThreatDetail.aspx?rule_id=";
    
    // Set the report type from the url              
    if(repType != null) {
        switch (repType) {
            case 'alarms':
                HELP_LINK_OVERRIDE = 7200;
                break;
            case 'denied_packets_detail':
                HELP_LINK_OVERRIDE = 7201;
                break;
            case 'denied_packets_client_detail':
                HELP_LINK_OVERRIDE = 7202;
                break;
            case 'pop3_proxy_detail':
                HELP_LINK_OVERRIDE = 7203;
                break;
             case 'smtp_proxy_detail':
                HELP_LINK_OVERRIDE = 7204;
                break;
            case 'web_audit_category':
                HELP_LINK_OVERRIDE = 7205;
                break;
            case 'web_audit_client':
                HELP_LINK_OVERRIDE = 7206;
                break;
             case 'web_blocker_client':
                HELP_LINK_OVERRIDE = 7207;
                break;
            case 'web_blocker_category':
                HELP_LINK_OVERRIDE = 7208;
                break;
            case 'dlp_detail':
                HELP_LINK_OVERRIDE = 7209;
                break;
            case 'ips_detail':
                HELP_LINK_OVERRIDE = 7210;
                break;
            case 'gav_detail':
                HELP_LINK_OVERRIDE = 7211;
                break;
            case 'apt_detail':
                HELP_LINK_OVERRIDE = 7212;
                break;
            case 'undetected_apt_detail':
                HELP_LINK_OVERRIDE = 7213;
                $('#page_label_id').attr("title", D_SUMMARY_EXECUTIVE_ZERO_DAY_APT);
                break;
        }
        $('#chart_select').val(repType);
    }
    
    if(period != null && period == 'custom'){
        $('#chart_select').hide();
    }

    customDetailReport();
    
    // Add handler for change the type of chart
    $("#chart_select").change(function () { getData(); });
    
    $("#custom_datepicker_trigger").bind('click', function() {
        // Listen fora click on this div, it means the date changed 
        // and a refresh is needed
        getData();
    });       

    $('#csv_link').click(function(){
        var startEnd = R_DATE_NAVBAR.getStartEndIsoStr();
        var startTime = R_DATE_NAVBAR.convertDateStr2GMT(startEnd[0] + ":00");
        var endTime = R_DATE_NAVBAR.convertDateStr2GMT(startEnd[1] + ":00");

        var reportType = $('#chart_select option:selected').val();

        $.ajax({
            url:"saveAsCsv?serial=" + htmlSn +  "&client_tz=" + WGRD.client_tz + "&start_time=" + startTime + "&end_time=" + endTime + "&report_type=" + reportType + "&search=" + htmlSearch,
            type: 'POST',
            contentType: 'application/json',
            success: function(data) {
                if(!data.status){
                    if(data.message){
                        alert(data.message);
                    }
                    return true;
                }
                window.location = "get_csv_file?serial=" + htmlSn;
                return false;
            }   
        });
    });

    function customDetailReport(){
        if(htmlSearch == '' || $("#chart_select").is(":visible"))
            return;

        var description = '';
        var linkSearch = unescape(htmlSearch);
        linkSearch = linkSearch.split('=');
        var link = linkSearch[0];
        
        if (repType == 'ips_detail') {
            if (link == 'threat') {
                description = ips_headers[link] + ': ' + threat_map[linkSearch[1]];
            }else{
                description = ips_headers[link] + ': ' + linkSearch[1];
            }
        }else if (repType == 'gav_detail') {
            description = gav_headers[link] + ': ' + linkSearch[1];
        }else if (repType == 'apt_detail' || repType == 'undetected_apt_detail') {
            description = apt_headers[link] + ': ' + linkSearch[1];
        }

        $('#link_search').text(description);
        $('#link_search').show();
    }

    // Get the report data and setup the grid with the response
    function getData(){
        var report_type = $('#chart_select option:selected').val(); 
        if (report_type == ''){
            return;
        }
        
        if(!id){
            id = '';
        }        
        
        showChartLoading('detail');
        
        var startEnd = R_DATE_NAVBAR.getStartEndSeconds();
        start_dt = startEnd[0];
        end_dt = startEnd[1];
        
        var jqxhr = $.ajax({
           url: 'get_detail_data?report_type=' + report_type + '&sn=' + htmlSn + '&start_time=' + start_dt + '&end_time=' + end_dt + '&div=detail&rep_id=' + id + "&period=" + period,
           method: 'GET',
           dataType: 'json',
           success: onSuccess,
           error: errorHandler
        });     
        return jqxhr;
    }     
    
    function onSuccess(series){
        // The column names and model are returned, once the grid is created it'll handle
        // the callbacks to retrieve the data
        preHandleDataGrid(series);
        
        // Store the column model so we can use it when modifying the date strings
        column_model = series.col_model;
        
        jQuery('#report_table').GridUnload('#report_table');
        createDataGrid(series.col_names, series.col_model);
        
        $("#report_table").jqGrid('setGridParam',{datatype:'json'}).trigger('reloadGrid');        
    }

    function preHandleDataGrid(series){
        var linkSearch = unescape(htmlSearch);

        if((repType == 'apt_detail' || repType == 'undetected_apt_detail') && linkSearch != ''){
            var link = linkSearch.split('=')[0];
            var i = 0;
            switch(link) {
                case 'threat_id':
                    for(i=0; i<series.col_model.length; i++){
                        if (series.col_model[i].name == 'threat_id'){
                            series.col_model[i].hidden = true;
                        }
                    }
                    break;
                case 'protocol':
                    for(i=0; i<series.col_model.length; i++){
                        if (series.col_model[i].name == 'protocol'){
                            series.col_model[i].hidden = true;
                        }
                    }
                    break;
                case 'threat_level':
                    for(i=0; i<series.col_model.length; i++){
                        if (series.col_model[i].name == 'threat_level'){
                            series.col_model[i].hidden = true;
                        }
                    }
                    break;
                case 'activity':
                case 'mime_type':
                case 'recipient_destination':
                case 'sender_source':
                    break;
            }
        }
    }
                 
    function createDataGrid(col_names, col_model){
        // IPS and GAV detail report.
        var search = false;
        var postData = {};
        if(htmlSearch !== ''){
            search = true;
            postData = {searchString: htmlSearch};
        }

        $("#report_table").jqGrid({
            url:'detail_report?sn=' + htmlSn,
            datatype: 'json',
            mtype: 'GET',
            colNames: col_names,
            colModel: col_model,
            autoencode: true,
            pager: '#pager',
            pagerpos: 'right',
            toppager: true,
            rowNum: 100,
            rowList:[25, 50, 75, 100],
            sortname: 'name',
            sortorder: 'desc',
            caption: '',
            height: 'auto',
            width: '750',
            loadui: 'block',
            autowidth: true,
            shrinkToFit: true,
            search: search,
            postData: postData,
        
            loadError: errorHandler,
            loadComplete: function (data) {
                // Update the timezone information
                var startTime = $.getDateDisplay(data.time_range_begin, true, urlTz);
                var endTime = $.getDateDisplay(data.time_range_end, true, urlTz);
                reportName = $('#chart_select option:selected').text();
                
                // Notify the date navbar the report range changed
                $('#report_range').trigger('reportRange', {start_time: startTime, 
                                                           end_time: endTime, 
                                                           name: reportName });
                
            }
        }).navGrid("#pager",{refresh:false,search:false,edit:false,add:false,del:false},{},{width:350},{});

        var reportType = $('#chart_select option:selected').val();
        if(reportType === "ips_detail"){
            $("#report_table").setColProp('more_info', { formatter: ipsLinkFormatter });
        }else if(reportType == "apt_detail" || reportType == 'undetected_apt_detail') {
            $("#report_table").setColProp('more_info', { formatter: aptLinkFormatter });
        }
    }

    function ipsLinkFormatter(elem, cellval, opts){
        if(cellval.colModel.name === 'more_info'){
            return "<a href='" + portal_link + opts[11] +"' class='detailviewLinks' target='ipsportal'>" + elem + "</a>";
        }
    }

    function aptLinkFormatter(elem, cellval, opts){
        if(cellval.colModel.name === 'more_info'){
            return "<a href='' id='" + opts[3] + "' class='detaildialog detailviewLinks' >"+ elem + "</a>";
        }
    }

    $(window).bind('resizeEnd', function() {
        var grid = "#report_table";
        var parent = "#grid_data";
        var grid_width = resizegrid();
        $("#webui_content").width(grid_width);
        $(grid).setGridWidth(100, true); 
        $(grid).setGridWidth($(parent).width(), true);
    });             
   
    $(document).on('click', '.detaildialog', S_APT_DETAIL.showDetailsDialog);
});
