$(document).ready(function() {
    var div = "#grid_entities";    
    jQuery(div).GridUnload(div);

    var colNames = ['Name', 'Serial Number', 'IP Address', 'Type'];

    var colModel = [
                { name: 'appliance_name', index: 'appliance_name', sortable: true, width: 170, 
                    sorttype: function(cellvalue) {
                        if (cellvalue.indexOf('<span class=') >= 0
                            && cellvalue.indexOf('&nbsp;') > 0) {
                            cellvalue = cellvalue.substring(cellvalue.indexOf('&nbsp;')+6);
                        }
                        return cellvalue.toLowerCase();
                    }
                },
                {name:'serial', index:'sn', sorttype:"text", sortable: true, width: 150},
                {name:'ip', index:'ip_address', sorttype:"text", sortable: true, width: 120},
                {name:'type_name', index:'type_name', sorttype:"text", sortable: true, width: 150}];

    var optParams = {
        url:'report_devices',
        datatype: 'json',
        mtype: 'GET',
        rowNum: -1,            
        altRows: true,
        altclass: 'gridAltRow',
        sortname: 'appliance_name',
        sortorder: 'asc',
        treeGrid: true,
        treeGridModel: 'adjacency',
        treeIcons: {plus: 'ui-icon-plus', minus: 'ui-icon-minus'}, 
        ExpandColumn: 'appliance_name',
        ExpandColClick: false,
        caption: '',
        height: 'auto',
        width: '800',
    
        loadError: errorHandler,
        loadComplete: function (data) {
            if(data === null) {
                $('#error_msg').show();
                $('#report_devices').hide();
            }
            $('.tree-leaf', $(this)).css('width', '0px');
        },
        onCellSelect: function(rowid, iRow, iCol, e){
            var sn = $("#grid_entities").jqGrid('getCell',rowid,'serial');
            window.location="dashboard?sn="+sn;            
        }
    };
    createRsGrid(colNames, colModel, div, optParams);
    $(div).navGrid("#pager",{refresh:false,search:false,edit:false,add:false,del:false},{},{width:350},{});

    function resizeGrids() {
        for (var plot in report_plots) {
            if (plot) {
                report_plots[plot].replot();
            }
        }

        resizeGrid('#grid_entities', "#current_grid");
    }

    $("#searchBox").focus(function() {
        if ($(this).val() == "Search") {
            $(this).val(''); 
        }
    });

    $(function() {
        $("#btn_action").button({
            icons: { 
                secondary: "ui-icon-triangle-1-s" 
            }
        });
    });

    $(".frontpanelUnitHeader select").each(function () {
        // Hide select's with a single item
        var i = 0;
        if (this.options.length < 2) {
            $(this).hide();
        }
    });
    $(window).bind('resizeEnd', function() {
        resizeGrids();
    })
    showChartLoading("chart");
});

function convertDate(dateStr){
    dateParts = dateStr.match(/(\d+)/g)
    newDate = new Date(dateParts[0], dateParts[1] - 1, dateParts[2]);  

    return newDate        
}

function convertDateTime(dateStr, timeStr){
    dateParts = dateStr.match(/(\d+)/g)
    timeParts = timeStr.split(":");    
    newDate = new Date(dateParts[0], (dateParts[1] - 1) ,dateParts[2], timeParts[0], timeParts[1], timeParts[2]);    

    return newDate        
}


// Get Chart Data function.  
// Parameters: divName - the prefix of the graph/loading/empty divs
//             sn - serial number of the device
//             showLabels - (optional) adds axis labels to the charts
// Returns: a jQuery XmlHttpRequest object which can be used to attach 
// additional 'success' functionality. 
// For example: var jqxhr = getChartData('foo', '123456');
//              jqxhr.success(someDataHanderFn);
function getChartData(divName, sn, showLabels, id){
    var urlPeriod = $.getUrlVar('period');
    var period = '1d';
    if (urlPeriod) {
        period = urlPeriod;
    }

    var report_type = $('#' + divName + '_select option:selected').val();
    if (divName.indexOf('px_') === 0 || divName.indexOf('pf_') === 0) {
        report_type = divName;
        divName = 'chart';
    }
    success = onData;
    
    if(showLabels){
        success = onDataLabels;
    }

    if (report_type === 'web_traffic_summary') {
        success = onDataMultipleCharts;
    }
    if(!id){
        id = '';
    }
    
    showChartLoading(divName);
    var start_dt =  $("#reports_toolbar_start").text();
    var end_dt =  $("#reports_toolbar_end").text();
    if(start_dt != '') {
        start_dt = start_dt.substring(0,start_dt.length - 2).trim(); //Remove the '-' from date at the end'
        start_dt = $.getDateLocalToSecs(start_dt);
    }
    if(end_dt !='') {
        end_dt=$.getDateLocalToSecs(end_dt);
    }
    var jqxhr = $.ajax({
        url: 'get_data?report_type=' + report_type + '&sn=' + sn + '&start_time=' + start_dt + '&end_time=' + end_dt + '&div=' + divName + '&id=' + id + '&period=' + period,
        method: 'GET',
        dataType: 'json',
        success: success,
        error: errorHandler
    });     
    return jqxhr;
} 

function errorHandler(jqxhr, status, error){
    if (error.toString().indexOf('Upgrade_0x1F8') > 0) {
        window.location.href = '/report/upgrade';
    }
    if (!checkLoginPageRedirect(jqxhr, status, error)) {
        //alert(status);
    }
}
function onData(series){
    onDataReceived(series, false)
}
function onDataLabels(series){
    onDataReceived(series, true)
}

function onDataMultipleCharts(series) {
    if(series.count > 0) {
        if (series.web_traffic_hits.count > 0) {
            bar_options.title = series.web_traffic_hits.label[0];
            bar_options.axes.xaxis.showLabel = false;
            showChart('web_traffic_hits');
            plotChart(series.web_traffic_hits, 'web_traffic_hits', true);
        }else{
            showChartEmpty('web_traffic_hits');
        }

        if (series.web_traffic_category.count > 0) {
            pie_options.title = series.web_traffic_category.label[0];
            showChart('web_traffic_category');
            plotChart(series.web_traffic_category, 'web_traffic_category', true);
        }else{
            showChartEmpty('web_traffic_category');
        }

    }else{
        showChartEmpty('web_traffic_hits');
        showChartEmpty('web_traffic_category');
        showChartEmpty(series.div);
    }
}

function onDataReceived(series, showLabels){
    if(series.count > 0){
        showChart(series.div);
        plotChart(series, series.div, showLabels);
    }else{
        showChartEmpty(series.div);
    }        
}

function updateChartTimes(series) {
    var urlTz = $.getUrlVar('tz');
    for (var j=0; j < series.data.length; j++){
        // Check both chart plots and look for a date
        for (var i=0; i < series.data[j].length; i++){
            if(String(series.data[j][i][0]).match(/ GMT$/)){
                series.data[j][i][0] = $.getDateDisplay(series.data[j][i][0], true, urlTz);
            }else{
                break;
            }
        }
        for (var i=0; i < series.data[j].length; i++){
            if(String(series.data[j][i][1]).match(/ GMT$/)){            
                series.data[j][i][1] = $.getDateDisplay(series.data[j][i][1], true, urlTz);
            }else{
                break;
            }
        }
    }

}

var report_plots = {};
function plotChart(series, graph, showLabels) {

    updateChartTimes(series);

    var graphDiv = graph + '_graph';
    var tableDiv = '#' + graph + '_table';
    if (report_plots && report_plots[graphDiv] != null) {
        $('#' + graphDiv + ' *').unbind(); // iexplore?
        report_plots[graphDiv].destroy();
    }

    // If series has no data, $.jqplot() raises an error 'Uncaught Error: No data specified'.
    if (series.count == 0)
        return;

    if (series.chart_type == 'bar') {
        bar_options.axes.xaxis.ticks = series.ticks;
        if(Math.max.apply(Math, series.ticks) < 5) {
            bar_options.axes.xaxis.tickOptions.formatString = '%.2f';
        }
        bar_options.series[0].label = series.legend[0];
        bar_options.axes.yaxis.ticks = series.cat_ticks;
        if(showLabels){
            bar_options.axes.xaxis.label = series.label[0]; // only for single report pages
            bar_options.axes.yaxis.label = series.label[1]; 
        }
        plot_trend = $.jqplot(graphDiv, series.data, bar_options);
    }else if(series.chart_type == 'bar_bar'){
        bar_bar_options.axes.xaxis.ticks = series.ticks;

        if(Math.max.apply(Math, series.ticks) < 5) {
            bar_bar_options.axes.xaxis.tickOptions.formatString = '%.2f';
        }
        if (series.data.length > 1){ // Stop small x2 tick vals from displaying with insufficent precision.
            var max = 0;
            for (var i=0; i<series.data[1].length; i++){
                x_value = series.data[1][i][0];
                if (x_value > max){
                    max = x_value;
                }
            }
            if (max < 5) {
                bar_bar_options.axes.x2axis.tickOptions.formatString = '%.2f';
            }
        }
        bar_bar_options.series[0].label = series.legend[0];    
        bar_bar_options.series[1].label = series.legend[1];                    
        bar_bar_options.axes.yaxis.ticks = series.cat_ticks;        
        if(showLabels){
            bar_bar_options.axes.xaxis.label = series.label[0];
            bar_bar_options.axes.x2axis.label = series.label[1];
            bar_bar_options.axes.yaxis.label = series.label[2];
        }
        plot_trend = $.jqplot(graphDiv, series.data, bar_bar_options);
    }else if(series.chart_type == 'line'){
        line_options.axes.yaxis.ticks = series.ticks;
        if(Math.max.apply(Math, series.ticks) < 5) {
        	line_options.axes.yaxis.tickOptions.formatString = '%.2f';
        }
        line_options.series[0].label = series.legend[0];        
        if(showLabels){        
            line_options.axes.yaxis.label = series.label[0];  // only for single report pages
        }
        plot_trend = $.jqplot(graphDiv, series.data, line_options);
    }else if(series.chart_type == 'bar_line'){
        bar_line_options.axes.yaxis.ticks = series.ticks;
        if(Math.max.apply(Math, series.ticks) < 5) {
        	bar_line_options.axes.yaxis.tickOptions.formatString = '%.2f';
        }
        bar_line_options.series[0].label = series.legend[0];
        bar_line_options.series[1].label = series.legend[1];
        if(showLabels){
            bar_line_options.axes.yaxis.label = series.label[0];  // only for single report pages
            bar_line_options.axes.y2axis.label = series.label[1];
        }
        plot_trend = $.jqplot(graphDiv, series.data, bar_line_options);
    } else if (series.chart_type == 'pie') {
        plot_trend = $.jqplot(graphDiv, series.data, pie_options);
    } else if (series.chart_type == 'pie_experimental') {
        var data = null;
        var newdata = [];
        var tick = '';
        var pieslices = (series.data[0].length < 7) ? series.data[0].length : 7;
        for (var i = pieslices - 1; i >= 0; i--) {
            data = series.data[0][i];
            tick = series.cat_ticks[series.cat_ticks.length - pieslices + i];
            newdata.push([tick, data[0]]);
        }
        series.data = [];
        series.data[0] = newdata;
        pie_options.title = {};
        pie_options.title.text = series.legend[0];
        var allcolors = $.get_hsl_colors(20);
        colors = allcolors[0];
        colors = colors.concat(allcolors[2]);
        colors = colors.concat(allcolors[4]);
        colors = colors.sort(function () { return 0.5 - Math.random() });
        pie_options.seriesDefaults.seriesColors = colors;
        plot_trend = $.jqplot(graphDiv, series.data, pie_options);
    }else if(series.chart_type == 'table'){
        // This is a grid of data
        var opt_params = {
            sortname: series.grid_sort.sortname,
            sortorder: series.grid_sort.sortorder
        };
		
        jQuery(tableDiv).GridUnload(tableDiv);
        createRsGrid(series.small_col_names, series.small_col_model, tableDiv, opt_params);
        
        // Only show the top 10 here
        var cnt = Math.min(10, series.grid_data.length);
        for(var i=0;i<cnt;i++) {
            $(tableDiv).jqGrid('addRowData',i+1,series.grid_data[i]);
        }            
        $(tableDiv).setGridParam({rowNum:i});
    }else if(series.chart_type == 'bar_date'){       
        var period = $.getUrlVar('period');
  
        for(var i=0;i<series.legend.length;i++) {
            bar_date_options.series[i].label = series.legend[i];
        }
        
        if(showLabels){
            bar_date_options.axes.y2axis.label = series.label[0];
            bar_date_options.axes.yaxis.label = series.label[1];
            bar_date_options.axes.xaxis.label = series.label[2];
        }
        bar_date_options.axes.yaxis.ticks = series.ticks;        
        if(Math.max.apply(Math, series.ticks) < 5) {
            bar_date_options.axes.yaxis.tickOptions.formatString = '%.2f';
        }
        var latest = $.getDateLocalToSecs(series.latest_record);
        var earliest = $.getDateLocalToSecs(series.earliest_record);
        var timespan = latest - earliest;
        var startTime = $.getDateDisplay(series.earliest_record, true);
        var endTime = $.getDateDisplay(series.latest_record, true);
        bar_date_options.axes.xaxis.min = startTime;
        bar_date_options.axes.xaxis.max = endTime;
        
        if(timespan > 86400){
            /* If the time span is bigger than one day, use the MM-DD HH:MM format */
            bar_date_options.axes.xaxis.tickOptions.formatString = '%m-%d %H:%M';
        }else{
            /* If the period is one day, use the HH:MM format */        
            bar_date_options.axes.xaxis.tickOptions.formatString = '%H:%M';
        }
        plot_trend = $.jqplot(graphDiv, series.data, bar_date_options);
    }else if(series.chart_type == 'line_date'){       
        var period = $.getUrlVar('period');
  
        for(var i=0;i<series.legend.length;i++) {
            line_date_options.series[i].label = series.legend[i];
        }
        
        if(showLabels){
            line_date_options.axes.y2axis.label = series.label[0];
            line_date_options.axes.yaxis.label = series.label[1];
        }
        line_date_options.axes.yaxis.ticks = series.ticks;        
        if(Math.max.apply(Math, series.ticks) < 5) {
            line_date_options.axes.yaxis.tickOptions.formatString = '%.2f';
        }
        line_date_options.axes.y2axis.ticks = series.cat_ticks;        
        if(Math.max.apply(Math, series.cat_ticks) < 5) {
            line_date_options.axes.y2axis.tickOptions.formatString = '%.2f';
        }
        var latest = $.getDateLocalToSecs(series.latest_record);
        var earliest = $.getDateLocalToSecs(series.earliest_record);
        var timespan = latest - earliest;
        var startTime = $.getDateDisplay(series.earliest_record, true);
        var endTime = $.getDateDisplay(series.latest_record, true);
        line_date_options.axes.xaxis.min = startTime;
        line_date_options.axes.xaxis.max = endTime;
        
        if(timespan > 86400){
            /* If the time span is bigger than one day, use the MM-DD HH:MM format */
            line_date_options.axes.xaxis.tickOptions.formatString = '%m-%d %H:%M';
        }else{
            /* If the period is one day, use the HH:MM format */        
            line_date_options.axes.xaxis.tickOptions.formatString = '%H:%M';
        }
        plot_trend = $.jqplot(graphDiv, series.data, line_date_options);
    }else {
        var period = $.getUrlVar('period');
  
        for(var i=0;i<series.legend.length;i++) {
            date_options.series[i].label = series.legend[i];
        }
        
        if(showLabels){
            date_options.axes.xaxis.label = series.label[0];
            date_options.axes.yaxis.label = series.label[1];
        }
        date_options.axes.yaxis.ticks = series.ticks;        
        if(Math.max.apply(Math, series.ticks) < 5) {
            date_options.axes.yaxis.tickOptions.formatString = '%.2f';
        }
        var latest = $.getDateLocalToSecs(series.latest_record);
        var earliest = $.getDateLocalToSecs(series.earliest_record);
        var timespan = latest - earliest;
        var startTime = $.getDateDisplay(series.earliest_record, true);
        var endTime = $.getDateDisplay(series.latest_record, true);
        date_options.axes.xaxis.min = startTime;
        date_options.axes.xaxis.max = endTime;
        
        if(timespan > 86400){
            /* If the time span is bigger than one day, use the MM-DD HH:MM format */
            date_options.axes.xaxis.tickOptions.formatString = '%m-%d %H:%M';
        }else{
            /* If the period is one day, use the HH:MM format */        
            date_options.axes.xaxis.tickOptions.formatString = '%H:%M';
        }
        plot_trend = $.jqplot(graphDiv, series.data, date_options);
    }
    if(series.chart_type != 'table'){
       plot_trend.replot();
       report_plots[graphDiv] = plot_trend;
   }
}

// Report DataGrid
function createGrid(grid_area, colNames, colModel){
    $(grid_area).jqGrid({ 
        datatype: "local", 
        colNames:colNames,
        colModel:colModel,
        autoencode: true,
        rowNum: -1,            
        height:'auto',
        autowidth: true,
        shrinkToFit: true
    });       
}    

/* Function to look through series.grid_data for fields with sorttype = date
 * and to convert them to the local display time if necessary.
 */ 
function updateTimezones(data, col_model){
    var urlTz = $.getUrlVar('tz');
    
    for (var i=0; i < col_model.length; i++){
        if(col_model[i].formatter == 'dateFormatter'){
            var col = col_model[i].name;
            
            for (var j=0; j < data.length; j++){
                if(data[j][col].length < 10){
                    // Assume we don't have a valid date, something like "  GMT"
                    data[j][col] = "";
                }else{
                    data[j][col] = $.getDateDisplay(data[j][col], true, urlTz);
                }
            }
        }
    }
    return data;
}

function updateUserTimezones(data, col_model){
    var urlTz = $.getUrlVar('tz');
    
    for (var i=0; i < col_model.length; i++){
        if(col_model[i].formatter == 'dateFormatter'){
            var col = col_model[i].name;
            
            for (var idx in data){
            	var item = data[idx];
            	for (var j=0; j < item.length; j++){
                	if(item[j][col].length < 10){
                    	// Assume we don't have a valid date, something like "  GMT"
                    	item[j][col] = "";
                	}else{
                    	item[j][col] = $.getDateDisplay(item[j][col], true, urlTz);
                	}
            	}
            }
        }
    }
    return data;
}

// Function to show/hide graphs and their loading icons 
function showChartLoading(divName){
    $('#' + divName + '_loading').show();        
    $('#' + divName + '_graph').hide();
    $('#' + divName + '_empty').hide();            
}
function showChart(divName){
    $('#' + divName + '_loading').hide();
    $('#' + divName + '_graph').show();            
    $('#' + divName + '_empty').hide();        
}
function showChartEmpty(divName){
    $('#' + divName + '_loading').hide();
    $('#' + divName + '_graph').hide();            
    $('#' + divName + '_empty').show();
} 

function showBranch(branch){    
    if( $('#' + branch).is(':hidden') == false){
        $('#id' + branch).attr("src", '/images/Show_16.png');
    }else{
        $('#id' + branch).attr("src", '/images/Hide_16.png');
    }

    $('#' + branch).slideToggle();
}



