var R_SCH_REP = {

    panes : ['gen', 'device', 'target', 'report'],
    active_pane : '',

    backButton :'',
    nextButton : '',
    closeButton : '',
    saveButton : '',

    mode : '',
    is_rbEnabled : false,

    // setup the page
    init : function () {

        if(error === 1) {
            $('#error_msg').show();
            $('#rep_schedule_div').hide();
            return;
        }
        R_SCH_REP.initData();
        R_SCH_REP.initUI();
        R_SCH_REP.initEvents();
    },

    initData : function () {
        // data values are shown in html elements, so they need to be escaped before being displayed
        // we escape the data here and store them escaped at the client
        // data sent to the server must not be escaped
        // the javascript logic must consider whether a value is escaped or unescaped when working with it

        for (var i=0, len=active_schedule_list.length; i < len; i++) {
            active_schedule_list[i].schedule_name = escapeHtml(active_schedule_list[i].schedule_name);
            active_schedule_list[i].schedule_desc = escapeHtml(active_schedule_list[i].schedule_desc);
            active_schedule_list[i].connectwise_active_id = escapeHtml(active_schedule_list[i].connectwise_active_id);
            active_schedule_list[i].file_location = escapeHtml(active_schedule_list[i].file_location);
        }

        for (var i=0, len=ftp_servers_list.length; i < len; i++) {
            ftp_servers_list[i].server_name = escapeHtml(ftp_servers_list[i].server_name);
            ftp_servers_list[i].upload_location = escapeHtml(ftp_servers_list[i].upload_location);
        }
    },

    // initialize UI elements
    initUI : function () {
        $('#error_container').hide();

        //Report Schedules
        R_SCH_REP.createReportScheduleGrid();
        R_SCH_REP.populateCustomizationList();
        R_SCH_REP.populateFtpServerList();

        WGRD.enableUIElements(false, ['#edit_schedule', '#remove_schedule']);
        //Initialize Schedule wizard
        R_SCH_REP.initScheduleUI();
        R_SCH_REP.initUserModeUI();
    },

    initUserModeUI : function () {
        var ids = ['#add_schedule', '#remove_schedule'];
        S_USER_MODE.initUI(ids);

        if (is_page_locked === 1) {
            $('#edit_schedule').val(S_VIEW_TEXT);
        } else {
            $('#edit_schedule').val(S_EDIT_TEXT);
        }
    },

    initScheduleUI : function() {
        var footer = $('#manage_schedule_dlg').find('.wizard-modal-footer');
        R_SCH_REP.backButton = $(footer).find('.wizard-back');
        R_SCH_REP.nextButton = $(footer).find('.wizard-next');
        R_SCH_REP.closeButton = $(footer).find('.wizard-close');
        R_SCH_REP.saveButton = $(footer).find('.wizard-save');
    },

    // add event handlers
    initEvents : function () {
        //Schedules
        $('#add_schedule').on('click', R_SCH_REP.showScheduleModal);
        $('#edit_schedule').on('click', R_SCH_REP.showScheduleModal);
        $('#remove_schedule').on('click', R_SCH_REP.removeSchedule);

        $(window).bind('resizeEnd', function() {
            R_SCH_REP.resizeGrids();
        });

        $('#confirm_save_btn').click(function(event) {
            $('#confirm_dlg').modal("hide");
            R_SCH_REP.deleteSchedule();
        });

        R_SCH_REP.initScheduleWizardEvent();

        //User mode changes
        S_USER_MODE.initEvents();
    },

    //------------------------------------------------------- REPORT SCHEDULE RELATED UI BEGINS HERE ------------------------------------- //
    initScheduleWizardEvent : function() {

        //Events for buttons on the wizard, next/back are visible when adding a schedule
        $(R_SCH_REP.nextButton).on('click', R_SCH_REP.nextButtonAction);
        $(R_SCH_REP.backButton).on('click', R_SCH_REP.backButtonAction);

        //Close and save are visible when editing a schedule
        $(R_SCH_REP.closeButton).on('click', R_SCH_REP.closeScheduleDialog);
        $(R_SCH_REP.saveButton).on('click', R_SCH_REP.updateSchedule);

        //Device div, init radio events
        $('#radio_devices').change(R_SCH_REP.showDevicesOrServers);
        $('#radio_servers').change(R_SCH_REP.showDevicesOrServers);

        //Device div, init select events
        $('#select_device_types').on('change', R_SCH_REP.toggleDeviceType);

        //Device div, init add/remove resources event
        $('#add_resource').on('click', R_SCH_REP.showSpecificDevicesModal);
        $('#rem_resource').on('click', R_SCH_REP.removeSpecificDevices);

        $('#copy_device').on('click', R_SCH_REP.copyDevices);
        $('#del_device').on('click', R_SCH_REP.delDevices);

        //specify_device_div, init event to save the add device/server dialog
        $('#specify_device_save').on('click', R_SCH_REP.saveSpecificDevices);
        $('#specify_device_close').on('click', R_SCH_REP.closeSpecificDevices);

        $('#device_server_name').on('keyup', R_SCH_REP.deviceSearchEvent);

        //Init Target div events
        $('#email').on('click', R_SCH_REP.showRepTypBasedOnTargets);
        $('#file').on('click', R_SCH_REP.toggleFileChkbox);
        $('#connectwise').on('click', R_SCH_REP.toggleCWChkbox);
        $('#email_adv').on('click', R_SCH_REP.showHideAdvSettings);
        $('#ftp_servers_list').on('change', R_SCH_REP.ftpServerAction);
        $('#file_select').on('change', R_SCH_REP.showFTPOrRemoteLocation);

        $('#add_schedule_email').on('click', R_SCH_REP.addEmail);
        $('#remove_schedule_email').on('click', R_SCH_REP.removeEmail);

        //Init report div events
        $('#add_report').on('click', R_SCH_REP.addReports);
        $('#rem_report').on('click', R_SCH_REP.removeReports);
        $('#specific_rep_type').on('change', R_SCH_REP.handleRepTypeChangeEvent);
        $('#rep_type').on('change', R_SCH_REP.toggleReportType);
        $('#copy_rep_right').on('click', R_SCH_REP.copyReports);
        $('#del_rep').on('click', R_SCH_REP.delReports);

        $('#rep_tz').on('change', R_SCH_REP.runReportAction);
        $('#run_schedule').on('change', R_SCH_REP.runReportAction);

        //specify_reports_div, init event to close the add reports dialog
        $('#specify_rep_close').on('click', R_SCH_REP.closeSpecificReports);

        //specify_device_div, init event to save the add reports dialog
        $('#specify_rep_save').on('click', R_SCH_REP.saveSpecificReports);

        $("#manage_schedule_dlg").find('.wizard-steps').on('click', 'li.already-visited a.wizard-nav-link', $('#manage_schedule_dlg'),
            function(event) {
                var currentActiveNav = '#' + R_SCH_REP.active_pane + '_li';
                var currentActiveDiv = '#' + R_SCH_REP.active_pane + '_div';

                //Validate before going to the next pane
                if(!R_SCH_REP.validateCurrentPane()) {
                    return;
                }

                var index = $(event.target).data('navindex');
                var newActiveNav = '#' + index + '_li';
                var newActiveDiv = '#' + index + '_div';

                R_SCH_REP.active_pane = index;
                $(currentActiveNav).removeClass('active');
                $(currentActiveDiv).hide();
                $(newActiveNav).addClass('active');
                $(newActiveDiv).show();
                R_SCH_REP.prevNextButtonTextState();
            });
    },

    showDevicesOrServers : function () {
        var device_checked = $('#radio_devices').prop('checked');
        if (device_checked) {
            $('#select_device_types option[value=0]').text(S_ALL_DEVICES_TEXT);
            $('#select_device_types option[value=1]').text(S_SPECIFY_DEV_TEXT);
            R_SCH_REP.hideShowConnectWise(true);
            if(cw_id_list.length !== 0) {
                $('#connectwise').prop("disabled", false);
            } else {
                $('#connectwise').prop("disabled", true);
            }
            $('#rep_aggr').prop('disabled', false);
        } else {
            $('#select_device_types option[value=0]').text(S_ALL_SERVERS_TEXT);
            $('#select_device_types option[value=1]').text(S_SPECIFY_SERVERS_TEXT);
            R_SCH_REP.hideShowConnectWise(false);
            $('#rep_aggr').prop('disabled', true)
                          .prop("selectedIndex", 0);
        }

        R_SCH_REP.toggleCWChkbox();
        $('#active_resources').empty();
        $('#select_device_types').prop('selectedIndex', 0);
        R_SCH_REP.toggleDeviceType();
    },

    showFTPOrRemoteLocation : function() {
        var selected_val = $('#file_select option:selected').val();
        if (selected_val === 'ftp') {
            $('#file_location_div').show();
            $('#rb_location_div').hide();
            $('#file_help').prop('title', FTP_HELP);
        } else {
            $('#file_location_div').hide();
            $('#rb_location_div').show();
            $('#file_help').prop('title', REMOTE_HELP);
        }
    },

    removeSpecificDevices : function(event) {
        event.preventDefault();
        $('#active_resources option:selected').remove();
    },

    closeSpecificDevices : function() {
        $('#specify_device_div').hide();
        $('#main_sch_div').show();
    },

    saveSpecificDevices : function() {

        var active_device_length = $('#active_devices_servers option').length;
        if(active_device_length !== 0) {
            $('#active_resources').empty();
            $('#active_resources')
                .append($('#active_devices_servers option')
                .clone()
                .children()
                .end());
        }
        R_SCH_REP.closeSpecificDevices();
    },

    closeSpecificReports : function() {
        $('#specify_reports_div').hide();
        $('#main_sch_div').show();
    },

    saveSpecificReports : function() {

        var active_rep_length = $('#active_rep_type option').length;
        if(active_rep_length !== 0) {
            $('#specify_rep_select').empty();
            $('#specify_rep_select')
                .append($('#active_rep_type optgroup')
                .clone()
                .children('option')
                .end());
        }
        R_SCH_REP.closeSpecificReports();
    },

    copyDevices : function(event) {
        event.preventDefault();
        var selected_items = $('#filtered_devices_servers option:selected');
        $.each(selected_items, function(index, value) {
            var device_id = value.value;
            var title = value.text;
            if($('#active_devices_servers option[value ='+ device_id +']').length === 0) {
                $('#active_devices_servers').append('<option value='+ device_id + ' title="'+ title +'">' + title + '</option>');
            }
        });
    },

    delDevices : function(event) {
        event.preventDefault();
        $('#active_devices_servers option:selected').remove();
    },

    copyReports : function(event) {
        event.preventDefault();

        //first find the category the current available reports belong to
        var current_category_id = $('#specific_rep_type option:selected').val();
        var current_category_text = $('#specific_rep_type option:selected').text();

        var selected_items = $('#filtered_rep_type').val();
        if($('#active_rep_type optgroup[id ='+ current_category_id +']').length === 0) {
            $('#active_rep_type').append('<optgroup id="'+ current_category_id +'" label="' + current_category_text + '"></optgroup>');
        }

        $.each(selected_items, function(index, value) {
            var title = $('#filtered_rep_type option[value=' + value + ']').text();
            if($('#active_rep_type option[value ='+ value +']').length === 0) {
                $('#active_rep_type optgroup[id=' + current_category_id +']').append('<option value='+ value + ' title="'+ title +'">' + title + '</option>');
            }
        });
    },

    delReports : function(event) {
        event.preventDefault();
        $('#active_rep_type option:selected').remove();
        $('#active_rep_type optgroup:empty').remove();
    },

    toggleReportType : function() {
        var index = $('#rep_type')[0].selectedIndex;
        if (index === 1) {
            $('#specify_rep_div').show();
        } else {
            $('#specify_rep_div').hide();
        }
    },

    handleRepTypeChangeEvent : function() {

        $('#filtered_rep_type').empty();
        var index = $('#specific_rep_type option:selected')[0];
        if(index.value === 'cw') {
            var sub_rep_list = cw_reports_list[0]['sub_reports'];
            $.each(sub_rep_list, function(index, value) {
                var id = value['id'];
                var title = value['title'];
                $('#filtered_rep_type').append('<option value='+ id + ' title="'+ title +'">' + title + '</option>');
            });
        } else {
            var sub_rep = $(index).data('sub_rep');
            $.each(sub_rep, function(index, rep) {
                var id = rep['id'];
                var title = rep['title'];
                $('#filtered_rep_type').append('<option value='+ id + ' title="'+ title +'">' + title + '</option>');
            });
        }
    },

    showSpecificDevicesModal : function(event) {
        event.preventDefault();
        $('#device_server_name').val("");

        $('#active_devices_servers').empty();

        $('#active_devices_servers')
            .append($('#active_resources option')
            .clone()
            .children()
            .end());

        var title = S_SEL_DEVICES_TITLE;
        var device_info_text = S_DEVICE_INFO_TEXT;
        var device_checked = $('#radio_devices').prop('checked');

        if(!device_checked) {
            title = S_SEL_SERVERS_TITLE;
            device_info_text = S_SERVER_INFO_TEXT;
        }
        $('#active_resources').empty();

        R_SCH_REP.populate_device_server_select();
        $('#specify_device_div')
                               .show()
                               .find('h3').text(title);
        $('#dev_serv_info').html(device_info_text);
        $('#main_sch_div').hide();
    },

    _add_reports : function(report_list) {
        $.each(report_list, function(index, report) {
            var id = report.id;
            var title = report.title;
            var sub_rep = report.sub_reports;
            $('#specific_rep_type').append('<option id=' + id + ' value='+ id +'>' + title + '</option>');
            $('#'+ id).data('sub_rep', sub_rep);
        });
    },

    addReports : function(event) {
        event.preventDefault();
        $('#specific_rep_type').empty();
        $('#active_rep_type').empty();

        $('#active_rep_type')
        .append($('#specify_rep_select optgroup')
        .clone()
        .children('option')
        .end());

        var rep_category = $('#rep_type')[0][0]['value'];
        if (rep_category === 'cw') {
            $('#specific_rep_type').append('<option value='+ rep_category +'>' + S_CW_REP + '</option>');
        } else if (rep_category === 'all_summary') {
            R_SCH_REP._add_reports(summary_rep_list);
        } else if (rep_category === 'all') {
            R_SCH_REP._add_reports(all_reports_list);
        } else if (rep_category === 'all_servers') {
            R_SCH_REP._add_reports(server_rep_list);
        } else if (rep_category === 'all_server_summary') {
            R_SCH_REP._add_reports(server_summary_rep_list);
        }
        $('#specify_reports_div')
                               .show()
                               .find('h3').text(S_SEL_REPORTS_TITLE);
        R_SCH_REP.handleRepTypeChangeEvent();
        $('#main_sch_div').hide();
    },

    removeReports : function(event) {
        event.preventDefault();
        $('#specify_rep_select option:selected').remove();
        $('#specify_rep_select optgroup:empty').remove();
    },

    showRepTypBasedOnTargets : function() {

        var email_checked = $('#email').is(':checked');
        var file_checked = $('#file').is(':checked');
        var cw_checked = $('#connectwise').is(':checked');
        var target = 0;
        $('#rep_type').empty();

        if(cw_checked) {
            $('#rep_type').append('<option value=cw>' + S_CW_REP + '</option>');
            $('#run_schedule').prop('disabled', true)
                              .prop("selectedIndex", 0);
            R_SCH_REP.runReportAction();
            target = 2;
        } else if(email_checked) {
            $('#rep_type').append('<option value=all_summary>' + S_EXECUTIVE_SUMM_REP + '</option>');
            $('#run_schedule').prop('disabled', false);
            target = 0;
        }else {  // file or remote backup
            $('#rep_type').append('<option value=all>' + S_EXECUTIVE_SUMM_REP + '</option>');
            $('#run_schedule').prop('disabled', false);
            target = 1;
        }
        var isDevicesChecked = isChecked('#radio_devices');
        if(!isDevicesChecked) {
            $('#rep_type').empty();
            report_filter_list = server_rep_list;
            if (email_checked && !file_checked) { //Email
                $('#rep_type').append('<option value=all_server_summary>' + S_SERVER_SUMMARY_REP + '</option>');
            } else {
                $('#rep_type').append('<option value=all_servers>' + S_SERVER_REP + '</option>');
            }
        }

        if (email_checked) {
             $('#target_email_div').show();
        } else {
            $('#target_email_div').hide();
        }
        $('#rep_type').append('<option value=specify>' + S_SPECIFIC_REP + '</option>');

        R_SCH_REP._update_selected_reps(target);
    },

    _update_selected_reps : function(target) {

        var selected_rep_len = $('#specify_rep_select option').length;
        if (selected_rep_len === 0) {
            $('#rep_type').prop('selectedIndex', 0);
            $('#specify_rep_select').empty();
            return;
        }
        var report_id_list = [];
        $('#specify_rep_select option').each(function() {
            report_id_list.push(this.value);
        });

        var report_filter_list = '';
        $('#rep_type').prop('selectedIndex', 1);
        var isDevicesChecked = isChecked('#radio_devices');
        if (!isDevicesChecked) {
            report_filter_list = server_rep_list;
            if (target === 0) { //Email
                //only summary reports should be present
                report_filter_list = server_summary_rep_list;
            }
        } else {
            if(target === 1) { //File or remote backup
                return; //No need to do anything, this target indicates all report types
            } else if (target === 0) { //Email
                //only summary reports should be present
                report_filter_list = summary_rep_list;
            } else { //ConnectWise
               //only cw reports must be present
               report_filter_list = cw_reports_list;
            }
        }

        $('#specify_rep_select').empty();
        $.each(report_filter_list, function(index, main_rep) {
            var main_rep_id = main_rep.id;
            var main_rep_title = main_rep.title;
            var main_rep_added = false;
            var sub_report_list = main_rep.sub_reports;

            $.each(sub_report_list, function(index, sub_rep) {
                var sub_rep_id = sub_rep.id;
                var sub_rep_title = sub_rep.title;
                if(report_id_list.indexOf(sub_rep_id.toString()) !== -1) {
                    if(!main_rep_added) {
                        $('#specify_rep_select').append('<optgroup id="'+ main_rep_id +'" label="' + main_rep_title + '"></optgroup>');
                        main_rep_added = true;
                    }
                    $('#specify_rep_select optgroup[id=' + main_rep_id +']').append('<option value='+ sub_rep_id + ' title="'+ sub_rep_title +'">' + sub_rep_title + '</option>');
                }
            });
        });
    },

    toggleFileChkbox : function() {
        var checked = $('#file').is(':checked');
        var cw_checked = $('#connectwise').is(':checked');

        if(checked) {
            $('#file_location_container').show();
            R_SCH_REP.showFTPOrRemoteLocation();
        } else {
            $('#file_location_container').hide();
            $('#file_location_div').hide();
            $('#rb_location_div').hide();
        }

        if(checked || cw_checked) {
            $('#notify_admin_div').show();
        } else {
            $('#notify_admin_div').hide();
        }
        R_SCH_REP.showRepTypBasedOnTargets();
    },

    toggleCWChkbox : function() {
        var checked = $('#connectwise').is(':checked');
        var file_checked = $('#file').is(':checked');

        if(checked) {
            $('#cw_rep_div').show();
        } else {
            $('#cw_rep_div').hide();
        }
        if(checked || file_checked) {
            $('#notify_admin_div').show();
        } else {
            $('#notify_admin_div').hide();
        }
        R_SCH_REP.showRepTypBasedOnTargets();
    },

    showHideAdvSettings : function(event) {
        event.preventDefault();
        $('#show_hide_subj_body').is(':visible') ?  $('#email_adv').text(S_SHOW_ADV_SETTINGS) : $('#email_adv').text(S_HIDE_ADV_SETTINGS);
        $('#show_hide_subj_body').slideToggle();
    },

    deviceSearchEvent : function() {
        var device_checked = $('#radio_devices').prop('checked');
        var resource_list = [];
        if (device_checked) {
            resource_list = avail_device_list;
        } else {
            resource_list = avail_server_list;
        }
        var val = $('#device_server_name').val();
        $('#filtered_devices_servers').empty();
        var matching_list = $.map(resource_list, function (value) {
                      search = new RegExp(val, "gi");
                      var name_sn = value.name;
                      if(name_sn.match(search)) return value;
                      return null;
                  });

        $.each(matching_list, function(index, value) {
            var resource_id = value.id;
            var name_sn = value.name;
            $('#filtered_devices_servers').append('<option value='+ resource_id + ' title="'+ name_sn +'">' + name_sn + '</option>');
        });
    },

    populate_device_server_select : function() {

        var device_checked = $('#radio_devices').prop('checked');
        var resource_list = [];
        if (device_checked) {
            resource_list = avail_device_list;
        } else {
            resource_list = avail_server_list;
        }
        $('#filtered_devices_servers').empty();
        $.each(resource_list, function(index, value) {
            var resource_id = value.id;
            var name_sn = value.name;
            $('#filtered_devices_servers').append('<option value='+ resource_id + ' title="'+ name_sn +'">' + name_sn + '</option>');
        });
    },

    toggleDeviceType : function() {
        var index = $('#select_device_types')[0].selectedIndex;
        if (index === 0) { //Hide if all devices are selected
            $('#selected_resources').hide();
        } else {
            $('#selected_resources').show();
        }
    },

    //Based on the arg doing the following:
    //Hide/show connectwise option in target div
    //Hide/show connectwise in report selection div
    hideShowConnectWise : function(show) {
        if(show) {
            $('#connectwise_div').show();
            $('#email_notify_span').text(S_NOTIFY_ADMIN_MSG);
            $('#rep_type option[value=cw]').show();
        } else {
            $('#connectwise_div').hide();
            $('#email_notify_span').text(S_NOTIFY_ADMIN_FILE_MSG);
            $('#connectwise').prop('checked', false);
            $('#rep_type option[value=cw]').hide();
        }
    },

    backButtonAction : function() {
      $('.add_error_sch').hide();
        $('#' + R_SCH_REP.active_pane + '_li').removeClass("active");
        $('#' + R_SCH_REP.active_pane + '_div').hide();
        var index = R_SCH_REP.panes.indexOf(R_SCH_REP.active_pane);
        R_SCH_REP.active_pane = R_SCH_REP.panes[index - 1];
        R_SCH_REP.prevNextButtonState();
    },

    prevNextButtonTextState : function() {
        if(R_SCH_REP.active_pane === 'gen') {
            WGRD.enableUIElements(false, [R_SCH_REP.backButton]);
        } else {
            WGRD.enableUIElements(true, [R_SCH_REP.backButton]);
        }

        if(R_SCH_REP.active_pane === 'report') {
            $(R_SCH_REP.nextButton).text(S_FINISH_BUTTON);
        } else {
            $(R_SCH_REP.nextButton).text(S_NEXT_BUTTON);
        }
    },

    prevNextButtonState : function() {
        $('#' + R_SCH_REP.active_pane + '_li').addClass('already-visited');
        $('#' + R_SCH_REP.active_pane + '_li').addClass('active');
        $('#' + R_SCH_REP.active_pane + '_div').show();
        R_SCH_REP.prevNextButtonTextState();
    },

    _validateGenDiv : function() {
        var name = $('#schedule_name').val();
        if (name.trim().length === 0) {
            $('#schedule_name').focus();
            $('#schedule_name').select();

            $('.add_error_sch').show().text(S_SCHEDULE_NAME_MSG);
            return false;
        }

        if (R_SCH_REP.mode === 'add') {
            //Check if schedule name exists already
            var sel_row = jQuery('#rep_schedule_table').jqGrid('getGridParam','selrow');
            var data = $("#rep_schedule_table").jqGrid('getGridParam','data');
            var schedule_obj = null;
            for(var i = 0, len = data.length; i < len; i++) {
                schedule_obj = data[i];
                if(schedule_obj.schedule_name === escapeHtml(name.trim().toLowerCase())) {
                    $('.add_error_sch').show().text(S_SCHEDULE_NAME_DUPLICATE_MSG);
                    return false;
                }
            }
        }
        $('.wizard-subtitle').text(name);
        return true;
    },

    _validateDeviceDiv : function() {

        var index = $('#select_device_types')[0].selectedIndex;
        if (index !== 0 && $('#active_resources option').length === 0) {
            $('.add_error_sch').show().text(S_ERR_DEVICE_MSG);
            return false;
        }
        return true;
    },

    _validateTargetDiv : function() {
        var targets = ['#email', '#file', '#connectwise'];
        var target_chkd = false;
        $.each(targets, function(i, target) {
            if($(target).prop('checked')) {
                target_chkd = true;
                return false;
            }
        });
        //At least one target must be checked
        if(!target_chkd) {
            $('.add_error_sch').show().text(S_ERR_TARGET_MSG);
            return false;
        }

        //If email checkbox is checked or notify checkbox is checked, then at least one recipient email address must be present
        var email_checked = $('#email').prop('checked');

        if (email_checked && $('#schedule_emails option').length === 0) {
            $('.add_error_sch').show().text(S_SCHEDULE_EMAIL_MSG);
            $('#schedule_email_to').focus();
            $('#schedule_email_to').select();
            return false;
        }

        //If file location checkbox is checked, then url must not be empty
        var file_checked = $('#file').prop('checked');
        var ftp_server_index = $('#ftp_servers_list')[0].selectedIndex;
        var selected_val = $('#file_select option:selected').val();
        if (file_checked) {
            if (selected_val === 'ftp') {
                var ftp_location = $('#ftp_location').val();
                if(ftp_server_index === 0) {
                    $('.add_error_sch').show().text(S_ERROR_FTP_SERVER);
                    $('#ftp_servers_list').focus();
                    $('#ftp_servers_list').select();
                    return false;
                } else if (ftp_location.trim().length === 0) {
                    $('.add_error_sch').show().text(S_ERR_FILE_LOC_MSG);
                    $('#ftp_location').focus();
                    $('#ftp_location').select();
                    return false;
                }
            } else {
                var rb_location = $('#rb_location').val();
                if (rb_location.trim().length === 0) {
                    $('.add_error_sch').show().text(S_ERR_FILE_LOC_MSG);
                    $('#rb_location').focus();
                    $('#rb_location').select();
                    return false;
                }
            }
        }
        return true;
    },

    _validateReportDiv : function() {
        var index = $('#rep_type')[0].selectedIndex;
        if (index !== 0 && $('#specify_rep_select option').length === 0) {
            $('.add_error_sch').show().text(S_ERR_REP_MSG);
            return false;
        }
        return true;
    },

    validateCurrentPane : function() {

        $('.add_error_sch').hide();

        var active_pane = R_SCH_REP.active_pane;

        switch(active_pane) {
            case "gen":
                return R_SCH_REP._validateGenDiv();
            case "device":
                return R_SCH_REP._validateDeviceDiv();
            case "target":
                return R_SCH_REP._validateTargetDiv();
            case "report":
                return R_SCH_REP._validateReportDiv();
        }
    },

    nextButtonAction : function() {
        $('#' + R_SCH_REP.active_pane + '_li').addClass('already-visited');

        if (!R_SCH_REP.validateCurrentPane()) {
            return;
        }

        if(R_SCH_REP.active_pane === 'report') {
            if(!R_SCH_REP.saveSchedule()) return;
            R_SCH_REP.backButton.hide();
            R_SCH_REP.nextButton.hide();
        }

        $('#' + R_SCH_REP.active_pane + '_li').removeClass('active');

        $('#' + R_SCH_REP.active_pane + '_div').hide();
        var index = R_SCH_REP.panes.indexOf(R_SCH_REP.active_pane);
        R_SCH_REP.active_pane = R_SCH_REP.panes[index + 1];
        R_SCH_REP.prevNextButtonState();
    },

    closeScheduleDialog : function() {
        $('#manage_schedule_dlg').modal('hide');
    },

    updateSchedule : function() {
        var name = $('#schedule_name').val();

        if (name.trim().length === 0) {
            //return error message string here
            return S_SCHEDULE_NAME_MSG;
        }

        //Check if schedule name exists already
        var data = $('#rep_schedule_table').jqGrid('getGridParam', 'data');
        var schedule_obj = null;

        for(var i = 0, len = data.length; i < len; i++) {
            schedule_obj = data[i];
            if(schedule_obj.schedule_name === escapeHtml(name)) {
                break;
            }
        }

        schedule_obj.schedule_name = unescapeHtml(schedule_obj.schedule_name);  // unescape the name since we will be sending this data to the server; could also use 'name' variable here
        schedule_obj.schedule_desc = $('#schedule_desc').val();  // value is already unescaped

        //Update device div
        if (!R_SCH_REP._validateDeviceDiv()) {
            return;
        }
        R_SCH_REP._save_devices_info(schedule_obj);

        //Update target div
        if (!R_SCH_REP._validateTargetDiv()) {
            return;
        }
        var current_targets = schedule_obj.targets;
        R_SCH_REP._save_targets_info(schedule_obj);

        var new_targets = schedule_obj.targets;

        var currentTargetStr = current_targets.toString();
        var newTargetStr = new_targets.toString();

        var emailInCurrentTarget = currentTargetStr.indexOf('#email');
        var emailInNewTarget = newTargetStr.indexOf('#email');

        var cwInCurrentTarget = currentTargetStr.indexOf('#connectwise');
        var cwInNewTarget = newTargetStr.indexOf('#connectwise');

        if(cwInCurrentTarget === cwInNewTarget && cwInCurrentTarget === -1) { //ConnectWise was never checked
            if(emailInCurrentTarget !== emailInNewTarget && emailInCurrentTarget === 0) {
                $('.add_error_sch').show().html(S_TARGET_CHANGE_MSG);
                return;
            }
        } else if ((cwInCurrentTarget === -1 || cwInNewTarget === -1) &&
                   (cwInCurrentTarget !== cwInNewTarget)) { //ConnectWise was toggled
            $('.add_error_sch').show().html(S_TARGET_CHANGE_MSG);
            return;
        }

        //get data from report div and save to schedule_obj
        if (!R_SCH_REP._validateReportDiv()) {
            return;
        }
        R_SCH_REP._save_reports_info(schedule_obj);
        schedule_obj.schedule_action = 0;
        // save the data to the server
        WGRD.putData(schedule_obj).success(function(response) {
            // we need to do some things after the save operations is successful
            if (response.status) {
                // unescaped data was sent to server, so we need to escape the local data
                schedule_obj.schedule_name = escapeHtml(schedule_obj.schedule_name);
                schedule_obj.schedule_desc = escapeHtml(schedule_obj.schedule_desc);
                schedule_obj.connectwise_active_id = escapeHtml(schedule_obj.connectwise_active_id);
                schedule_obj.file_location = escapeHtml(schedule_obj.file_location);

                $('#rep_schedule_table').trigger('reloadGrid');
                $('#error_container').text(S_SCH_EDIT_MSG);
            }
            $('#error_container')
            .delay(2000)
            .fadeOut();
        });
        $('#manage_schedule_dlg').modal('hide');
    },

    _save_devices_info : function(schedule_obj) {

        var isDevicesChecked = isChecked('#radio_devices');

        schedule_obj.device_or_server = -1;
        if(!isDevicesChecked) {
            schedule_obj.device_or_server = -2;
        }

        var index = $('#select_device_types')[0].selectedIndex;
        var active_device_list = [];
        if (index === 1) {
             $('#active_resources option').each(function() {
                active_device_list.push(parseInt(this.value, 10));
            });
        }
        schedule_obj.active_device_list = active_device_list;
    },

    _save_targets_info : function(schedule_obj) {
        //get data from target div and save to schedule_obj
        var targets_chks = ['email', 'file', 'connectwise'];
        var targets = [];
        $.each(targets_chks, function(i, target) {
            if($('#'+target).prop('checked')) {
                targets.push(target);
            }
        });

        schedule_obj.targets = targets;
        schedule_obj.file_location = '';
        if ($('#file').prop('checked')) {
            var selected_val = $('#file_select option:selected').val();
            if (selected_val === 'ftp') {
                var ftp_server = $('#ftp_servers_list option:selected').val();
                if (ftp_server !== '') {
                    var ftp_server_obj = null;
                    for (var i = 0; i < ftp_servers_list.length; i++) {
                        var name = unescapeHtml(ftp_servers_list[i].server_name);
                        if (name === ftp_server) {
                            ftp_server_obj = ftp_servers_list[i];
                            break;
                        }
                    }
                    if (ftp_server_obj !== null) {
                        //format: ftp://<server>/<directory_path>
                        var sub_folder = $('#ftp_location').val();
                        var server_name = ftp_server_obj.server_name;
                        var upload_location = ftp_server_obj.upload_location;
                        if (upload_location.length !== 0 && upload_location[0] !== '/') {
                            upload_location = '/' + upload_location;
                        }
                        var ftp_url = 'ftp://' + server_name + upload_location;
                        if (sub_folder[0] !== '/') {
                            sub_folder = '/' + sub_folder;
                        }
                        schedule_obj.file_location = unescapeHtml(ftp_url) + unescapeHtml(sub_folder);
                    }
                }
            } else {
                var rb_location = $('#rb_location').val();
                schedule_obj.file_location = unescapeHtml(rb_location);
            }
        }
        var connectwise_active_id = $('#cw_managed_id option:selected').val();

        schedule_obj.connectwise_active_id = connectwise_active_id ? connectwise_active_id : '';

        var email_list = [];
        $('#schedule_emails option').each(function() {
            email_list.push($(this).val());
        });

        schedule_obj.email_list = email_list;
        var subj = $('#schedule_email_subject').val();
        schedule_obj.email_subj = subj;
        var body = $('#schedule_email_body').val();
        schedule_obj.email_body = body;
        var notify_checked = $('#email_notify_chkbox').prop('checked');
        schedule_obj.notify_admin = notify_checked;
    },

    _save_reports_info : function(schedule_obj) {
        var index = $('#rep_type')[0].selectedIndex;
        var report_id_list = [];
        if (index === 1) {
            $('#specify_rep_select option').each(function() {
                report_id_list.push(parseInt(this.value, 10));
            });
        }
        schedule_obj.report_id_list = report_id_list;

        var tz_name = $('#rep_tz').val();
        schedule_obj.tz_name = tz_name;

        var report_customization = $('#rep_custom').val();
        schedule_obj.customization_name = report_customization;

        schedule_obj.aggregate = $('#rep_aggr option:selected').val();

        var rep_sch = $('#run_schedule option:selected').val();
        schedule_obj.report_schedule = rep_sch_map[rep_sch];
    },

    saveSchedule : function() {

        schedule_obj = {};
        var data = $('#rep_schedule_table').jqGrid('getGridParam','data');

        //get data from gen div
        schedule_obj.schedule_name = $('#schedule_name').val();
        schedule_obj.schedule_desc = $('#schedule_desc').val();

        //get data from device div
        R_SCH_REP._save_devices_info(schedule_obj);

        //get data from target div
        R_SCH_REP._save_targets_info(schedule_obj);

        //get data from report div and save to schedule_obj
        R_SCH_REP._save_reports_info(schedule_obj);

        var obj = new ReportScheduleObj();

        obj.schedule_action = 0;
        obj.schedule_name = schedule_obj.schedule_name;
        obj.schedule_desc = schedule_obj.schedule_desc;
        obj.report_schedule = schedule_obj.report_schedule;
        obj.notify_admin = schedule_obj.notify_admin;
        obj.report_id_list = schedule_obj.report_id_list;
        obj.device_or_server = schedule_obj.device_or_server;
        obj.active_device_list = schedule_obj.active_device_list;
        obj.targets = schedule_obj.targets;
        obj.aggregate = schedule_obj.aggregate;
        obj.tz_name = schedule_obj.tz_name;
        obj.customization_name = schedule_obj.customization_name;
        obj.file_location = schedule_obj.file_location;
        obj.email_list = schedule_obj.email_list;
        obj.email_subj = schedule_obj.email_subj;
        obj.email_body = schedule_obj.email_body;
        obj.connectwise_active_id = schedule_obj.connectwise_active_id;
        obj.remove_schedules_list = [];

        // save the data to the server
        WGRD.putData(obj).success(function(response) {
            // we need to do some things after the save operations is successful
            if (response.status) {
                // unescaped data was sent to server, so we need to escape the local data
                data.push({'schedule_name': escapeHtml(obj.schedule_name),
                           'schedule_desc': escapeHtml(obj.schedule_desc),
                           'report_schedule': obj.report_schedule,
                           'notify_admin': obj.notify_admin,
                           'report_id_list': obj.report_id_list,
                           'device_or_server': obj.device_or_server,
                           'active_device_list': obj.active_device_list,
                           'targets': obj.targets,
                           'aggregate': obj.aggregate,
                           'tz_name': obj.tz_name,
                           'customization_name': obj.customization_name,
                           'file_location': escapeHtml(obj.file_location),
                           'email_list': obj.email_list,
                           'email_subj': obj.email_subj,
                           'email_body': obj.email_body,
                           'connectwise_active_id': escapeHtml(obj.connectwise_active_id),
                           'remove_schedules_list': obj.remove_schedules_list,
                           '__module__': 'modules.scripts.report.rep_sch_grp_scripts',
                           '__class__': 'ReportScheduleObj'
                });

                $('#rep_schedule_table').trigger('reloadGrid');
                $('#error_container').text(S_SCH_ADD_MSG);
            }
            $('#error_container')
                                .delay(2000)
                                .fadeOut();
        });

        $('#manage_schedule_dlg').modal('hide');
    },

    populateCustomizationList : function() {
        $('#rep_custom').append('<option value="' + S_REPORT_CUST_DEFAULT + '">' + S_REPORT_CUST_DEFAULT + '</option>');
        for (var i=0; i<customization_list.length; i++) {
            $('#rep_custom').append('<option value="' + customization_list[i] + '">' + customization_list[i] + '</option>');
        }
    },

    populateFtpServerList : function() {
        for (var i = 0; i < ftp_servers_list.length; i++) {
            var name = ftp_servers_list[i].server_name;
            var upload_location = ftp_servers_list[i].upload_location;
            $('#ftp_servers_list').append('<option value="' + name + '">' + name + '</option>');
        }
    },

    enable_rb_UI : function(enable) {
        if  (!enable) {
            $('#rb_location').val('')
                             .prop('disabled', true);
            $('#rb_config_status').show();
        } else {
            $('#rb_config_status').hide();
            $('#rb_location').prop('disabled', false);
        }
    },

    showFileDiv : function() {
        var ftp_servers_length = ftp_servers_list.length;
        var file_checked = $('#file').prop('checked');
        var is_remote_bkup_enabled = R_SCH_REP.is_rbEnabled;
        if (ftp_servers_length === 0 && !is_remote_bkup_enabled) {
            $('#file').prop('checked', false);
            R_SCH_REP.enable_rb_UI(is_remote_bkup_enabled);
            $('#file_location_container').hide();
            return;
        }
        if (file_checked) {
            $('#file_location_container').show();
            R_SCH_REP.showFTPOrRemoteLocation();
            R_SCH_REP.enable_rb_UI(is_remote_bkup_enabled);
        } else {
            $('#file_location_container').hide();
        }
    },

    //Called when user changes the ftp server and when user clicks on the edit option
    ftpServerAction : function() {
        var selected_val = $('#ftp_servers_list option:selected').val();
        var root_location = S_NONE;
        for (var i = 0; i < ftp_servers_list.length; i++) {
            var server_name = unescapeHtml(ftp_servers_list[i].server_name);
            var server_index = selected_val.indexOf(server_name);
            if (server_index === 0) {
                var upload_location = ftp_servers_list[i].upload_location;
                if (upload_location.length !== 0) {
                    root_location = "<b>" + upload_location + "</b>";
                } else {
                    root_location = '';
                }
                break;
            }
        }
        $('#cur_ftp_server').html(root_location);
    },

    addEmail : function(event) {
        event.preventDefault();
        $('.add_error_sch').hide();
        var selected_email = $('#schedule_email_to').val();
        var patt = /[^\s]+@[^\s]+([.]\w{2,})+/;

        // email to address
        if (selected_email.length === 0 || (!patt.test(selected_email))) {
            $('#schedule_email_to').focus();
            $('#schedule_email_to').select();
            $('.add_error_sch').show().text(S_ERROR_EMAIL_TO_INVALID);
            return;
        }

        if($('#schedule_emails option[value="' + selected_email + '"]').length > 0) {
            $('#schedule_email_to').focus();
            $('#schedule_email_to').select();
            $('.add_error_sch').show().text(S_ERROR_EMAIL_TO_DUPLICATE);
            return;
        }

        $('#schedule_emails').append('<option value="' + selected_email + '">' + selected_email + '</option>');
        $('#schedule_email_to').val("");
    },

    removeEmail : function(event) {
        event.preventDefault();
        var selected_email = $('#schedule_emails').val();

        if(selected_email.length !== 0) {
           $('#schedule_emails option[value="' + selected_email + '"]').remove();
        }
        return;
    },

    runReportAction : function () {
        var report_interval = $('#run_schedule').val();
        $('#report_time').text(rep_schedules[report_interval][0]+', '+$('#rep_tz option:selected').text());
        $('#report_range').text(rep_schedules[report_interval][1]);
    },

    /*
       Called when add or Edit buttons are clicked for groups
       If edit, then pass in row data
    */
    showScheduleModal : function() {
        var button_id = $(this).attr('id');
        var params = {'parent_id': button_id};
        if (button_id === 'edit_schedule') {
            var sel_row = jQuery('#rep_schedule_table').jqGrid('getGridParam','selrow');
            if (sel_row === null) {
                return;
            }
        }
        WGRD.doModal('#manage_schedule_dlg',
                     R_SCH_REP.initializeSchedules,
                     R_SCH_REP.saveSchedules,
                     params);
        //Every time user clicks add/edit/view check if user has
        //permission for remote backup operation, accordingly enable or disable remote radio option
        R_SCH_REP.chk_for_rmt_bkup();
    },

    chk_for_rmt_bkup : function() {
        $.ajax({
            url: 'test_backup_conn',
            success: function(response) {
                R_SCH_REP.is_rbEnabled = response[0];
            },
            error: function(response) {
                R_SCH_REP.is_rbEnabled = false;
            },
            complete: function() {
                R_SCH_REP.showFileDiv();
            }
        });
    },

    initializeSchedules : function(params) {
        var parent_id = params.parent_id;
        R_SCH_REP.mode = 'add';

        if (parent_id === 'add_schedule') {
            R_SCH_REP._init_sch('add');
            R_SCH_REP._add_schedule();
        } else { //Update UI
            R_SCH_REP._init_sch('edit');
            R_SCH_REP._edit_schedule();
            R_SCH_REP.mode = 'edit';
        }
        return true;
    },

    _init_sch : function(arg) {
        R_SCH_REP.active_pane = 'gen';

        //Reset gen_div contents
        $('#schedule_name').val("")
                           .attr('disabled', false);
        $('.wizard-subtitle').text("");
        $('#schedule_desc').val("");

        $('#radio_devices').prop("checked", true);
        $('#device_server_container').show();
        $('#device_server_lbl').text(S_DEVICE_LABEL_MAIN);
        R_SCH_REP.showDevicesOrServers();
        $('#main_sch_div').show();

        //Reset specify_device_div contents
        $('#specify_device_div').hide();
        $('#device_server_name').val("");
        $('#active_devices_servers').empty();
        $('#active_resources').empty();

        //Reset target div contents
        var target_div_chkboxes = ['#email', '#file', '#connectwise'];
        $.each(target_div_chkboxes, function(i, chkbox) {
            $(chkbox).prop('checked', false);
        });

        $('#email_notify_chkbox').prop('checked', false);
        R_SCH_REP.showFTPOrRemoteLocation();
        R_SCH_REP.toggleFileChkbox();
        R_SCH_REP.toggleCWChkbox();

        $('select#ftp_servers_list').prop('selectedIndex', 0);
        $('select#file_select').prop('selectedIndex', 0);
        $('#cur_ftp_server').html(S_NONE);
        $('#ftp_location').val('');
        $('#rb_location').val('');

        $('#show_hide_subj_body').hide();
        $('#email_adv').text(S_SHOW_ADV_SETTINGS);

        //Reset schedule email text
        $('#schedule_email_to').val("");
        $('#schedule_emails').empty();

        //Reset schedule email subject and body
        $('#schedule_email_subject').val(S_SCHEDULE_DEFAULT_SUBJ);
        $('#schedule_email_body').val(S_SCHEDULE_DEFAULT_BODY);

        //Reset report types
        $('#rep_type').prop("selectedIndex", 0);
        $('#specify_rep_select').empty();
        R_SCH_REP.toggleReportType();

        //Reset report customization to 'Default'
        $('#rep_custom').prop("selectedIndex", 0);

        //Uncheck report aggregations
        $('#rep_aggr').prop('selectedIndex', 0);
        $('#rep_tz').val(WGRD.client_tz);

        //Reset run reports to 'Daily'
        $('#run_schedule').prop('selectedIndex', 0);
        R_SCH_REP.runReportAction();

        //Reset specify_device_div contents
        $('#specify_reports_div').hide();
        $('#filtered_rep_type').empty();
        $('#active_rep_type').empty();

        $.each(R_SCH_REP.panes, function(i, pane) {
            if(arg === 'add') {
                $('#' + pane + '_li').removeClass("already-visited");
            } else {
                $('#'+ pane + '_li').addClass('already-visited');
            }

            $('#' + pane + '_li').removeClass("active");
            $('#' + pane + '_div').hide();
        });

        $('#' + R_SCH_REP.active_pane + '_li').addClass("active");
        $('#' + R_SCH_REP.active_pane + '_div').show();

        if(arg === 'add') {
            $(R_SCH_REP.backButton).show();
            $(R_SCH_REP.nextButton).show();

            $(R_SCH_REP.closeButton).hide();
            $(R_SCH_REP.saveButton).hide();
        } else {
            $(R_SCH_REP.backButton).hide();
            $(R_SCH_REP.nextButton).hide();

            $(R_SCH_REP.closeButton).show();
            $(R_SCH_REP.saveButton).show();
        }
    },

    _add_schedule : function() {
       WGRD.enableUIElements(false, [R_SCH_REP.backButton]);
       $(R_SCH_REP.nextButton).text(S_NEXT_BUTTON);
        $('#manage_schedule_dlg h3').text(S_ADD_SCHEDULE_TITLE);
    },

    _edit_schedule : function() {

        if (is_page_locked === 1) {
            $('#manage_schedule_dlg h3').text(S_VIEW_SCHEDULE_TITLE);
            $("#saveSch").hide();
        } else {
            $('#manage_schedule_dlg h3').text(S_EDIT_SCHEDULE_TITLE);
            $("#saveSch").show();
        }

        var sel_row = $('#rep_schedule_table').jqGrid('getGridParam','selrow');
        var data = $('#rep_schedule_table').jqGrid('getGridParam','data');
        var schedule_obj = null;

        for(var i = 0, len = data.length; i < len; i++) {
            schedule_obj = data[i];
            if(schedule_obj.schedule_name === escapeHtml(sel_row)) {
                break;
            }
        }

        //populate gen div
        $('#schedule_name').val(unescapeHtml(schedule_obj.schedule_name)).attr('disabled',true);
        $('.wizard-subtitle').text(unescapeHtml(schedule_obj.schedule_name));
        $('#schedule_desc').val(unescapeHtml(schedule_obj.schedule_desc));

        //populate device div

        //In edit mode, disable switching from device to server and vice-versa
        var device_or_server = schedule_obj.device_or_server;
        var resource_list = [];
        $('#device_server_container').hide();
        if(device_or_server === -1) {
            $('#device_server_lbl').text(S_DEVICE_LABEL_1);
            resource_list = avail_device_list;
            $('#radio_devices').prop("checked", true);
        } else {
            $('#device_server_lbl').text(S_SERVER_LABEL_1);
            resource_list = avail_server_list;
            $('#radio_servers').prop("checked", true);
        }
        var index = 0;
        var device_list = schedule_obj.active_device_list;

        R_SCH_REP.showDevicesOrServers();
        if(device_list.length !== 0) {
            index = 1;
            var count = 0;
            $.each(resource_list, function(i, resource) {
                var resource_id = resource.id;

                if(device_list.indexOf(resource_id) !== -1) {
                    var name_sn = resource.name;
                    $('#active_resources').append('<option value='+ resource_id + ' title="'+ name_sn +'">' + name_sn + '</option>');
                    count = count + 1;
                }
                //We only want to iterate the resource list till we have looked into all of the devices in device_list.
                if(count === device_list.length) return false;
            });
        }

        $('#select_device_types').prop('selectedIndex', index);
        R_SCH_REP.toggleDeviceType();

        //populate target div
        var targets = schedule_obj.targets;
        var target_div_chkboxes = ['email', 'file', 'connectwise'];
        $.each(target_div_chkboxes, function(i, chkbox) {
            if(targets.indexOf(chkbox) !== -1) {
                $('#'+chkbox).prop('checked',true);
            }
        });


        if ($('#file').is(':checked')) {
            var file_loc = schedule_obj.file_location;
            if (file_loc.indexOf('ftp://') === 0) {
                for (var i = 0; i < ftp_servers_list.length; i++) {
                    var server_name = ftp_servers_list[i].server_name;
                    var server_name_index = file_loc.indexOf(server_name + '/');
                    if (server_name_index > 0) {
                        var upload_location = ftp_servers_list[i].upload_location;
                        if (upload_location.length !== 0 && upload_location.charAt(0) !== "/") {
                            upload_location = '/' + upload_location;
                        }
                        var server_upload_str = 'ftp://' + server_name + upload_location + "/";
                        var sub_folder = file_loc.substring(server_upload_str.length);
                        $('#ftp_servers_list').val(unescapeHtml(server_name));
                        $('#ftp_location').val(unescapeHtml(sub_folder));
                        if (upload_location.length !== 0) {
                            $('#cur_ftp_server').html("<b>" + upload_location + "</b>");
                        } else {
                            $('#cur_ftp_server').text('');
                        }
                        break;
                    }
                }
                R_SCH_REP.ftpServerAction();
            } else if (file_loc !== '') {
                $('select#file_select').prop('selectedIndex', 1);
                $('#rb_location').val(unescapeHtml(file_loc));
                R_SCH_REP.showFTPOrRemoteLocation();
            }
        }

        R_SCH_REP.toggleFileChkbox();
        R_SCH_REP.toggleCWChkbox();

        $('#cw_managed_id').val(unescapeHtml(schedule_obj.connectwise_active_id));

        var email_list = schedule_obj.email_list;
        $.each(email_list, function(index, value) {
            $('#schedule_emails').append('<option value="' + value + '">' + value + '</option>');
        });

        $('#schedule_email_subject').val(schedule_obj.email_subj);
        $('#schedule_email_body').val(schedule_obj.email_body);

        var notify = schedule_obj.notify_admin;
        $('#email_notify_chkbox').prop('checked', notify);

        //populate report div
        var report_id_list = schedule_obj.report_id_list;
        if(report_id_list.length !== 0) {
            $('#rep_type').prop("selectedIndex", 1);

            var email_checked = $('#email').is(':checked');
            var file_checked = $('#file').is(':checked');
            var cw_checked = $('#connectwise').prop('checked');

            var isDevicesChecked = isChecked('#radio_devices');

            var report_filter_list = '';
            if (!isDevicesChecked) {
                report_filter_list = server_rep_list;
                if (email_checked) { //Email
                    //only summary reports should be present
                    report_filter_list = server_summary_rep_list;
                }
            } else {
                if (cw_checked) {
                    report_filter_list = cw_reports_list;
                } else if (email_checked) {
                    report_filter_list = summary_rep_list;
                } else if (file_checked) {
                    report_filter_list = all_reports_list;
                }
            }

            $.each(report_filter_list, function(index, main_rep) {
                var main_rep_id = main_rep.id;
                var main_rep_title = main_rep.title;
                var main_rep_added = false;
                var sub_report_list = main_rep.sub_reports;

                $.each(sub_report_list, function(index, sub_rep) {
                    var sub_rep_id = sub_rep.id;
                    var sub_rep_title = sub_rep.title;
                    if(report_id_list.indexOf(sub_rep_id) !== -1) {
                        if(!main_rep_added) {
                            $('#specify_rep_select').append('<optgroup id="'+ main_rep_id +'" label="' + main_rep_title + '"></optgroup>');
                            main_rep_added = true;
                        }
                        $('#specify_rep_select optgroup[id=' + main_rep_id +']').append('<option value='+ sub_rep_id + ' title="'+ sub_rep_title +'">' + sub_rep_title + '</option>');
                    }
                });
            });
            R_SCH_REP.toggleReportType();
        }

        $('#rep_tz').val(schedule_obj.tz_name);
        $('#rep_custom').val(schedule_obj.customization_name);

        $('#rep_aggr').val(schedule_obj.aggregate);
        var rep_sch = schedule_obj.report_schedule;
        $('#run_schedule').val(rep_sch_map[rep_sch]);
        R_SCH_REP.runReportAction();
    },

    removeSchedule : function() {
        var sel_row = $('#rep_schedule_table').jqGrid('getGridParam','selrow');
        if (sel_row === null) {
            return;
        } else {
            $("#confirm_dlg").modal();
        }
    },

    deleteSchedule : function() {
        WGRD.enableUIElements(false, ['#removeSchedule']);
        var sel_row = $('#rep_schedule_table').jqGrid('getGridParam','selrow');
        var data = $('#rep_schedule_table').jqGrid('getGridParam','data');
        var schedule_obj = null;

        for(var i = 0, len = data.length; i < len; i++) {
            schedule_obj = data[i];
            if(schedule_obj.schedule_name === escapeHtml(sel_row)) {
                break;
            }
        }
        schedule_obj.schedule_action = 1;
        schedule_obj.remove_schedules_list.push(unescapeHtml(schedule_obj.schedule_name));
        // save the data to the server
        WGRD.putData(schedule_obj).success(function(response) {
            if (response.status) {
                var index = ($.inArray(schedule_obj, data));
                data.splice($.inArray(schedule_obj, data),1);

                $('#rep_schedule_table').trigger('reloadGrid');
                $('#error_container').text(S_SCH_DEL_MSG);
            }
            $('#error_container')
            .delay(2000)
            .fadeOut();
        });
    },

    createReportScheduleGrid : function() {
       var schedule_grid = $('#rep_schedule_table').jqGrid({
            loadonce: true,
            loadui: 'block',
            datatype: R_SCH_REP.refreshRepScheduleGrid,
            height:'auto',
            autowidth: true,
            shrinkToFit: true,
            colNames: repScheduleColNames,
            colModel: repScheduleColModel,
            pager: '#rep_schedule_pager',
            sortname: 'schedule_name',
            viewrecords: true,
            sortorder: 'asc',
            rowNum: 10,
            rowList: [10, 20, 50,100],
            altRows: true,
            altclass: 'gridAltRow',
            loadComplete:function() {
                R_SCH_REP.toggleEditRemoveBtn();
            },
            onSelectRow: function(rowid, status, e) {
                R_SCH_REP.toggleEditRemoveBtn();
            }
        });
         // add the pager with custom actions for the "delete" button
        schedule_grid.jqGrid('navGrid', '#rep_schedule_pager', { edit: false, add: false, del: false, search: false, refresh:false});
    },

    toggleEditRemoveBtn: function() {
        // enable/disable "Remove"/"Edit" button depending on if any rows are selected or not
        var selRowId = $('#rep_schedule_table').jqGrid('getGridParam', 'selrow');
        WGRD.enableUIElements(selRowId, ['#edit_schedule', '#remove_schedule']);
    },

    refreshRepScheduleGrid : function() {
        $('#rep_schedule_table').jqGrid('setGridParam', {
            datatype: 'local',
            data: active_schedule_list
        });
        $('#rep_schedule_table').trigger('reloadGrid');
    },

    resizeGrids : function() {
        // Pass the <table> id then the <div> that wraps it
        resizeGrid('#rep_schedule_table', '#rep_schedule_grid');
    }
};
$(document).ready(R_SCH_REP.init);
