$(document).ready(function() {                      
    var htmlDate = $("#date").val();
    var htmlSn = $("#sn").val();  
    var urlTz = $.getUrlVar('tz');           
    var resultData = new Object();

    /* Start page loading by retrieving the data */
    getData();
    
    function getData(){
        showChartLoading('chart');
        var seconds = R_DATE_NAVBAR.getStartEndSeconds();
        var start_seconds = seconds[0];
        var end_seconds = seconds[1];
        var jqxhr = $.ajax({
           url: 'get_data?report_type=server_audit_summary&sn=' + htmlSn + '&div=audit_sum_grid_area' + '&start_time=' + start_seconds + '&end_time=' + end_seconds,
           method: 'GET',
           dataType: 'json',
           success: success,
           error: errorHandler
        });     
        return jqxhr;
    }     
    
    function success(series){
        if(series.count > 0){
            showChart('chart');
            bar_options.axes.xaxis.ticks = series.ticks;
            if(Math.max.apply(Math, series.ticks) < 5) {
                bar_options.axes.xaxis.formatString = '%.2f';
            }
            bar_options.series[0].label = series.legend[0];
            bar_options.axes.xaxis.label = series.label[0];
            plot_trend = $.jqplot('chart_graph', series.data, bar_options);        
            plot_trend.replot();
                
            $('#audit_sum_grid_area').GridUnload('#audit_sum_grid_area');
            $('#audit_sum_grid_area').jqGrid({ 
                datatype: "local", 
                colNames:series.col_names,
                colModel:series.col_model,         
                sortname: series.grid_sort.sortname,
                sortorder: series.grid_sort.sortorder, 
                autoencode: true,
                height:'auto',
                autowidth: true,
                shrinkToFit: true
            });             
            
            /* set the column formatter for any columns with sorttype date 
             * to adjust for the timezone 
             */
            var i = 0;
            for(i=0;i<series.grid_data.length;i++) {
                $('#audit_sum_grid_area').jqGrid('addRowData',i+1,series.grid_data[i]);
            }               
            $("#audit_sum_grid_area").setGridParam({rowNum:i});                        
                        
        }else{
            $('#audit_sum_grid_area').GridUnload('#audit_sum_grid_area');                
            showChartEmpty('chart');            
        }
        resultData = series;        
    }
    
    
    $("#custom_datepicker_trigger").unbind('click').click( function() {
        // Listen fora click on this div, it means the date changed 
        // and a refresh is needed
        getData();
    });       
    
    $('#pdf_link_sum').click(function(){
        // No data available 
        if(resultData.count <= 0){
            return;
        }
        
        resultData.grid_data = updateTimezones(resultData.grid_data, resultData.col_model);
        resultData.user_data = updateUserTimezones(resultData.user_data, resultData.user_col_model);

        data = JSON.stringify(resultData);
        
        var startTime = R_DATE_NAVBAR.convertDateStr2GMT(R_DATE_NAVBAR.getStartEndIsoStr()[0] + ":00");
        var endTime = R_DATE_NAVBAR.convertDateStr2GMT(R_DATE_NAVBAR.getStartEndIsoStr()[1] + ":00");

        $.ajax({
            url:"saveAsPdf?serial=" + htmlSn + "&client_tz=" + WGRD.client_tz + "&report_type=server_audit_summary" + "&start_time=" + startTime + "&end_time=" + endTime,
            type: 'POST',
            data: data,
            contentType: 'application/json',
            success: function(data) {
                if(!data.status){
                    if(data.message){
                        alert(data.message);
                    }
                    return true;
                }
                window.location = "get_pdf_file?serial=" + htmlSn;
                return false;
            }    
        });
    }); 
});