$(document).ready(function() {
    var div = "#server_grid_entities";    

    jQuery(div).GridUnload(div);

    var colNames = ['Name', 'Serial', 'IP Address', 'Type'];

    var colModel = [{name:'appliance_name', index:'name', sortable: true, width: 150,
                    sorttype: function(cellvalue) {
                        if (cellvalue.indexOf('<span class=') >= 0
                            && cellvalue.indexOf('&nbsp;') > 0) {
                            cellvalue = cellvalue.substring(cellvalue.indexOf('&nbsp;')+6);
                        }
                        return cellvalue.toLowerCase();
                    }
                },
                {name:'serial', index:'sn', sorttype:"text", sortable: true, width: 150, hidden: true},
                {name:'ip', index:'ip_address', sorttype:"text", sortable: true, width: 150},
                {name:'type_name', index:'type_name', sorttype:"text", sortable: true, width: 150}]

    var optParams = {
        url: 'report_servers',
        datatype: 'json',
        mtype: 'GET',
        rowNum: -1,
        altRows: true,
        altclass: 'gridAltRow',
        sortname: 'appliance_name',
        sortorder: 'asc',
        caption: '',
        height: 'auto',
        width: '800',    
        loadError: errorHandler,
        loadComplete: function (data) {           
            if(data === null) {
                $('#error_msg').show();
                $('#report_servers').hide();
            }
            $('.tree-leaf', $(this)).css('width', '0px');
        },
        onCellSelect: function(rowid, iRow, iCol, e){
            var sn = $("#server_grid_entities").jqGrid('getCell',rowid,'serial');
            window.location="server?sn="+sn;            
        }
    };

    createRsGrid(colNames, colModel, div, optParams);
    $(div).navGrid("#pager",{refresh:false,search:false,edit:false,add:false,del:false},{},{width:350},{});

    function resizeGrids() {
        resizeGrid('#server_grid_entities', "#current_grid");
    }

    $(window).bind('resizeEnd', function() {
        resizeGrids();
    })

});

