var S_SINGLE_REP = {
    resultData : '',
    allVars : '', 
    urlSn : '',
    date : '',
    id : '',
    period : '',
    urlTz : '',
    repType : '',
    htmlDate : '',
    htmlSn : '',
    startTime : '',
    endTime : '',
    seriesEarliestRecord : '',
    seriesLatestRecord : '',
    reportName : '',
    portal_link : "http://www.watchguard.com/SecurityPortal/ThreatDetail.aspx?rule_id=",

    init: function() {
        S_SINGLE_REP.allVars = $.getUrlVars();
        S_SINGLE_REP.urlSn = $.getUrlVar('sn');
        S_SINGLE_REP.date = $.getUrlVar('date');
        S_SINGLE_REP.id = $.getUrlVar('id');
        S_SINGLE_REP.period = $.getUrlVar('period');
        S_SINGLE_REP.urlTz = $.getUrlVar('tz');
        S_SINGLE_REP.repType = $.getUrlVar('reptype');
        S_SINGLE_REP.htmlDate = $("#date").val();
        S_SINGLE_REP.htmlSn = $("#sn").val();
        S_SINGLE_REP.initUI();
        S_SINGLE_REP.initEvents();
    },

    initUI: function() {
        // Set the report type from the url
        if(S_SINGLE_REP.repType != null) {
            $('#chart_select').val(S_SINGLE_REP.repType);
        }
        if(S_SINGLE_REP.repType === "undetected_apt_malware_by_content" || S_SINGLE_REP.repType === "undetected_apt_malware_by_uuid"
            || S_SINGLE_REP.repType === "undetected_apt_malicious_activity" || S_SINGLE_REP.repType === "undetected_apt_destination"
            || S_SINGLE_REP.repType === "undetected_apt_threat") {
                $('#page_label_id').attr("title", D_SUMMARY_EXECUTIVE_ZERO_DAY_APT);
        }

        if(S_SINGLE_REP.period != null && S_SINGLE_REP.period == 'custom') {
            $('#chart_select').hide();
        }
        S_SINGLE_REP.showChartLoading();
    }, 

    initEvents: function() {
        $('#pdf_link').click(function() {
            S_SINGLE_REP.resultData.grid_data = updateTimezones(S_SINGLE_REP.resultData.grid_data, S_SINGLE_REP.resultData.col_model);
            var data = JSON.stringify(S_SINGLE_REP.resultData);

            var reportType = $('#chart_select option:selected').val();
            var tzOffsetStart = $.getDateUTCOffsetString(S_SINGLE_REP.seriesEarliestRecord, S_SINGLE_REP.urlTz);
            var tzOffsetEnd = $.getDateUTCOffsetString(S_SINGLE_REP.seriesLatestRecord, S_SINGLE_REP.urlTz);

            $.ajax({
                url: "saveAsPdf?serial=" + S_SINGLE_REP.htmlSn + "&client_tz=" + WGRD.client_tz + "&report_type=" + S_SINGLE_REP.reportType + "&start_time=" + S_SINGLE_REP.seriesEarliestRecord + "&end_time=" + S_SINGLE_REP.seriesLatestRecord
                   + "&tz_offset_start=" + S_SINGLE_REP.tzOffsetStart +  "&tz_offset_end=" + S_SINGLE_REP.tzOffsetEnd,
                type: 'POST',
                data: data,
                contentType: 'application/json',
                success: function(data) {
                    if(!data.status) {
                        if(data.message) {
                            alert(data.message);
                        }
                        return true;
                    }
                    window.location = "get_pdf_file?serial=" + S_SINGLE_REP.htmlSn;
                    return false;
                }
            });
       });

        // Add handler for change the type of chart
        $("#chart_select").change(function () {   S_SINGLE_REP.getData();  });
        $("#bw_hits_select").change(function () {   S_SINGLE_REP.getData();  });

        $("#custom_datepicker_trigger").bind('click', function() {
            // Listen fora click on this div, it means the date changed 
            // and a refresh is needed
            S_SINGLE_REP.getData();
        });

        $(window).bind('resizeEnd', function() {
            if(window.plot_trend) {
                var grid = "#grid_area";
                var parent = "#grid_data";
                var grid_width = resizegrid();
                $("#webui_content").width(grid_width);
                $(grid).setGridWidth(100, true); 
                $(grid).setGridWidth($(parent).width(), true);
                plot_trend.replot();
            }
        });

        $(document).on('click', '.detaildialog', S_APT_DETAIL.showDetailsDialog);
    },

    showChartLoading : function() {
        $('#chart_loading').show();
        $('#chart').hide();
    },

    getData : function () {
        var report_type = $('#chart_select option:selected').val();
        var divName = 'chart';
        if (report_type === 'px_daily_trend' || report_type === 'pf_daily_trend' ||
           (report_type.indexOf('pf_') != 0  &&
            report_type.indexOf('px_') != 0)) {
            $('#bw_hits_select').hide();
            $('#chart_select').css('width','187px');
        } 
        else {
            $('#bw_hits_select').show();
            $('#chart_select').css('width','120px');
            var rep_type = report_type + $('#bw_hits_select option:selected').val();
            divName = rep_type;
        }
        //Once the date is set, refresh all the charts
        var jqxhr = getChartData(divName, S_SINGLE_REP.htmlSn, true, S_SINGLE_REP.id);
        jqxhr.success(S_SINGLE_REP.dataReceived);
    },

    // Return data handler functions
    dataReceived : function (series) {
        S_SINGLE_REP.resultData = series;
        S_SINGLE_REP.seriesEarliestRecord = series.earliest_record;
        S_SINGLE_REP.seriesLatestRecord = series.latest_record;
        S_SINGLE_REP.startTime = $.getDateDisplay(series.earliest_record, true, S_SINGLE_REP.urlTz);
        S_SINGLE_REP.endTime = $.getDateDisplay(series.latest_record, true, S_SINGLE_REP.urlTz);
        S_SINGLE_REP.reportName = $('#chart_select option:selected').text();

        // Notify the date navbar the report range changed
        $('#report_range').trigger('reportRange', { start_time: S_SINGLE_REP.startTime,
                                                    end_time: S_SINGLE_REP.endTime,
                                                    name: S_SINGLE_REP.reportName });
        if ($('#bw_hits_select').is(":visible") && series.chart_type === "bar") {
            $('#bw_hits_select').hide();
            $('#chart_select').css('width','187px');
            var current_rep_name = $('#chart_select option:selected').text();
            if (current_rep_name.lastIndexOf(S_BY_HITS) === -1) {
                $('#chart_select option:selected').text(current_rep_name + " " + S_BY_HITS);
            }
        }
        // Unload the grid and then recreate it and populate the rows
        jQuery("#grid_area").GridUnload("#grid_area");

        // When series contains no data, series.grid_sord is undefined,
        // which causes createGrid() to raise an error.
        // Can't let this function return at the beginning when series has no data,
        // because it would make the empty report shown not like usual
        if (series.grid_sort) {
            S_SINGLE_REP.createGrid(series.col_names, series.col_model, series.grid_sort);
        }

        var i = 0;
        for(i=0;i<=series.grid_data.length;i++) {
            $("#grid_area").jqGrid('addRowData',i+1,series.grid_data[i]);
        }
        $("#grid_area").setGridParam({rowNum:i});

        $("#grid_area").jqGrid('footerData','set', series.footer, false);
    },

    // Report DataGrid
    createGrid : function (colNames, colModel, gridSort) {
        $("#grid_area").jqGrid({ 
            datatype: "local", 
            colNames:colNames,
            colModel:colModel,
            sortname: gridSort.sortname,
            sortorder: gridSort.sortorder,
            autoencode: true,
            height:'auto',
            autowidth: true,
            shrinkToFit: true,
            footerrow:true
        });

        $("#grid_area").setColProp('host', { formatter: S_SINGLE_REP.linkFormatter });
        $("#grid_area").setColProp('ip', { formatter: S_SINGLE_REP.linkFormatter });
        $("#grid_area").setColProp('user', { formatter: S_SINGLE_REP.linkFormatter });

        var reportType = $('#chart_select option:selected').val();
        if(reportType === "ips_signature" || reportType === "ips_source" || reportType === "ips_threat" || reportType === "ips_protocol") {
            $("#grid_area").setColProp('application', { formatter: S_SINGLE_REP.ipsLinkFormatter });
            $("#grid_area").setColProp('more_info', { formatter: S_SINGLE_REP.ipsLinkFormatter });
        }else if(reportType === "gav_virus" || reportType === "gav_host" || reportType === "gav_protocol" || reportType === "gav_email") {
            $("#grid_area").setColProp('application', { formatter: S_SINGLE_REP.gavLinkFormatter });
        }else if(reportType === "apt_malware_by_content" || reportType === "apt_malware_by_uuid" || 
                 reportType === "apt_malicious_activity" || reportType === "apt_mime" || 
                 reportType === "apt_protocol" || reportType === "apt_destination" ||
                 reportType === "apt_source" || reportType === "apt_threat" || 
                 reportType === "undetected_apt_malware_by_content" || reportType === "undetected_apt_malware_by_uuid" || 
                 reportType === "undetected_apt_malicious_activity" || reportType === "undetected_apt_destination" ||
                 reportType === "undetected_apt_threat") {
            $("#grid_area").setColProp('application', { formatter: S_SINGLE_REP.aptLinkFormatter });
            $("#grid_area").setColProp('more_info', { formatter: S_SINGLE_REP.aptLinkFormatter });
        }
    },

    linkFormatter : function(elem, cellval, opts) {
        return S_SINGLE_REP.formatPerClientLink(elem, cellval);
    },

    formatPerClientLink : function (elem, cellval) {
        var index = S_SINGLE_REP.startTime.indexOf(' ');
        var start_date = S_SINGLE_REP.startTime.substring(0, index);
        var start_time = S_SINGLE_REP.startTime.substring(index + 1, S_SINGLE_REP.startTime.length);
        index = S_SINGLE_REP.endTime.indexOf(' ');
        var end_date = S_SINGLE_REP.endTime.substring(0,index);
        var end_time = S_SINGLE_REP.endTime.substring(index + 1, S_SINGLE_REP.endTime.length);

        var uri = 'perclient?sn=' + S_SINGLE_REP.urlSn + 
                  '&start_date=' + start_date + 
                  '&start_time=' + start_time + 
                  '&end_date=' + end_date + 
                  '&end_time=' + end_time;
        if(cellval.colModel.name == 'ip') {
            uri = uri + '&ip=' + elem;
        }else if(cellval.colModel.name == 'user') {
            uri = uri + '&user=' + elem;
        }else if(cellval.colModel.name == 'host') {
            uri = uri + '&host=' + encodeURIComponent(elem);
        }

        return "<a href='" + uri + "'>" + escapeHtml(elem) + "</a>";
    },

    ipsLinkFormatter : function (elem, cellval, opts) {
        if(cellval.colModel.name === 'application') {
            var reportType = $('#chart_select option:selected').val();
            var uri = 'detail?sn=' + S_SINGLE_REP.urlSn;
            if(reportType === "ips_signature") {
                uri = uri + '&reptype=ips_detail&search=' + encodeURIComponent('signature=' + elem);
            }else if(reportType === "ips_source") {
                uri = uri + '&reptype=ips_detail&search=' + encodeURIComponent('source=' + elem);
            }else if(reportType === "ips_threat") {
                uri = uri + '&reptype=ips_detail&search=' + encodeURIComponent('threat=' + opts.severity);
            }else if(reportType === "ips_protocol") {
                uri = uri + '&reptype=ips_detail&search=' + encodeURIComponent('protocol=' + elem);
            }
            return "<a href='" + uri + "' class='detailviewLinks'>" + elem + "</a>";
        } else if(cellval.colModel.name === 'more_info') {
            return "<a href='" + S_SINGLE_REP.portal_link + opts.application +"' class='detailviewLinks' target='ipsportal'>"+ elem + "</a>";
        }
    },

    gavLinkFormatter : function (elem, cellval, opts) {
        if(cellval.colModel.name === 'application') {
            var reportType = $('#chart_select option:selected').val();
            var uri = 'detail?sn=' + S_SINGLE_REP.urlSn;
            if(reportType === "gav_virus") {
                uri = uri + '&reptype=gav_detail&search=' + encodeURIComponent('virus=' + elem);
            }else if(reportType === "gav_host") {
                uri = uri + '&reptype=gav_detail&search=' + encodeURIComponent('host=' + elem);
            }else if(reportType === "gav_protocol") {
                uri = uri + '&reptype=gav_detail&search=' + encodeURIComponent('protocol=' + elem);
            }else if(reportType === "gav_email") {
                uri = uri + '&reptype=gav_detail&search=' + encodeURIComponent('email=' + elem);
            }
        }
        return "<a href='" + uri + "' class='detailviewLinks'>" + elem + "</a>";
    },

    aptLinkFormatter : function (elem, cellval, opts) {
        if(cellval.colModel.name === 'application') {
            var reportType = $('#chart_select option:selected').val();
            var uri = 'detail?sn=' + S_SINGLE_REP.urlSn;
            if(reportType === "apt_malware_by_content" || reportType === "apt_malware_by_uuid") {
                uri = uri + '&reptype=apt_detail&search=' + encodeURIComponent('threat_id=' + elem);
            }else if(reportType === "apt_malicious_activity") {
                uri = uri + '&reptype=apt_detail&search=' + encodeURIComponent('activity=' + elem);
            }else if(reportType === "apt_mime") {
                uri = uri + '&reptype=apt_detail&search=' + encodeURIComponent('mime_type=' + elem);
            }else if(reportType === "apt_protocol") {
                uri = uri + '&reptype=apt_detail&search=' + encodeURIComponent('protocol=' + elem);
            }else if(reportType === "apt_destination") {
                uri = uri + '&reptype=apt_detail&search=' + encodeURIComponent('recipient_destination=' + elem);
            }else if(reportType === "apt_source") {
                uri = uri + '&reptype=apt_detail&search=' + encodeURIComponent('sender_source=' + elem);
            }else if(reportType === "apt_threat") {
                uri = uri + '&reptype=apt_detail&search=' + encodeURIComponent('threat_level=' + elem);
            }else if(reportType === "undetected_apt_malware_by_content" || reportType === "undetected_apt_malware_by_uuid") {
                uri = uri + '&reptype=undetected_apt_detail&search=' + encodeURIComponent('threat_id=' + elem);
            }else if(reportType === "undetected_apt_malicious_activity") {
                uri = uri + '&reptype=undetected_apt_detail&search=' + encodeURIComponent('activity=' + elem);
            }else if(reportType === "undetected_apt_destination") {
                uri = uri + '&reptype=undetected_apt_detail&search=' + encodeURIComponent('recipient_destination=' + elem);
            }else if(reportType === "undetected_apt_threat") {
                uri = uri + '&reptype=undetected_apt_detail&search=' + encodeURIComponent('threat_level=' + elem);
            }
            return "<a href='" + uri + "' class='detailviewLinks'>" + elem + "</a>";
        } else if(cellval.colModel.name === 'more_info') {
            var app= opts.application;
            return "<a href='' id='" + opts.application + "' class='detaildialog detailviewLinks' >"+ elem + "</a>";
        }
    }
};
$(document).ready(S_SINGLE_REP.init);
