var S_DB = {

    poller: null,

    // setup the page
    init : function () {
        S_DB.initUI();
        S_DB.initEvents();
    },

    // initialize UI elements
    initUI : function () {
        WGRD.enableUIElements(false, ['#btn_db_start', '#btn_db_stop', '#btn_db_restart']);

        S_DB.toggleBuiltinInfo(using_local_db);

        S_DB.createProcessGrid();
        S_DB.refreshLogList();
        S_DB.updateDbInfo();
        S_DB.refreshStatusReport();
    },

    // add event handlers
    initEvents : function () {
        $('#btn_db_start').button().click(S_DB.startDb);
        $('#btn_db_stop').button().click(S_DB.stopDb);
        $('#btn_db_restart').button().click(S_DB.restartDb);

        $('#refresh_process_table').button().click(function() {
            var attr = $('#refresh_process_table').attr('disabled');
            if (attr !== 'true' && attr !== 'disabled') {
                $('#process_table').jqGrid('setGridParam', {loadui: 'block', datatype: S_DB.refreshProcessGrid()});
            }
        });

        $('#refresh_log_list').button().click(function() {
            var attr = $('#refresh_log_list').attr('disabled');
            if (attr !== 'true' && attr !== 'disabled') {
                S_DB.refreshLogList();
            }
        });

        $('#log_select').change(function() {
            $('#refresh_log').click();
        });

        $('#refresh_log').button().click(function() {
            var attr = $('#refresh_log').attr('disabled');
            if (attr !== 'true' && attr !== 'disabled') {
                S_DB.refreshLog();
            }
        });

        $('#btn_refresh_status_report').button().click(S_DB.refreshStatusReport);

        $(window).bind('resizeEnd', function() {
            S_DB.doResize();
        });

        // start a poller to refresh the db info every minute
        S_DB.poller = new POLLER('db_info', {'interval': '5'}, 60000, S_DB.dbInfoRefreshSuccessHandler, S_DB.dbInfoRefreshErrorHandler);
    },

    dbInfoRefreshSuccessHandler : function(response) {
        S_DB.updateDbInfoUI(response);
        return true;
    },

    dbInfoRefreshErrorHandler : function(response, num_failed) {
        return true;
    },

    startDb : function() {
        S_DB.dbAction('start');
    },

    stopDb : function() {
        S_DB.dbAction('stop');
    },

    restartDb : function() {
        S_DB.dbAction('restart');
    },

    dbAction : function(param) {
        $('#progress_db_action').show();
        WGRD.enableUIElements(false, ['#btn_db_start', '#btn_db_stop', '#btn_db_restart']);
        if (S_DB.poller !== null) {
            S_DB.poller.pause();
        }

        $.ajax({
            url: 'db_action?action='+param+'&db_loc='+$('#db_location').text(),
            type: 'POST',
            dataType: 'json',
            data: '',
            success: S_DB.updateDbInfo,
            error: S_DB.updateDbInfo
        });
    },

    // ajax call to get some updated db info and refresh the UI
    updateDbInfo : function() {
        $.ajax({
            url: 'db_info',
            type: 'POST',
            dataType: 'json',
            data: {'interval': 0.2},
            success: function(data) {
                S_DB.updateDbInfoUI(data);
            }
        });
    },

    updateDbInfoUI: function(data) {
        typeof data.db_location == "undefined" ? $('#db_location').html('') : $('#db_location').html(data.db_location);
        typeof data.uptime == "undefined" ? $('#db_uptime').html('') : $('#db_uptime').html(data.uptime);
        typeof data.memory == "undefined" ? $('#db_memory').html('') : $('#db_memory').html(data.memory);
        typeof data.disk_usage == "undefined" ? $('#db_du').html('') : $('#db_du').html(data.disk_usage);

        var avail_str = '';
        if (typeof data.db_avail != "undefined") {
            avail_str += data.db_avail;
        }
        if (typeof data.db_status != "undefined") {
            if (avail_str.length === 0) {
                avail_str = data.db_avail;
            }
            else if (data.db_status.length > 0) {
                avail_str += ' <em>(' + data.db_status + ')</em>';
            }
        }
        $('#db_avail').html(avail_str);

        if (typeof data.avail == "undefined" || data.avail === -1 || data.using_local_db === 0) {
            // server is not available or is remote
            WGRD.enableUIElements(false, ['#btn_db_start', '#btn_db_stop', '#btn_db_restart']);
        }
        else if (data.avail !== 1) {
            // db is not available
            WGRD.enableUIElements(true, ['#btn_db_start']);
            WGRD.enableUIElements(false, ['#btn_db_stop', '#btn_db_restart']);
        }
        else {
            // db is available
            WGRD.enableUIElements(true, ['#btn_db_stop', '#btn_db_restart']);
            WGRD.enableUIElements(false, ['#btn_db_start']);
        }

        // hide/show the process info and logs depending on if it is a builtin db or not
        S_DB.toggleBuiltinInfo(data.using_local_db);

        $('#progress_db_action').hide();
        if (S_DB.poller !== null) {
            S_DB.poller.resume(false);
        }
    },

    toggleBuiltinInfo: function(local_db) {
        if (local_db === 0) {
            $('#processes_div').hide();
            $('#log_panel_div').hide();
        }
        else {
            $('#processes_div').show();
            $('#log_panel_div').show();
        }
    },

    createProcessGrid: function() {
        $('#process_table').jqGrid({
            loadonce: true,
            loadui: 'block',
            datatype: S_DB.refreshProcessGrid,
            height:'auto',
            autowidth: true,
            shrinkToFit: true,
            colNames: procTableColNames,
            colModel: procTableColModel,
            sortname: 'name',
            viewrecords: true,
            sortorder: 'asc'
        });
    },

    refreshProcessGrid: function() {
        WGRD.enableUIElements(false, ['#refresh_process_table']);
        $('#progress_refresh_process_table').show();
        $('#process_table').jqGrid('clearGridData');

        $.ajax({
            url: 'process_info',
            type: 'POST',
            dataType: 'json',
            data: '',
            success: function(data) {
                // update the table with the new data
                $('#process_table').jqGrid('setGridParam', {
                    rowNum: data.length,  // show all rows
                    datatype: 'local',
                    data: data
                });
                $('#process_table').trigger('reloadGrid');
            },
            error: function(response) {
                $('#process_table').jqGrid('setGridParam', {datatype: 'local'});
            },
            complete: function() {
                $('#progress_refresh_process_table').hide();
                WGRD.enableUIElements(true, ['#refresh_process_table']);
                S_DB.doResize();
            }
        });
    },

    refreshLogList: function() {
        WGRD.enableUIElements(false, ['#log_select', '#refresh_log_list']);
        $('#progress_refresh_log_list').show();

        var sel_log = $('#log_select').val();

        $.ajax({
            url: 'get_log_list',
            type: 'POST',
            dataType: 'json',
            data: '',
            success: function(response) {
                // update the choice box with the new data
                $('#log_select option').remove();
                var found_log = false;
                $.each(response.data, function(index, item) {
                    $('#log_select').append('<option value="'+item+'">'+item+'</option>');
                    if (item === sel_log) {
                        found_log = true;
                    }
                });

                // refresh log contents if selected log changed
                if (found_log) {
                    $('#log_select').val(sel_log);
                }
                else if ($('#log_select').val()) {
                    S_DB.refreshLog();
                }
                else {
                    WGRD.enableUIElements(false, ['#refresh_log']);
                    $('#progress_refresh_log').hide();
                }
            },
            error: function(response) {
                $('#log_contents').val('');
            },
            complete: function() {
                $('#progress_refresh_log_list').hide();
                WGRD.enableUIElements(true, ['#log_select', '#refresh_log_list']);
            }
        });
    },

    refreshLog: function() {
        WGRD.enableUIElements(false, ['#refresh_log', '#log_select', '#refresh_log_list']);
        $('#progress_refresh_log').show();
        $('#log_contents').val('');

        var lines = 100;  // default
        var error = WGRD.isValidNumeric($('#log_lines'), '');
        if (!error || error.length === 0) {
            lines = parseInt($('#log_lines').val(), 10);
        }
        else {
            $('#log_lines').val(lines);
        }

        if ($('#log_select').val() !== null) {
            $.ajax({
                url: 'get_log',
                type: 'POST',
                dataType: 'json',
                data: {'log_name': $('#log_select').val(), 'num_lines': lines},
                success: function(response) {
                    // update the text area with the new data
                    $('#log_contents').val(response.data);
                },
                error: function(response) {
                    $('#log_contents').val('');
                },
                complete: function() {
                    $('#progress_refresh_log').hide();
                    WGRD.enableUIElements(true, ['#refresh_log', '#log_select', '#refresh_log_list']);
                }
            });
        }
    },

    refreshStatusReport : function() {
        WGRD.enableUIElements(false, ['#btn_refresh_status_report']);
        $('#progress_refresh_status_report').show();
        $('#status_report_results').val('');

        $.ajax({
            url: 'get_status_report',
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                // update the text area with the new data
                $('#status_report_results').val(response.data);
            },
            error: function(response) {
                $('#status_report_results').val('');
            },
            complete: function() {
                $('#progress_refresh_status_report').hide();
                WGRD.enableUIElements(true, ['#btn_refresh_status_report']);
            }
        });
    },

    doResize: function() {
        var padleft = parseInt($("#processes_div").css('margin-left'), 10);
        var grid_width = $("#processes_div").width() - padleft * 2;
        $('#process_table').setGridWidth(grid_width);
    }

};
$(document).ready(S_DB.init);
