var S_LS_B = {

    // setup the page
    init : function () {
        S_LS_B.initUI();
        S_LS_B.initEvents();
    },

    // initialize UI elements
    initUI : function () {
        $('#no_backups_str').text(S_NO_BACKUPS);
        $('#progress_backup_now').hide();

        // disable the controls/buttons if remote backups are disabled
        if (!remote_backup_enabled) {
            $('#no_backups').show();
            WGRD.enableUIElements(false, ['#start_date_val', '#end_date_val', '#backup_now']);
        }
        $("#start_date span, #end_date span").bind('click', function(e) {
            if ($('#start_date_val').hasClass('disabled')) {
                e.stopImmediatePropagation();
            }
        });

        $('#start_date').datetimepicker({
            pickDate: true,
            pickTime: true,
            pick12HourFormat: true,
            pickSeconds: false
        });
        $('#start_date').data('datetimepicker').setLocalDate(new Date());

        $('#end_date').datetimepicker({
            pickDate: true,
            pickTime: true,
            pick12HourFormat: true,
            pickSeconds: false
        });
        $('#end_date').data('datetimepicker').setLocalDate(new Date());

        // detect if any fields are changed
        var flds = $("input", window.document);
        flds.live('change keyup', function() {
            $('#error_container').hide();
        });
    },

    // add event handlers
    initEvents : function () {
        $('#backup_now').button().click(S_LS_B.backupDb);
    },

    // handle create DB backup action
    backupDb : function () {
        // verify the start time is before the end time
        // note: start time and end time can be empty
        var start_date = $('#start_date').data('datetimepicker').getLocalDate(new Date());
        var end_date = $('#end_date').data('datetimepicker').getLocalDate(new Date());
        if (start_date == null || end_date == null) {
            writeErrorContainer(S_EMPTY_TIME, false);
            return;
        }
        if (start_date.getTime() > end_date.getTime()) {
            writeErrorContainer(S_ERROR_TIME, false);
            return;
        }

        $('#backup_now').attr('disabled', true);
        $('#progress_backup_now').show();

        var data = {
            'start_time': start_date.getTime(),
            'end_time': end_date.getTime()
        };

        $.ajax({
            url: 'create_backup_now',
            type: 'POST',
            dataType: 'json',
            data: data,
            success: S_LS_B.backupDbResults,
            error: S_LS_B.backupDbResultsError
        });
    },

    backupDbResults : function (data) {
        $('#progress_backup_now').hide();
        window.alert(data.message);
        $('#backup_now').attr('disabled', false);
    },

    backupDbResultsError : function (data) {
        $('#progress_backup_now').hide();
        window.alert(data.statusText + ": " + data.status);
        $('#backup_now').attr('disabled', false);
    }

};
$(document).ready(S_LS_B.init);
