var S_LS_C = {

    needs_restart: false,      // track if we need to restart the server after save
    db_password_changed: false,
    db_password_value: '', // Used to restore the database password when a user clicks away from that field.
    email_password_changed: false,
    email_password_value: '', // Used to restore the email password when a user clicks away from that field.

    // setup the page
    init : function () {
        S_LS_C.initUI();
        S_LS_C.initEvents();
        S_LS_C.initHelp();
    },

    // initialize UI elements
    initUI : function () {
        $("#dialog_comments").modal({
            show: false,
            backdrop: 'static'
        });

        $('#progress_test_db_conn').hide();
        $('#test_db_conn_results').hide();
        $('#progress_test_email').hide();
        $('#test_email_results').hide();
        $('#progress_save').hide();
        $('#progress_restarting').hide();
        $('#error_container').hide();

        S_LS_C.email_password_value = $('#email_password').val();
        S_LS_C.db_password_value = $('#db_password').val();

        // email and notifications
        S_LS_C.toggleEmailEnable();
        S_LS_C.checkNotifEnable();

        // DB backup settings
        // configure the backup time picker
        $('#db_backup_time').datetimepicker({
            pickDate: false,
            pickTime: true,
            pick12HourFormat: true,
            pickSeconds: false
        });

        // convert backup_time_org to local time as HH:mm
        $('#db_backup_time').data('datetimepicker').setLocalDate(utcTimeStrToDate(backup_time_org, false));
        $('#db_backup_time').data('datetimepicker').disable();  // disable by default; it will be enabled later if needed

        // convert the last/next backup run time to local time UTC time string
        S_LS_C.updateLastDbBackupTime();
        S_LS_C.updateNextDbBackupTime();

        S_LS_C.toggleDbBackupEnable(false);

        S_LS_C.toggleDeleteLogAge();

        // DB location settings
        if (show_db_builtin === 'checked') {
            S_LS_C.showDbBuiltin();
        }
        else {
            S_LS_C.showDbExternal();
        }

        // logging
        if (use_syslog === 1) {
            S_LS_C.showSyslog();
        }
        else {
            S_LS_C.showWindowsLog();
        }
        S_LS_C.toggleEncryptionKeyEnable();
        S_LS_C.toggleEventViewerEnable();
        S_LS_C.toggleSyslogEnable();
        S_LS_C.toggleFileEnable();

        $('#options_level_event_viewer').val('1');
        $('#options_level_syslog').val('1');
        $('#options_level_file').val('1');
        if ($('#event_viewer_enable').is(':checked')) {
            $('#options_level_event_viewer').val(org_system_log_level);
        }
        if ($('#syslog_enable').is(':checked')) {
            $('#options_level_syslog').val(org_system_log_level);
        }
        if ($('#file_enable').is(':checked')) {
            $('#options_level_file').val(org_file_log_level);
        }

        // detect if any fields are changed
        var flds = $("input, textarea", window.document);
        flds.live('change keyup', function() {
            $('#error_container').hide();
            $('#test_db_conn_results').hide();
            $('#test_email_results').hide();
        });

        //If user is in readonly mode, then grayout the entire UI
        //Only enable the report customization div and connectwise's company name div
        if (is_page_locked === 1) {
            WGRD.enableUI(false, ".tab-content");
            WGRD.enableUI(true, "#report_cust_list_div");
            WGRD.enableUI(true, "#cw_cnames_div");
            WGRD.enableUI(true, "#ftp_servers_list_div");
            WGRD.enableUIElements(true, ["#cust_close", '#add_close',
                                         '#ftp_close', '.wgrd-modal-close-x',
                                         '.close']);
        }

        S_USER_MODE.initUI(['#submit_button']);
        S_USER_MODE.show_warning_msg = true;
        $('#tabs a[href=' + selected_tab +']').tab('show');
        S_USER_MODE.selected_tab = selected_tab;
    },

    // add event handlers
    initEvents : function () {
        $('#change_encryption_key').click(S_LS_C.toggleEncryptionKeyEnable);
        $('#smtp_login_enable').click(S_LS_C.toggleEmailEnable);
        $('#notif_event_failure').click(S_LS_C.checkNotifEnable);
        $('#notif_event_received').click(S_LS_C.checkNotifEnable);
        $('#notif_event_purged').click(S_LS_C.checkNotifEnable);
        $('#submit_button').button().click(S_LS_C.savePage);
        $('#test_db_conn').button().click(S_LS_C.testDbConn);
        $('#test_email').button().click(S_LS_C.testEmail);
        $('#db_delete_log_age_enable').click(S_LS_C.toggleDeleteLogAge);
        $('#db_auto_backup').click(function() {
            S_LS_C.toggleDbBackupEnable(true);
        });
        $('#radio_db_builtin').change(S_LS_C.showDbBuiltin);
        $('#radio_db_external').change(S_LS_C.showDbExternal);
        $('#event_viewer_enable').click(S_LS_C.toggleEventViewerEnable);
        $('#syslog_enable').click(S_LS_C.toggleSyslogEnable);
        $('#file_enable').click(S_LS_C.toggleFileEnable);

        // button handlers for the comments dialog
        $('#comments_close_btn').click(function(event) {
            S_LS_C.cancelSave();
        });
        $('#comments_cancel_btn').click(function(event) {
            S_LS_C.cancelSave();
        });
        $('#comments_save_btn').click(function(event) {
            // close the dialog and proceed with the save
            $('#dialog_comments').modal('hide');
            S_LS_C._finishSave();
        });

        // Indicate that the pass has changed, and store its new value.
        $('#db_password').change(function(){
            S_LS_C.db_password_changed = true;
            S_LS_C.db_password_value = $('#db_password').val();
        });

        // When the user selects the password field, empty it.
        $('#db_password').focus(function(){$('#db_password').val('');});

        // Set the db password back to what it was from its blank form when the user moves on.
        $('#db_password').blur(function(){$('#db_password').val(S_LS_C.db_password_value);});

        // Indicate that the pass has changed, and store its new value.
        $('#email_password').change(function(){
            S_LS_C.email_password_changed = true;
            S_LS_C.email_password_value = $('#email_password').val();
        });

        // When the user selects the password field, empty it.
        $('#email_password').focus(function(){$('#email_password').val('');});

        // Set the email password back to what it was from its blank form when the user moves on.
        $('#email_password').blur(function(){$('#email_password').val(S_LS_C.email_password_value);});

        // start a poller to refresh the DB data every minute
        new POLLER('db_data', '', 60000, S_LS_C.dbRefreshSuccessHandler, S_LS_C.dbRefreshErrorHandler);

        //User mode changes
        S_USER_MODE.initEvents();
    },

    initHelp : function() {
        // Update help link based on tab selected
        $('#tabs a[href="#general"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7320;
            S_USER_MODE.selected_tab = "#general";
        });
        $('#tabs a[href="#notifications"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7321;
            S_USER_MODE.selected_tab = "#notifications";
        });
        $('#tabs a[href="#reporting"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7322;
            S_USER_MODE.selected_tab = "#reporting";
        });
        $('#tabs a[href="#logging"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7323;
            S_USER_MODE.selected_tab = "#logging";
        });
    },

    // ------------ DB/Server Info -----------------------------------------------------

    dbRefreshSuccessHandler : function(response) {
        S_LS_C.updateDBInfoUI(response);
        return true;
    },
    dbRefreshErrorHandler : function(response, num_failed) {
        return true;
    },

    // set the UI text based on the latest value of last_db_backup_time
    updateLastDbBackupTime : function() {
        if (last_db_backup_time.length === 0) {
            $('#last_backup_runtime').text(S_NONE);
        }
        else {
            var last_backup_d = createDateFromStr(last_db_backup_time);
            $('#last_backup_runtime').text(last_backup_d.toLocaleString());
        }
    },

    // set the UI text based on the latest value of next_db_backup_time
    updateNextDbBackupTime : function() {
        if (next_db_backup_time.length === 0) {
            $('#next_backup_runtime').text(S_NONE);
        }
        else {
            var next_backup_d = createDateFromStr(next_db_backup_time);
            $('#next_backup_runtime').text(next_backup_d.toLocaleString());
        }
    },

    toggleEmailEnable : function() {
        var enable = $('#smtp_login_enable').is(':checked');
        WGRD.enableUIElements(enable, ['#email_user_id', '#email_password']);
    },

    toggleDeleteLogAge : function() {
        var enable = $('#db_delete_log_age_enable').is(':checked');
        WGRD.enableUIElements(enable, ['#db_delete_log_age']);
    },

    toggleDbBackupEnable : function(show_warning) {
        var enable = $('#db_auto_backup').is(':checked');
        WGRD.enableUIElements(enable, ['#db_backup_day']);
        if (enable) {
            $('#db_backup_time').data('datetimepicker').enable();
            if (show_warning && !remote_backup_enabled) {
                // show a notification dialog telling the admin that system backup configuration is required
                WGRD.okMessageModal(S_BACKUP_MESSAGE, S_BACKUP_TITLE);
            }
        }
        else {
            $('#db_backup_time').data('datetimepicker').disable();
        }
    },

    checkNotifEnable : function() {
        var some_checked = $('#notif_event_failure').is(':checked') || $('#notif_event_received').is(':checked') || $('#notif_event_purged').is(':checked');
        WGRD.enableUIElements(some_checked, ['#email_to_address', '#email_from_address', '#email_subject', '#test_email']);
    },

    showDbBuiltin : function() {
        $('#db_builtin').show();
        $('#db_external').hide();
    },

    showDbExternal : function() {
        $('#db_builtin').hide();
        $('#db_external').show();
    },

    showWindowsLog : function() {
        $('#logging_windows').show();
        $('#logging_syslog').hide();
    },

    showSyslog : function() {
        $('#logging_windows').hide();
        $('#logging_syslog').hide(); // don't show syslog until we expose configuring a remote syslog server
    },

    toggleEncryptionKeyEnable : function() {
        var enable = $('#change_encryption_key').is(':checked');
        WGRD.enableUIElements(enable, ['#encryption_key', '#encryption_key_confirm']);
    },

    toggleEventViewerEnable : function() {
        var enable = $('#event_viewer_enable').is(':checked');
        WGRD.enableUIElements(enable, ['#options_level_event_viewer']);
    },

    toggleSyslogEnable : function() {
        var enable = $('#syslog_enable').is(':checked');
        WGRD.enableUIElements(enable, ['#options_level_syslog']);
    },

    toggleFileEnable : function() {
        var enable = $('#file_enable').is(':checked');
        WGRD.enableUIElements(enable, ['#options_level_file']);
    },

    testDbConn : function() {
        if (!S_LS_C.validateExternalDB()) {
            return;
        }

        $('#test_db_conn').button({'disabled': true});
        $('#test_db_conn_results').hide();
        $('#progress_test_db_conn').show();

        var db_password = S_LS_C.db_password_changed ? $('#db_password').val(): null;

        var test_data = {
                'name': $('#db_name').val(),
                'user': $('#db_user_name').val(),
                'host': IPHELPER.trimIP4($('#db_host').val()),
                'password': db_password,
                'port': parseInt($('#db_port').val(), 10)
        };

        $.ajax({
            url: 'test_db_conn',
            type: 'POST',
            dataType: 'json',
            data: test_data,
            success: S_LS_C.testDbResults,
            error: S_LS_C.testDbResultsError
        });
    },

    testDbResults : function(data) {
        $('#progress_test_db_conn').hide();

        if (data.status) {
            $('#test_db_conn_results').attr('class', 'success');
        }
        else {
            $('#test_db_conn_results').attr('class', 'fail');
        }
        $('#test_db_conn_results').text(data.message);
        $('#test_db_conn_results').show();
        $('#test_db_conn').button({'disabled': false});
    },

    testDbResultsError : function(data) {
        $('#progress_test_db_conn').hide();
        $('#test_db_conn_results').attr('class', 'fail');
        $('#test_db_conn_results').text(data.statusText + ": " + data.status);
        $('#test_db_conn_results').show();
        $('#test_db_conn').button({'disabled': false});
    },

    testEmail : function() {
        // check if any values have been changed and prompt to save first
        var changed = false;
        if ($('#email_host').val() !== org_email_host) {
            changed = true;
        }
        else if (isChecked('#smtp_login_enable') !== org_smtp_login_enable) {
            changed = true;
        }
        else if (isChecked('#starttls_enable') !== org_starttls_enable) {
            changed = true;
        }
        else if ($('#smtp_login_enable').is(':checked') &&
                ($('#email_user_id').val() !== org_email_user_id ||
                 S_LS_C.email_password_changed)) {
                changed = true;
        }
        else if ($('#email_to_address').val() !== org_email_to_address ||
                 $('#email_from_address').val() !== org_email_from_address ||
                 $('#email_subject').val() !== org_email_subject) {
            changed = true;
        }

        if (changed) {
            if (!confirm(S_CONFIRM_SAVE_BEFORE_TEST)) {
                return;
            }
        }

        $('#test_email').attr('disabled', true);
        $('#test_email_results').hide();
        $('#progress_test_email').show();

        $.ajax({
            url: 'test_email',
            type: 'POST',
            dataType: 'json',
            data: '',
            success: S_LS_C.testEmailResults,
            error: S_LS_C.testEmailResultsError
        });
    },

    testEmailResults : function(data) {
        $('#progress_test_email').hide();

        if (data.status) {
            $('#test_email_results').attr('class', 'success');
        }
        else {
            $('#test_email_results').attr('class', 'fail');
        }
        $('#test_email_results').text(data.message);
        $('#test_email_results').show();
        $('#test_email').attr('disabled', false);
    },

    testEmailResultsError : function(data) {
        $('#progress_test_email').hide();
        $('#test_email_results').attr('class', 'fail');
        $('#test_email_results').text(data.statusText + ": " + data.status);
        $('#test_email_results').show();
        $('#test_email').attr('disabled', false);
    },

    // ajax call to get some updated db-related info and refresh the UI
    updateDBInfo : function() {
        $.ajax({
            url: 'db_data',
            type: 'POST',
            dataType: 'json',
            data: '',
            success: function(data) {
                S_LS_C.updateDBInfoUI(data);
            }
        });
    },

    // update the DB related UI from the ajax response data
    updateDBInfoUI : function(data) {
        curr_db_size = data.db_curr_size;
        last_db_backup_time = data.db_last_backup_runtime;
        next_db_backup_time = data.db_next_backup_runtime;

        $('#db_curr_size').text(data.db_curr_size + " ");
        $('#db_avail_space').text(data.db_avail_space + " " + S_GB + " (" + data.db_percent_free + ")");
        S_LS_C.updateLastDbBackupTime();
        S_LS_C.updateNextDbBackupTime();
    },

    restartLogServer : function() {
        $('#submit_button').attr('disabled', true);
        $('#progress_restarting').show();
        $.ajax({
            url: 'server_action?action=restart',
            type: 'POST',
            dataType: 'json',
            data: '',
            success: S_LS_C.restartResults,
            error: S_LS_C.restartResultsError
        });
    },

    restartResults : function(data) {
        $('#progress_restarting').hide();
        $('#submit_button').removeAttr('disabled');
        if (!data.status) {
            writeErrorContainer(data.message, false);
        }
        else {
            // reload the page if we connected to a new DB
            location.reload();
        }
    },

    restartResultsError : function(data) {
        $('#progress_restarting').hide();
        $('#submit_button').removeAttr('disabled');
        writeErrorContainer(S_ERROR_RESTART_FAILED, false);
    },

    // ------------ Validation ---------------------------------------------------------

    // validate all UI input
    validateUI : function() {
        //
        // general tab
        //

        // see if we are changing the encryption key
        if (isChecked('#change_encryption_key')) {
            if ($('#encryption_key').val().length === 0) {
                // don't allow empty encryption key
                writeErrorContainer(S_ERROR_ENCRYPT_KEY_EMPTY, false);
                return false;
            }
            else {
                // verify encryption_key and confirm_encryption_key values match
                if ($('#encryption_key').val() !== $('#encryption_key_confirm').val()) {
                    $('#tabs a[href="#general"]').tab('show');
                    $('#encryption_key').focus();
                    $('#encryption_key').select();
                    writeErrorContainer(S_ERROR_ENCRYPT_KEY_MISMATCH, false);
                    return false;
                }
            }
        }

        // max db size - 1-10000
        // can't be less than current size
        if (!db_auto_size) {
            var db_max_size_error = WGRD.isValidNumeric($('#db_max_size'), S_MAX_DB_SIZE_NAME);
            if (!db_max_size_error || db_max_size_error.length === 0) {
                var db_max_size = parseInt($('#db_max_size').val(), 10);
                if (db_max_size < curr_db_size) {
                    db_max_size_error = S_ERROR_DB_SIZE_SMALL;
                }
            }
            if (db_max_size_error && db_max_size_error.length > 0) {
                $('#tabs a[href="#general"]').tab('show');
                $('#db_max_size').focus();
                $('#db_max_size').select();
                writeErrorContainer(db_max_size_error, false);
                return false;
            }
        }

        // log age deletion value
        if ($('#db_delete_log_age_enable').is(':checked')) {
            var db_delete_age_error = WGRD.isValidNumeric($('#db_delete_log_age'), S_DELETE_LOG_AGE_NAME);
            if (db_delete_age_error && db_delete_age_error.length > 0) {
                $('#tabs a[href="#general"]').tab('show');
                $('#db_delete_log_age').focus();
                $('#db_delete_log_age').select();
                writeErrorContainer(db_delete_age_error, false);
                return false;
            }
        }

        // backup settings
        if (isChecked('#db_auto_backup')) {
            // days 1-365
            var db_backup_day_error = WGRD.isValidNumeric($('#db_backup_day'), S_DB_BACKUP_DAY_NAME);
            if (db_backup_day_error && db_backup_day_error.length > 0) {
                $('#tabs a[href="#general"]').tab('show');
                $('#db_backup_day').focus();
                $('#db_backup_day').select();
                writeErrorContainer(db_backup_day_error, false);
                return false;
            }
        }

        // validate the external DB settings
        if (!S_LS_C.validateExternalDB()) {
            return false;
        }

        //validate connectwise settings
        if (!S_LS_CW_REP.validateConnectWise()) {
            return false;
        }
        //
        // Notifications tab
        //

        // verify mail server address > 0
        if (!S_LS_C.validateEmptyField('#email_host', 1, S_ERROR_SMTP_HOST)) {
            return false;
        }

        // if smtp checkbox is selected, verify username/password > 0
        if ($('#smtp_login_enable').is(':checked')) {
            if (!S_LS_C.validateEmptyField('#email_user_id', 1, S_ERROR_EMAIL_USER)) {
                return false;
            }
            if (S_LS_C.email_password_changed && !S_LS_C.validateEmptyField('#email_password', 1, S_ERROR_EMAIL_PASSWORD)) {
                return false;
            }
        }

        // if any notifications are enabled, require email from/to/subject
        if ($('#notif_event_failure').is(':checked') ||
            $('#notif_event_received').is(':checked') ||
            $('#notif_event_purged').is(':checked')) {

            var patt = /^[^\s]+@[^\s]+$/;  // basic sanity checking

            // email to address
            if (!S_LS_C.validateEmptyField('#email_to_address', 1, S_ERROR_EMAIL_TO_EMPTY)) {
                return false;
            }
            if (!patt.test($('#email_to_address').val())) {
                $('#tabs a[href="#notifications"]').tab('show');
                $('#email_to_address').focus();
                $('#email_to_address').select();
                writeErrorContainer(S_ERROR_EMAIL_TO_INVALID, false);
                return false;
            }

            // email from address
            if (!S_LS_C.validateEmptyField('#email_from_address', 1, S_ERROR_EMAIL_FROM_EMPTY)) {
                return false;
            }
            if (!patt.test($('#email_from_address').val())) {
                $('#tabs a[href="#notifications"]').tab('show');
                $('#email_from_address').focus();
                $('#email_from_address').select();
                writeErrorContainer(S_ERROR_EMAIL_FROM_INVALID, false);
                return false;
            }
        }

        // more tests for the SMTP server
        var host = $('#email_host').val();
        var colon = host.indexOf(":");
        var port = NaN;
        if (colon >= 0) {
            port = host.substring(colon+1, host.length);
            host = host.substring(0, colon);
            if (!/^[0-9]+$/.test(port)) {
                port = -1;
            }
            else {
                port = parseInt(port, 10);
                if (isNaN(port)) {
                    port = -1;
                }
            }
        }
        if (port < 1 || port > 65535) {
            $('#tabs a[href="#notifications"]').tab('show');
            $('#email_host').focus();
            $('#email_host').select();
            writeErrorContainer(S_ERROR_SMTP_HOST_PORT, false);
            return false;
        }
        if (host.length === 0) {
            $('#tabs a[href="#notifications"]').tab('show');
            $('#email_host').focus();
            $('#email_host').select();
            writeErrorContainer(S_ERROR_SMTP_HOST, false);
            return false;
        }
        if (host.indexOf(".") >= 0) {
            if ((!IPHELPER.validIP4(host) && !validateDomainNameStr(host))) {
                $('#tabs a[href="#notifications"]').tab('show');
                $('#email_host').focus();
                $('#email_host').select();
                writeErrorContainer(S_ERROR_SMTP_HOST_INVALID, false);
                return false;
            }
        }

        // warn the user if the db settings are changing
        var warn = false;
        if ((org_db_remote === '0' && isChecked('#radio_db_external')) ||
            (org_db_remote === '1' && !isChecked('#radio_db_external'))) {
            warn = true;
        }
        if (isChecked('#radio_db_external') && !warn) {
            if ($('#db_user_name').val() !== org_db_user_name) {
                warn = true;
            }
            else if (S_LS_C.db_password_changed) {
                warn = true;
            }
            else if (IPHELPER.trimIP4($('#db_host').val()) !== org_db_host) {
                warn = true;
            }
            else if ($('#db_port').val() !== org_db_port) {
                warn = true;
            }
            else if ($('#db_name').val() !== org_db_name) {
                warn = true;
            }
        }
        if (warn) {
            if (!confirm(S_DB_CHANGE_CONFIRMATION)) {
                return false;
            }
            else {
                S_LS_C.needs_restart = true;
            }
        }

        return true;
    },

    validateExternalDB : function() {
        // external DB
        if (isChecked('#radio_db_external')) {

            var patt = /.*[@=,\/_;#'"*?`\[\]\\].*/;

            // db name can't be empty or larger than 64 chars
            if (!S_LS_C.validateEmptyField('#db_name', 0, S_ERROR_DB_NAME_SIZE)) {
                return false;
            }
            else if ($('#db_name').val().length > 64) {
                $('#tabs a[href="#general"]').tab('show');
                $('#db_name').focus();
                $('#db_name').select();
                writeErrorContainer(S_ERROR_DB_NAME_LONG, false);
                return false;
            }
            else if (patt.test($('#db_name').val())) {
                $('#tabs a[href="#general"]').tab('show');
                $('#db_name').focus();
                $('#db_name').select();
                writeErrorContainer(S_ERROR_DB_NAME_CHARS, false);
                return false;
            }

            // IP address - allow 127.0.0.1 plus IpHelper.isUsableHostIP()
            if (!isValidIp($('#db_host'))) {
                $('#tabs a[href="#general"]').tab('show');
                $('#db_host').focus();
                $('#db_host').select();
                writeErrorContainer(S_ERROR_DB_IP, false);
                return false;
            }

            // port - 1-65535
            var db_port_error = WGRD.isValidNumeric($('#db_port'), S_DB_PORT_NAME);
            if (db_port_error && db_port_error.length > 0) {
                $('#tabs a[href="#general"]').tab('show');
                $('#db_port').focus();
                $('#db_port').select();
                writeErrorContainer(db_port_error, false);
                return false;
            }

            // username - can't be empty or larger than 64 chars; block special chars
            if (!S_LS_C.validateEmptyField('#db_user_name', 0, S_ERROR_DB_USER_NAME_SIZE)) {
                return false;
            }
            else if ($('#db_name').val().length > 64) {
                $('#tabs a[href="#general"]').tab('show');
                $('#db_user_name').focus();
                $('#db_user_name').select();
                writeErrorContainer(S_ERROR_DB_USER_NAME_LONG, false);
                return false;
            }
            else if (patt.test($('#db_user_name').val())) {
                $('#tabs a[href="#general"]').tab('show');
                $('#db_user_name').focus();
                $('#db_user_name').select();
                writeErrorContainer(S_ERROR_DB_USER_NAME_CHARS, false);
                return false;
            }

            // password cannot be empty
            if (!S_LS_C.validateEmptyField('#db_password', 0, S_ERROR_DB_PASSWORD_EMPTY)) {
                return false;
            }
        }

        return true;
    },

    validateEmptyField : function(elm_str, tab_index, error_str) {
        if ($(elm_str).val().length === 0) {
            return S_LS_C._show_error_msg(elm_str, tab_index, error_str);
        }
        return true;
    },

    get_db_max_size : function() {
        if (db_auto_size) {
            return org_max_db_size;
        }
        else {
            return parseInt($('#db_max_size').val(), 10);
        }
    },

    _show_error_msg : function(elm_str, tab_index, error_str) {
        $('#tabs li:eq(' + tab_index + ') a').tab('show');
        $(elm_str).focus();
        $(elm_str).select();
        writeErrorContainer(error_str, false);
        return false;
    },

    // called when the "Save" action is cancelled
    cancelSave : function() {
        $('#progress_save').hide();
        $('#submit_button').attr('disabled', false);
    },

    // entry point for submitting the changes to the server
    // this starts/controls the process of:
    //   1 - validate the UI
    //   2 - prompt for change comments
    //   3 - submit the changes to the server
    savePage : function() {
        $('#error_container').hide();
        $('#submit_button').attr('disabled', true);
        $('#progress_save').show();

        // reset the needs_restart flag; this may be set in validateUI() and may be used after putData()
        S_LS_C.needs_restart = false;

        // validate the input
        if (!S_LS_C.validateUI()) {
            // validation failed
            $('#submit_button').removeAttr('disabled');
            $('#progress_save').hide();
            return;
        }

        // prompt for config change (audit) comments and then save
        S_LS_C._getComments(S_LS_C._savePage);
    },

    // prompt for change comments and then proceed to _savePage()
    _getComments : function (next_action) {
        // check to see if we need to restart due to log settings change
        var show_restart = false;
        var new_log_level_system = "-1";
        if (use_syslog === 1) {
            if ($('#syslog_enable').is(':checked')) {
                new_log_level_system = $('#options_level_syslog').val();
            }
        }
        else {
            if ($('#event_viewer_enable').is(':checked')) {
                new_log_level_system = $('#options_level_event_viewer').val();
            }
        }

        var new_log_level_file = -1;
        if ($('#file_enable').is(':checked')) {
            new_log_level_file = $('#options_level_file').val();
        }

        if (new_log_level_system !== org_system_log_level ||
            new_log_level_file !== org_file_log_level) {
            show_restart = true;
        }

        // hide/show the checkbox
        if (show_restart) {
            $('#dialog_comments_restart').show();
            $('#restart_server').prop('checked', true);
        }
        else {
            $('#dialog_comments_restart').hide();
        }

        // disable the checkbox if needs_restart is already true (due to DB change)
        WGRD.enableUIElements(!S_LS_C.needs_restart, ['#restart_server']);
        if (S_LS_C.needs_restart) {
            $("form #restart_server").attr('checked', true);
        }

        // clear the old comments
        $('#change_comments').val('');

        // prompt for the change comments
        $("#dialog_comments").modal('show');
    },

    _finishSave : function() {
        // save the comments, set the restart flag and proceed to the next action
        var comments = $('#change_comments').val();
        if ($('#dialog_comments_restart').is(':visible') && isChecked('#restart_server')) {
            S_LS_C.needs_restart = true;
        }

        S_LS_C._savePage(comments);
    },

    // save the data to the server with optional audit comments
    _savePage : function (comments) {
        var obj = new LogServerConfigObj();

        obj.audit_comments = comments;

        obj.notif_event_failure = isChecked('#notif_event_failure');
        obj.notif_event_received = isChecked('#notif_event_received');
        obj.notif_event_purged = isChecked('#notif_event_purged');

        obj.smtp_login_enable = isChecked('#smtp_login_enable');
        obj.starttls_enable = isChecked('#starttls_enable');
        obj.log_del_flag = 0;

        obj.email_password = S_LS_C.email_password_changed ? $('#email_password').val() : null;
        obj.email_user_id = $.trim($('#email_user_id').val());
        obj.email_address = org_email_address;  // not exposed; preserve the value
        obj.email_host = $.trim($('#email_host').val());
        obj.email_subject = $.trim($('#email_subject').val());
        obj.email_from_address = $.trim($('#email_from_address').val());
        obj.email_to_address = $.trim($('#email_to_address').val());

        if (isChecked('#change_encryption_key')) {
            obj.encryption_key = $('#encryption_key').val();
        }
        else {
            obj.encryption_key = '';
        }

        obj.db_max_size = S_LS_C.get_db_max_size();
        if ($('#db_delete_log_age_enable').is(':checked')) {
            obj.db_delete_log_age = parseInt($('#db_delete_log_age').val(), 10);
        }
        else {
            obj.db_delete_log_age = -1;
        }

        obj.db_backup_enable = isChecked('#db_auto_backup');
        obj.db_run_backup_day = parseInt($('#db_backup_day').val(), 10);
        obj.db_run_backup_time = dateToUTCTimeStr($('#db_backup_time').data('datetimepicker').getLocalDate());
        obj.db_backup_file_dir = $('#db_backup_dir').val();

        obj.db_remote = isChecked('#radio_db_external');
        obj.db_name = $.trim($('#db_name').val());
        obj.db_host = IPHELPER.trimIP4($.trim($('#db_host').val()));
        obj.db_port = parseInt($('#db_port').val(), 10);
        obj.db_user_name = $('#db_user_name').val();
        obj.db_password = S_LS_C.db_password_changed ? $('#db_password').val() : null;
        obj.db_location = org_db_location; // preserve the DB location

        if ((org_db_remote === '0' && obj.db_remote) || (org_db_remote === '1' && !obj.db_remote)) {
            obj.db_remote_changed = true;
        }
        else {
            obj.db_remote_changed = false;
        }

        obj.log_level_system = -1;
        if (use_syslog === 1) {
            if ($('#syslog_enable').is(':checked')) {
                obj.log_level_system = parseInt($('#options_level_syslog').val(), 10);
            }
        }
        else {
            if ($('#event_viewer_enable').is(':checked')) {
                obj.log_level_system = parseInt($('#options_level_event_viewer').val(), 10);
            }
        }

        if ($('#file_enable').is(':checked')) {
            obj.log_level_file = parseInt($('#options_level_file').val(), 10);
            obj.log_file_dir = $('#log_file_location').val();
        }
        else {
            obj.log_level_file = -1;
            obj.log_file_dir = org_log_file_dir;
        }

        // preserving
        obj.db_size_warning_limit = db_size_warning_limit;
        obj.db_run_delete_time = db_run_delete_time;
        obj.db_days_retain_log = db_days_retain_log;
        obj.log_del_flag = log_del_flag;

        //get ConnectWise settings from cw_rep_customization.js file
        obj.cw_obj = S_LS_CW_REP.get_cw_obj();

        // get report customization settings from cw_rep_customization.js file
        obj.report_cust_list = S_LS_CW_REP.get_rep_cust_list();
        obj.rep_customization_cw_only = 0; // Save everything by default

        // get ftp servers from cw_rep_customization.js file
        obj.ftp_servers_list = S_LS_CW_REP.get_ftp_servers_list();

        // save the data to the server
        WGRD.putData(obj).success(function(response) {
            // we need to do some things after the save operations is successful
            if (response.status) {

                //
                // update all saved org_ variables to the latest values
                //

                // general
                org_max_db_size = S_LS_C.get_db_max_size();
                org_db_name = isChecked('#radio_db_external').toString();
                org_db_user_name = $('#db_user_name').val();
                org_db_host = IPHELPER.trimIP4($('#db_host').val());
                org_db_port = $('#db_port').val();
                org_db_name = $('#db_name').val();

                // notifs (update vals from UI)
                org_email_host = $('#email_host').val();
                org_smtp_login_enable = isChecked("#smtp_login_enable");
                org_starttls_enable = isChecked("#starttls_enable");
                org_email_user_id = $('#email_user_id').val();
                org_email_to_address = $('#email_to_address').val();
                org_email_from_address = $('#email_from_address').val();
                org_email_subject = $('#email_subject').val();

                // logging - none
                org_system_log_level = obj.log_level_system.toString();
                org_file_log_level = obj.log_level_file.toString();

                // clear the "change encryption key" checkbox
                $("#change_encryption_key").attr('checked', false);
                $('#encryption_key').val('');
                $('#encryption_key_confirm').val('');
                S_LS_C.toggleEncryptionKeyEnable();

                //
                // update the db last run time and db size
                //
                S_LS_C.updateDBInfo();

                //
                // restart the server, if needed
                //
                if (S_LS_C.needs_restart) {
                    S_LS_C.restartLogServer();
                } else {
                    WGRD.updateModeUI(1);  //Update the user mode div
                    WGRD.resetUserMode();  //Reset the lock after save
                }
            }
        });
    },

    showwaitcursor : function(prefix) {
        $('#'+prefix+'error').hide();
        $('#'+prefix+'loading').show();
        return true;
    }
};
$(document).ready(S_LS_C.init);
