var S_LS_CW_REP = {
    cw_password_changed : false,
    cw_password_value : '',
    ftp_password_changed : false,
    ftp_password_value : '',
    
    // setup the page
    init : function () {
        S_LS_CW_REP.initData();
        S_LS_CW_REP.initUI();
        S_LS_CW_REP.initEvents();
    },

    initData : function () {
        // data values are shown in html elements, so they need to be escaped before being displayed
        // we escape the data here and store them escaped at the client
        // data sent to the server must not be escaped
        // the javascript logic must consider whether a value is escaped or unescaped when working with it

        for (var i=0, len=report_cust_list.length; i < len; i++) {
            report_cust_list[i].header_text = escapeHtml(report_cust_list[i].header_text);
            report_cust_list[i].footer_text = escapeHtml(report_cust_list[i].footer_text);
            report_cust_list[i].name = escapeHtml(report_cust_list[i].name);
        }

        for (var i=0, len=ftp_servers_list.length; i < len; i++) {
            ftp_servers_list[i].server_name = escapeHtml(ftp_servers_list[i].server_name);
            ftp_servers_list[i].upload_location = escapeHtml(ftp_servers_list[i].upload_location);
            ftp_servers_list[i].user_name = escapeHtml(ftp_servers_list[i].user_name);
        }
    },

    // initialize UI elements
    initUI : function () {

        $('#save_cw_rep_button').hide();
        if (standalone_mode == 0) { //No need to do this if 1, since it will be done in configure.js
            $('#progress_save').hide();
            $('#error_container').hide();
            $('#save_cw_rep_button').button().click(S_LS_CW_REP.savePage);
            HELP_LINK_OVERRIDE = 7322;
        }

        S_LS_CW_REP.cw_password_value = $('#cw_password').val();

        var ids = ['#add_cw_cname', '#remove_cw_cname', '#add_report_cust',
                   '#add_save', '#cust_save', '#remove_report_cust',
                   '#add_ftp_server', '#remove_ftp_server','#ftp_save',
                   '#save_cw_rep_button'];

        S_USER_MODE.initUI(ids);
        S_USER_MODE.show_warning_msg = true;

        if (is_page_locked === 1) {
            $('#edit_cw_cname').val(S_VIEW_TEXT);
            $('#edit_report_cust').val(S_VIEW_TEXT);
            $('#edit_ftp_server').val(S_VIEW_TEXT);

            //If user is in readonly mode, then grayout the entire UI
            //Only enable the report customization div and connectwise's company name div
            WGRD.enableUI(false, "#log_configure_tab_reporting");
            WGRD.enableUI(true, "#report_cust_list_div");
            WGRD.enableUI(true, "#cw_cnames_div");
            WGRD.enableUI(true, "#ftp_servers_list_div");
        } else {
            $('#edit_cw_cname').val(S_EDIT_TEXT);
            $('#edit_report_cust').val(S_EDIT_TEXT);
            $('#edit_ftp_server').val(S_EDIT_TEXT);
        }

        // ConnectWise
        S_LS_CW_REP.toggleConnectWiseSettings();
        S_LS_CW_REP.updateConnectWiseUIButtons();

        if (selected_cw_tz !== '') {
            $('#cw_tz').val(selected_cw_tz);
        }

        $("#uploadCertFrame").load(function() {
            var data = $("#import_cert_dlg input[type=file]").val();
            if (data.length === 0) {
                $("#import_cert_error").show();
                return;
            }
            $("#import_cert_dlg").modal('hide');
            $(this).hide();
        });

        // report customizations
        S_LS_CW_REP.populateReportCustList();
        S_LS_CW_REP.updateReportCustUI();
        $('#cust_preview_btn').hide();  // hide the preview button until we support it

        //ftp server
        S_LS_CW_REP.populateFtpServerList();
        S_LS_CW_REP.updateFtpServerUI();
    },

     // add event handlers
    initEvents : function () {
         // ConnectWise
        $('#enable_cw').click(S_LS_CW_REP.toggleConnectWiseSettings);
        $('#add_cw_cname').button().click(S_LS_CW_REP.showCWModal);
        $('#edit_cw_cname').button().click(S_LS_CW_REP.showCWModal);
        $('#remove_cw_cname').button().click(S_LS_CW_REP.removeCW);
        $('#import_cert_btn').button().click(S_LS_CW_REP.importAction);
        $('#cw_cnames').change(S_LS_CW_REP.updateConnectWiseUIButtons);

        // Indicate that the pass has changed, and store its new value.
        $('#cw_password').change(function(){
            S_LS_CW_REP.cw_password_changed = true;
            S_LS_CW_REP.cw_password_value = $('#cw_password').val();
        });

        // When the user selects the password field, empty it.
        $('#cw_password').focus(function(){$('#cw_password').val('');});

        // Set the password back to what it was from its blank form when the user moves on.
        $('#cw_password').blur(function(){$('#cw_password').val(S_LS_CW_REP.cw_password_value);});

        // report customization
        $('#add_report_cust').click(S_LS_CW_REP.showReportCustModal);
        $('#edit_report_cust').click(S_LS_CW_REP.showReportCustModal);
        $('#remove_report_cust').click(S_LS_CW_REP.removeReportCust);
        $('#report_cust_list').change(S_LS_CW_REP.updateReportCustUI);

        // ftp server settings
        $('#add_ftp_server').click(S_LS_CW_REP.showFtpModal);
        $('#edit_ftp_server').click(S_LS_CW_REP.showFtpModal);
        $('#remove_ftp_server').click(S_LS_CW_REP.removeFtpServer);
        $('#ftp_servers_list').change(S_LS_CW_REP.updateFtpServerUI);

        // Indicate that the ftp password has changed.
        $('#ftp_pass').change(function(){
            S_LS_CW_REP.ftp_password_changed = true;
            S_LS_CW_REP.ftp_password_value = $('#ftp_pass').val();
        });

        // When the user selects the password field, empty it.
        $('#ftp_pass').focus(function(){$('#ftp_pass').val('');});

        // Set the password back to what it was from its blank form when the user moves on.
        $('#ftp_pass').blur(function(){$('#ftp_pass').val(S_LS_CW_REP.ftp_password_value);});
        
        //Test ftp button
        $('#test_ftp_btn').on('click', S_LS_CW_REP.testFTP);

        if (standalone_mode == 0) { //No need to do this if 1, since it will be done in configure.js
            S_USER_MODE.save_btn_id = '#save_cw_rep_button';
            S_USER_MODE.initEvents();
        }
    },

    // ------------ ConnectWise --------------------------------------------------------

    importAction : function() {
        $("#import_cert_dlg input[type=file]").val("");
        $("#import_cert_error").hide();
        $("#import_cert_dlg").modal();
    },

    /*
       Called when add or Edit buttons are clicked for connectWise company names
       If edit, then pass in row data
    */
    showCWModal : function() {
        var button_id = $(this).attr('id');
        var params = {'parent_id': button_id};
        if (button_id === 'edit_cw_cname') {
            var selected = $('#cw_cnames :selected').length;
            if (selected === 0) {
                return;
            }
        }
        WGRD.doModal('#manage_cw_dlg',
                     S_LS_CW_REP.initializeCW,
                     S_LS_CW_REP.saveCW,
                     params);
    },

    initializeCW : function(params) {
        var parent_id = params.parent_id;

        if (parent_id === 'add_cw_cname') { // Initialize UI
            S_LS_CW_REP._add_CW();
        } else { //Update UI
            S_LS_CW_REP._edit_CW();
        }

        return true;
    },

    _add_CW : function() {
        //Set title
        $('#manage_cw_dlg h3').text(S_ADD_CNAME_TITLE);

        //Reset UI
        $('#managed_id').attr('disabled',false)
                        .val("");
        $('#managed_sol').val("");
    },

    _edit_CW : function() {

        //Set title
        if (is_page_locked === 1) {
            $('#manage_cw_dlg h3').text(S_VIEW_CNAME_TITLE);
        } else {
            $('#manage_cw_dlg h3').text(S_EDIT_CNAME_TITLE);
        }

        //Update UI
        var cname = $('#cw_cnames :selected').text();
        var sol_name = $('#cw_cnames :selected').val();

        $('#managed_id').attr('disabled',true)
                        .val(cname);
        $('#managed_sol').val(sol_name);
    },

    saveCW : function(params) {
        var parent_id = params.parent_id;
        if ( parent_id === 'add_cw_cname') {
            return S_LS_CW_REP._save_cw();
        } else {
            return S_LS_CW_REP._update_cw();
        }
    },

    _save_cw : function() {

        var managed_id = $('#managed_id').val();
        var managed_sol = $('#managed_sol').val();

        if (managed_id.length === 0) {
            return S_MGD_ID_EMPTY;
        }
        if ($('#cw_cnames option[id="' + managed_id +'"]').length > 0) {
            $('#managed_id').focus();
            $('#managed_id').select();
            return S_MGD_ID;
        }
        if (managed_id.length > 50) {
            return S_MGD_ID_LONG;
        }
        if (managed_sol.length === 0) {
            return S_MGMT_SOL_EMPTY;
        }
        if (managed_sol.length > 30) {
            return S_MGMT_SOL_LONG;
        }

        managed_id = escapeHtml(managed_id);
        managed_sol = escapeHtml(managed_sol);
        $('#cw_cnames').append('<option id="' + managed_id  +
                                   '"value="' + managed_sol + '">' +
                                                managed_id  + '</option>');
    },

    _update_cw : function() {
        var managed_sol = $('#managed_sol').val();

        if (managed_sol.length > 30) {
            return S_MGMT_SOL_LONG;
        }
        $('#cw_cnames :selected').val(escapeHtml(managed_sol));
    },

    removeCW : function() {
        var selected = $('#cw_cnames :selected').length;
        if (selected === 0) {
            return;
        }

        var selected_cname = $('#cw_cnames').val();
        $('#cw_cnames option[value="' + selected_cname + '"]').remove();
        S_LS_CW_REP.updateConnectWiseUIButtons();
    },

    toggleConnectWiseSettings : function() {
        var enable = $('#enable_cw').is(':checked');
        if(enable) {
            $('#cw').show();
        } else {
            $('#cw').hide();
        }
    },

    updateConnectWiseUIButtons  : function() {
        // enable/disable buttons
        if ($('#cw_cnames :selected').length === 0) {
            WGRD.enableUIElements(false, ['#edit_cw_cname', '#remove_cw_cname']);
        }
        else {
            WGRD.enableUIElements(true, ['#edit_cw_cname', '#remove_cw_cname']);
        }
    },

    // ------------ Report Customizations  ---------------------------------------------

    populateReportCustList: function() {
        for (var i = 0; i < report_cust_list.length; i++) {
            var name = report_cust_list[i].name;
            if (report_cust_list[i].is_default) {
                $('#report_cust_list').append('<option value="' + name + '">' + name + S_DEFAULT + '</option>');
            }
            else {
                $('#report_cust_list').append('<option value="' + name + '">' + name + '</option>');
            }
        }
    },

    updateReportCustUI: function() {
        // enable/disable buttons
        if ($('#report_cust_list :selected').length === 0) {
            WGRD.enableUIElements(false, ['#edit_report_cust', '#remove_report_cust']);
        }
        else {
            WGRD.enableUIElements(true, ['#edit_report_cust', '#remove_report_cust']);
        }

        // set the customization note
        $('#report_cust_note').html(S_RPT_NOTE_DEF);
        for (var i = 0; i < report_cust_list.length; i++) {
            if (report_cust_list[i].is_default) {
                $('#report_cust_note').html(S_RPT_NOTE_CUST);
                break;
            }
        }
    },

    showReportCustModal: function() {
        var button_id = $(this).attr('id');
        var params = {'new_mode': true};
        if (button_id === 'edit_report_cust') {
            if ($('#report_cust_list :selected').length === 0) {
                return;
            }
            params.new_mode = false;
        }
        WGRD.doModal('#report_cust_dlg',
                     S_LS_CW_REP.initializeReportCust,
                     S_LS_CW_REP.saveReportCust,
                     params);
    },

    initializeReportCust: function(params) {
        // clear any existing logo related divs from the iframe
        $('#custReportFrame').empty();
        $('#cust_report_form')[0].reset();  // needed to clear the file input in IE

        // Initialize UI
        if (params.new_mode) {
            // add dialog
            $('#report_cust_dlg h3').text(S_CUST_REPORT_ADD_TITLE);
            WGRD.enableUIElements(true, ['#cust_name']);
            $('#cust_name').val('');
            $('#cust_header').val('');
            $('#cust_footer').val('');
            $('#cust_logo_edit_note').hide();
            $('#cust_default').prop('checked', false);
        }
        else {
            // edit dialog
            var name = $('#report_cust_list').val();
            if (is_page_locked === 1) {
                $('#report_cust_dlg h3').text(S_CUST_REPORT_VIEW_TITLE);
            } else{
                $('#report_cust_dlg h3').text(S_CUST_REPORT_EDIT_TITLE);
            }
            WGRD.enableUIElements(false, ['#cust_name']);
            $('#cust_name').val(name);
            for (var i = 0; i < report_cust_list.length; i++) {
                if (report_cust_list[i].name === name) {
                    $('#cust_header').val(unescapeHtml(report_cust_list[i].header_text));
                    $('#cust_footer').val(unescapeHtml(report_cust_list[i].footer_text));
                    $('#cust_default').prop('checked', report_cust_list[i].is_default);
                    break;
                }
            }
            $('#cust_logo_edit_note').show();
        }
        $('#cust_logo').val('');

        return true;
    },

    saveReportCust: function(params) {
        // validate the data

        // customization name is 32 chars, alphanumeric plus underscore, dash and dot
        var name = $('#cust_name').val();
        if (name.length < 1 || name.length > 32) {
            return S_ERR_CUST_REPORT_NAME_LEN;
        }
        if (!/^[a-z0-9\_\-\.]+$/i.test(name)) {
            return S_ERR_CUST_REPORT_NAME_CHARS;
        }

        // don't allow reserved name "WatchGuard"
        if (name === 'WatchGuard') {
            return S_ERR_CUST_REPORT_NAME_RESERVED;
        }

        // don't allow duplicate names
        if (params.new_mode) {
            for (var i=0 ;i<report_cust_list.length; i++) {
                if (name === report_cust_list[i].name) {
                    return S_ERR_CUST_REPORT_NAME_DUP;
                }
            }
        }

        // header and footer text is optional, but limited to 50 chars and 80 chars
        if ($('#cust_header').val().length > 50) {
            return S_ERR_CUST_REPORT_HEADER_LEN;
        }
        if ($('#cust_footer').val().length > 80) {
            return S_ERR_CUST_REPORT_FOOTER_LEN;
        }

        // logo is required if it is new
        if (params.new_mode && $('#cust_logo').val().length === 0) {
            return S_ERROR_CUST_REPORT_NO_LOGO;
        }

        // we submit the logo to the server and rely on the iframe reload to close the dialog
        S_LS_CW_REP.uploading_logo = true;
        WGRD.enableUIElements(false, ['#cust_save']);

        // only inputs that have 'name' attributes and are enabled are submitted in the form
        // since the cust_name is disabled in edit mode, we omit the 'name' attribute and rewrite the submit URL to pass the cust_name that way
        $('#cust_report_form').prop('action', 'upload_cust_report_image?cust_name='+name);

        $('#cust_report_form').submit();
        return S_UPLOADING;
    },

    // called when the iframe that handles the logo upload is loaded
    // we use this to check for uploaded logo error
    // we save the report customization report data here if there are logo errors
    logoUploaded: function() {
        if (!S_LS_CW_REP.uploading_logo) {
            return;
        }

        // if it is a new customization, logo is required
        var new_mode = $('#report_cust_dlg h3').text() === S_CUST_REPORT_ADD_TITLE;
        if (new_mode && $('#custReportFrame').contents().find('#cust_upload_results_nologo').val()) {
            // no logo error
            $('#report_cust_dlg div.wgrd-modal-error').html(S_ERROR_CUST_REPORT_NO_LOGO);
        }
        else {
            // check for any errors
            var results = $('#custReportFrame').contents().find('#cust_upload_results_err').text();
            if (results) {
                $('#report_cust_dlg div.wgrd-modal-error').html(results);
            }
            else {
                // save the new data
                var cust_entry = null;
                var name = $('#cust_name').val();

                if (new_mode) {
                    // add the new entry to the array
                    cust_entry = new ReportCustomizationObj();
                    report_cust_list.push(cust_entry);
                }
                else {
                    // update the existing entry (name can't be changed)
                    for (var i=0 ;i<report_cust_list.length; i++) {
                        if (name === report_cust_list[i].name) {
                            cust_entry = report_cust_list[i];
                            break;
                        }
                    }
                }

                cust_entry.name = name;
                cust_entry.header_text = $('#cust_header').val();
                cust_entry.footer_text = $('#cust_footer').val();

                // allow at most 1 default
                var disp_str = cust_entry.name;
                if ($('#cust_default').is(':checked')) {
                    for (var i=0 ;i<report_cust_list.length; i++) {
                        if (cust_entry.name !== report_cust_list[i].name) {
                            if (report_cust_list[i].is_default) {
                                $("#report_cust_list option[value='" + report_cust_list[i].name + "']").text(report_cust_list[i].name);
                                report_cust_list[i].is_default = false;
                            }
                        }
                    }
                    cust_entry.is_default = true;
                    disp_str =  cust_entry.name + S_DEFAULT;
                }
                else {
                    cust_entry.is_default = false;
                }

                if (new_mode) {
                    $('#report_cust_list').append('<option value="' + cust_entry.name + '">' + disp_str + '</option>');
                }
                else {
                    $("#report_cust_list option[value='" + cust_entry.name + "']").text(disp_str);
                }

                // update the button states and note
                S_LS_CW_REP.updateReportCustUI();

                // no errors so hide the dialog
                $('#report_cust_dlg').modal('hide');
            }
        }

        WGRD.enableUIElements(true, ['#cust_save']);
        S_LS_CW_REP.uploading_logo = false;
    },

    removeReportCust: function() {
        var sel_item = $('#report_cust_list').val();

        if(sel_item && sel_item.length !== 0) {
            // find the matching entry
            for (var i=0 ;i<report_cust_list.length; i++) {
                if (sel_item === report_cust_list[i].name) {
                    report_cust_list.splice(i, 1);
                    break;
                }
            }
            $('#report_cust_list option[value="' + sel_item + '"]').remove();
        }

        S_LS_CW_REP.updateReportCustUI();  // update the button states and note

        return;
    },

    // ----------------------- FTP Server ---------------------------------------------
    populateFtpServerList: function() {
        for (var i = 0; i < ftp_servers_list.length; i++) {
            var name = ftp_servers_list[i].server_name;
            $('#ftp_servers_list').append('<option value="' + name + '">' + name + '</option>');
        }
    },

    updateFtpServerUI: function() {
        // enable/disable buttons
        if ($('#ftp_servers_list :selected').length === 0) {
            WGRD.enableUIElements(false, ['#edit_ftp_server', '#remove_ftp_server']);
        }
        else {
            WGRD.enableUIElements(true, ['#edit_ftp_server', '#remove_ftp_server']);
        }
    },

    showFtpModal: function() {
        var button_id = $(this).attr('id');
        var params = {'new_mode': true};
        $('#ftp_msg').text('');
        if (button_id === 'edit_ftp_server') {
            if ($('#ftp_servers_list :selected').length === 0) {
                return;
            }
            params.new_mode = false;
        }
        WGRD.doModal('#ftp_dlg',
                     S_LS_CW_REP.initializeFtpSettings,
                     S_LS_CW_REP.saveFtpSettings,
                     params);
    },

    initializeFtpSettings: function(params) {
        // Initialize the flag and value
        S_LS_CW_REP.ftp_password_changed = params.new_mode;
        S_LS_CW_REP.ftp_password_value = '********';
        
        // Initialize UI
        $('#ftp_pass').val('');
        
        if (params.new_mode) {
            // add dialog
            $('#ftp_dlg h3').text(S_FTP_SERVER_ADD_TITLE);
            WGRD.enableUIElements(true, ['#server_name']);
            $('#server_name').val('');
            $('#ftp_location').val('');
            $('#ftp_user').val('');
        }
        else {
            // edit dialog
            var name = $('#ftp_servers_list').val();
            if (is_page_locked === 1) {
                $('#ftp_dlg h3').text(S_FTP_SERVER_VIEW_TITLE);
            } else{
                $('#ftp_dlg h3').text(S_FTP_SERVER_EDIT_TITLE);
            }
            WGRD.enableUIElements(false, ['#server_name']);
            $('#server_name').val(name);
            for (var i = 0; i < ftp_servers_list.length; i++) {
                if (unescapeHtml(ftp_servers_list[i].server_name) === name) {
                    $('#server_name').val(unescapeHtml(ftp_servers_list[i].server_name));
                    $('#ftp_location').val(unescapeHtml(ftp_servers_list[i].upload_location));
                    $('#ftp_user').val(unescapeHtml(ftp_servers_list[i].user_name));
                    // filled the ftp_pass when ftp_user is not empty.
                    var ftp_user = $('#ftp_user').val();
                    if (ftp_user.length > 0) {
                        $('#ftp_pass').val(S_LS_CW_REP.ftp_password_value);
                    } else {
                        S_LS_CW_REP.ftp_password_value = '';
                    }
                    break;
                }
            }
        }
        return true;
    },

    saveFtpSettings: function(params) {
        var err_msg = S_LS_CW_REP.validateFTPSettings();
        if (err_msg !== '') {
            return err_msg;
        }
        var name = escapeHtml($('#server_name').val());
        var ftp_server = null;
        // don't allow duplicate names

        for (var i=0 ;i<ftp_servers_list.length; i++) {
            if (name === ftp_servers_list[i].server_name) {
                ftp_server = ftp_servers_list[i];
                break;
            }
        }

        if (params.new_mode) {
            if (ftp_server !== null) {
                $('#server_name').focus();
                $('#server_name').select();
                return S_ERROR_SERVER_NAME_DUP;
            }
            ftp_server = new FtpServerObj();
            // add new ftp server, set the flag.
            ftp_server.is_pass_changed = true;
        }
        ftp_server.server_name = name;
        ftp_server.upload_location = escapeHtml($('#ftp_location').val());
        ftp_server.user_name = escapeHtml($('#ftp_user').val());
        // check ftp_pass is changed or not
        if (S_LS_CW_REP.ftp_password_changed) {
            ftp_server.is_pass_changed = true;
            ftp_server.user_pass = escapeHtml($('#ftp_pass').val());
        }
        if (params.new_mode) {
            ftp_servers_list.push(ftp_server);
            $('#ftp_servers_list').append('<option value="' + ftp_server.server_name + '">' + name + '</option>');
        }
    },

    removeFtpServer: function() {
        var sel_item = escapeHtml($('#ftp_servers_list').val());

        if(sel_item && sel_item.length !== 0) {
            // find the matching entry
            for (var i=0 ;i<ftp_servers_list.length; i++) {
                if (sel_item === ftp_servers_list[i].server_name) {
                    ftp_servers_list.splice(i, 1);
                    break;
                }
            }
            $('#ftp_servers_list option[value="' + unescapeHtml(sel_item) + '"]').remove();
        }
        S_LS_CW_REP.updateFtpServerUI();  // update the button states and note

        return;
    },

    testFTP : function() {
        var err_msg = S_LS_CW_REP.validateFTPSettings();
        if (err_msg !== '') {
            $('#add_error_ftp').show().text(err_msg);
            return;
        }

        $('#add_error_ftp').hide()
                           .text('');
        $('#ftp_msg').text('');
        $("#test_ftp_btn").prop("disabled", true);

        var ftp_server = $('#server_name').val();

        var upload_location = $('#ftp_location').val();

        var user_name = $('#ftp_user').val();
        if (user_name.trim().length === 0) {
            user_name = '';
        }

        var user_pass = $('#ftp_pass').val();
        if (user_pass.trim().length === 0) {
            user_pass = '';
        }

        var is_pass_changed = true;
        if (!S_LS_CW_REP.ftp_password_changed) {
            for (var i=0; i<ftp_servers_list.length; i++) {
                if (unescapeHtml(ftp_servers_list[i].server_name) === ftp_server) {
                    user_pass = unescapeHtml(ftp_servers_list[i].user_pass);
                    is_pass_changed = ftp_servers_list[i].is_pass_changed;
                    break;
                }
            }
        }
        
        var ftp_data = {
                        'ftp_server'     : ftp_server,
                        'upload_location': upload_location,
                        'user_name'      : user_name,
                        'user_pass'      : user_pass,
                        'is_pass_changed': is_pass_changed
                       };

        $('#test_ftp').show();

        $.ajax({
            url: 'test_ftp_connection',
            type: 'POST',
            data: JSON.stringify(ftp_data),
            contentType: 'application/json',
            success: function(data) {
                if (data.status) {
                    $('#ftp_msg')
                                 .text(S_TEST_PASS_MSG)
                                 .removeClass('text-error')
                                 .addClass('text-success');
                } else {
                    $('#ftp_msg')
                                 .text(S_TEST_FAIL_MSG)
                                 .removeClass('text-success')
                                 .addClass('text-error');
                    $('#add_error_ftp').show()
                                       .text(data.msg);
                }
            },
            error: function() {
                $('#ftp_msg')
                             .text(S_TEST_FAIL_MSG)
                             .removeClass('text-success')
                             .addClass('text-error');

                $('#add_error_ftp').show()
                                   .text(data.msg);
            },
            complete: function() {
                $('#test_ftp').hide();
                $("#test_ftp_btn").prop("disabled", false);
            }
        });
    },

    validateFTPSettings : function() {
        var host = $('#server_name').val();
        var colon = host.indexOf(":");
        var port = NaN;
        if (colon >= 0) {
            port = host.substring(colon+1, host.length);
            host = host.substring(0, colon);
            if (!/^[0-9]+$/.test(port)) {
                port = -1;
            }
            else {
                port = parseInt(port, 10);
                if (isNaN(port)) {
                    port = -1;
                }
            }
        }

        if (port < 1 || port > 65535) {
            $('#server_name').focus();
            $('#server_name').select();
            return S_ERROR_FTP_PORT;
        }

        if (host.trim().length === 0) {
            $('#server_name').focus();
            $('#server_name').select();
            return S_ERROR_SMTP_HOST;
        }

        if (host.indexOf(".") >= 0) {
            if ((!IPHELPER.validIP4(host) && !validateDomainNameStr(host))) {
                $('#server_name').focus();
                $('#server_name').select();
                return S_ERROR_FTP_HOST_INVALID;
            }
        }
        return '';
    },

    // ------------ Validation ---------------------------------------------------------

    validateConnectWise : function() {
        if (isChecked('#enable_cw')) {
            if (!S_LS_CW_REP.validateEmptyField('#cw_server', 0, S_ERROR_CW_SERVER_EMPTY)) {
                $('#tabs a[href="#reporting"]').tab('show');
                $('#cw_server').focus();
                $('#cw_server').select();
                return false;
            }

            // more tests for the cw server
            var host = $('#cw_server').val();
            var colon = host.indexOf(":");
            var port = NaN;
            if (colon >= 0) {
                port = host.substring(colon+1, host.length);
                host = host.substring(0, colon);
                if (!/^[0-9]+$/.test(port)) {
                    port = -1;
                }
                else {
                    port = parseInt(port, 10);
                    if (isNaN(port)) {
                        port = -1;
                    }
                }
            }
            if (port < 1 || port > 65535) {
                $('#tabs a[href="#reporting"]').tab('show');
                $('#cw_server').focus();
                $('#cw_server').select();
                writeErrorContainer(S_ERROR_CW_SERVER_INVALID_PORT, false);
                return false;
            }
            if (host.indexOf(".") >= 0) {
                if (!validateDomainNameStr(host)) { //Check if it's a valid domain
                    if (!isValidIp($('#cw_server'))) { //Or valid IP
                        $('#tabs a[href="#reporting"]').tab('show');
                        $('#cw_server').focus();
                        $('#cw_server').select();
                        writeErrorContainer(S_ERROR_CW_SERVER_INVALID_HOST, false);
                        return false;
                    }
                }
            } else { //Fail if it's neither a valid domain or ip
                $('#tabs a[href="#reporting"]').tab('show');
                $('#cw_server').focus();
                $('#cw_server').select();
                writeErrorContainer(S_ERROR_CW_SERVER_INVALID_HOST, false);
                return false;
            }

            if (!S_LS_CW_REP.validateEmptyField('#cw_id', 0, S_ERROR_CW_ID_EMPTY)) {
                return false;
            }

            if (!S_LS_CW_REP.validateEmptyField('#cw_login', 0, S_ERROR_CW_LOGIN_EMPTY)) {
                return false;
            }

            if (S_LS_CW_REP.cw_password_changed && !S_LS_CW_REP.validateEmptyField('#cw_password', 0, S_ERROR_CW_PASS_EMPTY)) {
                return false;
            }

            var cw_names = $('#cw_cnames option').length;
            if (cw_names === 0) {
                return S_LS_CW_REP._show_error_msg('#cw_cnames', 0, S_ERROR_CW_COMP_NAME_EMPTY);
            }

            var cert_data = $("#import_cert_dlg input[type=file]").val();
            if(current_cw_cert_len === 0 && cert_data.length === 0) {
                writeErrorContainer(S_ERROR_CW_CERT_EMPTY, false);
                $('#tabs a[href="#reporting"]').tab('show');
                return false;
            }
        }
        return true;
    },

    validateEmptyField : function(elm_str, tab_index, error_str) {
        if ($(elm_str).val().length === 0) {
            return S_LS_CW_REP._show_error_msg(elm_str, tab_index, error_str);
        }
        return true;
    },

    _show_error_msg : function(elm_str, tab_index, error_str) {
        $('#tabs li:eq(' + tab_index + ') a').tab('show');
        $(elm_str).focus();
        $(elm_str).select();
        writeErrorContainer(error_str, false);
        return false;
    },

    get_cw_obj : function() {
        var cw_obj = new ConnectWiseConfigObj();
        cw_obj.cw_server = $('#cw_server').val();
        cw_obj.cw_comp_id = $('#cw_id').val();

        cw_obj.cw_login = $('#cw_login').val();
        cw_obj.cw_password = S_LS_CW_REP.cw_password_changed ? $('#cw_password').val() : null;

        cw_obj.cw_tz = $('#cw_tz').val();

        var cname_list = [];
        $('#cw_cnames option').each(function() {
            var cw_cname = {};
            cw_cname['company_name'] = unescapeHtml($(this).text());
            cw_cname['solution_name'] = unescapeHtml($(this).val());

            cname_list.push(cw_cname);
        });
        cw_obj.cw_cnames = cname_list;
        cw_obj.is_cw_enabled = isChecked('#enable_cw');
        return cw_obj;
    },

    get_rep_cust_list : function() {
        // unescape the html before saving
        for (var i = 0; i < report_cust_list.length; i++) {
            report_cust_list[i].header_text = unescapeHtml(report_cust_list[i].header_text);
            report_cust_list[i].footer_text = unescapeHtml(report_cust_list[i].footer_text);
        }
        return report_cust_list;
    },

    get_ftp_servers_list : function() {
        // unescape the html before saving
        for (var i = 0; i < ftp_servers_list.length; i++) {
            ftp_servers_list[i].server_name = unescapeHtml(ftp_servers_list[i].server_name);
            ftp_servers_list[i].upload_location = unescapeHtml(ftp_servers_list[i].upload_location);
            ftp_servers_list[i].user_name = unescapeHtml(ftp_servers_list[i].user_name);
            ftp_servers_list[i].user_pass = unescapeHtml(ftp_servers_list[i].user_pass);
        }
        return ftp_servers_list;
    },

    // entry point for submitting the changes to the server
    // this starts/controls the process of:
    //   1 - validate the UI
    //   2 - submit the changes to the server
    savePage : function() {
        if (standalone_mode == 0) {
            $('#error_container').hide();
            $('#save_cw_rep_button').attr('disabled', true);
            $('#progress_save').show();

            // validate the input
            if (!S_LS_CW_REP.validateConnectWise()) {
                // validation failed
                $('#save_cw_rep_button').removeAttr('disabled');
                $('#progress_save').hide();
                return;
            }
        }

        var obj = new LogServerConfigObj();
        obj.cw_obj = S_LS_CW_REP.get_cw_obj();

        // report customization
        obj.report_cust_list = S_LS_CW_REP.get_rep_cust_list();

        obj.rep_customization_cw_only = 1; // Save only cw and rep customization

        // ftp servers
        obj.ftp_servers_list = S_LS_CW_REP.get_ftp_servers_list();

        // save the data to the server
        WGRD.putData(obj).success(function(response) {
            if (standalone_mode == 0) {
                WGRD.updateModeUI(1);  //Update the user mode div
                WGRD.resetUserMode();  //Reset the lock after save
            }
        });
    }
};
$(document).ready(S_LS_CW_REP.init);
