var S_LS_D = {

    LOG_TYPES : ['server', 'collector'],

    // setup the page
    init : function () {
        S_LS_D.initUI();
        S_LS_D.initEvents();
    },

    // initialize UI elements
    initUI : function () {
        $('#progress_purge_diag_logs').hide();
        $('#purge_diag_logs_results').hide();
        $('#progress_refresh_process_table').hide();
        $('#progress_refresh_server_log').hide();
        $('#progress_refresh_collector_log').hide();

        S_LS_D.createProcessGrid();

        $.each(S_LS_D.LOG_TYPES, function(index, log_type) {
            S_LS_D.refreshLog(log_type);
        });
    },

    // add event handlers
    initEvents : function () {
        $('#purge_diag_logs').button().click(S_LS_D.purgeDiagLogs);

        $('#refresh_process_table').button().click(function() {
            var attr = $('#refresh_process_table').attr('disabled')
            if (attr !== 'true' && attr !== 'disabled') {
                $('#process_table').jqGrid('setGridParam', {loadui: 'block', datatype: S_LS_D.refreshProcessGrid()});
            }
        });

        $.each(S_LS_D.LOG_TYPES, function(index, log_type) {
            $('#refresh_'+log_type+'_log').button().click(function() {
                var attr = $('#refresh_'+log_type+'_log').attr('disabled')
                if (attr !== 'true' && attr !== 'disabled') {
                    S_LS_D.refreshLog(log_type);
                }
            });
        });

        $(window).bind('resizeEnd', function() {
            S_LS_D.doResize();
        });
    },

    purgeDiagLogs : function() {
        $('#purge_diag_logs').attr('disabled', true);
        $('#purge_diag_logs_results').hide();
        $('#progress_purge_diag_logs').show();

        $.ajax({
            url: 'purge_diags',
            type: 'POST',
            dataType: 'json',
            data: '',
            success: function(response) {
                $('#progress_purge_diag_logs').hide();
                if (response.status) {
                    $('#purge_diag_logs_results').attr('class', 'alert alert-success');
                }
                else {
                    $('#purge_diag_logs_results').attr('class', 'alert alert-error');
                }
                $('#purge_diag_logs_results_str').text(response.message);
                $('#purge_diag_logs_results').show();
                $('#purge_diag_logs').attr('disabled', false);
            },
            error: function(response) {
                $('#progress_purge_diag_logs').hide();
                $('#purge_diag_logs_results').attr('class', 'alert alert-error');
                $('#purge_diag_logs_results_str').text(response.statusText + ": " + response.status);
                $('#purge_diag_logs_results').show();
                $('#purge_diag_logs').attr('disabled', false);
            }
        });
    },


    createProcessGrid: function() {
        $('#process_table').jqGrid({
            loadonce: true,
            loadui: 'block',
            datatype: S_LS_D.refreshProcessGrid,
            height:'auto',
            autowidth: true,
            shrinkToFit: true,
            colNames: procTableColNames,
            colModel: procTableColModel,
            sortname: 'name',
            viewrecords: true,
            sortorder: 'asc'
        });
    },

    refreshProcessGrid: function() {
        WGRD.enableUIElements(false, ['#refresh_process_table']);
        $('#progress_refresh_process_table').show();
        $('#process_table').jqGrid('clearGridData');

        $.ajax({
            url: 'process_info',
            type: 'POST',
            dataType: 'json',
            data: '',
            success: function(data) {
                // update the table with the new data
                $('#process_table').jqGrid('setGridParam', {
                    datatype: 'local',
                    data: data
                });
                $('#process_table').trigger('reloadGrid');
            },
            error: function(response) {
                $('#process_table').jqGrid('setGridParam', {datatype: 'local'});
            },
            complete: function() {
                $('#progress_refresh_process_table').hide();
                WGRD.enableUIElements(true, ['#refresh_process_table']);
                S_LS_D.doResize();
            }
        });
    },

    refreshLog: function(log_type) {
        WGRD.enableUIElements(false, ['#refresh_'+log_type+'_log']);
        $('#progress_refresh_'+log_type+'_log').show();
        $('#'+log_type+'_log').val('');
        
        var lines = 100;  // default
        var error = WGRD.isValidNumeric($('#'+log_type+'_log_lines'), '');
        if (!error || error.length === 0) {
            lines = parseInt($('#'+log_type+'_log_lines').val(), 10);
        }
        else {
            $('#'+log_type+'_log_lines').val(lines);
        }

        $.ajax({
            url: 'get_log',
            type: 'POST',
            dataType: 'json',
            data: {'log_type': log_type, 'num_lines': lines},
            success: function(response) {
                // update the text area with the new data
                $('#'+log_type+'_log').val(response.data);
            },
            error: function(response) {
                $('#'+log_type+'_log').val('');
            },
            complete: function() {
                $('#progress_refresh_'+log_type+'_log').hide();
                WGRD.enableUIElements(true, ['#refresh_'+log_type+'_log']);
            }
        });
    },

    doResize: function() {
        var padleft = parseInt($("#processes_div").css('margin-left'));
        var grid_width = $("#processes_div").width() - padleft * 2;
        $('#process_table').setGridWidth(grid_width);
    }

};
$(document).ready(S_LS_D.init);