var S_IP_MAP = {
    path: "/servers/logserver/ip_map/",
    dynamic_resolution_enabled: false,

    init : function () {
        S_IP_MAP.initUI();
        S_IP_MAP.initEvents();
    },

    initUI: function() {
        if ($('#dynamic_resolution_enabled').is(':checked')) {
            S_IP_MAP.dynamic_resolution_enabled = true;
            $('#dynamic_resolution_state').html($('#str_enabled').html());
        }
        else {
            S_IP_MAP.dynamic_resolution_enabled = false;
            $('#dynamic_resolution_state').html($('#str_disabled').html());
        }

        S_IP_MAP.createIpMapGrid();

        S_USER_MODE.initUI([]);
        S_USER_MODE.initEvents();

        // if user mode is readonly, disable the dynamic resolution "configure" button
        if (is_page_locked === 1) {
            WGRD.enableUIElements(false, ["#btn_dynamic_resolution", "#create_ip_map", "#update_ip_map", "#remove_ip_map", "#import_ip_map", "#reset_ip_map"]);
        }
    },

    initEvents: function() {
        $('#btn_dynamic_resolution').button().click(S_IP_MAP.dynResAction);

        $('#create_ip_map').click(S_IP_MAP.create);
        $('#update_ip_map').click(S_IP_MAP.update);
        $('#remove_ip_map').click(S_IP_MAP.remove);

        $('#import_ip_map').click(S_IP_MAP.importCsv);
        $('#export_ip_map').click(S_IP_MAP.exportCsv);
        $('#reset_ip_map').click(S_IP_MAP.reset);

        $('#btn_refresh').click(S_IP_MAP.refreshGrid);

        $('#search').click(S_IP_MAP.search);

        $(window).bind('resizeEnd', function() {
            S_IP_MAP._doResizeGrid();
        });
    },

    // ------------ Dynamic Resolution  ------------------------------------------------

    dynResAction : function() {
        WGRD.doModal('#dynamic_resolution_dlg',
                     S_IP_MAP.initDynResModal,
                     S_IP_MAP.saveDynResModal);
    },

    initDynResModal : function() {
        // set the checkbox state
        $('#dynamic_resolution_enabled').prop('checked', S_IP_MAP.dynamic_resolution_enabled);

        return true;
    },

    saveDynResModal : function() {
        // save the dynamic hostname resolution setting
        var enabled = $('#dynamic_resolution_enabled').is(':checked');

        var err = null;
        $.ajax({
            url: 'ip_map/set_dyn_res_state?enabled='+enabled,
            type: 'POST',
            async: false,
            error: function(data) {
                err = data.statusText;
            },
        });

        if (err == null) {
            if (enabled) {
                S_IP_MAP.dynamic_resolution_enabled = true;
                $('#dynamic_resolution_state').html($('#str_enabled').html());
            }
            else {
                S_IP_MAP.dynamic_resolution_enabled = false;
                $('#dynamic_resolution_state').html($('#str_disabled').html());
            }
        }

        return err;
    },

    // ------------ Dynamic Resolution (end) -------------------------------------------

    createIpMapGrid: function(){
        var ip_map_grid = $("#ip_map_table").jqGrid({
            loadonce: true,
            datatype: S_IP_MAP.refreshGrid,
            // The colNames are placed in the template so we can localize them.
            colNames: [$("#ip_map_col_model #ip").html(), $("#ip_map_col_model #name").html()],
            colModel: [
                { name: "ip", sortable: true, sorttype: IPHELPER.sortIpAddressCell},
                { name: "name", sortable: true, sorttype: 'text'},
            ],
            viewrecords: true,
            gridview: true,
            autoencode: true,
            shrinktofit: true,
            viewrecords: true,
            autowidth: true,
            shrinkToFit: true,
            height: "auto",
            sortname: 'ip',
            sortorder: 'asc',
            prmNames: {
                page:null,
                rows:null,
                sort:null,
                order:null,
                search:null,
                nd:null,
                id:null,
                oper:null,
                editoper:null,
                addoper:null,
                deloper:null,
                subgridid:null,
                npage:null,
                totalrows:null
            } ,
            onSortCol: function(){
                // Concession to limits of jqgrid. Before we refresh we set datatype back to json.
                $("#ip_map_table").setGridParam({datatype:'local'});
            },
            loadComplete: function() {
                S_IP_MAP._toggleRowChangeBtns();
                S_IP_MAP._doResizeGrid();
                S_IP_MAP.sortGrid();
            },
            onSelectRow: function(rowid, status, e) {S_IP_MAP._toggleRowChangeBtns();}
        });
    },

    create: function(){
        var params = {};
        WGRD.doModal('#update_and_create_dlg',
            S_IP_MAP._initializeCreateControl,
            S_IP_MAP._createRecord,
            params,
            undefined,
            false
        );
    },

    _initializeCreateControl: function(){
        S_IP_MAP._resetUpdateAndCreateModal();
        var title = $("#create_dlg_title").html();
        $("#update_and_create_title").html(title);
        $("#ip").attr('disabled', false);
        return true;
    },

    _resetUpdateAndCreateModal: function(){
        // Contains shared logic to initialize state for the update/create modal divs.
        $("#update_and_create_error").hide();
        $("#update_and_create_error").html('');
        $("#update_and_create_dlg #ip").val('');
        $("#update_and_create_dlg #name").val('');
    },

    _createRecord: function(params){
        var ip = $("#update_and_create_dlg #ip").val();
        var name = $("#update_and_create_dlg #name").val();
        var blocking_response;
        if (IPHELPER.validIP4(ip) || IPHELPER.validIP6(ip)){
            $.ajax({
                url: S_IP_MAP.path + 'create',
                type: 'POST',
                data: {ip: ip, name: name},
                dataType: "json",
                async: false,
                success: function(response){
                    blocking_response = response;
                }
            });
            var error_msg;
            if (blocking_response.status){
                S_IP_MAP.refreshGrid();
            } else {
                error_msg = blocking_response.message;
            }
        } else {
            error_msg = $("#invalid_ip_error").html();
        }
        return error_msg;
    },

    update: function(){
        var sel_row_id = $('#ip_map_table').jqGrid('getGridParam', 'selrow');
        if (sel_row_id === null) {
            return;
        } else {
            var params = {};
            WGRD.doModal('#update_and_create_dlg',
                S_IP_MAP._initializeUpdateControl,
                S_IP_MAP._updateRecord,
                params,
                undefined,
                false
            );
        }
    },

    _initializeUpdateControl: function(){
        S_IP_MAP._resetUpdateAndCreateModal();
        var title = $("#update_dlg_title").html();
        $("#update_and_create_title").html(title);

        var ip_table = $('#ip_map_table');
        var sel_row_id = $('#ip_map_table').jqGrid('getGridParam', 'selrow');
        var ip = ip_table.jqGrid('getCell', sel_row_id, 'ip');
        $("#update_and_create_dlg #ip").val(ip);
        var name = ip_table.jqGrid('getCell', sel_row_id, 'name');
        $("#update_and_create_dlg #name").val(name);

        $("#ip").attr('disabled', true);
        return true;
    },

    _updateRecord: function(params){
        var ip = $("#update_and_create_dlg #ip").val();
        var name = $("#update_and_create_dlg #name").val();
        if (IPHELPER.validIP4(ip) || IPHELPER.validIP6(ip)){
            var blocking_response;
            $.ajax({
                url: S_IP_MAP.path + 'update',
                type: 'POST',
                dataType: 'json',
                data: {ip: ip, name: name},
                async: false,
                success: function(response){blocking_response = response;}
            });
            var error_msg;
            if (blocking_response.status){
                S_IP_MAP.refreshGrid();
            } else {
                error_msg = blocking_response.message;
            }
        } else {
            error_msg = $("#invalid_ip_error").html();
        }
        return error_msg;
    },

    remove: function(){
        var ip_table = $('#ip_map_table');
        var sel_row_id = ip_table.jqGrid('getGridParam', 'selrow');
        if (sel_row_id === null) {
            return;
        } else {
            var ip = ip_table.jqGrid('getCell', sel_row_id, 'ip');
            var params = {ip: ip};
            var msg = $("#delete_confirm_msg").html();
            var title = $("#delete_title").html();
            $('#confirmBoxDiv h3').text(title);
            WGRD.confirmModal(msg, false, S_IP_MAP._deleteRecord, false, true, params);
        }
    },

    _deleteRecord: function(params){
        $.ajax({
            url: S_IP_MAP.path + 'delete',
            type: 'POST',
            dataType: 'json',
            data: {ip: params.ip},
            success: function(response){
                if (response.status){
                    S_IP_MAP.refreshGrid();
                } else {
                    WGRD.okMessageModal(response.message, $("#delete_error_title").html());
                }
            }
        });
    },

    importCsv: function(){
        WGRD.doModal('#csv_load_dlg',
            S_IP_MAP._initializeImportCsv,
            S_IP_MAP._saveImportCsv,
            undefined,
            S_IP_MAP._cancelImportCsv,
            true
        );
    },

    _initializeImportCsv: function(){
        return true;
    },

    _saveImportCsv: function(){
        S_IP_MAP.uploading_csv = true;
        if ($("#csv_import_file").val() == ''){
            return $("#no_file_error").html();
        }
        $('#csv_load_form').submit();
    },

    _cancelImportCsv: function(){
        S_IP_MAP._hideWaitCursor();
    },

    _csvFileUploaded: function(){
        // called when the iframe that handles the csv file upload is loaded
        // we use this to check for errors
        if (!S_IP_MAP.uploading_csv) {
            return;
        }

        // check for any errors
        var result = $.parseJSON($("#csvImportIFrame").contents().find("body").text());
        if (!result.status) {
            $('#csv_load_dlg div.wgrd-modal-error').html(result.message);
            $('#csv_load_dlg div.wgrd-modal-error').show();
        }
        else {
            // no errors so hide the dialog
            $('#csv_load_dlg').modal('hide');
            S_IP_MAP.refreshGrid();
        }

        S_IP_MAP._hideWaitCursor();
        S_IP_MAP.uploading_csv = false;
    },

    exportCsv: function(){
        window.location = S_IP_MAP.path + "export_csv";
    },

    reset: function(){
        var msg = $("#reset_confirm_msg").html();
        var title = $("#reset_title").html();
        $('#confirmBoxDiv h3').text(title);
        WGRD.confirmModal(msg, false, S_IP_MAP._resetAllRecords, false, true, undefined);
    },

    _resetAllRecords: function(){
        $.ajax({
            url: S_IP_MAP.path + 'reset',
            type: 'POST',
            dataType: 'json',
            success: function(response){
                if (response.status){
                    S_IP_MAP.refreshGrid();
                } else {
                    WGRD.okMessageModal(response.message, $("#reset_error_title").html());
                }
            }
        });
    },

    search: function(){
        $("#ip_map_table").setGridParam({datatype:'json'});
        var value = $("#search_input").val();
        S_IP_MAP._showWaitCursor();
        $.ajax({
            url: S_IP_MAP.path + 'search',
            type: 'GET',
            dataType: 'json',
            data: {value: value},
            success: function(response){
                if (response.status){
                    S_IP_MAP._loadSpecificData(response.data);
                } else {
                    alert(response.message);
                }
            },
            complete: S_IP_MAP._hideWaitCursor
        });
    },

    _loadSpecificData: function(data){
        $("#ip_map_table").jqGrid('clearGridData');
        $('#ip_map_table').jqGrid('setGridParam', {
            rowNum: data.records,
            datatype: 'json'
        });
        $("#ip_map_table")[0].addJSONData(data);
        S_IP_MAP.sortGrid();
    },

    refreshGrid: function(){
        $("#search_input").val('');
        $('#ip_map_table').jqGrid('clearGridData');
        S_IP_MAP._showWaitCursor();
        $.ajax({
            url: S_IP_MAP.path + "retrieve",
            type: 'GET',
            dataType: 'json',
            data: '',
            success: function(data) {
                // update the table with the new data
                S_IP_MAP._loadSpecificData(data);
            },
            error: function(response) {
                $('#ip_map_table').jqGrid('setGridParam', {datatype: 'local'});
            },
            complete: function(){
                S_IP_MAP._doResizeGrid();
                S_IP_MAP._hideWaitCursor();
            }
        });
    },

    sortGrid: function(){
        $("#ip_map_table").jqGrid('setGridParam', 'datatype', 'local');
        $("#ip_map_table").jqGrid('sortGrid').trigger('reloadGrid');
        // sortGrid has no direction and toggles. We have to sort twice to preserve existing direction.
        $("#ip_map_table").jqGrid('sortGrid').trigger('reloadGrid');
        $("#ip_map_table").jqGrid('setGridParam', 'datatype', 'json');
    },

    _toggleRowChangeBtns: function() {
        // enable/disable "Remove"/"Edit" button depending on if any rows are selected or not
        if (is_page_locked === 0) {
            // only toggle the buttons in read/write mode
            var selRowId = $('#ip_map_table').jqGrid('getGridParam', 'selrow');
            WGRD.enableUIElements(selRowId, ["#update_ip_map", "#remove_ip_map"]);
        }
    },

    _showWaitCursor: function() {
        WGRD.enableUIElements(false, ['#search', '#btn_refresh']);
        $('#error').hide();
        $('#table_loading').show();
    },

    _hideWaitCursor: function() {
        WGRD.enableUIElements(true, ['#search', '#btn_refresh']);
        $('#table_loading').hide();
    },

    _doResizeGrid : function() {
        var pad = parseInt($("#ip_map_table_div").css('margin-left'), 10);
        pad *= 2;
        if (pad === 0) {
            pad += 1;  // add at least 1 pixel padding to keep the grid smaller than the parent
        }
        var grid_width = $("#ip_map_table_div").width() - pad;
        $('#ip_map_table').setGridWidth(grid_width);
    },

};

$(document).ready(S_IP_MAP.init);
