var S_LS_R = {

    // setup the page
    init : function () {
        S_LS_R.initUI();
        S_LS_R.initEvents();
    },

    // initialize UI elements
    initUI : function () {
        $('#no_backups_str').text(S_NO_BACKUPS);
        $('#no_backups').hide();
        $('#progress_restore_now').hide();

        if (backup_list.length === 0) {
            $('#no_backups').show();
            WGRD.enableUIElements(false, ['#backup_dir', '#backup_select', '#radio_entire_file', '#radio_by_time', '#restore_now']);
        }
        else {
            WGRD.enableUIElements(true, ['#backup_dir', '#backup_select', '#radio_entire_file', '#radio_by_time', '#restore_now']);
        }

        // configure the start/end time pickers
        $('#start_time').datetimepicker({
            pickDate: false,
            pickTime: true,
            pick12HourFormat: true,
            pickSeconds: false
        });
        $('#end_time').datetimepicker({
            pickDate: false,
            pickTime: true,
            pick12HourFormat: true,
            pickSeconds: false
        });

        // detect if any fields are changed
        var flds = $("input, select", window.document);
        flds.live('change keyup', function() {
            $('#error_container').hide();
        });

        S_LS_R.toggleTimeFilterEnable();
    },

    // add event handlers
    initEvents : function () {
        $('#radio_entire_file').click(S_LS_R.toggleTimeFilterEnable);
        $('#radio_by_time').click(S_LS_R.toggleTimeFilterEnable);
        $('#restore_now').button().click(S_LS_R.restoreDb);
    },

    // hide/show the start/end time input fields
    toggleTimeFilterEnable : function () {
        var enable = $('#radio_by_time').is(':checked');
        if (enable) {
            $('#start_time').data('datetimepicker').enable();
            $('#end_time').data('datetimepicker').enable();
        }
        else {
            $('#start_time').data('datetimepicker').disable();
            $('#end_time').data('datetimepicker').disable();
        }
    },

    // handle the "Restore Database" action
    restoreDb : function () {
        // make sure the start time is before the end time
        var start_time = $('#start_time_val').val();
        var end_time = $('#end_time_val').val();
        if ($('#radio_by_time').is(':checked')) {
            // the date string returned by toLocaleDateString()
            // may contain characters from non-English language
            var start_d = new Date(new Date().toDateString() + " " + start_time);
            var end_d = new Date(new Date().toDateString() + " " + end_time);
            if (start_time == "" || end_time == "") {
                writeErrorContainer(S_EMPTY_TIME, false);
                return;
            }
            if (start_d.getTime() > end_d.getTime()) {
                writeErrorContainer(S_ERROR_TIME, false);
                return;
            }
        }

        $('#restore_now').attr('disabled', true);
        $('#progress_restore_now').show();

        var begin_date = null;
        var end_date = null;
        if ($('#radio_by_time').is(':checked')) {
            begin_date = $('#backup_select').val() + " " + converToTimeStr24(start_time);
            end_date = $('#backup_select').val() + " " + converToTimeStr24(end_time);
        }
        else {
            begin_date = $('#backup_select').val() + " 00:00:00";
            end_date = $('#backup_select').val() + " 23:59:59";
        }

        var backup_dir = $('#backup_dir').val();

        var data = {
            'start_time': begin_date,
            'end_time': end_date,
            'directory': backup_dir
        };

        $.ajax({
            url: 'restore_backup_now',
            type: 'POST',
            dataType: 'json',
            data: data,
            success: S_LS_R.restoreDbResults,
            error: S_LS_R.restoreDbResultsError
        });
    },

    restoreDbResults : function (data) {
        $('#progress_restore_now').hide();
        window.alert(data.message);
        $('#restore_now').attr('disabled', false);
    },

    restoreDbResultsError : function (data) {
        $('#progress_restore_now').hide();
        console.log(data.responseText);
        window.alert(data.statusText + ": " + data.status);
        $('#restore_now').attr('disabled', false);
    }

};
$(document).ready(S_LS_R.init);

