var S_LS_S = {

    poller: null,

    // setup the page
    init : function() {
        S_LS_S.initUI();
        S_LS_S.initEvents();
    },

    // initialize UI elements
    initUI : function() {
        WGRD.enableUIElements(false, ['#btn_server_start', '#btn_server_stop', '#btn_server_restart']);

        S_LS_S.createLogFreqChart();
        S_LS_S.updateServerInfo();
        S_LS_S.getLogFreqChartData();
    },

    // add event handlers
    initEvents : function() {
        $('#btn_server_start').button().click(S_LS_S.startServer);
        $('#btn_server_stop').button().click(S_LS_S.stopServer);
        $('#btn_server_restart').button().click(S_LS_S.restartServer);

        $('#btn_refresh_freq').click(function(e) {
            e.preventDefault();
            S_LS_S.getLogFreqChartData();
        });

        $(window).bind('resizeEnd', function() {
            S_LS_S.doResizeChart();
        });

        // start a poller to refresh the server info every minute
      S_LS_S.poller = new POLLER('server_info', {'interval': '5'}, 60000, S_LS_S.serverInfoRefreshSuccessHandler, S_LS_S.serverInfoRefreshErrorHandler);
    },

    serverInfoRefreshSuccessHandler : function(response) {
        S_LS_S.updateServerInfoUI(response);
        return true;
    },

    serverInfoRefreshErrorHandler : function(response, num_failed) {
        return true;
    },

    startServer : function() {
        S_LS_S.serverAction('start');
    },

    stopServer : function() {
        S_LS_S.serverAction('stop');
    },

    restartServer : function() {
        S_LS_S.serverAction('restart');
    },

    serverAction : function(param) {
        $('#progress_server_action').show();
        WGRD.enableUIElements(false, ['#btn_server_start', '#btn_server_stop', '#btn_server_restart']);
        if (S_LS_S.poller != null) {
            S_LS_S.poller.pause();
        }

        $.ajax({
            url: 'server_action?action='+param,
            type: 'POST',
            dataType: 'json',
            data: '',
            success: S_LS_S.updateServerInfo,
            error: S_LS_S.updateServerInfo
        });
    },

    // ajax call to get some updated server info and refresh the UI
    updateServerInfo : function() {
        $.ajax({
            url: 'server_info',
            type: 'POST',
            dataType: 'json',
            data: {'interval': 0.2},
            success: function(data) {
                S_LS_S.updateServerInfoUI(data);
            }
        });
    },

    updateServerInfoUI: function(data) {
        typeof data.server_status == "undefined" ? $('#log_server_status').html('') : $('#log_server_status').html(data.server_status);
        typeof data.db_status == "undefined" ? $('#log_db_status').html('') : $('#log_db_status').html(data.db_status);
        typeof data.uptime == "undefined" ? $('#log_server_uptime').html('') : $('#log_server_uptime').html(data.uptime);
        typeof data.memory == "undefined" ? $('#log_server_memory').html('') : $('#log_server_memory').html(data.memory);
        typeof data.disk_usage == "undefined" ? $('#log_server_du').html('') : $('#log_server_du').html(data.disk_usage);

        if (typeof data.avail == "undefined" || (data.avail != 0 && data.avail != 1)) {
            // server is not available
            WGRD.enableUIElements(true, ['#btn_server_start']);
            WGRD.enableUIElements(false, ['#btn_server_stop', '#btn_server_restart']);
        }
        else {
            // server is available
            WGRD.enableUIElements(true, ['#btn_server_stop', '#btn_server_restart']);
            WGRD.enableUIElements(false, ['#btn_server_start']);
        }

        if (typeof data.cpu_tooltip != "undefined") {
            $('#log_server_cpu').html(data.cpu + '&nbsp;<a id="log_server_cpu_tooltip" data-toggle="tooltip"><i class="icon-question-sign"></i></a>');
            $('#log_server_cpu_tooltip').tooltip({
                html: true,
                placement: 'right',
                title: data.cpu_tooltip
            });
        }
        else if (typeof data.cpu != "undefined") {
            $('#log_server_cpu').html(data.cpu);
        }
        else {
            $('#log_server_cpu').html('');
        }

        $('#progress_server_action').hide();
        if (S_LS_S.poller != null) {
            S_LS_S.poller.resume(false);
        }
    },


    //
    // Log Frequency Chart
    //
    plot_trend : null,
    chartType : 'bar',
    seriesLength: 0,

    createLogFreqChart : function() {
        /* chart control buttons */
        $('#log_frequency_line').tooltip();
        $('#log_frequency_bar').tooltip();
        $('#btn_refresh_freq').tooltip();
        $('#log_frequency_bar').click(function() {
            S_LS_S.chartType = 'bar';
            S_LS_S.getLogFreqChartData();
        });
        $('#log_frequency_line').click(function() {
            S_LS_S.chartType = 'line';
            S_LS_S.getLogFreqChartData();
        });
    },

    getLogFreqChartData : function(start, end) {
        S_LS_S.showChartLoading();
        var myurl = 'log_data_frequency';
        if (start != null && end != null) {
            myurl = 'log_data_frequency?start=' + start + '&end=' + end;
            if (start > end) {
                myurl = 'log_data_frequency?start=' + end + '&end=' + start;
            }
            $('#log_frequency_reset').show();
        } else {
            $('#log_frequency_reset').hide();
        }
        $.ajax({
            url: myurl,
            method: 'GET',
            dataType: 'json',
            error: S_LS_S.checkLoginPageRedirect,
            success: S_LS_S.onDataReceived
        });
    },

    onDataReceived : function(series) {
        var barWidth = 1;

        $('#div_log_frequency').show();
        $('#log_frequency_graph').show();
        $('#log_frequency_loading').hide();
        $.jqplot.config.enablePlugins = true; // on the page before plot creation.

        if (S_LS_S.plot_trend) {
            $("#log_frequency_graph *").unbind();
            S_LS_S.plot_trend.destroy();
        }

        var options = S_LS_S.line_options;
        if (S_LS_S.chartType == 'bar') {
            options = S_LS_S.bar_options;
        }

        if (series == null || series.length === 0) {
            // use default scale and null series when there is no data
            options.axes.xaxis.min = 0;
            options.axes.xaxis.max = 100;
            S_LS_S.seriesLength = 0;
            S_LS_S.plot_trend = $.jqplot('log_frequency_graph', [[null]], options);
        }
        else {
            options.axes.xaxis.min = series[0][0];
            options.axes.xaxis.max = series[0][-1];
            S_LS_S.seriesLength = series.length;
            S_LS_S.plot_trend = $.jqplot('log_frequency_graph', [series], options);
        }
        setBarWidths(S_LS_S.plot_trend, S_LS_S.seriesLength, '#log_frequency_graph');
        S_LS_S.plot_trend.replot();
    },

    checkLoginPageRedirect : function(xhr, status, error) {
        checkLoginPageRedirect(xhr, status, error);
    },

    showChartLoading : function() {
        $('#log_frequency_loading').show();
        $('#log_frequency_graph').hide();
    },

    line_options: {
        title: { show: false },
        legend: { yoffset: 0, show: false },
        gridPadding: { left: 0, top: 0, right: 0, bottom: 0 },
        seriesDefaults: {
            pointLabels: { show: false }
        },
        axes: {
            xaxis: {
                pad: 0,
                renderer: $.jqplot.DateAxisRenderer,
                autoscale: false,
                numberTicks: 5,
                tickOptions: {
                    showLabel: false,
                    angle: 0,
                    formatString: '%Y-%m-%d %H:%M',
                    fontSize: 9
                }
            },
            yaxis: {
                tickOptions: {
                    fontSize: 9,
                    formatString: '%.0f',
                    show: false,
                    showLabel: false
                }
            }
        },
        cursor: {
            zoom: false,
            tooltipLocation: 'sw',
            showVerticalLine: true,
            showCursorLegend: true,
            showTooltip: false,
            cursorLegendFormatString: '%s%s %s',
            constrainZoomTo: 'x'
        },
        grid: { background: '#ffffff' },
        series: [{
                    label: ' ',
                    fill: true,
                    fillAlpha: 0.8,
                    fillAndStroke: true,
                    color: "rgb(32,92,128)",
                    fillColor: "rgb(225,235,245)",
                    lineWidth: 1.0,
                    neighborThreshold: 10,
                    showMarker: true,
                    markerOptions: {
                        show: true,
                        style: 'filledCircle',
                        size: 1.0
                    }
                }]
    },

    bar_options: {
        title: { show: false },
        legend: { yoffset: 0, show: false },
        gridPadding: { left: 0, top: 0, right: 0, bottom: 0 },
        series:[{
                   renderer:$.jqplot.BarRenderer,
                   pointLabels: { show: false },
                   label: ' ',
                   neighborThreshold: 10,
                   color: '#1F77B4',
                   markerOptions: {
                       show: false
                   }
               }],
        seriesDefaults: { showMarker: false,
                          shadow: false,
                          renderer:$.jqplot.BarRenderer,
                          rendererOptions: {
                                             barWidth: 10,
                                             barDirection:'vertical'
                                           }
                        },
        grid: { background: '#ffffff', shadow: false},
        axesDefaults: { useSeriesColor: false },
        axes: {
            xaxis: {
                pad: 0,
                renderer: $.jqplot.DateAxisRenderer,
                autoscale: false,
                numberTicks: 5,
                tickOptions: {
                    showLabel: false,
                    angle: 0,
                    formatString: '%Y-%m-%d %H:%M',
                    fontSize: 9
                }
            },
            yaxis: {
                tickOptions: {
                    fontSize: 9,
                    formatString: '%.0f',
                    show: false,
                    showLabel: false
                },
                pad: 0,
                padMax: 1.2,
                min:0,
                autoscale:false
            }
        },
        highlighter: { show: false },
        cursor: {
            zoom: false,
            tooltipLocation: 'sw',
            showVerticalLine: true,
            showCursorLegend: true,
            showTooltip: false,
            cursorLegendFormatString: '%s%s %s',
            constrainZoomTo: 'x'
        }
    },

    doResizeChart: function() {
        var padleft = parseInt($("#log_frequency_parent").css('margin-left'));
        var div_width = $("#log_frequency_parent").width() - padleft * 2;
        $("#div_log_frequency").width(div_width);
        if (S_LS_S.plot_trend != null) {
            var length = S_LS_S.seriesLength;
            if (S_LS_S.plot_trend.plugins.cursor._zoom.isZoomed) {
                length = 1;
                for (var i in S_LS_S.plot_trend.series[0].data) {
                    if (S_LS_S.plot_trend.series[0].data[i]['0'] > S_LS_S.plot_trend.axes.xaxis.min
                        && (S_LS_S.plot_trend.series[0].data[i]['0'] < S_LS_S.plot_trend.axes.xaxis.max)) {
                        length += 1;
                    }
                }
            }
            setBarWidths(S_LS_S.plot_trend, length, "#div_log_frequency");
            S_LS_S.plot_trend.replot();
        }
    }

};
$(document).ready(S_LS_S.init);
