var SETUP_WIZ = {
    currentPane : 0,
    nextPane : 1,

    activePanes : [],
    activeTasks : [],

    serversConfigured: false,

    setupWizObj : {},
    setupResult : [],

    init : function () {
        SETUP_WIZ.initUI();
        SETUP_WIZ.initEvents();
        SETUP_WIZ.stackComponents();
    },

    initUI : function () {
        //Increase height only if system is enabled to accommodate system page UI
        if(system_enabled === 1) {
            $('div.wizard_pane').css('height','386px');
            $('#note').show()
                      .html(S_PANE_MSGS['system_info']);
        } else {
            $('#note').hide();
        }
        $('#db_div').hide();  //We dont need to expose this, sinces users cannot change it
        $('#back_btn').attr('disabled', true);
    },

    //If the active form's width is less than or equal to 450
    //stack the UI components one below the other.
    stackComponents: function () {

        //Find the form that does not have 'hide' class.
        //Only the current active view will not have this class.
        var $active_form=$('div.wizard_pane').find('form:not([class*="hide"])');

        if($active_form.width() <= 450) {
            $active_form.removeClass('form-horizontal');
        }
        else {
            $active_form.addClass('form-horizontal');
        }
    },

    initEvents : function () {
        $('#iface_type').change(SETUP_WIZ.toggleIfaceType);

        $(window).resize(function() {
            SETUP_WIZ.stackComponents();
        });

        $('#back_btn').button()
                      .click(SETUP_WIZ.backAction);
        $('#next_btn').button()
                      .click(SETUP_WIZ.nextAction);
        $('#button_location').button()
                      .click(SETUP_WIZ.browseAction);

        $('#add_license_button').button()
                               .click(SETUP_WIZ.addLicenseAction);
        $('#remove_license_button').button()
                               .click(SETUP_WIZ.removeLicenseAction);
        $('#add_domain_button').button()
                               .click(SETUP_WIZ.addDomainAction);
        $('#remove_domain_button').button()
                               .click(SETUP_WIZ.removeDomainAction);
    },

    // return true if we are fully managing the system (including network interfaces)
    // for the amazon ec2 case, we manage the system, but not the IPs/Hostname
    isSystemInfsManaged : function() {
        return system_enabled && !is_amazon_ec2;
    },

    toggleIfaceType : function() {
        if ($('#iface_type')[0].selectedIndex === 0) {
            // static
            $('#static_div').show();
        }
        else {
            // dhcp
            $('#static_div').hide();
        }
    },

    browseAction : function () {
        return;
    },

    addLicenseAction : function () {
        return;
    },

    removeLicenseAction : function () {
        return;
    },

    addDomainAction : function () {
        return;
    },

    removeDomainAction : function () {
        return;
    },

    updateHelpID : function (currentPage) {
        switch (currentPage) {
            case 'welcome':
                HELP_LINK_OVERRIDE = 7000;
                break;
            case 'system':
                HELP_LINK_OVERRIDE = 7001;
                break;
            case 'adminpassphrase':
                HELP_LINK_OVERRIDE = 7002;
                break;
            case 'wlogserver':
                HELP_LINK_OVERRIDE = 7003;
                break;
            case 'review':
                HELP_LINK_OVERRIDE = 7004;
                break;
            case 'progress':
                HELP_LINK_OVERRIDE = 7005;
                break;
            case 'finish':
                HELP_LINK_OVERRIDE = 7006;
                break;
            case 'amazon_ec2':
                HELP_LINK_OVERRIDE = 7007;
                break;
        }
    },

    backAction : function () {
        SETUP_WIZ.nextPane -= 1;
        SETUP_WIZ.currentPane -= 1;

        SETUP_WIZ.togglePanes(SETUP_WIZ.currentPane, SETUP_WIZ.nextPane);
        SETUP_WIZ.updateButtonStates();

        SETUP_WIZ.updateHelpID(SETUP_WIZ.activePanes[SETUP_WIZ.currentPane]);
        if(S_PANE_MSGS[SETUP_WIZ.activePanes[SETUP_WIZ.currentPane]]) {
            $('#note').show()
                      .html(S_PANE_MSGS[SETUP_WIZ.activePanes[SETUP_WIZ.currentPane]]);
        }
        else if (SETUP_WIZ.currentPane == 0 && system_enabled === 1) {
            $('#note').show()
                      .html(S_PANE_MSGS['system_info']);
        }
        else {
           $('#note').hide();
        }
    },

    //Hide the current pane, show the nextPrevPane
    togglePanes : function (currentPane, nextPrevPane) {
        $('#' + SETUP_WIZ.activePanes[currentPane]).toggleClass('hide');
        $('#' + SETUP_WIZ.activePanes[nextPrevPane]).toggleClass('hide');
        SETUP_WIZ.stackComponents();
    },

    updateButtonStates : function () {
        var is_finish_pane = (SETUP_WIZ.currentPane === SETUP_WIZ.activePanes.length - 1);

        var back_button_state = (SETUP_WIZ.currentPane === 0 || is_finish_pane);

        $('#back_btn').attr('disabled', back_button_state);

        if (is_finish_pane) {
            $('#next_btn').text(S_FINISH_BUTTON);
        }
    },

    validatePane : function (pane) {

        function updateServers(serverID) {
            //If server is log server or report server and if 'pg' not already present, the add it to the array
            var test =  $.inArray('pg', SETUP_WIZ.activePanes);
            if ((serverID === 'wlogserver' || serverID === 'wrserver') && ($.inArray('pg', SETUP_WIZ.activeTasks) === -1)) {
                SETUP_WIZ.activeTasks.push('pg');
                SETUP_WIZ.activeTasks.push(serverID);
            }

            //Add org name pane only if wmserver is present
            if (serverID === 'wmserver') {
                SETUP_WIZ.activePanes.splice(1, 0, 'org');
            }
            //Add Report Server pane only if log server is not selected or installed
            test =  $.inArray('wlogserver', SETUP_WIZ.activePanes);
            if (serverID === 'wrserver' && $.inArray('wlogserver', SETUP_WIZ.activePanes) !== -1) {
                return;
            }
            SETUP_WIZ.activePanes.push(serverID);
            if (serverID === 'wmserver') {
                SETUP_WIZ.activePanes.push(serverID + '_license');
            }
        }

        function doEmptyCheck(elem, msg) {
            if ($(elem).val().length === 0) {
                showHideErrorMsg(elem, msg);
                return false;
            }
            showHideErrorMsg(elem);
            return true;
        }

        function doLengthCheck(elem, min_len, msg) {
           if($(elem).val().length < min_len) {
               showHideErrorMsg(elem, msg);
               return false;
           }
           showHideErrorMsg(elem);
           return true;
        }

        function doMinMaxLenCheck(elem, min_len, max_len, msg) {
            if($(elem).val().length < min_len ||
               $(elem).val().length > max_len) {
                showHideErrorMsg(elem, msg);
                return false;
            }
            showHideErrorMsg(elem);
            return true;
        }

        function doIpCheck(elem, msg) {
            if(!isValidIp(elem)) {
                showHideErrorMsg(elem, msg);
                return false;
            }
            showHideErrorMsg(elem);
            return true;
        }

        function doEqualityCheck(elem1, elem2, msg) {
            if($(elem1).val() !== $(elem2).val()) {
                showHideErrorMsg(elem1, msg);
                showHideErrorMsg(elem2, msg);
                return false;
            }
            showHideErrorMsg(elem1);
            showHideErrorMsg(elem2);
            return true;
        }

        var current_pane_id = SETUP_WIZ.activePanes[pane] || 'welcome';
        //We need to make sure that the ids for each pane match the id below
        switch (current_pane_id) {
        case 'welcome':
            //Welcome pane
            var checked_servers_count = $('.select_one:checked').length;
            if (checked_servers_count === 0 && installed_servers_list.length > 1) {
                $('#note').show()
                          .html(S_SERVER_SELECT_MSG);
                return false;
            }
            //Reset setupObj
            SETUP_WIZ.setupWizObj = {};
            //populate the activePanes list
            SETUP_WIZ.activePanes = [];
            SETUP_WIZ.activeTasks = [];
            SETUP_WIZ.activePanes.push('welcome');

            if (system_enabled === 1) {
                if (is_amazon_ec2) {
                    SETUP_WIZ.activePanes.push('amazon_ec2');
                    SETUP_WIZ.activeTasks.push('amazon_ec2');
                }
                else {
                    SETUP_WIZ.activePanes.push('system');
                    SETUP_WIZ.activeTasks.push('system');
                }
            }

            SETUP_WIZ.activePanes.push('adminpassphrase');
            SETUP_WIZ.activeTasks.push('adminpassphrase');

            if (installed_servers_list.length === 1) {
                var serverID = installed_servers_list[0][0];
                updateServers(serverID);
            } else {
                $('.select_one:checked').each(function () {
                    var serverID = $(this).attr('id');
                    var strSplit = serverID.split('_');

                    serverID = strSplit[1];
                    updateServers(serverID);
                });
            }
            SETUP_WIZ.activePanes.push('review', 'progress', 'finish');
            break;

        case 'org':

            if (!doEmptyCheck('#org_name',S_ORG_NAME_MSG)) {
                return false;
            }
            SETUP_WIZ.setupWizObj.org_name = $('#org_name').val();
            break;

        case 'adminpassphrase':

            var $elems = [ '#passphrase', '#confirm_passphrase' ];
            $('#note').show()
                      .html(S_PANE_MSGS['adminpassphrase']);
            for (var i = 0 ; i < $elems.length; i++) {
                var elem = $elems[i];
                if ( !doEmptyCheck(elem, S_PASSPHRASE_EMPTY_MSG)) {
                    return false;
                }
                if ( !doLengthCheck(elem, 8, S_PASSPHRASE_LENGTH_MSG)) {
                    return false;
                }
            }

            if(!doEqualityCheck('#passphrase', '#confirm_passphrase', S_PASSPHRASE_MATCH_MSG)) {
                return false;
            }

            SETUP_WIZ.setupWizObj.admin_passphrase = $('#passphrase').val();
            break;
        case 'system':

            // hostname (alphanumeric plus dash and max 64 chars)
            var hname = $('#hostname').val();
            if (hname.length === 0) {
                $('#hostname').focus();
                $('#hostname').select();
                showHideErrorMsg('#hostname', S_ERR_HNAME_EMPTY);
                return false;
            } else if (hname.length > 64) {
                $('#hostname').focus();
                $('#hostname').select();
                showHideErrorMsg('#hostname', S_ERR_HNAME_LEN);
                return false;
            } else if (hname.indexOf('-') === 0) {  // can't start with dash
                $('#hostname').focus();
                $('#hostname').select();
                showHideErrorMsg('#hostname', S_ERR_HNAME_DASH_STARTS);
                return false;
            } else if (/\-$/.test(hname) === true) {  // can't end with dash
                $('#hostname').focus();
                $('#hostname').select();
                showHideErrorMsg('#hostname', S_ERR_HNAME_DASH_ENDS);
                return false;
            } else if (/^[a-z0-9\-]+$/i.test(hname) === false) {  // letters, numbers and dash
                $('#hostname').focus();
                $('#hostname').select();
                showHideErrorMsg('#hostname', S_ERR_HNAME_CHARS);
                return false;
            } else {
                showHideErrorMsg('#hostname');
                SETUP_WIZ.setupWizObj.host_name = $('#hostname').val();
            }

            if ($('#iface_type')[0].selectedIndex === 0) {
                var ip_addr = $('#iface_ip').val();
                var mask = $('#iface_mask').val();
                var gw = $('#iface_gw').val();
                var dns_server = $('#dns_server').val();

                // validate IP and subnet mask
                if (IPHELPER.usableHostIP4(ip_addr) !== 0) {
                    $('#iface_ip').focus();
                    $('#iface_ip').select();
                    showHideErrorMsg('#iface_ip', S_ERR_IFACE_IP_MASK);
                    return false;
                } else {
                    showHideErrorMsg('#iface_ip');
                    SETUP_WIZ.setupWizObj.iface_ip = IPHELPER.trimIP4(ip_addr);
                }

                if (mask.length === 0 || !$.isNumeric(mask) || parseInt(mask, 10) < 0 || parseInt(mask, 10) > 32) {
                    $('#iface_mask').focus();
                    $('#iface_mask').select();
                    showHideErrorMsg('#iface_mask', S_ERR_IFACE_IP_MASK);
                    return false;
                } else {
                    showHideErrorMsg('#iface_mask');
                    SETUP_WIZ.setupWizObj.iface_mask = mask;
                }
                if (IPHELPER.usableHostIP4(gw) !== 0) {
                    $('#iface_gw').focus();
                    $('#iface_gw').select();
                    showHideErrorMsg('#iface_gw', S_ERR_IFACE_GW);
                    return false;
                } else {
                    showHideErrorMsg('#iface_gw');
                    SETUP_WIZ.setupWizObj.iface_gw = IPHELPER.trimIP4(gw);
                }

                // domain name
                var dns_name = $('#dns_name').val();
                if (dns_name.length !== 0 && !validateDomainName('#dns_name')) {// validate only if dns_name is not empty
                    $('#dns_name').focus();
                    $('#dns_name').select();
                    showHideErrorMsg('#dns_name', S_ERR_DOMAIN);
                    return false;
                } else {
                    showHideErrorMsg('#dns_name');
                    SETUP_WIZ.setupWizObj.dns_name = dns_name;
                }

                // verify server is valid ip
                if (dns_server.length === 0 || (!IPHELPER.validIP4(dns_server))) {
                    $('#dns_server').focus();
                    $('#dns_server').select();
                    showHideErrorMsg('#dns_server', S_ERR_DNS_IP);
                    return false;
                } else {
                    showHideErrorMsg('#dns_server');
                    SETUP_WIZ.setupWizObj.dns_server = IPHELPER.trimIP4(dns_server);
                }
                SETUP_WIZ.setupWizObj.dhcp_enabled = false;
            } else {
                SETUP_WIZ.setupWizObj.dhcp_enabled = true;
            }

            SETUP_WIZ.setupWizObj.tz = tz;
            SETUP_WIZ.setupWizObj.send_feedback = $('#send_feedback').is(':checked');
            break;

        case 'amazon_ec2':
            SETUP_WIZ.setupWizObj.host_name = ec2_local_hostname;
            SETUP_WIZ.setupWizObj.send_feedback = $('#send_feedback').is(':checked');
            break;

        case 'wlogserver':  //validate log server pane
            var $elems = [['#encryption_key', S_ENCRYPTION_KEY_EMPTY_MSG],
                           ['#confirm_encryption_key', S_ENCRYPTION_KEY_EMPTY_MSG],
                           ['#dbase_location', S_DBASE_LOCATION_EMPTY_MSG]
                         ];

            for (var i = 0 ; i < $elems.length; i++) {
                var elem = $elems[i][0];
                var msg = $elems[i][1];
                // The trim applies only to encryption key, making the behavior consistent to WSM
                if ($(elem).val().trim().length === 0) {
                    showHideErrorMsg(elem, msg);
                    return false;
                }
            }

            if(!doEqualityCheck('#encryption_key', '#confirm_encryption_key', S_ENCRYPTION_KEY_MATCH_MSG)) {
                return false;
            }

            SETUP_WIZ.setupWizObj.encryption_key = $('#encryption_key').val();
            SETUP_WIZ.setupWizObj.pg_db_location = $('#dbase_location').val();
            break;

        case 'wrserver': //validate report server pane

            var $elems = [
                           ['#ls_ip', S_IP_ADDRESS_MSG],
                           ['#ls_password', S_PASSPHRASE_EMPTY_MSG],
                           ['#rs_dbase_location', S_DBASE_LOCATION_EMPTY_MSG]
                         ];

            for(var i = 0; i < $elems.length; i++) {
                var elem = $elems[i][0];
                var msg = $elems[i][1];

                if(!doEmptyCheck(elem, msg)) {
                    return false;
                }
            }

            if (!doIpCheck('#ls_ip', S_VALID_IP_MSG)) {
                return false;
            }

            if (!doLengthCheck('#ls_password', 8, S_PASSPHRASE_LENGTH_MSG)) {
                return false;
            }

            SETUP_WIZ.setupWizObj.logserver_ip = $('#ls_ip').val();
            SETUP_WIZ.setupWizObj.logserver_password = $('#ls_password').val();
            SETUP_WIZ.setupWizObj.pg_db_location = $('#rs_dbase_location').val();
            break;

        case 'wmserver': //validate management server pane

            var $elems = [ ['#firebox_ip', S_IP_ADDRESS_MSG],
                           ['#status_password', S_PASSPHRASE_EMPTY_MSG],
                           ['#readwrite_password', S_PASSPHRASE_EMPTY_MSG]
                         ];

            for (var i = 0 ; i < $elems.length; i++) {
                var elem = $elems[i][0];
                var msg = $elems[i][1];

                if (!doEmptyCheck(elem, msg)) {
                    return false;
                }
            }

            if (!doIpCheck('#firebox_ip', S_VALID_IP_MSG)) {
                return false;
            }

            if (!doMinMaxLenCheck('#status_password', 8, 32, S_FIREBOX_PASSPHRASE_MSG)) {
                return false;
            }

            if (!doMinMaxLenCheck('#readwrite_password', 8, 32, S_FIREBOX_PASSPHRASE_MSG)) {
                return false;
            }

            break;

        case 'wmserver_license': //validate mgmt server license pane
            break;

        case 'wqserver': //validate quarantine server pane
            break;

        default:
            break;
        }
        return true;
    },

    updateStatus : function () {
        $.get('get_progress', function (data) {
            var dataSplit = data.split(',');
            var val = '';

            if (dataSplit.length > 1) {
                var tr = ('#setup_' + dataSplit[0]);
                var $first_td_tag = $(tr + ' td:first');

                var img_tag = $('#setup_' + dataSplit[0] + ' td:first').has('img');
                var msg_key = '';
                if (img_tag.length === 0) { //Add the img tag only if already does not exist
                    $('<img></img>').attr('src', dataSplit[2])
                                  .appendTo($first_td_tag);
                    msg_key = dataSplit[0] + '_' + dataSplit[1];
                    $(tr + ' td:last').text(S_SETUP_TASK_MSGS[msg_key]);
                } else {
                    $('#setup_' + dataSplit[0] + ' td:first img').attr('src', dataSplit[2]);
                    msg_key = dataSplit[0] + '_' + dataSplit[1];
                    //console.log("updated text ="+S_SETUP_TASK_MSGS[msg_key]);
                    $(tr + ' td:last').text(S_SETUP_TASK_MSGS[msg_key]);
                }
                val = parseInt(dataSplit[3], 10);
            } else {
                val = parseInt(dataSplit, 10);
            }
            if (val < 100) {
                setTimeout(SETUP_WIZ.updateStatus, 1000);
            }
        });
    },

    beginServerConfigAction: function () {

        setTimeout(SETUP_WIZ.updateStatus);

        SETUP_WIZ.setupWizObj.tasks = SETUP_WIZ.activeTasks;

        $('#back_btn').attr('disabled', true);
        $('#next_btn').attr('disabled', true);

        $.ajax({
            url: 'configure_servers',
            type: 'POST',
            data: JSON.stringify(SETUP_WIZ.setupWizObj),
            contentType: 'application/json',
            dataType: 'json',
            success : function (data) {
                SETUP_WIZ.serversConfigured = true;
                SETUP_WIZ.setupResult = data;
                $('#next_btn').attr('disabled', false);
                if (SETUP_WIZ.setupResult.status.length > 0) {
                    $("#note").show()
                          .html(S_PANE_MSGS['progress_fail']);
                }
                else {
                    $("#note").show()
                          .html(S_PANE_MSGS['progress']);
                }
            }
        });
    },

    prepareReviewPaneContents : function () {
        $('#dl_review').empty();

        if(system_enabled) {
            if (is_amazon_ec2) {
                $('<dt>' + S_REVIEW_SYS + '</dt>').appendTo($('#dl_review'));
                $('<dd><i>' + S_REVIEW_SYSTEM_NAME + '</i>&nbsp;' + SETUP_WIZ.setupWizObj.host_name + '</dd>').appendTo($('#dl_review'));
                $('<dd><i>' + S_REVIEW_PUB_HOST_NAME + '</i>&nbsp;' + ec2_has_pub_hostname + '</dd>').appendTo($('#dl_review'));
                $('<dd><i>' + S_REVIEW_PUB_IP_ADDR + '</i>&nbsp;' + ec2_has_pub_ip + '</dd>').appendTo($('#dl_review'));
                $('<dd><i>' + S_REVIEW_AVAIL_ZONE + '</i>&nbsp;' + ec2_avail_zone + '</dd>').appendTo($('#dl_review'));
                $('<dd><br/></dd>').appendTo($('#dl_review'));
            }
            else {
                $('<dt>' + S_REVIEW_SYS + '</dt>').appendTo($('#dl_review'));
                $('<dd><i>' + S_REVIEW_HOST_NAME + '</i>&nbsp;' + SETUP_WIZ.setupWizObj.host_name + '</dd>').appendTo($('#dl_review'));
                var dhcp_enabled = SETUP_WIZ.setupWizObj.dhcp_enabled;
                if(dhcp_enabled) {
                    $('<dd><i>' + S_REVIEW_IP_TYPE + '</i>&nbsp;DHCP' + '</dd>').appendTo($('#dl_review'));
                } else {
                    $('<dd><i>' + S_REVIEW_IP_ADDR + '</i>&nbsp;' + SETUP_WIZ.setupWizObj.iface_ip  + '/' + SETUP_WIZ.setupWizObj.iface_mask + '</dd>').appendTo($('#dl_review'));
                    $('<dd><i>' + S_REVIEW_GWAY + '</i>&nbsp;' + SETUP_WIZ.setupWizObj.iface_gw + '</dd>').appendTo($('#dl_review'));
                    $('<dd><i>' + S_REVIEW_DNS + '</i>&nbsp;' + SETUP_WIZ.setupWizObj.dns_server + '</dd>').appendTo($('#dl_review'));
                    $('<dd><i>' + S_REVIEW_DOMAIN_NAME + '</i>&nbsp;' + SETUP_WIZ.setupWizObj.dns_name + '</dd>').appendTo($('#dl_review'));
                }
                $('<dd><br/></dd>').appendTo($('#dl_review'));
            }
        }

        $('<dt>' + S_REVIEW_GEN  + '</dt>').appendTo($('#dl_review'));
        $('<dd>' + S_REVIEW_ADMIN_PASS + '</dd>').appendTo($('#dl_review'));
        $('<dd><br/></dd>').appendTo($('#dl_review'));

        $('<dt>' + S_REVIEW_LS + '</dt>').appendTo($('#dl_review'));
        $('<dd>' + S_REVIEW_ENC_KEY + '</dd>').appendTo($('#dl_review'));
        $('<dd><i>' + S_REVIEW_DB_LOC + '</i>' + SETUP_WIZ.setupWizObj.pg_db_location + '</dd>').appendTo($('#dl_review'));
    },

    nextAction : function () {

        function updatePaneAndButton() {
            SETUP_WIZ.togglePanes(SETUP_WIZ.currentPane, SETUP_WIZ.nextPane);
            SETUP_WIZ.nextPane += 1;
            SETUP_WIZ.currentPane += 1;
            SETUP_WIZ.updateButtonStates();
        }

        if (SETUP_WIZ.currentPane === SETUP_WIZ.activePanes.length - 1) {  //Finish Pane
            //If system is enabled and net is managed and static ip is set then update the static ip information when user clicks the Finish button
            if(SETUP_WIZ.isSystemInfsManaged() && !SETUP_WIZ.setupWizObj.dhcp_enabled) {
                $.ajax({
                    url: 'setup_static_ip',
                    type: 'POST',
                    async: false,
                    data: JSON.stringify(SETUP_WIZ.setupWizObj),
                    contentType: 'application/json',
                    dataType: 'json',
                    success : function (response) {
                        if(response.status === 0) {
                            $('#finish_success').html(S_FINISH_MSG.format(SETUP_WIZ.setupWizObj.iface_ip, server_port));
                            $('#note').html(S_PANE_MSGS['finish_static_success']);
                        } else {
                            $('#finish_success').html(S_ERR_STATIC_IP_MSG.format(SETUP_WIZ.setupWizObj.iface_ip));
                            $('#note')
                                  .addClass('alert-error')
                                  .removeClass('alert-info')
                                  .html(S_PANE_MSGS['finish_static_error']);
                        }
                    },
                    fail : function(response) {
                        $('#note').html(S_PANE_MSGS['finish_static_error']);
                    }
                });
                $('#next_btn').attr('disabled', true);
                SETUP_WIZ.updateHelpID(SETUP_WIZ.activePanes[SETUP_WIZ.currentPane]);
                return;
            } else {
                $('#target').submit();
            }
        } else if (SETUP_WIZ.nextPane === SETUP_WIZ.activePanes.length - 1) { //Progress Pane
            if (SETUP_WIZ.serversConfigured) {
                if (SETUP_WIZ.setupResult.status.length > 0) {
                    $('#finish_success').hide();
                    $('#finish_msg').removeClass('hide');

                    $.each(SETUP_WIZ.setupResult.status, function (index, val) {
                        var li_text = S_SETUP_TASK_MSGS[val+'_error'];
                        $('<li>' + li_text + '</li>').addClass('text-error').appendTo($('#finish_msg_list'));
                    });
                } else {
                    var dhcp = SETUP_WIZ.setupWizObj.dhcp_enabled;
                    if(SETUP_WIZ.isSystemInfsManaged() && !dhcp) {
                        $('#finish_success').html(S_USE_STATIC_IP_MSG.format(SETUP_WIZ.setupWizObj.iface_ip));
                    }
                }
                if(SETUP_WIZ.isSystemInfsManaged() && !SETUP_WIZ.setupWizObj.dhcp_enabled) {
                     $('#note')
                          .show()
                          .html(S_PANE_MSGS['finish_static']);
                } else {
                     $('#note')
                          .show()
                          .html(S_PANE_MSGS['finish']);
                }
                updatePaneAndButton();
                SETUP_WIZ.updateHelpID(SETUP_WIZ.activePanes[SETUP_WIZ.currentPane]);
                return;
            }
        } else if (SETUP_WIZ.nextPane === SETUP_WIZ.activePanes.length - 2) { //Review Pane
            $('.server_setup').each(function () {
                var idStr = $(this).attr('id');
                var strSplit = idStr.split('_');
                idStr = strSplit[1];

                if ($.inArray(idStr, SETUP_WIZ.activeTasks) !== -1) {
                    $(this).removeClass('hide');
                } else {
                    $(this).addClass('hide');
                }
            });
            updatePaneAndButton();
            SETUP_WIZ.beginServerConfigAction();
        } else {
            //stay on the currentPane if validation fails
            if (!SETUP_WIZ.validatePane(SETUP_WIZ.currentPane)) {
                return;
            }
            updatePaneAndButton();
        }

        var current_pane_id = SETUP_WIZ.activePanes[SETUP_WIZ.currentPane];
        if (current_pane_id === 'review') {
            SETUP_WIZ.prepareReviewPaneContents();
        }
        if (current_pane_id === 'progress') {
            var wait_msg = S_WAIT_MSG;
            if(system_enabled) {
                wait_msg = wait_msg + '<br>' + S_PANE_MSGS['system_info'];
            }
            $('#note').html(wait_msg);
        }else {
            if (S_PANE_MSGS[SETUP_WIZ.activePanes[SETUP_WIZ.currentPane]]) {
                $('#note').show()
                          .html(S_PANE_MSGS[SETUP_WIZ.activePanes[SETUP_WIZ.currentPane]]);
            }
            else {
                $('#note').hide();
            }
        }
        SETUP_WIZ.updateHelpID(SETUP_WIZ.activePanes[SETUP_WIZ.currentPane]);
    }
};

$(document).ready(SETUP_WIZ.init);
