var SYS_D = {

    pollServerStatus : null,

    // setup the page
    init : function () {
        SYS_D.initUI();
        SYS_D.initEvents();
        SYS_D.initHelp();
    },

    // initialize UI elements
    initUI : function () {
        $('#progress_refresh_ping').hide();
        $('#progress_refresh_status_report').hide();
        $('#ping_error').hide();

        $('#ping_host').live('change keyup', function() {
            $('#ping_error').hide();
        });

        SYS_D.doStatusReport();
        SYS_D.updateServerInfo();
        SYS_D.refreshLog();
        SYS_D.initTaskHistoryTable();
    },

    // add event handlers
    initEvents : function () {
        $('#btn_ping').button().click(SYS_D.doPing);
        $('#btn_sys_update').button().click(SYS_D.doSysUpdate);
        $('#btn_status_report').button().click(SYS_D.doStatusReportDownload);
        $('#btn_send_status_report').button().click(SYS_D.doSendStatusReport);
        $('#btn_refresh_status_report').button().click(function() {
            var attr = $('#btn_refresh_status_report').attr('disabled');
            if (attr !== 'true' && attr !== 'disabled') {
                SYS_D.doStatusReport();
            }
        });

        $('#ssh_btn').button().click(SYS_D.sshAction);
        $('#ssh_enabled').click(SYS_D.toggleSshEnabled);

        $('#refresh_server_log').button().click(function() {
            var attr = $('#refresh_server_log').attr('disabled');
            if (attr !== 'true' && attr !== 'disabled') {
                SYS_D.refreshLog();
            }
        });

        $("#refresh_task_history").click(SYS_D.refreshGrid);

        $(window).bind('resizeEnd', function() {
            SYS_D._doResizeGrid();
        });

        // start a poller to refresh the system info
        SYS_D.pollServerStatus = new POLLER('server_info', null, 30000, SYS_D.updateServerInfoHandler, SYS_D.serverInfoRefreshErrorHandler);
    },

    initHelp : function() {
        // Update help link based on tab selected
        $('#tabs a[href="#os"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7362;
        });
        $('#tabs a[href="#server"]').click(function (e) {
            HELP_LINK_OVERRIDE = 7363;
        });
    },

    doPing : function() {
        if ($('#btn_ping').text() === S_PING) {
            $('#ping_results').val('');

            // validate the host
            var host = $('#ping_host').val();
            if (host.length === 0 || (!IPHELPER.validIP4(host) && !validateDomainNameStr(host))) {
                $('#ping_results').val(S_ERR_PING_HOST+host);
                return;
            }

            // toggle the UI state
            $('#progress_refresh_ping').show();
            $('#btn_ping').text(S_STOP);

            // jquery's ajax request doesn't support readystatechange events, so we do it manually to support the streaming response
            var ping_req = new XMLHttpRequest();
            ping_req.open('POST', 'start_ping?host='+host);
            ping_req.onreadystatechange = function() {
                // check status is 200
                if (this.status === 200) {
                    if (this.readyState === 3) {  // in progress
                        $('#ping_results').val(this.responseText);
                    }
                    else if (this.readyState === 4) {  // done
                        $('#ping_results').val(this.responseText);
                        $('#btn_ping').text(S_PING);
                        $('#progress_refresh_ping').hide();
                    }
                }
                else if (this.readyState > 1) {  // readystate<1 means haven't sent data yet; IE will have status=0 with readystate=1
                    // error
                    $('#ping_results').val(this.responseText);
                    $('#btn_ping').text(S_PING);
                    $('#progress_refresh_ping').hide();
                }
            };
            ping_req.send();
        }
        else { // assume it is stop
            $.ajax({
                url: 'stop_ping',
                type: 'POST',
                success: function(response) {
                    // don't need to do anything - handled by complete()
                },
                error: function(response) {
                    var curr_data = $('#ping_results').val();
                    $('#ping_results').val(curr_data + response.responseText);
                },
                complete: function() {
                    $('#btn_ping').text(S_PING);
                    $('#progress_refresh_ping').hide();
                }
            });
        }
    },


    // ------------ System Update  -----------------------------------------------------

    doSysUpdate : function() {
        WGRD.doModal('#update_dlg',
                     SYS_D.initSysUpdateModal,
                     SYS_D.saveSysUpdateModal);
    },

    initSysUpdateModal : function() {
        // clear the package text field
        $('#update_package').val('');

        return true;
    },

    saveSysUpdateModal : function() {
        // check if the package name is valid
        var pname = $('#update_package').val();
        if (pname.length === 0 || $.inArray(pname, installed_packages) === -1) {
            return S_ERR_INVALID_PACKAGE;
        }

        // send the task request to the server
        var err = null;
        $.ajax({
            url: 'update_package?package='+pname,
            type: 'POST',
            async: false,
            error: function(data) {
                err = data.statusText;
            }
        });

        return err;
    },

    // ------------ System Update (end) ------------------------------------------------


    doStatusReportDownload : function(){
        WGRD.enableUIElements(false, ['#btn_status_report']);

        $('#progress_dlg').modal();

        $.ajax({
            url: 'gen_diag_file',
            dataType: 'json',
            success: function(response) {
                $('#progress_dlg').modal('hide');
                if (response.status === 0) {
                    window.location = 'get_tmp_file';
                }
                else {
                    var msg = S_GET_DIAGS_ERROR;
                    if (response.message) {
                        msg += '<br/>' + response.message;
                    }
                    WGRD.okMessageModal(msg, S_GET_DIAGS_TITLE);
                }
            },
            error: function(response) {
                $('#progress_dlg').modal('hide');
                WGRD.okMessageModal(S_GET_DIAGS_ERROR, S_GET_DIAGS_TITLE);
            },
            complete: function() {
                WGRD.enableUIElements(true, ['#btn_status_report']);
            }
        });
    },

    doSendStatusReport : function(){
        WGRD.enableUIElements(false, ['#btn_send_status_report']);

        $('#progress_dlg').modal();

        $.ajax({
            url: 'send_diag_file',
            dataType: 'json',
            success: function(response) {
                $('#progress_dlg').modal('hide');
                WGRD.okMessageModal(S_SEND_DIAGS_OK, S_GET_DIAGS_TITLE);
            },
            error: function(response) {
                $('#progress_dlg').modal('hide');
                WGRD.okMessageModal(S_GET_DIAGS_ERROR, S_GET_DIAGS_TITLE);
            },
            complete: function() {
                WGRD.enableUIElements(true, ['#btn_send_status_report']);
            }
        });
    },

    doStatusReport : function() {
        WGRD.enableUIElements(false, ['#btn_refresh_status_report']);
        $('#progress_refresh_status_report').show();
        $('#status_report_results').val('');

        $.ajax({
            url: 'get_status_report',
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                // update the text area with the new data
                $('#status_report_results').val(response.data);
            },
            error: function(response) {
                $('#status_report_results').val('');
            },
            complete: function() {
                $('#progress_refresh_status_report').hide();
                WGRD.enableUIElements(true, ['#btn_refresh_status_report']);
            }
        });
    },

    // ------------ SSH  ---------------------------------------------------------------

    toggleSshEnabled : function(event) {
        var enable = $('#ssh_enabled').is(':checked');
        WGRD.enableUIElements(enable, ['#ssh_port']);
    },

    sshAction : function() {
        WGRD.doModal('#ssh_dlg',
                     SYS_D.initSshModal,
                     SYS_D.saveSshModal);
    },

    initSshModal : function() {
        // get the current ssh setting
        var cfg_ssh = null;
        $.ajax({
            url: 'get_support_access_state',
            dataType: 'json',
            async: false,
            success: function(response) {
                cfg_ssh = response;
            },
            error: function(response) {
                alert(S_ERR_GET_SSH_CONFIG);
            }
        });

        if (!cfg_ssh) {
            return false;
        }

        $('#ssh_enabled').prop('checked', cfg_ssh.enabled);
        $('#ssh_port').val(cfg_ssh.port);
        SYS_D.toggleSshEnabled();

        return true;
    },

    saveSshModal : function() {
        // save the ssh setting
        var enabled = $('#ssh_enabled').is(':checked');

        if (enabled) {
            var ssh_port_error = WGRD.isValidNumeric($('#ssh_port'), S_SSH_PORT_NAME);
            if (ssh_port_error && ssh_port_error.length > 0) {
                $('#ssh_port').focus();
                $('#ssh_port').select();
                return ssh_port_error;
            }
        }

        var err = null;
        var port = parseInt($('#ssh_port').val(), 10);
        $.ajax({
            url: 'set_support_access_state?enabled='+enabled+'&port='+port,
            type: 'POST',
            async: false,
            error: function(data) {
                err = data.statusText;
            }
        });

        return err;
    },

    // ------------ SSH (end) ----------------------------------------------------------

    updateServerInfoHandler : function(response) {
        SYS_D.updateServerInfoUI(response);
        return true;
    },

    serverInfoRefreshErrorHandler : function(response, num_failed) {
        return true;
    },

    // ajax call to get some updated server info and refresh the UI
    updateServerInfo : function() {
        $.ajax({
            url: 'server_info',
            type: 'POST',
            dataType: 'json',
            success: function(data) {
                SYS_D.updateServerInfoUI(data);
            }
        });
    },

    updateServerInfoUI : function(data) {
        typeof data.ws_uptime == "undefined" ? $('#ws_uptime').html('') : $('#ws_uptime').html(data.ws_uptime);
        typeof data.ws_memory == "undefined" ? $('#ws_memory').html('') : $('#ws_memory').html(data.ws_memory);

        if (typeof data.ws_cpu_tooltip != "undefined") {
            $('#ws_cpu').html(data.ws_cpu + '&nbsp;<a id="ws_cpu_tooltip" data-toggle="tooltip"><i class="icon-question-sign"></i></a>');
            $('#ws_cpu_tooltip').tooltip({
                html: true,
                placement: 'right',
                title: data.ws_cpu_tooltip
            });
        }
        else if (typeof data.ws_cpu != "undefined") {
            $('#ws_cpu').html(data.ws_cpu);
        }
        else {
            $('#ws_cpu').html('');
        }
    },

    refreshLog : function() {
        WGRD.enableUIElements(false, ['#refresh_server_log']);
        $('#progress_refresh_server_log').show();
        $('#server_log').val('');

        var lines = 100;  // default
        var error = WGRD.isValidNumeric($('#server_log_lines'), '');
        if (!error || error.length === 0) {
            lines = parseInt($('#server_log_lines').val(), 10);
        }
        else {
            $('#server_log_lines').val(lines);
        }

        $.ajax({
            url: 'get_log',
            type: 'POST',
            dataType: 'json',
            data: {'num_lines': lines},
            success: function(response) {
                // update the text area with the new data
                $('#server_log').val(response.data);
            },
            error: function(response) {
                $('#server_log').val('');
            },
            complete: function() {
                $('#progress_refresh_server_log').hide();
                WGRD.enableUIElements(true, ['#refresh_server_log']);
            }
        });
    },

    // ------------ System Task History ------------------------------------------------

    initTaskHistoryTable : function(){
        var taskHistoryGrid = $("#task_history_table").jqGrid({
            datatype: SYS_D.refreshGrid,
            // The colNames are placed in the template so we can localize them.
            colNames: [
                S_TASK_HISTORY.column_names.state,
                S_TASK_HISTORY.column_names.task_type,
                S_TASK_HISTORY.column_names.creation_time,
                S_TASK_HISTORY.column_names.last_update_time,
                S_TASK_HISTORY.column_names.general_info
            ],
            colModel: [
                { name: 'state', sortable: true },
                { name: 'task_type', sortable: true },
                { name: 'creation_time', sortable: true },
                { name: 'last_update_time', sortable: true },
                { name: 'general_info', sortable: true }
            ],
            rowNum: 10,
            rowList: [10, 20, 30],
            viewrecords: true,
            gridview: true,
            autoencode: true,
            shrinktofit: true,
            viewrecords: true,
            autowidth: true,
            height: "auto",
            sortname: 'creation_time',
            sortorder: 'asc',
            pager: "#task_history_pager"
        });
    },

    refreshGrid: function(){
        WGRD.enableUIElements(false, ['#refresh_task_history']);
        $('#progress_refresh_task_history').show();
        $("#task_history_error").hide();
        $.ajax({
            url: "get_task_history",
            type: 'GET',
            dataType: 'json',
            data: '',
            success: function(data) {
                // update the table with the new data
                SYS_D._loadSpecificData(data);
            },
            error:  function(data){
                $("#task_history_error").show();
            },
            complete: function(data){
                $('#progress_refresh_task_history').hide();
                WGRD.enableUIElements(true, ['#refresh_task_history']);
                SYS_D._doResizeGrid();
            }
        });
    },

    _loadSpecificData: function(data){
        $("#task_history_table").jqGrid('clearGridData');
        $("#task_history_table").jqGrid("setGridParam", {
            "datatype": 'local',
            "data": data
        });
        $("#task_history_table").trigger('reloadGrid');
    },

    _doResizeGrid : function() {
        var pad = parseInt($("#full_width_row").css('margin-left'), 10);
        var row_width = $("#full_width_row").width();
        pad *= 2;
        if (pad === 0) {
            pad += row_width/110;  // add padding to keep the grid smaller than the parent
        }
        var grid_width = row_width - pad;
        $('#task_history_table').setGridWidth(grid_width);
    }
};

$(document).ready(SYS_D.init);
