var SYS_MC = {
	IMPORTED_CERT_LOCATION: '',

    // setup the page
    init : function () {
        SYS_MC.initUI();
        SYS_MC.initEvents();
    },

    // initialize UI elements
    initUI : function () {
        SYS_MC.initCertsGrid();
        SYS_MC.IMPORTED_CERT_LOCATION='/usr/local/share/ca-certificates';
    },

    // add event handlers
    initEvents : function () {
        $('#import_ca_cert_btn').button().click(SYS_MC.importCACertAction);
        $('#view_ca_cert_btn').button().click(SYS_MC.viewCACert);
        $('#remove_ca_cert_btn').button().click(SYS_MC.removeCACertAction);
        $('#view_cert_close').button().click(SYS_MC.viewcloseCACert);
        $('#confirm_close_btn').button().click(function(event) {
            $('#confirm_dlg').modal('hide');
        });
        $('#confirm_remove_btn').click(function(event) {
            SYS_MC.removeCACert();
        });
        $(window).bind('resizeEnd', function() {
            SYS_MC._doResizeGrid();
        });
    },

    // create the certificates table grid
    initCertsGrid : function(data) {
        var certs_grid = $('#certs_table').jqGrid({
            datatype: SYS_MC.refreshGrid,
            colModel: certsColModel,
            colNames: certsColNames,
            loadonce: true,
            loadui: 'block',
            height:'auto',
            autowidth: true,
            shrinkToFit: true,
            sortname: 'org',
            viewrecords: true,
            sortorder: 'asc',
            rowNum: 20,
            rowList: [20,40,60,80],
            pager: '#imported_certs_pager',
            loadComplete:function() {
                SYS_MC.toggleRemoveBtn();
            },
            onSelectRow: function(rowid, status, e) {
                SYS_MC.toggleRemoveBtn();
            }
        });
        certs_grid.jqGrid('navGrid', '#imported_certs_pager', { edit: false, add: false, del: false, search: false, refresh: false });
    },

    toggleRemoveBtn: function() {
        // enable/disable "Remove"/"Edit" button depending on if any rows are selected or not
        var selRowId = $('#certs_table').jqGrid('getGridParam', 'selrow');
        WGRD.enableUIElements(selRowId, ['#remove_ca_cert_btn', '#view_ca_cert_btn']);
    },

    importCACertAction : function() {
        WGRD.doModal('#import_ca_cert_dlg',
                    SYS_MC.initializeCAImport,
                    SYS_MC.saveCACert,
                    null,  // params
                    null,  // cancelHandler
                    true); // stayOpenOnSave
    },

    removeCACertAction : function() {
        var sel_row = $('#certs_table').jqGrid('getGridParam','selrow');
        var rowdata = $('#certs_table').getRowData(sel_row);
        if (sel_row === null) {
            return;
        }

        if (rowdata.filename.substring(0,32) == SYS_MC.IMPORTED_CERT_LOCATION) {
            $("#confirm_dlg").modal();
        } else {
            $('#rem_system_cert_error')
                                .show()
                                .text(S_CA_CERT_SYSTEM_CERT_REMOVE_ERROR)
                                .delay(2000)
                                .fadeOut();
        }
    },

    removeCACert : function() {
        var sel_row = $('#certs_table').jqGrid('getGridParam','selrow');
        var rowdata = $('#certs_table').getRowData(sel_row);
        data = { 'certfile' : rowdata.filename };

        $('#confirm_cancel_btn').show();
        $('#confirm_remove_btn').show();

        $.ajax({
            url: 'remove_cert_file',
            dataType: 'json',
            data: data,
            success: function(response) {
                if (response.success == true) {
                    $('#certs_table').jqGrid('delRowData', sel_row);
                    var table_data = $("#certs_table").jqGrid('getGridParam','data');
                    for (var key in table_data) {
                        if (table_data[key].filename == rowdata.filename) {
                            table_data.splice(key, 1);
                        }
                    }
                    $('#certs_table').trigger('reloadGrid');
                    $('#confirm_dlg').modal('hide');
                } else {
                    var err_msg =  response.err_msg || S_CA_CERT_PATH_ERROR;
                    $('#confirm_cancel_btn').hide();
                    $('#confirm_remove_btn').hide();
                    $('#confirm_close_btn').show();
                    $('#confirm_dlg .modal-body').html("<div><p>" + S_CA_CERT_IMPORTED_CERT_REMOVE_ERROR + "</br>" + err_msg + "</p></div>");
                }
            },
            error: function(response) {
                    $('#confirm_cancel_btn').hide();
                    $('#confirm_remove_btn').hide();
                    $('#confirm_close_btn').show();
                    $('#confirm_dlg .modal-body').html("<div><p>" + S_CA_CERT_IMPORTED_CERT_REMOVE_ERROR + "</p></div>");
            },
        });
    },

    viewCACert : function() {
        var sel_row = $('#certs_table').jqGrid('getGridParam','selrow');
        var rowdata = $('#certs_table').getRowData(sel_row);
        data = { 'certfile' : rowdata.filename };

        $.ajax({
            url: 'get_detailed_cert_info',
            dataType: 'json',
            data: data,
            success: function(response) {
                if (response.success == true) {
                    $('#issuer').html(response.issuer);
                    $('#subject').html(response.subject);
                    $('#serial').html(response.serial);
                    $('#valid_from').html(response.notbefore);
                    $('#valid_to').html(response.notafter);
                    $('#view_cert_dlg').modal();
                } else {
                    $('#view_cert_dlg .modal-body').html("<div><p>" + S_CA_CERT_DETAIL_ERROR + "</p></div>");
                    $('#view_cert_dlg').modal();
                }
            },
            error: function(response) {
                $('#view_cert_dlg .modal-body').html("<div><p>" + S_CA_CERT_DETAIL_ERROR + "</p></div>");
                $('#view_cert_dlg').modal();
            },
        });
    },

    viewcloseCACert : function() {
        $('#view_cert_dlg').modal('hide');
    },

    initializeCAImport : function(params) {
        // clear any existing related divs from the iframe
        $('#uploadCACertFrame').empty();
        $('#caCertForm')[0].reset();  // needed to clear the file input in IE 

        $('#ca_cert_import_file').val('');
        WGRD.enableUIElements(true, ['#ca_import_close', '#ca_import_ok']);
        $('#ca_cert_load_loading').hide();
        $('#ca_cert_load_error').addClass('alert-error')
                                .removeClass('alert-success');
        return true;
    },

    saveCACert : function() {
        if (!$('#ca_cert_import_file').val()) {
            return S_CA_CERT_EMPTY_ERROR;
        }
        // we submit the cert to the server and rely on the iframe reload to close the dialog
        SYS_MC.uploading_ca_cert = true;
        WGRD.enableUIElements(false, ['#ca_import_close', '#ca_import_ok']);
        $('#caCertForm').submit();
        return;
    },

    // called when the iframe that handles the webserver cert upload is loaded
    // we use this to check for uploaded cert errors
    caCertUploaded : function() {
        if (!SYS_MC.uploading_ca_cert) {
            return;
        }
        // check for any errors
        var results = $('#uploadCACertFrame').contents().find('#ca_cert_results_err').text();
        var cert_fname = $('#uploadCACertFrame').contents().find('#ncert_fname').text();
        var cert_org = $('#uploadCACertFrame').contents().find('#ncert_org').text();
        var cert_cname = $('#uploadCACertFrame').contents().find('#ncert_cname').text();
        var cert_country= $('#uploadCACertFrame').contents().find('#ncert_country').text();
        if (results) {
            $('#import_ca_cert_dlg div.wgrd-modal-error').html(results);
            $('#import_ca_cert_dlg div.wgrd-modal-error').show();
        } else {
            $('#ca_cert_load_error').addClass('alert-success')
                                    .removeClass('alert-error')
                                    .text(S_CA_CERT_SUCCESS)
                                    .show();
            // no errors so hide the dialog
            setTimeout(function() {
                var num_rows=$("#certs_table").jqGrid('getGridParam', 'records');
                var new_row= {"org":cert_org, "common_name":cert_cname,"country":cert_country, "imported":true, "filename":cert_fname};
                $('#certs_table').jqGrid('addRowData', num_rows+1, new_row);
                $('#certs_table').trigger('reloadGrid');
                $('#import_ca_cert_dlg').modal('hide');
            }, 1000);
        }
        WGRD.enableUIElements(true, ['#ca_import_close', '#ca_import_ok']);
        $('#ca_cert_load_loading').hide();
        SYS_MC.uploading_ca_cert = false;
    },

    refreshGrid: function(){
        $.ajax({
            url: "get_all_certificates",
            type: 'GET',
            dataType: 'json',
            data: '',
            success: function(data) {
                // update the table with the new data
                SYS_MC._loadSpecificData(data);
            },
            complete: function(data){
                SYS_MC._doResizeGrid();
            }
        });
    },

    _loadSpecificData: function(data){
        $("#certs_table").jqGrid('clearGridData');
        $("#certs_table").jqGrid("setGridParam", {
            "datatype": 'local',
            "data": data
        });
        $("#certs_table").trigger('reloadGrid');
    },

    _doResizeGrid : function() {
        var pad = parseInt($("#full_width_row").css('margin-left'), 10);
        var row_width = $("#full_width_row").width();
        pad *= 2;
        if (pad === 0) {
            pad += row_width/110;  // add padding to keep the grid smaller than the parent
        }
        var grid_width = row_width - pad;
        $('#certs_table').setGridWidth(grid_width);
    },

    showwaitcursor : function(prefix) {
        $('#'+prefix+'error').hide();
        $('#'+prefix+'loading').show();
        return true;
    }
};

$(document).ready(SYS_MC.init);

