var S_USER_MODE = {
    save_btn_id : '#submit_button',
    //Set this flag true from caller, if you want to warn user[currently applicable to config settings log server, system settings]
    show_warning_msg: false,
    selected_tab:'',

    // initialize UI elements
    initUI : function (ids) {
        $.each(ids, function(index, id) {
            (is_page_locked === 1) ? $(id).hide() : $(id).show();
        });
        WGRD.updateModeUI(is_page_locked);
    },

    initEvents : function() {
        //User mode changes
        $('#user_mode_btn').click(S_USER_MODE.check_mode);
        
        $('#mode_switch_save_btn').click(function() {
            $('#mode_switch_dlg').modal("hide");
            S_USER_MODE.cancel_operation();
        });
    },

    check_mode : function() {
        var sel_tab = S_USER_MODE.selected_tab;
        if (is_page_locked === 1) { //Currently view only
            var page_info = {'page': lock_page};
            if (sel_tab.length !== 0) {
                page_info['selected_tab'] = sel_tab;
            }
            WGRD.checkUserMode(page_info).success(function(response) {
                WGRD.handleUserModeResponse(response, S_USER_MODE.save_btn_id);
            });
        } else { //Currently readwrite mode, switch to view only mode
            if(S_USER_MODE.show_warning_msg) {
                $('#mode_switch_dlg').modal("show");
            } else {
                S_USER_MODE.cancel_operation();
            }
        }
    },

    cancel_operation : function() {
        var page_info = {};
        var sel_tab = S_USER_MODE.selected_tab;
        if (sel_tab.length !== 0) {
            page_info['selected_tab'] = sel_tab;
        }
        WGRD.resetUserMode(page_info);
    }
};
$(document).ready();