var USER_MANAGEMENT = {
    mode : '',
    localEnabled: true,

    init : function () {
        USER_MANAGEMENT.initUI();
        USER_MANAGEMENT.initEvents();
    },

    initUI : function () {
        $('#progress_save').hide();
        $('#error_container').hide();

        if (show_local_users) {
            USER_MANAGEMENT.toggleLocal();
            USER_MANAGEMENT.showLocalUsers();
            USER_MANAGEMENT.showHideSubmitButton(false);
        }
        else {
            USER_MANAGEMENT.toggleRemote();
            USER_MANAGEMENT.showRemoteUsers();
        }

        $('#active_directory').hide();

        USER_MANAGEMENT.toggleChangeADSettings();

        WGRD.enableUIElements(false, ['#edit_users', '#remove_users']);
        //Users and Roles
        USER_MANAGEMENT.createUsersRolesGrid();
        USER_MANAGEMENT.initUserModeUI();
    },

    initUserModeUI : function () {
        var ids = ['#add_users', '#remove_users', '#add_save'];
        S_USER_MODE.initUI(ids);

        if (is_page_locked === 1) {
            $('#edit_users').val(S_VIEW_TEXT);
            var elem_ids = ['#add_ad_domain', '#remove_ad_domain',
                            '#active_directory_chkbox', '#dc_ssl_chkbox'
                           ];
            WGRD.enableUIElements(false, elem_ids);
        } else {
            $('#edit_users').val(S_EDIT_TEXT);
        }
    },

    showLocalConfirmDlg : function() {
        if (USER_MANAGEMENT.localEnabled) return;
        USER_MANAGEMENT.toggleRemote();
        $('#toggle_local_dlg').modal();
    },

    showRemoteConfirmDlg : function() {
        if (!USER_MANAGEMENT.localEnabled) return;
        USER_MANAGEMENT.toggleLocal();
        $('#toggle_remote_dlg').modal();
    },

    initEvents : function () {

        $('#local_button').button().click(USER_MANAGEMENT.showLocalConfirmDlg);
        $('#remote_button').button().click(USER_MANAGEMENT.showRemoteConfirmDlg);
        //Users and Roles
        $('#add_users').button().click(USER_MANAGEMENT.showUserRoleModal);
        $('#edit_users').button().click(USER_MANAGEMENT.showUserRoleModal);
        $('#remove_users').button().click(USER_MANAGEMENT.removeUserRole);

        $('#change_pass_chkbox').click(USER_MANAGEMENT.togglePasswordDiv);

        $('#add_resource').on('click', USER_MANAGEMENT.addResource);
        $('#remove_resource').on('click', USER_MANAGEMENT.removeResource);
        $('#device_server_name').on("keyup", USER_MANAGEMENT.groupDeviceSearchEvent);

        $('#copy_device').on('click', USER_MANAGEMENT.copyGroupDevice);
        $('#del_device').on('click', USER_MANAGEMENT.delGroupDevice);

        $('#specify_device_close').on('click', USER_MANAGEMENT.closeGroupDevice);
        $('#specify_device_save').on('click', USER_MANAGEMENT.saveGroupDevice);

        $('#select_user_types').click(USER_MANAGEMENT.toggleUserType);
        $('#user_devices').click(USER_MANAGEMENT.toggleDeviceType);

        $('#active_directory_link').click(USER_MANAGEMENT.showHideADSettings);
        $('#active_directory_chkbox').click(USER_MANAGEMENT.toggleChangeADSettings);

        $('#sa').click(USER_MANAGEMENT.toggleChangeSuperAdminRoleSettings);
        $('#ra').click(USER_MANAGEMENT.toggleChangeRepAdminRoleSettings);
        $('#vl').click(USER_MANAGEMENT.toggleChangeViewLogRoleSettings);
        $('#vr').click(USER_MANAGEMENT.toggleChangeViewRepRoleSettings);

        $('#add_ad_domain').button().click(USER_MANAGEMENT.addADDomain);
        $('#remove_ad_domain').button().click(USER_MANAGEMENT.removeADDomain);
        $('#test_ad_domain').button().click(USER_MANAGEMENT.testADDomain);

        $('#change_passphrase_btn').button().click(USER_MANAGEMENT.changeAdminPassphrase);

        $('#sys_page').click(USER_MANAGEMENT.showSysPage);

        $('#local_cancel_btn').click(function() {
            USER_MANAGEMENT.toggleRemote();
        });

        $('#local_save_btn').click(function() {
            $('#toggle_local_dlg').modal("hide");
            USER_MANAGEMENT.toggleLocal();
            USER_MANAGEMENT.showLocalUsers();
            var new_user_state = USER_MANAGEMENT.localEnabled;
            //Trigger a save only if localEnabled is not True
            if(!show_local_users) {
                var obj = new UserManagementObj();
                obj.is_ext_mgmt_enabled = false;
                // save the data to the server
                WGRD.putData(obj).success(function(response) {
                    // we need to do some things after the save operations is successful
                    if (response.status) {
                        window.location = '/usersandroles/users';
                    }
                });
            }
        });

        $('#remote_cancel_btn').click(function() {
            USER_MANAGEMENT.toggleLocal();
        });

        $('#remote_save_btn').click(function() {
            $('#toggle_remote_dlg').modal("hide");
            USER_MANAGEMENT.toggleRemote();
            USER_MANAGEMENT.showRemoteUsers();
        });

        $('#confirm_save_btn').click(function() {
            $('#confirm_dlg').modal("hide");
            window.location='/system/settings';
        });

        $('#user_confirm_save_btn').click(function() {
            $('#user_confirm_dlg').modal("hide");
            USER_MANAGEMENT.deleteUser();
        });

        $('#submit_button').button()
                           .click(USER_MANAGEMENT.savePage);

        $(window).bind('resizeEnd', function() {
            USER_MANAGEMENT.resizeGrids();
        });

        //User mode changes
        S_USER_MODE.initEvents();
    },

    changeAdminPassphrase : function() {
        var $id = $('#passphrase_success_error');
        $id.hide();

        var password = $('#user_passsword').val();
        var confirm_password = $('#confirm_user_passsword').val();

        var val = validatePassword(password, true);
        if (val !== 0) {
            $('#user_passsword').focus();
            $('#user_passsword').select();
            USER_MANAGEMENT._show_success_error_msg($id, S_ERR_ADMIN_PASSPHRASE, false);
            return S_ERR_ADMIN_PASSPHRASE;
        }

        val = validatePassword(confirm_password, true);
        if (val !== 0) {
            $('#confirm_user_passsword').focus();
            $('#confirm_user_passsword').select();
            USER_MANAGEMENT._show_success_error_msg($id, S_ERR_ADMIN_PASSPHRASE, false);
            return S_ERR_ADMIN_PASSPHRASE;
        }

        if( password !== confirm_password) {
            $('#user_passsword').select();
            $('#user_passsword').focus();
            USER_MANAGEMENT._show_success_error_msg($id, S_ERR_PASSPHRASE_MATCH, false);
            return S_ERR_PASSPHRASE_MATCH;
        }

        val = '';
        var test_data = {'password': password};
        $.ajax({
            url: 'change_passphrase',
            type: 'POST',
            dataType: 'json',
            async: false,
            data: test_data,
            success : function(data) {
                if(data.status) {
                    USER_MANAGEMENT._show_success_error_msg($id, S_PASSWORD_CHANGE_SUCCESS, true);
                    val = S_PASSWORD_CHANGE_SUCCESS;
                    $('#add_close').prop("disabled", true);
                    $('#change_passphrase_btn').prop("disabled", true);
                    $('#loading').show();
                    setTimeout(function() {
                        window.location = 'user_logout';
                    }, 3000);

                } else {
                    USER_MANAGEMENT._show_success_error_msg($id, S_PASSWORD_CHANGE_FAILED, false);
                    val = S_PASSWORD_CHANGE_FAILED;
                }
            },
            error : function(data) {
                USER_MANAGEMENT._show_success_error_msg($id, S_PASSWORD_CHANGE_FAILED, false);
                val = S_PASSWORD_CHANGE_FAILED;
            }
        });
        return val;
    },

    showHideADSettings : function(event) {
        event.preventDefault();
        var ad_div_visible = $('#active_directory').is(':visible');
        if (ad_div_visible) {
            $('#active_directory_link').text(S_SHOW_AD_SETTING_MSG);
        } else {
            $('#active_directory_link').text(S_HIDE_AD_SETTING_MSG);
        }
        USER_MANAGEMENT.showHideSubmitButton(!ad_div_visible);
        $('#active_directory').slideToggle();
    },

    addResource : function(event) {
        event.preventDefault();
        $('#device_server_name').val("");

        $('#filtered_devices_servers').empty();
        $('#active_devices_servers').empty();

        USER_MANAGEMENT.populate_group_device_select();

        $('#active_devices_servers')
            .append($('#active_group_dev option')
            .clone()
            .children()
            .end());

        $('#specify_device_div')
                         .show()
                         .find('h3').text(S_SEL_DEVICES_TITLE);
        $('#main_rbac_div').hide();
    },

    removeResource : function(event) {
        event.preventDefault();
        $('#active_group_dev option:selected').remove();
    },

    copyGroupDevice : function(event) {
        event.preventDefault();
        var selected_items = $('#filtered_devices_servers option:selected');

        $.each(selected_items, function(index, value) {
            var device_id = value.value;
            var title = value.text;
            var type = value.id;
            if($('#active_devices_servers option[value ="'+ device_id +'"]').length === 0) {
                $('#active_devices_servers').append('<option id='+ type +' value='+ device_id + ' title="'+ title +'">' + title + '</option>');
            }
        });
    },

    delGroupDevice : function(event) {
        event.preventDefault();
        $('#active_devices_servers option:selected').remove();
    },

    closeGroupDevice : function() {
        $('#specify_device_div').hide();
        $('#main_rbac_div').show();
    },

    saveGroupDevice : function() {

        var active_grp_device_length = $('#active_devices_servers option').length;
        if(active_grp_device_length !== 0) {
            $('#active_group_dev').empty();
            $('#active_group_dev')
                .append($('#active_devices_servers option')
                .clone()
                .children()
                .end());
        }
        USER_MANAGEMENT.closeGroupDevice();
    },

    groupDeviceSearchEvent : function() {
        var val = $('#device_server_name').val();

        $('#filtered_devices_servers').empty();
        var matching_list = $.map(avail_device_list, function (value) {
                  search = new RegExp(val, "gi");
                  var name_sn = value.name;
                  if(name_sn.match(search)) return value;
                  return null;
        });

        $.each(matching_list, function(index, value) {
            var resource_id = value.id;
            var name_sn = value.name;
            var type = value.type;
            $('#filtered_devices_servers').append('<option id='+ type +' value='+ resource_id + ' title="'+ name_sn +'">' + name_sn + '</option>');
        });
    },

    populate_group_device_select : function() {
        $('#filtered_devices_servers').empty();
        $.each(avail_device_list, function(index, value) {
            var resource_id = value.id;
            var name_sn = value.name;
            var type = value.type;
            $('#filtered_devices_servers').append('<option id='+ type +' value='+ resource_id + ' title="'+ name_sn +'">' + name_sn + '</option>');
        });
    },

    toggleUserType : function() {
        var index = $('#select_user_types')[0].selectedIndex;
        if (index === 0) {
            $('#local_user_pass').show();
            $('#user_type_eg').text("");
        } else {
            if(index === 1) {
                $('#user_type_eg').html(S_EG_AD_USER);
            } else {
                $('#user_type_eg').html(S_EG_AD_GROUP);
            }
            $('#local_user_pass').hide();
        }
    },

    toggleDeviceType : function() {
        if ($('#user_devices')[0].selectedIndex === 0) {
            $('#selected_resources').hide();
        } else {
            $('#selected_resources').show();
        }
    },

    showSysPage : function(event) {
        event.preventDefault();
        var enable = $('#dc_ssl_chkbox').is(':checked');
        if(!enable) return;
        $("#confirm_dlg").modal();
    },

    testADDomain : function() {
        WGRD.doModal('#test_ad_dlg',
                     USER_MANAGEMENT._initializeADTest,
                     USER_MANAGEMENT._testAD,
                     null);
    },

    _initializeADTest : function() {
        $('#user_name').val("");
        $('#password').val("");
        return true;
    },

    _show_success_error_msg : function(id, msg, success) {
        $(id)
             .text(msg)
             .show();
        if(success) {
            $(id)
                 .addClass("alert-success wgrd-modal-success")
                 .removeClass("alert-error wgrd-modal-error");
        } else {
            $(id)
                 .removeClass("alert-success wgrd-modal-success")
                 .addClass("alert-error wgrd-modal-error");
        }
    },

     _testAD : function() {
        var $id = $('#add_success_error');
        $id.hide();
        var user_name = $('#user_name').val();
        var password = $('#password').val();

        var error_msg = '';
        if(user_name.trim().length === 0 ) {
            $('#user_name').focus();
            $('#user_name').select();
            USER_MANAGEMENT._show_success_error_msg($id, S_USER_NAME_EMPTY, false);
            return S_USER_NAME_EMPTY;
        }

        if(password.trim().length === 0 ) {
            $('#password').focus();
            $('#password').select();
            USER_MANAGEMENT._show_success_error_msg($id, S_PASSWORD_EMPTY, false);
            return S_PASSWORD_EMPTY;
        }

        var val = '';
        var test_data = {'user_name': user_name, 'password': password};
        $.ajax({
            url: 'test_ad',
            type: 'POST',
            dataType: 'json',
            async: false,
            data: test_data,
            success : function(data) {
                if(data.status) {
                    USER_MANAGEMENT._show_success_error_msg($id, S_AD_TEST_PASSED, true);
                    val=S_AD_TEST_PASSED;
                } else {
                    USER_MANAGEMENT._show_success_error_msg($id, S_AD_TEST_FAILED, false);
                    val = S_AD_TEST_FAILED;
                }
            },
            error : function(data) {
                USER_MANAGEMENT._show_success_error_msg($id, S_AD_TEST_FAILED, false);
                val = S_AD_TEST_FAILED;
            }
        });
        return val;
    },

    addADDomain : function(event) {
        event.preventDefault();
        if(!WGRD.isEnabled('#add_ad_domain')) {
            return;
        }
        var val = USER_MANAGEMENT._validateAD();

        if(val) {
            var ad_domain = $('#active_directory_domain').val();

            if($('#active_directory_domains option[value="' + ad_domain + '"]').length > 0) {
                $('#active_directory_domain').focus();
                $('#active_directory_domain').select();
                writeErrorContainer(S_AD_DUPLICATE, false);
                return;
            }
            $('#active_directory_domains').append('<option value="' + ad_domain + '">' + ad_domain + '</option>');
            $('#active_directory_domain').val("");
            $('#error_container').hide();
        }
    },

    _validateAD : function() {
        var ad_domain = $('#active_directory_domain').val();

        var pattern = /[^\s]+([.]\w{2,})+/;

        if (ad_domain.length === 0 || (!pattern.test(ad_domain))) {
            $('#active_directory_domain').focus();
            $('#active_directory_domain').select();
            writeErrorContainer(S_ERROR_AD_INVALID, false);
            return false;
        }
        return true;
    },

    removeADDomain : function(event) {
        event.preventDefault();
        if(!WGRD.isEnabled('#remove_ad_domain')) {
            return;
        }
        var sel_ad_domain = $('#active_directory_domains').val();

        if(sel_ad_domain === null || sel_ad_domain.length === 0) return;

        $('#active_directory_domains option[value="' + sel_ad_domain + '"]').remove();

        return;
    },

    /*
       Called when add or Edit buttons are clicked for groups
       If edit, then pass in row data
    */
    showUserRoleModal : function() {
        var button_id = $(this).attr('id');
        var params = {'parent_id': button_id};
        if (button_id === 'edit_users') {
            var sel_row = jQuery('#users_roles_table').jqGrid('getGridParam','selrow');
            if (sel_row === null) {
                return;
            }
        }
        WGRD.doModal('#manage_users_roles_dlg',
                     USER_MANAGEMENT.initializeUsersRoles,
                     USER_MANAGEMENT.saveUsersRoles,
                     params);
    },

    initializeUsersRoles : function(params) {
        var parent_id = params.parent_id;
        $("#save_user").prop("disabled", false);
        if (parent_id === 'add_users') { //Initialize UI
            USER_MANAGEMENT._add_users();
            USER_MANAGEMENT.mode = 'add';
        } else { //Update UI
            USER_MANAGEMENT._edit_users();
            USER_MANAGEMENT.mode = 'edit';
        }
        $('#main_rbac_div').show();
        $('#specify_device_div').hide();
        return true;
    },

    _add_users : function() {

        //Set title
        $('#manage_users_roles_dlg h3').text(S_ADD_USER_TITLE);

        //Reset username
        $('#username').val("")
                      .attr('disabled',false);

        //Reset password and confirm
        $('#user_passsword').val("");
        $('#confirm_user_passsword').val("");

        $('#change_pass_chkbox').prop('checked', false);
        $("#add_save").show();
        $("#change_passphrase_btn").hide();
        //Set local user as default
        $('#select_user_types')[0].selectedIndex = 0;
        $('#select_user_types').prop("disabled", false);
        $('#active_group_dev').empty();
        USER_MANAGEMENT.toggleUserType();
        $('#change_pass_div').hide();

        //Uncheck the roles
        var all_roles_ids = ["#sa", "#ra", "#vl", "#vr"];
        USER_MANAGEMENT._reset_roles(false, all_roles_ids);

        //Select All devices option
        $('#user_devices').val("0");
        $('#user_devices').prop("disabled", false);
        USER_MANAGEMENT.toggleDeviceType();
    },

    //This is useful if someone checks / unchecks super admin role or report admin role
    //If check super admin role - disable other roles and uncheck them
    //Uncheck super admin role - enable other roles and uncheck them
    _reset_roles : function(arg, roles) {
        $.each(roles, function(index, role_id) {
            $(role_id).prop("checked", arg);
            $(role_id).prop("disabled", arg);
        });
    },

    _get_active_roles : function() {
        var all_roles_ids = ["sa", "ra", "vl", "vr"];
        var active_roles = [];
        $.each(all_roles_ids, function(index, role_id) {
            if($('#'+role_id).prop("checked")) {
                active_roles.push(roles_id_map[role_id]);
            }
        });
        return active_roles;
    },

    _edit_users : function() {

        //Set title
        if (is_page_locked === 1) {
            $('#manage_users_roles_dlg h3').text(S_VIEW_USER_TITLE);
        } else {
            $('#manage_users_roles_dlg h3').text(S_EDIT_USER_TITLE);
            USER_MANAGEMENT.toggleChangeViewMode(true);
        }

        var sel_row = jQuery('#users_roles_table').jqGrid('getGridParam','selrow');
        var data = $("#users_roles_table").jqGrid('getGridParam','data');

        var user_obj = null;

        for(var i = 0, len = data.length; i < len; i++) {
            user_obj = data[i];
            if(user_obj.user_name === sel_row) {
                break;
            }
        }
        $('#username')
                     .val(user_obj.user_name)
                     .attr('disabled',true);

        //Reset password and confirm
        $('#user_passsword').val("");
        $('#confirm_user_passsword').val("");

        var user_type = user_obj.user_type;
        var password = user_obj.password;

        var value = user_type_map[user_type];

        $('#select_user_types')[0].selectedIndex = value;
        $('#select_user_types').prop("disabled",true);
        USER_MANAGEMENT.toggleUserType();

        $('#change_pass_chkbox').prop('checked', false);

        if (value === "0") {
           $("#change_pass_div").show();
        } else {
           $("#change_pass_div").hide();
        }

        $("#change_passphrase_btn").hide();
        USER_MANAGEMENT.togglePasswordDiv();

        if (user_obj.user_name === 'admin') {
            $("#sa").prop("checked", true);
            $("#sa").prop("disabled", true);
            $("#local_user_pass").hide();
            USER_MANAGEMENT.toggleChangeSuperAdminRoleSettings();
            $("#add_save").hide();
            return;
        }

        $('#active_group_dev').empty();

        //Uncheck the roles
        var all_roles_ids = ["#sa", "#ra", "#vl", "#vr"];
        USER_MANAGEMENT._reset_roles(false, all_roles_ids);

        var user_roles = user_obj.user_roles;
        $.each(user_roles, function(index, value) {
            var role_id = roles_id_map[value];
            $("#" +role_id +"").prop("checked", true);
        });

        var selected_option = 0;  //All devices
        var enable = $('#sa').is(':checked');
        var ra_enable = $('#ra').is(':checked');
        if (enable) {
            USER_MANAGEMENT.toggleChangeSuperAdminRoleSettings(); //If 'Super Admin' role is checked disable all other roles role and check them
        } else if (ra_enable) {
            USER_MANAGEMENT.toggleChangeRepAdminRoleSettings(); //If 'Report Admin' role is checked disable 'View Logs and View Reports' role and check them
        } else {
            var device_list = user_obj.active_devices;

            if(device_list.length !== 0) {
                selected_option = 1;  //Specify devices
                var count = 0;
                var device_ids = [];
                $.each(device_list, function(i, device) {
                    device_ids.push(device.hashid);
                });

                $.each(avail_device_list, function(i, resource) {
                    var resource_id = resource.id;

                    if(device_ids.indexOf(resource_id) !== -1) {
                        var type = resource.type;
                        var id = resource.id;
                        var name_sn = resource.name;
                        $('#active_group_dev').append('<option id='+ type +' value='+ id + ' title="'+ name_sn +'">' + name_sn + '</option>');
                        count = count + 1;
                    }
                    //We only want to iterate the avail_device_list till we have looked into all of the devices in device_list.
                    if(count === device_list.length) return false;
                });

                // View Logs and View Reports only apply to specify devices.
                $('#user_devices').prop("disabled", true);
            }
            $('#user_devices').prop('selectedIndex', selected_option);
            USER_MANAGEMENT.toggleDeviceType();
        }

        // disable the other element ids in RO mode.
        if (is_page_locked === 1) {
            USER_MANAGEMENT.toggleChangeViewMode(false);
        }
    },

    removeUserRole : function() {
        var sel_row = jQuery('#users_roles_table').jqGrid('getGridParam','selrow');
        if (sel_row === null || sel_row === 'admin') {
            if(sel_row === 'admin') {
                $('#rem_admin_error')
                                    .show()
                                    .text(S_ADMIN_USER_REMOVE_ERROR)
                                    .delay(2000)
                                    .fadeOut();
            }
            return;
        } else {
            $("#user_confirm_dlg").modal();
        }
    },

    deleteUser : function() {
        WGRD.enableUIElements(false, ['#remove_users']);
        var sel_row = jQuery('#users_roles_table').jqGrid('getGridParam','selrow');
        var data = $("#users_roles_table").jqGrid('getGridParam','data');
        var user_obj = null;

        for(var i = 0, len = data.length; i < len; i++) {
            user_obj = data[i];
            if(user_obj.user_name === sel_row) {
                break;
            }
        }
        var obj = new UserManagementObj();
        obj.is_ext_mgmt_enabled = false;
        user_obj.user_action = 2;
        obj.user_obj = user_obj;
        // save the data to the server
        WGRD.putData(obj).success(function(response) {
            if (response.status) {
                var index = ($.inArray(user_obj, data));
                data.splice($.inArray(user_obj, data), 1);
                $('#users_roles_table').trigger('reloadGrid');
                $('#error_container').text(S_USER_DEL_MSG);
            }
            $('#error_container')
            .delay(2000)
            .fadeOut();
        });
    },

    saveUsersRoles : function(params) {
        var parent_id = params.parent_id;

        if (parent_id === 'add_users') { //Initialize UI
            return USER_MANAGEMENT._save_user();
        } else { //Update UI
            return USER_MANAGEMENT._update_user();
        }
    },

    _validate_user_type : function(user_type, obj) {
        var ret = '';
        var user_name = $('#username').val();
        switch (user_type) {
            case 0:
                var patt = /[-!\@$%^&*()_+|~=`{}\[\]:";'<>?,.\/]/;
                if (patt.test(user_name)) {
                    $('#username').focus();
                    $('#username').select();
                    return S_ERR_LOCAL_USER;
                }
                var is_checked = $('#change_pass_chkbox').is(':checked');
                if(USER_MANAGEMENT.mode == 'add' || is_checked) {
                    //Local User validate password
                    var password = $('#user_passsword').val();
                    var confirm_password = $('#confirm_user_passsword').val();

                    var val = validatePassword(password, true);
                    if (val !== 0) {
                        $('#user_passsword').focus();
                        $('#user_passsword').select();
                        return S_ERR_ADMIN_PASSPHRASE;
                    }

                    val = validatePassword(confirm_password, true);
                    if (val !== 0) {
                        $('#confirm_user_passsword').focus();
                        $('#confirm_user_passsword').select();
                        return S_ERR_ADMIN_PASSPHRASE;
                    }

                    if( password !== confirm_password) {
                        $('#user_passsword').select();
                        $('#user_passsword').focus();
                        return S_ERR_PASSPHRASE_MATCH;
                    }
                }
                break;
            case 1:
                //AD User validation
                if(USER_MANAGEMENT.mode == 'add') {
                    var patt1 = /[^\s]+@[^\s]+([.]\w{2,})+/;
                    if (!patt1.test(user_name)) {
                        $('#username').focus();
                        $('#username').select();
                        return S_ERR_AD_USER;
                    }
                }
                break;
            case 2:
                if(USER_MANAGEMENT.mode == 'add') {

                    //CN=joe,OU=Users,OU=My,DC=test,DC=loc. Canonically that looks like test.loc/My/Users/joe
                    //formatGroup regex should start with any word char ie matches any single letter, number or underscore (same as [a-zA-Z0-9_])
                    //It could also contain a space, ' or a dash(-) Should have at least one dot followed by a word and atleast one / and ending with a word
                    var formatGroup = /^(\w+((\w+|\s|-|')*\w+[.]))+(\w+(\w+|\s|-|')*\w+\/)+\w+(\w+|\s|-|')*\w+$/;

                    //FormatCN should start with a cn=<any word and allow - or ' or space in the name followed by 0 or more ou= and atleast two dc=
                    //Should not have leading or trailing spaces
                    //Can have dashes, spaces or single quotes for the values of cn= or ou= or dc=
                    //Atleast one cn=should be present, ou= are optional at least 2 dc= should be present. 
                    var formatCN=/^(cn=\w+(\w+|'|\s|-)*(\w)+,)+(ou=(\w)+(\w|\s|-|')*(\w)+,)*(dc=\w+(\w+|'|\s|-)*,)+(dc=\w+(\w+|'|\s|-)*)$/;

                    user_name = user_name.toLowerCase();

                    if(formatGroup.test(user_name)) {
                        obj.user_name = user_name;
                    } else if(formatCN.test(user_name)) {
                        obj.user_name = USER_MANAGEMENT._normalize_ad_group(user_name);
                    } else {
                        $('#username').focus();
                        $('#username').select();
                        return S_ERR_AD_GROUP;
                    }
                }
                break;
        }
        return '';
    },

    _normalize_ad_group : function (user_name) {
        //Extract dc
        var dc_index = user_name.indexOf('dc=');
        var cn_str = '';
        var ou_str = '/';
        var dc_str = user_name.substring(dc_index, user_name.length).trim();

        //check if we have 'ou='
        var ou_index = user_name.indexOf('ou=');
        if (ou_index === -1) {//
            cn_str = user_name.substring(0, dc_index - 1);
        } else {
            ou_str = user_name.substring(ou_index, dc_index - 1);
            ou_str = ou_str.replace(/ou=/g,'');
            var ou_comma_index = ou_str.indexOf(',');
            if (ou_comma_index !== -1) {
                var tmp_ou = '';
                ou_str = ou_str.split(',');
                for(var ou = ou_str.length - 1; ou >=0 ; ou--) {
                    tmp_ou = tmp_ou + ou_str[ou] + '/';
                }
                ou_str = '/'+tmp_ou;
            } else {
                ou_str = '/'+ou_str+'/';
            }
            cn_str = user_name.substring(0, ou_index - 1);
        }
        cn_str = cn_str.replace(/cn=/g,'');
        var cn_comma_index = cn_str.indexOf(',');
        if (cn_comma_index !== -1) {
            var tmp_cn = '';
            cn_str = cn_str.split(',');
            for(var cn = cn_str.length - 1; cn >=0 ; cn--) {
                tmp_cn = tmp_cn + cn_str[cn] + '/';
            }
            cn_str = tmp_cn.substring(0, tmp_cn.length - 1);
        } else {
            cn_str = cn_str;
        }

        dc_str = dc_str.replace(/dc=/g,'');
        dc_str = dc_str.replace(/,/g,'.');
        return dc_str+ou_str+cn_str;
    },

    _save_user : function() {

        //validate dialog controls
        var user_name = $('#username').val();

        if(user_name.trim().length === 0) {
            return S_USER_NAME_EMPTY;
        }

        var grid_data = $("#users_roles_table").jqGrid('getGridParam','data');

        var user_obj = null;

        var user_type = $('#select_user_types')[0].selectedIndex;

        if (user_type === 2) { //Type AD group check if it matches CN= format
            var formatCNRegex=/^(cn=\w+(\w+|'|\s|-)*(\w)+,)+(ou=(\w)+(\w|\s|-|')*(\w)+,)*(dc=\w+(\w+|'|\s|-)*,)+(dc=\w+(\w+|'|\s|-)*)$/;
            var temp_user_name = user_name.toLowerCase();
            if(formatCNRegex.test(user_name)) {
                user_name = USER_MANAGEMENT._normalize_ad_group(user_name);
            }
        }

        for(var i = 0, len = grid_data.length; i < len; i++) {
            user_obj = grid_data[i];
            if(user_obj.user_name === user_name) {
                return S_ERR_USER_DUPLICATE;
            }
        }
        user_obj = new UserObj();
        user_obj.user_name = user_name;
        var msg = USER_MANAGEMENT._update_user_obj(user_obj);
        if(msg) return msg;
        var obj = new UserManagementObj();
        obj.is_ext_mgmt_enabled = false;
        user_obj.user_action = 0;
        obj.user_obj = user_obj;
        // save the data to the server
        WGRD.putData(obj).success(function(response) {
            // we need to do some things after the save operations is successful
            if (response.status) {
                    grid_data.push({
                   'user_name':user_obj.user_name,
                   'user_type':user_obj.user_type,
                   'password':user_obj.password,
                   'user_roles':user_obj.user_roles,
                   'active_devices':user_obj.active_devices,
                   '__module__': 'modules.scripts.users.user_scripts',
                   '__class__': 'UserObj'
                 });
                $('#users_roles_table').trigger('reloadGrid');
                $('#error_container').text(S_USER_ADD_MSG);
            }
            $('#error_container')
            .delay(2000)
            .fadeOut();
        });
        return '';
    },

    _update_user : function() {

        //validate dialog controls
        var user_name = $('#username').val();

        if(user_name.trim().length === 0) {
            return S_USER_NAME_EMPTY;
        }

        var data = $("#users_roles_table").jqGrid('getGridParam','data');

        var user_obj = null;

        for(var i = 0, len = data.length; i < len; i++) {
            user_obj = data[i];
            if(user_obj.user_name === user_name) {
                break;
            }
        }

        var current_user_roles = user_obj.user_roles;

        jQuery.each(current_user_roles, function(i, val) {
            if (role_locNames_engNames_map[val] !== undefined) {
                current_user_roles[i] = role_locNames_engNames_map[val]; 
            }
        });

        var msg = USER_MANAGEMENT._update_user_obj(user_obj);
        if(msg) return msg;

        var updated_user_roles = user_obj.user_roles;

        user_obj.current_user_roles = current_user_roles;
        user_obj.user_roles = updated_user_roles;

        var obj = new UserManagementObj();
        obj.is_ext_mgmt_enabled = false;
        user_obj.user_action = 1;
        obj.user_obj = user_obj;
        // save the data to the server
        WGRD.putData(obj).success(function(response) {
            // we need to do some things after the save operations is successful
            if (response.status) {
                $('#users_roles_table').trigger('reloadGrid');
                $('#error_container').text(S_USER_EDIT_MSG);
            }
            $('#error_container')
                .delay(2000)
                .fadeOut();
        });
        return "";
    },

    _update_user_obj : function(user_obj) {

        var user_type = $('#select_user_types')[0].selectedIndex;

        var val = USER_MANAGEMENT._validate_user_type(user_type, user_obj);

        if (val !== '') return val;
        user_obj.user_type = user_type_map[user_type];
        var user_password = $('#user_passsword').val();
        if(user_type === 0 && user_password.trim() !== '') {
            user_obj.password = user_password;
        } else {
            user_obj.password = "";
        }

        var active_roles = USER_MANAGEMENT._get_active_roles();
        if(active_roles.length === 0) return S_ERR_ROLES;
        user_obj.user_roles = active_roles;

        var active_device_list = [];
        var index = $('#user_devices')[0].selectedIndex;
        if (index !== 0 && $('#active_group_dev option').length === 0) {
            return S_DEVICE_ADD_MSG;
        }

        var is_group_present = false;
        if(index !== 0) {
             $('#active_group_dev option').each(function() {
                var resource = {};
                resource['hashid'] = this.value;
                resource['type'] = parseInt(this.id, 10);
                resource['name'] = '';
                resource['serialno'] = '';
                if (!is_group_present && resource['type'] === 3) {
                    is_group_present = true;
                }
                active_device_list.push(resource);
            });
        }

        if (active_roles.length === 1 && active_roles[0] === roles_id_map['vl'] && is_group_present) {
            return S_ERROR_GROUP_MSG;
        }

        user_obj.active_devices = active_device_list;
    },

    toggleLocal : function() {
        $('#local_button').addClass('active');
        $('#remote_button').removeClass('active');
        USER_MANAGEMENT.localEnabled = true;
    },

    toggleRemote : function() {
        $('#local_button').removeClass('active');
        $('#remote_button').addClass('active');
        USER_MANAGEMENT.localEnabled = false;
    },

    showLocalUsers : function () {
        $('#local_users').show();
        $('#external_users').hide();
        var enable = $('#active_directory').is(':visible');
        USER_MANAGEMENT.showHideSubmitButton(enable);
        USER_MANAGEMENT.resizeGrids();
    },

    showRemoteUsers : function () {
        $('#local_users').hide();
        $('#external_users').show();
        if(is_page_locked !== 1) {
            $('#submit_button').show();
        }
    },

    toggleChangeViewMode : function(enabled) {
        // Disable or enable the other element ids in RO or RW mode.
        var elem_ids = ['#change_pass_chkbox', '#sa', '#ra', '#vl', '#vr',
                        '#user_devices', '#active_group_dev'];
        WGRD.enableUIElements(enabled, elem_ids);
        if (enabled) {
            $('#add_resource').show();
            $('#remove_resource').show();
            $("#add_save").show();
        } else {
            $('#add_resource').hide();
            $('#remove_resource').hide();
            $("#add_save").hide();
        }
    },

    //If super admin role is checked, then reset other roles ie uncheck them and disable them
    //Also disable the user devices drop down and select 'All devices' option
    toggleChangeSuperAdminRoleSettings : function() {
        var enable = $('#sa').is(':checked');
        var roles_ids = ["#ra", "#vl", "#vr"];
        USER_MANAGEMENT.toggleRoleAndDeviceSelection(enable, roles_ids);
    },

    toggleRoleAndDeviceSelection : function(enabled, roles) {
        if(enabled) {
           USER_MANAGEMENT._reset_roles(true, roles);
           $('#user_devices').prop("disabled", true);
           $('#user_devices').val("0");
        } else {
           USER_MANAGEMENT._reset_roles(false, roles);
           $('#user_devices').prop("disabled", false);
        }
        USER_MANAGEMENT.toggleDeviceType();
    },

    toggleChangeRepAdminRoleSettings : function() {
        var enable = $('#ra').is(':checked');
        var roles_ids = ["#vl", "#vr"];
        USER_MANAGEMENT.toggleRoleAndDeviceSelection(enable, roles_ids);
    },

    is_RepAdminRoleChecked : function() {
        var active_roles = USER_MANAGEMENT._get_active_roles();
        var ra_role_present = $.inArray(roles_id_map['ra'], active_roles) !== -1;
        return ra_role_present;
    },

    toggleChangeViewLogRoleSettings : function() {
        var vl_enable = $('#vl').is(':checked');
        var vr_enable = $('#vr').is(':checked');
        USER_MANAGEMENT._updateDeviceViewBasedOnRole(vl_enable, vr_enable)
    },

    toggleChangeViewRepRoleSettings : function() {
        var vr_enable = $('#vr').is(':checked');
        var vl_enable = $('#vl').is(':checked');
        USER_MANAGEMENT._updateDeviceViewBasedOnRole(vr_enable, vl_enable)
    },

    _updateDeviceViewBasedOnRole : function(role1_enabled, role2_enabled) {
        var devices_present = ($('#active_group_dev option').length !== 0);

        if(role1_enabled && !USER_MANAGEMENT.is_RepAdminRoleChecked()) {
           $('#user_devices').prop("disabled", true);
           $('#user_devices').val("1");
        } else if(!role2_enabled) {
           $('#user_devices').prop("disabled", false);
           if (devices_present) {
               $('#user_devices').val("1");
           } else {
               $('#user_devices').val("0");
           }
        }
        USER_MANAGEMENT.toggleDeviceType();
    },

    toggleChangeADSettings : function() {
        if(!WGRD.isEnabled('#active_directory_chkbox')) {
            return;
        }
        var enable = $('#active_directory_chkbox').is(':checked');

        if(enable) {
            $('#active_directory_div').show();
        } else {
            $('#active_directory_div').hide();
        }
    },

    showHideSubmitButton : function(enable) {
        if(enable && is_page_locked !== 1) {
            $('#submit_button').show();
        } else {
            $('#submit_button').hide();
        }
    },

    togglePasswordDiv : function() {
        var enable = $('#change_pass_chkbox').is(':checked');

        if(enable) {
            $('#local_user_pass').show();
        } else {
            $('#local_user_pass').hide();
        }
        
        var user_name = $('#username').val();
        if (user_name === 'admin' && enable && is_page_locked !== 1) {
            $('#change_passphrase_btn').show();
        } else {
            $('#change_passphrase_btn').hide();
        }
    },

    createUsersRolesGrid : function() {
       var users_roles_grid = $('#users_roles_table').jqGrid({
            loadonce: true,
            loadui: 'block',
            datatype: USER_MANAGEMENT.refreshUsersRolesGrid,
            height:'auto',
            autowidth: true,
            shrinkToFit: true,
            colNames: usersRolesColNames,
            colModel: usersRolesColModel,
            pager: '#users_roles_pager',
            sortname: 'user_name',
            viewrecords: true,
            sortorder: 'asc',
            rowNum: 10,
            rowList: [10, 20, 50,100],
            altRows: true,
            altclass: 'gridAltRow',
            loadComplete:function() {
                USER_MANAGEMENT.toggleEditRemoveBtn();
            },
            onSelectRow: function(rowid, status, e) {
                USER_MANAGEMENT.toggleEditRemoveBtn();
            }
        });
         // add the pager with custom actions for the "delete" button
        users_roles_grid.jqGrid('navGrid', '#users_roles_pager', { edit: false, add: false, del: false, search: false, refresh:false});
    },

    toggleEditRemoveBtn: function() {
        // enable/disable "Remove"/"Edit" button depending on if any rows are selected or not
        var selRowId = $('#users_roles_table').jqGrid('getGridParam', 'selrow');
        WGRD.enableUIElements(selRowId, ['#edit_users', '#remove_users']);
    },

    userRolesFormatter: function(cellvalue, options, rowObject) {
        jQuery.each(cellvalue, function(i, val) {
            if (role_engNames_LocNames_map[val] !== undefined) {
                cellvalue[i] = role_engNames_LocNames_map[val]; 
            }
        });
        return cellvalue;
    },

    refreshUsersRolesGrid : function() {
        $('#users_roles_table').jqGrid('setGridParam', {
            datatype: 'local',
            data: active_users_list
        });
        $('#users_roles_table').trigger('reloadGrid');
    },

    resizeGrids : function() {
        // Pass the <table> id then the <div> that wraps it
        resizeGrid('#users_roles_table', '#local_users');
    },

    // validate all UI input
    validateUI : function() {

        var isLocalEnabled = USER_MANAGEMENT.localEnabled;

        if (isLocalEnabled) {  //Validate local user settings
            //verify if at least 'admin' user is present

            if ($('#active_directory_chkbox').is(':checked')) {
                var ad_domains_count = $('#active_directory_domains option').length;
                if (ad_domains_count === 0) {
                    $('#active_directory_domains').focus();
                    $('#active_directory_domains').select();
                    writeErrorContainer(S_ATLEAST_ONE_AD, false);
                    return false;
                }
            }
            return true;

        } else { //validate remote settings
            var ip = $('#mgmt_ip').val();
            if(IPHELPER.usableHostIP4(ip) !== 0) {
                $('#mgmt_ip').focus();
                $('#mgmt_ip').select();
                writeErrorContainer(S_ERR_MGMT_IP, false);
                return false;
            }
        }
        return true;
    },

    savePage : function() {
        $('#error_container').hide();
        $('#submit_button').attr('disabled', true);
        $('#progress_save').show();

        // validate the input
        if (!USER_MANAGEMENT.validateUI()) {
            // validation failed
            $('#submit_button').removeAttr('disabled');
            $('#progress_save').hide();
            return;
        }

        var isLocalEnabled = USER_MANAGEMENT.localEnabled;

        var obj = new UserManagementObj();
        if (isLocalEnabled) {
            //Save AD related settings
            var enable = $('#active_directory_chkbox').is(':checked');
            obj.is_ad_enabled = enable;
            obj.is_ext_mgmt_enabled = false;

            enable = $('#dc_ssl_chkbox').is(':checked');
            obj.dc_ssl_enabled = enable;

            var ad_list = [];
            $('#active_directory_domains option').each(function() {
                ad_list.push($(this).val());
            });

            obj.ad_new_list = ad_list;
            obj.ad_domain_list = ad_domain_list;
        } else {
            obj.is_ext_mgmt_enabled = true;
            obj.mgmt_ip = IPHELPER.trimIP4($('#mgmt_ip').val());
        }

        // save the data to the server
        WGRD.putData(obj).success(function(response) {
            // we need to do some things after the save operations is successful
            if (response.status) {
                var isLocalEnabled = USER_MANAGEMENT.localEnabled;
                if (isLocalEnabled) {
                    ad_domain_list = obj.ad_new_list;
                } else {
                    show_local_users = false;
                }
                $('#error_container')
                                    .delay(2000)
                                    .fadeOut();

                WGRD.updateModeUI(1);;  //Update the user mode div
                WGRD.resetUserMode();  //Reset the lock after save
            }
        });
    }
};
$(document).ready(USER_MANAGEMENT.init);
