var isValidIp = function(element){
    return isValidIpStr($(element).val());
}

var isValidIpStr = function(ip_str){
    return /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/i.test($.trim(ip_str));   
}

var hasDashCommaPeriod = function(element){
    return /^[a-z0-9\_\-\.]+$/i.test($(element).val());
}

var hasPeriodSlashDash = function(element){
    return /^[a-z0-9\.\\\-]+$/i.test($(element).val());
}
var hasAlphaNumSpecial = function(element){
    var val = $(element).val();
    if (val == '') return true;
    return /^[a-z0-9\-\ \,\_\+\.\*\:\@\/]+$/i.test($(element).val());
}
var hasAlphaNumSpecialAll = function(element){
    return valHasAlphaNumSpecialAll($element.val());
}
var valHasAlphaNumSpecialAll = function(val){
    return /^[a-z0-9\-\ \_\+\.\*\:\@\/\~\!\#\%\(\)\{\}\?\`\=\[\]\\\;\,\|\$\^\&]+$/i.test(val);
}

var containsAllAscii = function(str) {
    return  /^[\000-\177]*$/.test(str) ;
}

//Password is valid if it is not empty and less than/equal to 32 chars OR less than/equal to max_length if passed.
//Element 1 is required, Element 2 is optional, if present check if they have identical values
//
// return value, 0 means - password is valid OR respective error number
var checkPassword = function(element1, element2, max_length) {
    var max_length = max_length || 32;
    var password = $(element1).val();
    
    if (password === '') {
        return 1;
    }
    if (password.length > max_length) {
        return (max_length === 32) ? 2 : 3;
    }
    if ($(element2).length) {
        var confirm_password = $(element2).val();
        return (confirm_password === password) ? 0 : 4; 
    }   
    return 0;   
}

// Validate a password.  val is the password string
// limit8_32: Boolean, limit the string to 8-32 chars
// limitAsciiChars: Boolean, limit the string to ascii only
var validatePassword = function(val, limit8_32, limitAsciiChars){
    var limitLength = limit8_32 || false;
    var limitAscii = limitAsciiChars || false;
    
    if($.trim(val) === ''){
        return 1;
    }
    if(val.indexOf(' ') >= 0){
        return 2;
    }
    if(limitLength && (val.length < 8 || val.length > 32)){
        return 3;
    }
    if(limitAscii && valHasAlphaSpecialAll(val)){
        return 4;
    }
    return 0;
}

// Validate a password and a password confirmation.  
// password/confirm are the password strings
// limit8_32: Boolean, limit the string to 8-32 chars
// limitAsciiChars: Boolean, limit the string to ascii only
var validatePasswordAndConfirm = function(password, confirm, limit8_32, limitAsciiChars){
    var limitLength = limit8_32 || false;
    var limitAscii = limitAsciiChars || false;
        
    var passValid = validatePassword(password, limitLength, limitAscii);
    if(passValid){
        return passValid;
    }
    var confValid = validatePassword(confirm, limitLength, limitAscii);
    if(confValid){
        return confValid;
    }
    
    if(password != confirm){
        return 5;
    }
    return 0;
}

var validateDomainName = function(element) {
    var domainName = $.trim($(element).val());
    return validateDomainNameStr(domainName);
}

var validateDomainNameStr = function(str) {
    var domainName = $.trim(str);
    if(domainName.length < 1 || domainName.length > 255){
        return false;
    }

    if(isValidIpStr(domainName)){
        return false;
    }

    return /^([a-zA-Z0-9]([-a-zA-Z0-9]*[a-zA-Z0-9])?\.)+([a-zA-Z])+$/i.test(domainName);
}
 
/*
  If msg is not empty, then show the error message
  and add the error class to control-group which is the
  ancestor of the passed in element
*/ 
var showHideErrorMsg = function (element, msg) {
  if (msg !== undefined) {
    $(element).parents('.control-group').addClass('error');
    $(element + '~ span').text(msg);
  }
  else {
    $(element).parents('.control-group').removeClass('error');
    $(element + '~ span').text(""); 
  }
}