var LogServerConfigObj = function() {
    this.__module__ = 'modules.scripts.servers.log_server_scripts';
    this.__class__ = 'LogServerConfigObj';

    this.audit_comments = '';

    this.db_max_size = 1;
    this.db_size_warning_limit = 8;
    this.db_run_backup_day = 1;
    this.db_run_delete_day = 1;
    this.db_run_delete_time = '';
    this.db_run_backup_time = '';
    this.db_backup_file_dir = '';
    this.db_days_retain_log = 1;
    this.db_backup_enable = 0;
    this.db_last_backup_runtime = '';
    this.db_delete_log_age = '';

    this.db_remote = 0;
    this.db_remote_changed = false;
    this.db_user_name = '';
    this.db_password =  '';
    this.db_host = '';
    this.db_port = '';
    this.db_name = '';
    this.db_location = '';

    this.notif_event_failure = 0;
    this.notif_event_received = 0;
    this.notif_event_purged = 0;

    this.smtp_login_enable = 0;
    this.starttls_enable = 0;
    this.log_del_flag = 0;

    this.email_password = '';
    this.email_user_id = '';
    this.email_address = '';
    this.email_host = '';
    this.email_subject = '';
    this.email_from_address = '';
    this.email_to_address = '';

    this.log_level_system = -1;
    this.log_level_file = -1;
    this.log_file_dir = '';

    this.encryption_key = '';

    //ConnectWise
    this.connectWiseObj = ConnectWiseConfigObj(); //Type ConnectWiseConfigObj

    // report customizations
    this.report_cust_list = [];  // array of ReportCustomizationObjs

    // Use this information to decide if only connectwise/rep customization
    // should be saved or everything, This will be useful when a user with only
    // Report admin permission is logged in and wants to save just connectwise or report customization
    this.rep_customization_cw_only = 0;  //Save everything by default

    // ftp servers
    this.ftp_servers_list = [];  // array of FtpServerObjs
};

var ConnectWiseConfigObj = function() {
    this.__module__ = 'modules.scripts.servers.log_server_scripts';
    this.__class__ = 'ConnectWiseConfigObj';

    this.cw_server = '';
    this.cw_comp_id = '';
    this.cw_login = '';
    this.cw_password = '';
    this.cw_tz = '';
    this.cw_cnames = [];
    this.cw_cert = '';
    this.is_cw_enabled = 0;
};

var ReportCustomizationObj = function() {
    this.__module__ = 'modules.scripts.servers.log_server_scripts';
    this.__class__ = 'ReportCustomizationObj';

    this.name = '';
    this.header_text = '';
    this.footer_text = '';
    this.is_default = false;
    // logo not needed since it is uploaded separately
};

var FtpServerObj = function() {
    this.__module__ = 'modules.scripts.servers.log_server_scripts';
    this.__class__ = 'FtpServerObj';

    this.server_name = '';
    this.upload_location = '';
    this.user_name = '';
    this.user_pass = '';
    this.is_pass_changed = false;
};
