
// override the $.ajax() call with a wrapper that:
//  Adds a call to checkLoginPageRedirect() to handle session expiration on success/error and calls the normal jQuery ajax() function
(function(jQuery) {
    var _o_ajax = jQuery.ajax;  // original jquery ajax() function
    jQuery.ajax = function(url, options) {
        // handle case where only one param is passed in; assume it is options objectc
        if (typeof url === "object") {
            options = url;
            url = undefined;
        }

        // add the checkLoginPageRedirect call to check for auto-redirect to login page (eg, session expiration)
        //   if the dataType is json/jsonp/xml, we will get an error when it tries to parse the html login page content
        //   if it is html/text, it will be success with the html login page content
        if (options.dataType && 
            (options.dataType.toLowerCase() === 'json' || 
             options.dataType.toLowerCase() === 'jsonp' || 
             options.dataType.toLowerCase() === 'xml')) {
            if (options.error) {
                if ($.isArray(options.error)) {
                    options.error.unshift(checkLoginPageRedirect);
                }
                else {
                    options.error = [checkLoginPageRedirect, options.error];
                }
            }
            else {
                options.error = checkLoginPageRedirect;
            }
        }
        else {
            if (options.success) {
                if ($.isArray(options.success)) {
                    options.success.unshift(checkLoginPageRedirect);
                }
                else {
                    options.success = [checkLoginPageRedirect, options.success];
                }
            }
            else {
                options.success = checkLoginPageRedirect;
            }
        }

        // forward to the original jquery call
        return _o_ajax(url, options);
    };
})(jQuery);

function checkLoginPageRedirect(data) {
    // if data is an object with a responseText attribute or if it is text,
    //   then check to see if it is login page content and redirect if so
    if (data &&
        ( (data.responseText && data.responseText.indexOf('Framework_login_0x1F9') > 0) || data.toString().indexOf('Framework_login_0x1F9') > 0) ) {
        var from_page = window.location.pathname + window.location.search;
        window.location.href = '/auth/login?from_page=' + encodeURIComponent(from_page);
        return true;
    }
    return false;
}

function resizegrid(selector, parent)
{
    var padleft = $("main_div").css('padding-left');
    var MIN_WIDTH = 785 + parseInt(padleft);
    var parent_selector = (parent) ? parent : window;
    var window_width = $(parent_selector).width();
    if (window_width < MIN_WIDTH) {
        window_width = MIN_WIDTH;
    }

    $("#webui_header").width(window_width);
    var grid_width = window_width - parseInt(padleft) - 20;
    if (selector != null) {
        $(selector).setGridWidth(grid_width);
    }

    return grid_width;
}

// TODO: Deprecate the resizegrid method above and use only this one
// div is the table and parent is the grid div surrounding the table
// ie: resizeGrid('#my_table', '#my_grid_div')

function resizeGrid(div, parent){
    if($(div).is(':visible')){
        $(div).setGridWidth(100, true);
        $(div).setGridWidth($(parent).width() - 10, true);
    }
}

function bindGridResizeToParent(grid, parent)
{
    if (grid == null || parent == null) {
        return;
    }
    $(window).bind('resize', function () {
        $(grid).setGridWidth(100, true);
        $(grid).setGridWidth($(parent).width(), true);
    });
}


/* Call before calling plot.replot() on bar charts to auto-size bars */
function setBarWidths(plot, seriesLength, selector) {
    var width = $(selector).width();
    var barWidth = 1;
    if (seriesLength > 0) {
        barWidth = Math.max(1, parseInt(width / seriesLength) - 1);
    }
    if (plot) {
        $.each(plot.series, function (index, series) {
            series.barWidth = barWidth;
        });
    }
    return barWidth;
}

$(document).ready(function() {

    $(".portlet").addClass("ui-widget ui-widget-content ui-helper-clearfix ui-corner-all")
		.find(".portlet-header")
			.addClass("ui-widget-header ui-corner-all")
            //.prepend("<span class='ui-icon ui-icon-circle-triangle-n'></span>")
			.prepend("<span class='ui-icon ui-icon-carat-n'></span>")
			.end()
		.find(".portlet-content");

    $(".portlet-header .ui-icon").click(function() {
        //$(this).toggleClass("ui-icon-circle-triangle-n").toggleClass("ui-icon-circle-triangle-s");
        $(this).toggleClass("ui-icon-carat-n").toggleClass("ui-icon-carat-s");
        $(this).parents(".portlet:first").find(".portlet-content").toggle();
    });

    $("#btn_action").button({
        icons: {
            secondary: "ui-icon-triangle-1-s"
        }
    });

    /*
     * setNavSelection - Highlight active navigation item
     *
     * Determine which module is loaded and match the text of the
     * breadcrumb root to the text of the navigation link
     *
     */
     /*
    setNavSelection();
    function setNavSelection() {
        var bcroot = $(".breadcrumb .root");
        var bctext = bcroot.text();
        if (bctext == "") {
            // If root isn't specified, get the first anchor
            bcroot = $(".breadcrumb a").each( function() {
                bctext = $(this).text();
                return false;
            });
        }
        var path = window.location.pathname;
        var pathroot = path.substr(0, path.indexOf('/', 1));
        $(".accordionItem").each(function () {
            if (this.id.indexOf(pathroot) == 0) {
                var text = $.trim($(this).text());
                if (bctext == text) {
                    $(this).addClass('ui-state-highlight');
               }
            }
        });
    }
    */
    /* Resize navigation pane to height of content */
    /*
    function resizescroll() {
        var height = $(document).height();
        var ui_height = $("#webui_content").height();
        if (ui_height > height) {
            $("#accordion").height(ui_height);
            $("#accordion_minimized").height(ui_height);
        } else {
            $("#accordion").height(height-40);
            $("#accordion_minimized").height(height-40);
        }
    }
    $(window).bind('scroll', function() {
        resizescroll();
    });
    */
    /* trigger a 'resizeEnd' event after resize is complete */
    $(window).resize(function() {
        if(this.resizeTO) clearTimeout(this.resizeTO);
        this.resizeTO = setTimeout(function() {
            $(this).trigger('resizeEnd');
        }, 150);
    });
});




